/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.tablelayout.TableLayoutConstraints;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.Glue;
import elgato.measurement.backhaul.LED;
import elgato.measurement.backhaul.PanelProperties;
import elgato.measurement.backhaul.ReadingBitRow;
import elgato.measurement.backhaul.StatusProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.JPanel;

public class StatusPanel {
    private static final float[] statusColumnSizes = new float[]{-1.0f, 13.0f, 0.24f, 1.0f, 7.0f, -1.0f, 13.0f, 0.24f, 10.0f};
    private boolean isPrimaryEnabled;
    private boolean isSecondaryEnabled;
    private ReadingBitRow[] textRows;
    private ReadingBitRow[] ledRows;
    private int rowHeight;

    public StatusPanel(boolean bl, boolean bl2, ReadingBitRow[] readingBitRowArray, ReadingBitRow[] readingBitRowArray2, int n) {
        this.isPrimaryEnabled = bl;
        this.isSecondaryEnabled = bl2;
        this.textRows = readingBitRowArray;
        this.ledRows = readingBitRowArray2;
        this.rowHeight = n;
    }

    public Container createComponent() {
        Object object;
        TableLayout tableLayout = new TableLayout(new float[][]{statusColumnSizes, new float[0]});
        JPanel jPanel = new JPanel(tableLayout);
        ((Component)jPanel).setBackground(null);
        int n = -1;
        tableLayout.insertRow(++n, -2.0f);
        jPanel.add((Component)new ELabel(Text.Status, this.getColor(this.isPrimaryEnabled), PanelProperties.TITLE_FONT), "0,0");
        jPanel.add((Component)new ELabel(Text.Primary, this.getColor(this.isPrimaryEnabled), PanelProperties.TITLE_FONT), "1,0,2,0");
        jPanel.add((Component)new ELabel(Text.Status, this.getColor(this.isSecondaryEnabled), PanelProperties.TITLE_FONT), "5,0");
        jPanel.add((Component)new ELabel(Text.Secondary, this.getColor(this.isSecondaryEnabled), PanelProperties.TITLE_FONT), "6,0,7,0");
        tableLayout.insertRow(++n, PanelProperties.RULE_SIZE);
        jPanel.add((Component)new Glue(1, PanelProperties.RULE_SIZE, PanelProperties.RULE_COLOR), TableLayoutConstraints.newSpan(0, 1, statusColumnSizes.length - 1, 1));
        tableLayout.insertRow(++n, 5.0f);
        int n2 = n;
        for (int i = 0; i < this.ledRows.length; ++i) {
            object = this.ledRows[i].getLabel();
            tableLayout.insertRow(++n, this.rowHeight);
            StatusProvider[] statusProviderArray = this.ledRows[i].getStatusProviders();
            jPanel.add((Component)this.createStatusRowLabel((String)object, this.isPrimaryEnabled), TableLayoutConstraints.newCell(0, n));
            jPanel.add((Component)new LED(this.getStatusLEDType(this.isPrimaryEnabled), statusProviderArray[0]), TableLayoutConstraints.newCell(1, n));
            if (statusProviderArray.length <= 1 || statusProviderArray[1] == null) continue;
            jPanel.add((Component)this.createStatusRowLabel((String)object, this.isSecondaryEnabled), TableLayoutConstraints.newCell(5, n));
            jPanel.add((Component)new LED(this.getStatusLEDType(this.isSecondaryEnabled), statusProviderArray[1]), TableLayoutConstraints.newCell(6, n));
        }
        tableLayout.insertRow(++n, 5.0f);
        tableLayout.insertRow(++n, 1.0f);
        jPanel.add((Component)new Glue(1, 1, PanelProperties.RULE_COLOR), TableLayoutConstraints.newSpan(0, n, statusColumnSizes.length - 1, n));
        tableLayout.insertRow(++n, 5.0f);
        Color color = this.isPrimaryEnabled ? PanelProperties.TEXT_COLOR : Color.gray;
        object = this.isSecondaryEnabled ? PanelProperties.TEXT_COLOR : Color.gray;
        for (int i = 0; i < this.textRows.length; i += 2) {
            tableLayout.insertRow(++n, this.rowHeight);
            jPanel.add((Component)this.createSummaryLabel(this.textRows[i].getLabel(), color), TableLayoutConstraints.newCell(0, n));
            if (this.isPrimaryEnabled) {
                this.addAlarmsAndErrorsText(jPanel, 1, n, this.textRows[i], this.ledRows[0], 0);
            }
            jPanel.add((Component)this.createSummaryLabel(this.textRows[i + 1].getLabel(), (Color)object), TableLayoutConstraints.newCell(5, n));
            if (!this.isSecondaryEnabled) continue;
            this.addAlarmsAndErrorsText(jPanel, 6, n, this.textRows[i + 1], this.ledRows[0], 1);
        }
        tableLayout.insertRow(++n, -1.0f);
        jPanel.add((Component)new Glue(1, 1, PanelProperties.RULE_COLOR), TableLayoutConstraints.newSpan(3, n2, 3, n));
        return new BorderWrapper(jPanel, PanelProperties.STATUS_PANEL_BORDER, true, 5, 1);
    }

    private Color getColor(boolean bl) {
        return bl ? PanelProperties.TEXT_COLOR : Color.gray;
    }

    private Color getStatusLabelColor(boolean bl) {
        return bl ? PanelProperties.TEXT_COLOR : Color.gray;
    }

    private LED.Type getStatusLEDType(boolean bl) {
        return bl ? LED.Type.green : LED.Type.gray;
    }

    private ELabel createStatusRowLabel(String string, boolean bl) {
        return new ELabel(string, this.getStatusLabelColor(bl), PanelProperties.TITLE_FONT, 3, 2);
    }

    private ELabel createSummaryLabel(String string, Color color) {
        return new ELabel(string, color, PanelProperties.SUMMARY_FONT, 3, 2);
    }

    private void addAlarmsAndErrorsText(Container container, int n, int n2, ReadingBitRow readingBitRow, ReadingBitRow readingBitRow2, int n3) {
        container.add(this.createSummaryCellHistoryText(readingBitRow, readingBitRow2, n3), TableLayoutConstraints.newSpan(n, n2, n + 1, n2));
    }

    private Component createSummaryCellHistoryText(final ReadingBitRow readingBitRow, final ReadingBitRow readingBitRow2, final int n) {
        ELabel eLabel = new ELabel(1){

            public void paint(Graphics graphics) {
                StatusPanel.this.configureSummaryLabelForState(this, readingBitRow.getValues()[0], readingBitRow.getValues()[1], readingBitRow2.getValues()[n]);
                super.paint(graphics);
            }
        };
        eLabel.setVAlignment(2);
        return eLabel;
    }

    void configureSummaryLabelForState(ELabel eLabel, boolean bl, boolean bl2, boolean bl3) {
        Color color;
        String string;
        if (!bl3) {
            string = Text.No_Signal;
            color = Color.red;
        } else if (bl) {
            string = Text.Detected;
            color = Color.red;
        } else if (bl2) {
            string = Text.Were_Detected;
            color = Color.red;
        } else {
            string = Text.OK;
            color = Color.green;
        }
        eLabel.setTextNoRepaint(string);
        eLabel.setAttributesNoRepaint(0, color, PanelProperties.SUMMARY_FONT);
    }

    public TabDelimitable[] getTabDelimitedFields() {
        return this.ledRows;
    }
}

