/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.mainScreens.SaveData;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.readings.DoubleReadingField;
import elgato.infrastructure.readings.IntegerReadingField;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.backhaul.AlarmsPanel;
import elgato.measurement.backhaul.BackhaulAnalyzer;
import elgato.measurement.backhaul.BackhaulBitRow;
import elgato.measurement.backhaul.BackhaulMeasurement;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;
import elgato.measurement.backhaul.ComponentFactory;
import elgato.measurement.backhaul.ErrorPanel;
import elgato.measurement.backhaul.LEDResultPanel;
import elgato.measurement.backhaul.ModeTitle;
import elgato.measurement.backhaul.PerformanceResultsPanel;
import elgato.measurement.backhaul.PerformanceRow;
import elgato.measurement.backhaul.ReadingBitRow;
import elgato.measurement.backhaul.ResultPanel;
import elgato.measurement.backhaul.StatusPanel;
import elgato.measurement.backhaul.T1Measurement;
import elgato.measurement.backhaul.T1MeasurementSettings;
import elgato.measurement.backhaul.TwoReadingRow;
import java.awt.Component;
import java.io.PrintWriter;
import javax.swing.JPanel;

public class T1Analyzer
extends BackhaulAnalyzer {
    public static final int ROW_HEIGHT = 18;
    private T1Measurement t1Measurement;
    private IntegerReadingField primaryBpvErrors;
    private DoubleReadingField primaryBpvErrorRate;
    private IntegerReadingField primaryBpvErroredSeconds;
    private IntegerReadingField primaryFrameErrors;
    private DoubleReadingField primaryFrameErrorRate;
    private IntegerReadingField primaryFrameErroredSeconds;
    private IntegerReadingField primaryCrcErrors;
    private DoubleReadingField primaryCrcErrorRate;
    private IntegerReadingField primaryCrcErroredSeconds;
    private IntegerReadingField primarySignalLoss;
    private IntegerReadingField primaryFrameSyncLoss;
    private IntegerReadingField primaryExcessZeroes;
    private IntegerReadingField primaryA1S;
    private IntegerReadingField primaryYellowAlarm;
    private IntegerReadingField primaryClockSlips;
    private DoubleReadingField primarySlipRate;
    private IntegerReadingField primaryPeakPosWander;
    private IntegerReadingField primaryPeakNegWander;
    private IntegerReadingField primaryPosFrameSlip;
    private IntegerReadingField primaryNegFramSlip;
    private IntegerReadingField primaryBitErrors;
    private DoubleReadingField primaryBitErrorRate;
    private IntegerReadingField primaryBitErrorSeconds;
    private IntegerReadingField primaryPatternSyncLoss;
    private IntegerReadingField primaryTestDataRate;
    private IntegerReadingField secondaryBpvErrors;
    private DoubleReadingField secondaryBpvErrorRate;
    private IntegerReadingField secondaryBpvErroredSeconds;
    private IntegerReadingField secondaryFrameErrors;
    private DoubleReadingField secondaryFrameErrorRate;
    private IntegerReadingField secondaryFrameErroredSeconds;
    private IntegerReadingField secondaryCrcErrors;
    private DoubleReadingField secondaryCrcErrorRate;
    private IntegerReadingField secondaryCrcErroredSeconds;
    private IntegerReadingField secondarySignalLoss;
    private IntegerReadingField secondaryFrameSyncLoss;
    private IntegerReadingField secondaryExcessZeroes;
    private IntegerReadingField secondaryA1S;
    private IntegerReadingField secondaryYellowAlarms;
    AlarmsPanel primaryAlarmsPanel;
    AlarmsPanel secondaryAlarmsPanel;
    private ReadingBitRow[] statusLedRows;
    private ReadingBitRow[] statusTextRows;
    private ReadingBitRow[] primaryErrorSummaryLeds;
    private ResultPanel[] emulationPanels;
    private ResultPanel[] resultPanelList;

    public T1Analyzer() {
        super(T1MeasurementSettings.instance());
    }

    protected void initResultPanels() {
        super.initResultPanels();
        this.frameELabels = new ELabel[3];
        LEDResultPanel lEDResultPanel = new LEDResultPanel(T1MeasurementSettings.VALUE_DISPLAYED_RESULTS_EMULATE_PRIMARY_ERROR_SUMMARY, Text.Pri_Error, Text.Primary, Text.Error_Summary, this.primaryErrorSummaryLeds, 18);
        this.frameELabels[0] = lEDResultPanel.getELabel(Text.Frame_Slip);
        this.emulationPanels = new ResultPanel[]{ResultPanel.createPrimaryResultPanel(T1MeasurementSettings.VALUE_DISPLAYED_RESULTS_EMULATE_RESULTS, Text.Emulation, Text.Emulation_Results, new ReadingField[]{this.primaryElapsedTime, this.primaryBpvErrors, this.primaryFrameErrors, this.primaryCrcErrors, this.primaryBitErrors}), lEDResultPanel};
        TwoReadingRow[] twoReadingRowArray = new TwoReadingRow[]{new TwoReadingRow(this.primaryRecieverLevelDbdsx, this.primaryReceiverLevelVpp)};
        LEDResultPanel lEDResultPanel2 = new LEDResultPanel(0, Text.Pri_Summary, Text.Primary_Summary, Text.Primary + ": " + Text.Summary, this.primaryErrorSummaryLeds, this.primaryFrequencyFields, twoReadingRowArray, 18);
        this.frameELabels[1] = lEDResultPanel2.getELabel(Text.Frame_Slip);
        LEDResultPanel lEDResultPanel3 = new LEDResultPanel(2, Text.Pri_Error, Text.Primary, Text.Error_Summary, this.primaryErrorSummaryLeds, 18);
        this.frameELabels[2] = lEDResultPanel3.getELabel(Text.Frame_Slip);
        this.resultPanelList = new ResultPanel[]{lEDResultPanel2, ResultPanel.createPrimaryResultPanel(1, Text.Lev_slash_Freq, Text.Level_Frequency, Text.Level_slash_Freq_slash_Time, this.primaryFrequencyFields, twoReadingRowArray), lEDResultPanel3, new LEDResultPanel(3, Text.Sec_Error, Text.Secondary, Text.Error_Summary, new ReadingBitRow[]{new T1ErrorBitRow(Text.Secondary, Text.BPV, 4, 12, this), new T1ErrorBitRow(Text.Secondary, Text.Frame, 5, 13, this), new T1ErrorBitRow(Text.Secondary, Text.CRC, 6, 14, this)}, 18), ResultPanel.createPrimaryResultPanel(4, Text.BPV_slash_Frame, Text.BPV_and_Frame_Errors, Text.BPV_and_Frame, new ReadingField[]{this.primaryBpvErrors, this.primaryBpvErrorRate, this.primaryBpvErroredSeconds, this.primaryFrameErrors, this.primaryFrameErrorRate, this.primaryFrameErroredSeconds}), ResultPanel.createSecondaryResultPanel(5, Text.BPV_slash_Frame, Text.BPV_and_Frame_Errors, Text.BPV_and_Frame, new ReadingField[]{this.secondaryBpvErrors, this.secondaryBpvErrorRate, this.secondaryBpvErroredSeconds, this.secondaryFrameErrors, this.secondaryFrameErrorRate, this.secondaryFrameErroredSeconds}), ResultPanel.createPrimaryResultPanel(6, Text.CRC, Text.CRC_Errors, new ReadingField[]{this.primaryCrcErrors, this.primaryCrcErrorRate, this.primaryCrcErroredSeconds}), ResultPanel.createSecondaryResultPanel(7, Text.CRC, Text.CRC_Errors, new ReadingField[]{this.secondaryCrcErrors, this.secondaryCrcErrorRate, this.secondaryCrcErroredSeconds}), ResultPanel.createPrimaryResultPanel(8, Text.Alarm, Text.Alarm_Seconds, new ReadingField[]{this.primarySignalLoss, this.primaryFrameSyncLoss, this.primaryExcessZeroes, this.primaryA1S, this.primaryYellowAlarm}), ResultPanel.createSecondaryResultPanel(9, Text.Alarm, Text.Alarm_Seconds, new ReadingField[]{this.secondarySignalLoss, this.secondaryFrameSyncLoss, this.secondaryExcessZeroes, this.secondaryA1S, this.secondaryYellowAlarms}), new PerformanceResultsPanel(10, Text.Pri + " " + Text.Perform, Text.Primary, Text.Performance, new PerformanceRow[]{ComponentFactory.createPrimaryPerformanceRow(this, Text.Error_Free_Secs, 38, 62), ComponentFactory.createPrimaryPerformanceRow(this, Text.Errored_Seconds, 39, 63), ComponentFactory.createPrimaryPerformanceRow(this, Text.Sever_Errd_Secs, 40, 64), ComponentFactory.createPrimaryPerformanceRow(this, Text.Available_Secs, 41, 65), ComponentFactory.createPrimaryPerformanceRow(this, Text.UnAvail_Secs, 42, 66), ComponentFactory.createPrimaryPerformanceRow(this, Text.Degraded_Mins, 43, 67)}), new PerformanceResultsPanel(11, Text.Sec + " " + Text.Perform, Text.Secondary, Text.Performance, new PerformanceRow[]{ComponentFactory.createSecondaryPerformanceRow(this, Text.Error_Free_Secs, 44, 68), ComponentFactory.createSecondaryPerformanceRow(this, Text.Errored_Seconds, 45, 69), ComponentFactory.createSecondaryPerformanceRow(this, Text.Sever_Errd_Secs, 46, 70), ComponentFactory.createSecondaryPerformanceRow(this, Text.Available_Secs, 47, 71), ComponentFactory.createSecondaryPerformanceRow(this, Text.UnAvail_Secs, 48, 72), ComponentFactory.createSecondaryPerformanceRow(this, Text.Degraded_Mins, 49, 73)}), ResultPanel.createPrimaryResultPanel(12, Text.Clock, Text.Clock_and_Frame_Slips, Text.ClockandSymbolFrame_Slips, new ReadingField[]{this.primaryClockSlips, this.primarySlipRate, this.primaryPeakPosWander, this.primaryPeakNegWander, this.primaryPosFrameSlip, this.primaryNegFramSlip}), ResultPanel.createPrimaryResultPanel(13, Text.Pattern, Text.Test_Pattern, new ReadingField[]{this.primaryBitErrors, this.primaryBitErrorRate, this.primaryBitErrorSeconds, this.primaryPatternSyncLoss, this.primaryTestDataRate})};
    }

    protected void initBitRows() {
        BackhaulBitRow backhaulBitRow = new BackhaulBitRow(this, Text.Pattern_Sync, 3, 2, Text.Present, Text.Absent){

            public String toTabDelimitedString() {
                if (T1MeasurementSettings.instance().getStatus().getSelectedValue().intValue() == 1) {
                    return "";
                }
                return super.toTabDelimitedString();
            }
        };
        backhaulBitRow.setLongLabel(Text.Primary + " " + backhaulBitRow.getLabel());
        this.statusLedRows = new ReadingBitRow[]{new StatusRow(Text.T1_Pulses, 0, 6), new StatusRow(Text.B8ZS, 1, 7), new StatusRow(Text.Frame_Sync, 2, 8), backhaulBitRow};
        this.statusTextRows = new ReadingBitRow[]{new StatusRow(Text.Alarms, 3, 15), new StatusRow(Text.Alarms, 9, 21), new StatusRow(Text.Errors, 4, 16), new StatusRow(Text.Errors, 10, 22)};
        BackhaulBitRow backhaulBitRow2 = new BackhaulBitRow(this, Text.Frame_Slip, 3, 6, Text.Detected, Text.OK){

            protected boolean getValue(int n) {
                if (T1Analyzer.this.settings.isSlipRefNone()) {
                    return false;
                }
                return super.getValue(n);
            }
        };
        backhaulBitRow2.setLongLabel(Text.Primary + " " + backhaulBitRow2.getLabel());
        this.primaryErrorSummaryLeds = new ReadingBitRow[]{new T1ErrorBitRow(Text.Primary, Text.BPV, 0, 8, this), new T1ErrorBitRow(Text.Primary, Text.Frame, 1, 9, this), new T1ErrorBitRow(Text.Primary, Text.CRC, 2, 10, this), new T1ErrorBitRow(Text.Primary, Text.Pattern, 3, 11, this), backhaulBitRow2};
    }

    protected StatusPanel createStatusPanel(boolean bl, boolean bl2) {
        return new StatusPanel(bl, bl2, this.getStatusTextRows(), this.getStatusLedRows(), 18);
    }

    protected void initAlarmsPanels() {
        this.primaryAlarmsPanel = new AlarmsPanel(Text.Pri, Text.Primary, new ReadingBitRow[]{new T1AlarmBitRow(Text.Primary, Text.Signal_Loss, 0, 16, this), new T1AlarmBitRow(Text.Primary, Text.Frame_Loss, 1, 17, this), new T1AlarmBitRow(Text.Primary, Text.Excess_Zeros, 2, 18, this), new T1AlarmBitRow(Text.Primary, Text.All_Ones_AIS, 3, 19, this), new T1AlarmBitRow(Text.Primary, Text.Yellow_Alarm, 4, 20, this), new T1AlarmBitRow(Text.Primary, Text.Idle_CDI, 5, 21, this)}, 18);
        this.secondaryAlarmsPanel = new AlarmsPanel(Text.Sec, Text.Secondary, new ReadingBitRow[]{new T1AlarmBitRow(Text.Secondary, Text.Signal_Loss, 8, 24, this), new T1AlarmBitRow(Text.Secondary, Text.Frame_Loss, 9, 25, this), new T1AlarmBitRow(Text.Secondary, Text.Excess_Zeros, 10, 26, this), new T1AlarmBitRow(Text.Secondary, Text.All_Ones_AIS, 11, 27, this), new T1AlarmBitRow(Text.Secondary, Text.Yellow_Alarm, 12, 28, this), new T1AlarmBitRow(Text.Secondary, Text.Idle_CDI, 13, 29, this)}, 18);
    }

    protected void initReadingFields() {
        this.primaryRecieverLevelDbdsx = ComponentFactory.createPrimaryReadingField(this, Text.Recv_Level, Text.dBdsx, 5, 1000.0, 1);
        this.primaryReceiverLevelVpp = ComponentFactory.createPrimaryReadingField(this, Text.Recv_Level, Text.VPP, 4, 1000.0, 1);
        this.primaryFrequency = ComponentFactory.createPrimaryReadingField(this, Text.Frequency, Text.MHz, 6, 1000000.0, 6);
        this.primaryElapsedTime = ComponentFactory.createPrimaryTimeReadingField(this, Text.Elapsed_Time, 7);
        this.primaryBpvErrors = ComponentFactory.createPrimaryReadingField(this, Text.BPV_Errors, 8);
        this.primaryBpvErrorRate = ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Primary, Text.BPV_Error_Rate, 9, 6);
        this.primaryBpvErroredSeconds = ComponentFactory.createPrimaryReadingField(this, Text.BPV_Errd_Secs, 10);
        this.primaryFrameErrors = ComponentFactory.createPrimaryReadingField(this, Text.Frame_Errors, 14);
        this.primaryFrameErrorRate = ComponentFactory.createPrimaryDoubleReadingField(this, Text.Frame_Error_Rate, 15, 6);
        this.primaryFrameErroredSeconds = ComponentFactory.createPrimaryReadingField(this, Text.Frame_Errd_Secs, 16);
        this.primaryCrcErrors = ComponentFactory.createPrimaryReadingField(this, Text.CRC_Errors, 20);
        this.primaryCrcErrorRate = ComponentFactory.createPrimaryDoubleReadingField(this, Text.CRC_Error_Rate, 21, 6);
        this.primaryCrcErroredSeconds = ComponentFactory.createPrimaryReadingField(this, Text.CRC_Errd_Secs, 22);
        this.primarySignalLoss = ComponentFactory.createPrimaryReadingField(this, Text.Signal_Loss_Secs, 26);
        this.primaryFrameSyncLoss = ComponentFactory.createPrimaryReadingField(this, Text.Frame_Sync_Loss_Secs, 27);
        this.primaryExcessZeroes = ComponentFactory.createPrimaryReadingField(this, Text.Excess_Zeros_Secs, 30);
        this.primaryA1S = ComponentFactory.createPrimaryReadingField(this, Text.All_1s_Secs, 29);
        this.primaryYellowAlarm = ComponentFactory.createPrimaryReadingField(this, Text.Yellow_Alarm_Secs, 31);
        this.primaryClockSlips = ComponentFactory.createPrimaryReadingField(this, Text.Clock_Slips, 50);
        this.primarySlipRate = ComponentFactory.createPrimaryDoubleReadingField(this, Text.Slip_Rate, 51, 6);
        this.primaryPeakPosWander = ComponentFactory.createPrimaryReadingField(this, Text.Peak_PLUS_Wander, 52);
        this.primaryPeakNegWander = ComponentFactory.createPrimaryReadingField(this, Text.Peak_NEGATIVE_Wander, 53);
        this.primaryPosFrameSlip = ComponentFactory.createPrimaryReadingField(this, Text.PLUS_Frame_Slips, 54);
        this.primaryNegFramSlip = ComponentFactory.createPrimaryReadingField(this, Text.MINUS_Frame_Slips, 55);
        this.primaryBitErrors = ComponentFactory.createPrimaryReadingField(this, Text.Bit_Errors, 56);
        this.primaryBitErrorRate = ComponentFactory.createPrimaryDoubleReadingField(this, Text.Bit_Error_Rate, 57, 6);
        this.primaryBitErrorSeconds = ComponentFactory.createPrimaryReadingField(this, Text.Bit_Errd_Secs, 58);
        this.primaryPatternSyncLoss = ComponentFactory.createPrimaryReadingField(this, Text.Pattern_Sync_Loss_Secs, 59);
        this.primaryTestDataRate = ComponentFactory.createPrimaryReadingField(this, Text.Test_Data_Rate, "Mbits/s", 61, 1000.0, 4);
        this.secondaryBpvErrors = ComponentFactory.createSecondaryReadingField(this, Text.BPV_Errors, 11);
        this.secondaryBpvErrorRate = ComponentFactory.createSecondaryDoubleReadingField(this, Text.BPV_Error_Rate, 12, 6);
        this.secondaryBpvErroredSeconds = ComponentFactory.createSecondaryReadingField(this, Text.BPV_Errd_Secs, 13);
        this.secondaryFrameErrors = ComponentFactory.createSecondaryReadingField(this, Text.Frame_Errors, 17);
        this.secondaryFrameErrorRate = ComponentFactory.createSecondaryDoubleReadingField(this, Text.Frame_Error_Rate, 18, 6);
        this.secondaryFrameErroredSeconds = ComponentFactory.createSecondaryReadingField(this, Text.Frame_Errd_Secs, 19);
        this.secondaryCrcErrors = ComponentFactory.createSecondaryReadingField(this, Text.CRC_Errors, 23);
        this.secondaryCrcErrorRate = ComponentFactory.createSecondaryDoubleReadingField(this, Text.CRC_Error_Rate, 24, 6);
        this.secondaryCrcErroredSeconds = ComponentFactory.createSecondaryReadingField(this, Text.CRC_Errd_Secs, 25);
        this.secondarySignalLoss = ComponentFactory.createSecondaryReadingField(this, Text.Signal_Loss_Secs, 32);
        this.secondaryFrameSyncLoss = ComponentFactory.createSecondaryReadingField(this, Text.Frame_Sync_Loss_Secs, 33);
        this.secondaryExcessZeroes = ComponentFactory.createSecondaryReadingField(this, Text.Excess_Zeros_Secs, 36);
        this.secondaryA1S = ComponentFactory.createSecondaryReadingField(this, Text.All_1s_Secs, 35);
        this.secondaryYellowAlarms = ComponentFactory.createSecondaryReadingField(this, Text.Yellow_Alarm_Secs, 37);
        this.delayUnitIntervals = ComponentFactory.createDelayReadingField(this, Text.Unit_Intervals, 74);
        this.delayMicroseconds = ComponentFactory.createDelayDoubleReadingField(this, Text.Microseconds, 75, 1);
        this.delayKiloFeet = ComponentFactory.createDelayDoubleReadingField(this, Text.Kilofeet, 76, 1);
        this.delayMiles = ComponentFactory.createDelayDoubleReadingField(this, Text.Miles, 77, 1);
        this.delayKilometers = ComponentFactory.createDelayDoubleReadingField(this, Text.Kilometers, 103, 2);
    }

    protected ResultPanel[] getResultPanels() {
        return this.resultPanelList;
    }

    public Measurement getMeasurement() {
        return this.t1Measurement;
    }

    public BackhaulMeasurement getBackhaulMeasurement() {
        return this.t1Measurement;
    }

    public void saveData(PrintWriter printWriter) {
        if (T1MeasurementSettings.instance().isDelayMode()) {
            SaveData.saveData(this.createDelayModeReadingFields(), printWriter, this.getMeasurement().getMeasurementTitle());
        } else {
            SaveData.saveData(this.getSavableFields(), printWriter, this.getMeasurement().getMeasurementTitle());
        }
    }

    Component getResultsPanelForTesting() {
        return this.resultsPanelComponent;
    }

    public void measurementReceived(Measurement measurement) {
        final T1Measurement t1Measurement = (T1Measurement)measurement;
        if (this.delayModePanel != null) {
            this.delayModePanel.measurementReceived(t1Measurement);
        }
        if (T1MeasurementSettings.instance().isEmulateMode() && MeasurementFactory.instance().getCommandProcessor().isStartupComplete()) {
            T1MeasurementSettings.instance().setLoopState(t1Measurement.getLoopState());
        }
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                T1Measurement t1Measurement2 = T1Analyzer.this.t1Measurement;
                if (t1Measurement2 != null) {
                    t1Measurement2.recycle();
                }
                T1Analyzer.this.t1Measurement = t1Measurement;
                T1Analyzer.this.showMainPanel();
                T1Analyzer.this.paintImmediately(0, 0, T1Analyzer.this.getWidth(), T1Analyzer.this.getHeight());
            }
        }, "T1Analyzer.measurementReceived");
    }

    protected ReadingBitRow[] getStatusTextRows() {
        return this.statusTextRows;
    }

    protected ReadingBitRow[] getStatusLedRows() {
        return this.statusLedRows;
    }

    public Component getResultSubPanelComponent(ResultPanel resultPanel) {
        String string = resultPanel.getPanelName();
        if (string.endsWith(Text.CRC_Errors) && !T1MeasurementSettings.instance().isEsfFraming()) {
            return new ErrorPanel(Text.ESF_FRAMING_ERROR_MESSAGE);
        }
        if (string.endsWith(Text.ClockandSymbolFrame_Slips) && T1MeasurementSettings.instance().isSlipRefNone()) {
            return new ErrorPanel(Text.SLIP_REF_ERROR_MESSAGE);
        }
        return resultPanel.createComponent();
    }

    protected CommonBackhaulMeasurementSettings getCommonSettings() {
        return T1MeasurementSettings.instance();
    }

    public AlarmsPanel getPrimaryAlarmsPanel() {
        return this.primaryAlarmsPanel;
    }

    public AlarmsPanel getSecondaryAlarmsPanel() {
        return this.secondaryAlarmsPanel;
    }

    public ResultPanel[] getEmulationPanels() {
        return this.emulationPanels;
    }

    protected JPanel getModeTitle() {
        return new ModeTitle(T1MeasurementSettings.instance());
    }

    public void dispose() {
        super.dispose();
    }

    protected ResultPanel getCurrentResultPanel() {
        if (T1MeasurementSettings.instance().isEmulateMode()) {
            return this.getEmulationPanel(T1MeasurementSettings.instance().getEmulationPanel().intValue());
        }
        return super.getCurrentResultPanel();
    }

    public ResultPanel getResultsPanel(int n) {
        if (T1MeasurementSettings.instance().isEmulateMode()) {
            return this.getEmulationPanel(n);
        }
        return super.getResultsPanel(n);
    }

    private ResultPanel getEmulationPanel(int n) {
        if (n == T1MeasurementSettings.VALUE_DISPLAYED_RESULTS_EMULATE_RESULTS) {
            return this.emulationPanels[0];
        }
        if (n == T1MeasurementSettings.VALUE_DISPLAYED_RESULTS_EMULATE_PRIMARY_ERROR_SUMMARY) {
            return this.emulationPanels[1];
        }
        throw new RuntimeException("No panel for emulation mode: " + n);
    }

    class StatusRow
    extends BackhaulBitRow {
        public StatusRow(String string, int n, int n2) {
            super(T1Analyzer.this, string, 1, n, n2, Text.Present, Text.Absent);
        }

        public String toTabDelimitedString() {
            String string = T1MeasurementSettings.instance().getStatus().intValue() == 0 ? this.makePrimaryStatusString() : (T1MeasurementSettings.instance().getStatus().intValue() == 1 ? this.makeSecondaryStatusString() : this.makePrimaryStatusString() + "\n" + this.makeSecondaryStatusString());
            return string;
        }

        private String makePrimaryStatusString() {
            return Text.Primary + " " + this.getLabel() + "\t" + this.getTextForCurrentBit();
        }

        private String makeSecondaryStatusString() {
            return Text.Secondary + " " + this.getLabel() + "\t" + this.getTextForHistoryBit();
        }
    }

    class T1AlarmBitRow
    extends BackhaulBitRow {
        public T1AlarmBitRow(String string, String string2, int n, int n2, BackhaulAnalyzer backhaulAnalyzer) {
            super(backhaulAnalyzer, string2, 0, n, n2, Text.Detected, Text.OK);
            this.setLongLabel(string + " " + string2 + " " + Text.Alarm);
        }
    }

    class T1ErrorBitRow
    extends BackhaulBitRow {
        public T1ErrorBitRow(String string, String string2, int n, int n2, BackhaulAnalyzer backhaulAnalyzer) {
            super(backhaulAnalyzer, string2, 2, n, n2, Text.Detected, Text.OK);
            this.setLongLabel(string + " " + string2 + " " + Text.Error);
        }
    }
}

