/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.backhaul.ControlMenuAbstractFactory;
import elgato.measurement.backhaul.SetupMenuMgr;
import elgato.measurement.backhaul.SetupScreen;
import elgato.measurement.backhaul.T1MeasurementSettings;
import elgato.measurement.backhaul.T1Screen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class T1ControlMenuAbstractFactory
extends ControlMenuAbstractFactory {
    private T1Screen screen;
    private T1MeasurementSettings settings = T1MeasurementSettings.instance();
    private ValueListener loopDownValueListener;
    private ValueListener loopUpValueListener;
    private Menu emulateMenu;

    public T1ControlMenuAbstractFactory(T1Screen t1Screen) {
        super(t1Screen, T1MeasurementSettings.instance());
        this.screen = t1Screen;
    }

    protected Menu[] createControlMenus() {
        Menu[] menuArray = new Menu[17];
        menuArray[0] = this.createControlHardLoopMenu();
        menuArray[1] = this.createControlChannelMenu();
        menuArray[3] = this.createNiuCsuFullT1Menu();
        menuArray[4] = this.createLoopNiuCsuChannelMenu();
        menuArray[6] = this.createNiuCsuFullT1Menu();
        menuArray[7] = this.createLoopNiuCsuChannelMenu();
        menuArray[9] = this.createMonitorFullMenu();
        menuArray[10] = this.createMonitorChannelMenu();
        menuArray[14] = this.createEmulateNiuCsuMenu();
        menuArray[15] = this.createEmulateNiuCsuMenu();
        menuArray[16] = this.createBlankControlMenu();
        return menuArray;
    }

    protected MenuItem createChannelButton() {
        return this.createChannelButton(this.settings.getChannel());
    }

    protected MenuItem createChannelButton(LongActuator longActuator) {
        return new ActuatorEditor(longActuator, SetupScreen.getContextString("channel"), this.screen.getListenerBaseName() + ".channelButton");
    }

    private ActionListener createLoopStateActionListener(final int n) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (n == 1) {
                    T1ControlMenuAbstractFactory.this.settings.setSendingLoopUp();
                } else {
                    T1ControlMenuAbstractFactory.this.settings.setSendingLoopDown();
                }
                T1ControlMenuAbstractFactory.this.settings.getLoopState().send(n);
            }
        };
    }

    MenuItem createSendLoopUpButton() {
        return new PushButton(Text.Send_Loop_n_Up, this.screen.getContextString("sendLoopUp"), this.createLoopStateActionListener(1));
    }

    MenuItem createSendLoopDownButton() {
        return new PushButton(Text.Send_Loop_n_Down, this.screen.getContextString("sendLoopDown"), this.createLoopStateActionListener(0));
    }

    Menu createNiuCsuFullT1Menu() {
        return new Menu(Text.Control, new MenuItem[]{SetupMenuMgr.createPatternButton(T1MeasurementSettings.instance(), this.screen.getListenerBaseName() + ".niuCsuFull"), null, null, this.createAlarmErrorButton(), null, this.createSendLoopUpButton(), this.createSendLoopDownButton()});
    }

    Menu createLoopNiuCsuChannelMenu() {
        return new Menu(Text.Control, new MenuItem[]{SetupMenuMgr.createPatternButton(T1MeasurementSettings.instance(), this.screen.getListenerBaseName() + ".niuCsuChan"), this.createChannelButton(), this.createFillDataButton(), this.createAlarmErrorButton(), null, this.createSendLoopUpButton(), this.createSendLoopDownButton()});
    }

    protected void configureInjectButton() {
        if (this.isAlarmType()) {
            this.alarmInjectButton.setBodyText(this.getInjectStateText());
            this.setButtonInPosition4(this.alarmInjectButton);
        } else {
            T1MeasurementSettings t1MeasurementSettings = T1MeasurementSettings.instance();
            if (t1MeasurementSettings.isUnframed() && t1MeasurementSettings.isFrameError() || t1MeasurementSettings.isD3D4Frammed() && t1MeasurementSettings.isCRCError() || t1MeasurementSettings.isUnframed() && t1MeasurementSettings.isCRCError()) {
                this.errorInjectButton.setEnabled(false);
            } else {
                this.errorInjectButton.setEnabled(true);
            }
            this.errorInjectButton.setBodyText(this.getInjectStateText());
            this.setButtonInPosition4(this.errorInjectButton);
        }
    }

    Menu createEmulateNiuCsuMenu() {
        if (this.emulateMenu == null) {
            this.emulateMenu = new Menu(Text.Control, new MenuItem[]{SetupMenuMgr.createPatternButton(T1MeasurementSettings.instance(), this.screen.getListenerBaseName() + ".emulateNiuCsu"), null, null, null, null, this.createSelfLoopUpButton(), this.createSelfLoopDownButton()});
        }
        return this.emulateMenu;
    }

    MenuItem createSelfLoopUpButton() {
        final PushButton pushButton = new PushButton(Text.Self_Loop_n_Up, "");
        pushButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                T1ControlMenuAbstractFactory.this.settings.sendLoopUp();
            }
        });
        this.enableLoopUpButton(pushButton);
        this.loopUpValueListener = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = T1ControlMenuAbstractFactory.this.screen.getListenerBaseName() + ".loopUpValueListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                T1ControlMenuAbstractFactory.this.enableLoopUpButton(pushButton);
            }
        };
        this.settings.getLoopState().addValueListener(this.loopUpValueListener);
        return pushButton;
    }

    private void enableLoopUpButton(PushButton pushButton) {
        pushButton.setEnabled(!this.settings.isLoopUp());
    }

    MenuItem createSelfLoopDownButton() {
        final PushButton pushButton = new PushButton(Text.Self_Loop_n_Down, "");
        pushButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                T1ControlMenuAbstractFactory.this.settings.sendLoopDown();
            }
        });
        this.enableLoopDownButton(pushButton);
        this.loopDownValueListener = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = T1ControlMenuAbstractFactory.this.screen.getListenerBaseName() + ".loopDownValueListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                T1ControlMenuAbstractFactory.this.enableLoopDownButton(pushButton);
            }
        };
        this.settings.getLoopState().addValueListener(this.loopDownValueListener);
        return pushButton;
    }

    private void enableLoopDownButton(PushButton pushButton) {
        pushButton.setEnabled(this.settings.isLoopUp());
    }

    public void dispose() {
        if (this.loopDownValueListener != null) {
            this.settings.getLoopState().removeValueListener(this.loopDownValueListener);
        }
        if (this.loopUpValueListener != null) {
            this.settings.getLoopState().removeValueListener(this.loopUpValueListener);
        }
    }
}

