/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.readings.BitFieldReading;
import elgato.infrastructure.readings.DoubleReading;
import elgato.infrastructure.readings.FloatReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.measurement.backhaul.BackhaulMeasurement;
import java.io.DataInput;
import java.io.IOException;

public class T1Measurement
extends BackhaulMeasurement {
    private static final Queue pool = new Queue(3);
    private static int NUM_COMPUTED_READINGS = 1;
    public static final int CURRENT_ALARM_INDICATORS = 0;
    public static final int CURRENT_STATUS_INDICATORS = 1;
    public static final int CURRENT_ERROR_INDICATORS = 2;
    public static final int CURRENT_MISC_INDICATORS = 3;
    public static final int RECEIVED_LEVEL_VPP = 4;
    public static final int RECEIVED_LEVEL_DBDSX = 5;
    public static final int RECEIVED_FREQUENCY = 6;
    public static final int ELAPSED_TIME = 7;
    public static final int BPV_ERRORS_PRIMARY = 8;
    public static final int BPV_ERROR_RATE_PRIMARY = 9;
    public static final int BPV_ERRD_SECS_PRIMARY = 10;
    public static final int BPV_ERRORS_SECONDARY = 11;
    public static final int BPV_ERROR_RATE_SECONDARY = 12;
    public static final int BPV_ERRD_SECS_SECONDARY = 13;
    public static final int FRAME_ERRORS_PRIMARY = 14;
    public static final int FRAME_ERROR_RATE_PRIMARY = 15;
    public static final int FRAME_ERRD_SECS_PRIMARY = 16;
    public static final int FRAME_ERRORS_SECONDARY = 17;
    public static final int FRAME_ERROR_RATE_SECONDARY = 18;
    public static final int FRAME_ERRD_SECS_SECONDARY = 19;
    public static final int CRC_ERRORS_PRIMARY = 20;
    public static final int CRC_ERROR_RATE_PRIMARY = 21;
    public static final int CRC_ERRD_SECS_PRIMARY = 22;
    public static final int CRC_ERRORS_SECONDARY = 23;
    public static final int CRC_ERROR_RATE_SECONDARY = 24;
    public static final int CRC_ERRD_SECS_SECONDARY = 25;
    public static final int SIGNAL_LOSS_PRIMARY = 26;
    public static final int FRAME_SYNC_LOSS_PRIMARY = 27;
    public static final int PATTERN_LOSS_PRIMARY_REALLY_DOESNT_EXIST = 28;
    public static final int ALL_ONES_PRIMARY = 29;
    public static final int EXCESS_ZEROS_PRIMARY = 30;
    public static final int YELLOW_ALARM_PRIMARY = 31;
    public static final int SIGNAL_LOSS_SECONDARY = 32;
    public static final int FRAME_SYNC_LOSS_SECONDARY = 33;
    public static final int PATTERN_LOSS_SECONDARY_REALLY_DOESNT_EXIST = 34;
    public static final int ALL_ONES_SECONDARY = 35;
    public static final int EXCESS_ZEROS_SECONDARY = 36;
    public static final int YELLOW_ALARM_SECONDARY = 37;
    public static final int ERR_FREE_PRIMARY = 38;
    public static final int ERRORED_PRIMARY = 39;
    public static final int SEVERELY_ERRORRED_PRIMARY = 40;
    public static final int AVAILABLE_PRIMARY = 41;
    public static final int UNAVAILABLE_PRIMARY = 42;
    public static final int DEGRADED_MIN_PRIMARY = 43;
    public static final int ERR_FREE_SECONDARY = 44;
    public static final int ERRORED_SECONDARY = 45;
    public static final int SEVERELY_ERRORRED_SECONDARY = 46;
    public static final int AVAILABLE_SECONDARY = 47;
    public static final int UNAVAILABLE_SECONDARY = 48;
    public static final int DEGRADED_MIN_SECONDARY = 49;
    public static final int CLOCK_SLIPS = 50;
    public static final int SLIP_RATE = 51;
    public static final int PEAK_POS_WANDER = 52;
    public static final int PEAK_NEG_WANDER = 53;
    public static final int POS_FRAME_SLIP = 54;
    public static final int NEG_FRAME_SLIP = 55;
    public static final int BIT_ERRORS = 56;
    public static final int BIT_ERROR_RATE = 57;
    public static final int BIT_ERROR_SECS = 58;
    public static final int PATTERN_SYNC_LOSS = 59;
    public static final int TEST_PATTERN = 60;
    public static final int TEST_DATA_RATE = 61;
    public static final int PERCENT_ERROR_FREE_SECONDS_PRIMARY = 62;
    public static final int PERCENT_ERRORED_SECONDS_PRIMARY = 63;
    public static final int PERCENT_SEVERELY_ERRORED_SECONDS_PRIMARY = 64;
    public static final int PERCENT_AVAILABLE_SECONDS_PRIMARY = 65;
    public static final int PERCENT_UNAVAILABLE_SECONDS_PRIMARY = 66;
    public static final int PERCENT_DEGRADED_MINUTES_PRIMARY = 67;
    public static final int PERCENT_ERROR_FREE_SECONDS_SECONDARY = 68;
    public static final int PERCENT_ERRORED_SECONDS_SECONDARY = 69;
    public static final int PERCENT_SEVERELY_ERRORED_SECONDS_SECONDARY = 70;
    public static final int PERCENT_AVAILABLE_SECONDS_SECONDARY = 71;
    public static final int PERCENT_UNAVAILABLE_SECONDS_SECONDARY = 72;
    public static final int PERCENT_DEGRADED_MINUTES_SECONDARY = 73;
    public static final int DELAY_UNIT_INTERVAL = 74;
    public static final int DELAY_MICROSECONDS = 75;
    public static final int DELAY_KILO_FETT = 76;
    public static final int DELAY_MILES = 77;
    public static final int SIG_BITS_START = 78;
    public static final int SIG_BITS_COUNT = 24;
    public static final int LOOP_STATE = 102;
    public static final int DELAY_KILOMETERS = 103;
    private BitFieldReading currentAlarmIndicators = new BitFieldReading();
    private BitFieldReading currentStatusIndicators = new BitFieldReading();
    private BitFieldReading currentErrorIndicators = new BitFieldReading();
    private BitFieldReading miscellaneousIndicators = new BitFieldReading();
    private IntegerReading receivedLevelPeaktoPeak = new IntegerReading();
    private IntegerReading receivedLeveldBdsx = new IntegerReading();
    private IntegerReading receivedFrequencyInHx = new IntegerReading();
    private IntegerReading elapsedTime = new IntegerReading();
    private IntegerReading bPVErrCount1 = new IntegerReading();
    private DoubleReading bPVErrRate1 = new DoubleReading();
    private IntegerReading bPVErrSeconds1 = new IntegerReading();
    private IntegerReading bPVErrCount2 = new IntegerReading();
    private DoubleReading bPVErrRate2 = new DoubleReading();
    private IntegerReading bPVErrSeconds2 = new IntegerReading();
    private IntegerReading frameErrCount1 = new IntegerReading();
    private DoubleReading frameErr1 = new DoubleReading();
    private IntegerReading frameErrSec1 = new IntegerReading();
    private IntegerReading frameErrCount2 = new IntegerReading();
    private DoubleReading frameErr2 = new DoubleReading();
    private IntegerReading frameErrSec2 = new IntegerReading();
    private IntegerReading cRCErrCount1 = new IntegerReading();
    private DoubleReading cRCErr1 = new DoubleReading();
    private IntegerReading cRCErrSeconds1 = new IntegerReading();
    private IntegerReading cRCErrCount2 = new IntegerReading();
    private DoubleReading cRCErr2 = new DoubleReading();
    private IntegerReading cRCErrSeconds2 = new IntegerReading();
    private IntegerReading signalLoss1 = new IntegerReading();
    private IntegerReading frameSyncLoss1 = new IntegerReading();
    private IntegerReading patternLoss1IsAlways0 = new IntegerReading();
    private IntegerReading allOnes1 = new IntegerReading();
    private IntegerReading excessZeros1 = new IntegerReading();
    private IntegerReading yellow1 = new IntegerReading();
    private IntegerReading signalLoss2 = new IntegerReading();
    private IntegerReading frameSyncLoss2 = new IntegerReading();
    private IntegerReading patternLoss2IsAlways0 = new IntegerReading();
    private IntegerReading allOnes2 = new IntegerReading();
    private IntegerReading excessZeros2 = new IntegerReading();
    private IntegerReading yellow2 = new IntegerReading();
    private IntegerReading errFree1 = new IntegerReading();
    private IntegerReading errored1 = new IntegerReading();
    private IntegerReading severelyErrored1 = new IntegerReading();
    private IntegerReading available1 = new IntegerReading();
    private IntegerReading unavailable1 = new IntegerReading();
    private IntegerReading degradedMin1 = new IntegerReading();
    private IntegerReading errFree2 = new IntegerReading();
    private IntegerReading errored2 = new IntegerReading();
    private IntegerReading severelyErrored2 = new IntegerReading();
    private IntegerReading available2 = new IntegerReading();
    private IntegerReading unavailable2 = new IntegerReading();
    private IntegerReading degradedMin2 = new IntegerReading();
    private IntegerReading clockSlips = new IntegerReading();
    private DoubleReading clockSlipRate = new DoubleReading();
    private IntegerReading peakPosWander = new IntegerReading();
    private IntegerReading peakNegWander = new IntegerReading();
    private IntegerReading plusFrameSlips = new IntegerReading();
    private IntegerReading minusFrameSlips = new IntegerReading();
    private IntegerReading bitErrors = new IntegerReading();
    private DoubleReading bitErrorRate = new DoubleReading();
    private IntegerReading bitErroredSec = new IntegerReading();
    private IntegerReading patternSyncLoss = new IntegerReading();
    private IntegerReading testPattern = new IntegerReading();
    private IntegerReading testDataRate = new IntegerReading();
    private FloatReading percentErrorFreeSecondsPrimary = new FloatReading();
    private FloatReading percentErroredSecondsPrimary = new FloatReading();
    private FloatReading percentSeverelyErroredFreeSecondsPrimary = new FloatReading();
    private FloatReading percentAvailableSecondsPrimary = new FloatReading();
    private FloatReading percentUnAvailableSeconds = new FloatReading();
    private FloatReading percentDegradedMinutesPrimary = new FloatReading();
    private FloatReading percentErrorFreeSecondsSecondary = new FloatReading();
    private FloatReading percentErroredSecondsSecondary = new FloatReading();
    private FloatReading percentSeverelyErroredFreeSecondsSecondary = new FloatReading();
    private FloatReading percentAvailableSecondsSecondary = new FloatReading();
    private FloatReading percentUnAvailableSecondsSecondary = new FloatReading();
    private FloatReading percentDegradedMinutesSecondary = new FloatReading();
    private IntegerReading delayUnitInterval = new IntegerReading();
    private FloatReading delayMicroseconds = new FloatReading();
    private FloatReading delayKiloFeet = new FloatReading();
    private FloatReading delayMiles = new FloatReading();
    private DoubleReading delayKilometers = new DoubleReading();
    private BitFieldReading[] sigBits = new BitFieldReading[24];
    private IntegerReading loopState;
    private Reading[] readings;
    public static final int ALARM_LINE1_LOSS_OF_SIGNAL = 0;
    public static final int ALARM_LINE1_LOSS_OF_FRAME = 1;
    public static final int ALARM_LINE1_EXCESS_ZEROS = 2;
    public static final int ALARM_LINE1_ALL_ONES = 3;
    public static final int ALARM_LINE1_YELLOW_ALARM = 4;
    public static final int ALARM_LINE1_IDLE = 5;
    public static final int ALARM_LINE2_LOSS_OF_SIGNAL = 8;
    public static final int ALARM_LINE2_LOSS_OF_FRAME = 9;
    public static final int ALARM_LINE2_EXCESS_ZEROS = 10;
    public static final int ALARM_LINE2_ALL_ONES = 11;
    public static final int ALARM_LINE2_YELLOW_ALARM = 12;
    public static final int ALARM_LINE2_IDLE = 13;
    public static final int ALARM_LINE1_LOSS_OF_SIGNAL_HISTORY = 16;
    public static final int ALARM_LINE1_LOSS_OF_FRAME_HISTORY = 17;
    public static final int ALARM_LINE1_EXCESS_ZEROS_HISTORY = 18;
    public static final int ALARM_LINE1_ALL_ONES_HISTORY = 19;
    public static final int ALARM_LINE1_YELLOW_ALARM_HISTORY = 20;
    public static final int ALARM_LINE1_IDLE_HISTORY = 21;
    public static final int ALARM_LINE2_LOSS_OF_SIGNAL_HISTORY = 24;
    public static final int ALARM_LINE2_LOSS_OF_FRAME_HISTORY = 25;
    public static final int ALARM_LINE2_EXCESS_ZEROS_HISTORY = 26;
    public static final int ALARM_LINE2_ALL_ONES_HISTORY = 27;
    public static final int ALARM_LINE2_YELLOW_ALARM_HISTORY = 28;
    public static final int ALARM_LINE2_IDLE_HISTORY = 29;
    public static final int STATUS_LINE1_PULSES = 0;
    public static final int STATUS_LINE1_B8ZS = 1;
    public static final int STATUS_LINE1_FRAME_SYNC = 2;
    public static final int STATUS_LINE1_ALARMS = 3;
    public static final int STATUS_LINE1_ERRORS = 4;
    public static final int STATUS_LINE1_AIS = 5;
    public static final int STATUS_LINE2_PULSES = 6;
    public static final int STATUS_LINE2_B8ZS = 7;
    public static final int STATUS_LINE2_FRAME_SYNC = 8;
    public static final int STATUS_LINE2_ALARMS = 9;
    public static final int STATUS_LINE2_ERRORS = 10;
    public static final int STATUS_LINE2_AIS = 11;
    public static final int STATUS_LINE1_PULSES_HISTORY = 12;
    public static final int STATUS_LINE1_B8ZS_HISTORY = 13;
    public static final int STATUS_LINE1_FRAME_SYNC_HISTORY = 14;
    public static final int STATUS_LINE1_ALARMS_HISTORY = 15;
    public static final int STATUS_LINE1_ERRORS_HISTORY = 16;
    public static final int STATUS_LINE1_AIS_HISTORY = 17;
    public static final int STATUS_LINE2_PULSES_HISTORY = 18;
    public static final int STATUS_LINE2_B8ZS_HISTORY = 19;
    public static final int STATUS_LINE2_FRAME_SYNC_HISTORY = 20;
    public static final int STATUS_LINE2_ALARMS_HISTORY = 21;
    public static final int STATUS_LINE2_ERRORS_HISTORY = 22;
    public static final int STATUS_LINE2_AIS_HISTORY = 23;
    public static final int ERROR_LINE1_BPV = 0;
    public static final int ERROR_LINE1_FRAME = 1;
    public static final int ERROR_LINE1_CRC = 2;
    public static final int ERROR_LINE1_PATTERN_ERRORS = 3;
    public static final int ERROR_LINE2_BPV = 4;
    public static final int ERROR_LINE2_FRAME = 5;
    public static final int ERROR_LINE2_CRC = 6;
    public static final int ERROR_LINE2_PATTERN_ERRORS = 7;
    public static final int ERROR_LINE1_BPV_HISTORY = 8;
    public static final int ERROR_LINE1_FRAME_HISTORY = 9;
    public static final int ERROR_LINE1_CRC_HISTORY = 10;
    public static final int ERROR_LINE1_PATTERN_ERRORS_HISTORY = 11;
    public static final int ERROR_LINE2_BPV_HISTORY = 12;
    public static final int ERROR_LINE2_FRAME_HISTORY = 13;
    public static final int ERROR_LINE2_CRC_HISTORY = 14;
    public static final int ERROR_LINE2_PATTERN_ERRORS_HISTORY = 15;
    public static final int MISC_RUNNING = 0;
    public static final int MISC_ALARM_ERROR_INJECTION = 1;
    public static final int MISC_ALARM_PATTERN_SYNC = 2;
    public static final int MISC_ALARM_PATTERN_ERRORS = 3;
    public static final int MISC_ALARM_LOOPBACK_INDICATOR = 4;
    public static final int MISC_PATTERN_ERRORS = 5;
    public static final int MISC_CLOCK_FRAME_SLIPS = 6;
    public static final int MISC_LINE1_ERRORS = 7;
    public static final int MISC_LINE1_ALARMS = 8;
    public static final int MISC_LINE2_ERRORS = 9;
    public static final int MISC_LINE2_ALARMS = 10;
    public static final int MISC_COMMAND_ERROR = 11;
    public static final int MISC_POWER_UP_TESET = 12;
    public static final int MISC_ROM_TEST_FAIL = 13;
    public static final int MISC_RAM_TEST_FAIL = 14;
    public static final int MISC_SELF_TEST_FAIL = 15;
    public static final int SIG_BIT_A = 3;
    public static final int SIG_BIT_B = 2;
    public static final int SIG_BIT_C = 1;
    public static final int SIG_BIT_D = 0;
    private static final int VALUE_LOOP_DOWN = 0;
    private static final int VALUE_LOOP_UP = 1;

    public T1Measurement() {
        for (int i = 0; i < this.sigBits.length; ++i) {
            this.sigBits[i] = new BitFieldReading();
        }
        this.loopState = new IntegerReading();
        this.readings = new Reading[]{this.currentAlarmIndicators, this.currentStatusIndicators, this.currentErrorIndicators, this.miscellaneousIndicators, this.receivedLevelPeaktoPeak, this.receivedLeveldBdsx, this.receivedFrequencyInHx, this.elapsedTime, this.bPVErrCount1, this.bPVErrRate1, this.bPVErrSeconds1, this.bPVErrCount2, this.bPVErrRate2, this.bPVErrSeconds2, this.frameErrCount1, this.frameErr1, this.frameErrSec1, this.frameErrCount2, this.frameErr2, this.frameErrSec2, this.cRCErrCount1, this.cRCErr1, this.cRCErrSeconds1, this.cRCErrCount2, this.cRCErr2, this.cRCErrSeconds2, this.signalLoss1, this.frameSyncLoss1, this.patternLoss1IsAlways0, this.allOnes1, this.excessZeros1, this.yellow1, this.signalLoss2, this.frameSyncLoss2, this.patternLoss2IsAlways0, this.allOnes2, this.excessZeros2, this.yellow2, this.errFree1, this.errored1, this.severelyErrored1, this.available1, this.unavailable1, this.degradedMin1, this.errFree2, this.errored2, this.severelyErrored2, this.available2, this.unavailable2, this.degradedMin2, this.clockSlips, this.clockSlipRate, this.peakPosWander, this.peakNegWander, this.plusFrameSlips, this.minusFrameSlips, this.bitErrors, this.bitErrorRate, this.bitErroredSec, this.patternSyncLoss, this.testPattern, this.testDataRate, this.percentErrorFreeSecondsPrimary, this.percentErroredSecondsPrimary, this.percentSeverelyErroredFreeSecondsPrimary, this.percentAvailableSecondsPrimary, this.percentUnAvailableSeconds, this.percentDegradedMinutesPrimary, this.percentErrorFreeSecondsSecondary, this.percentErroredSecondsSecondary, this.percentSeverelyErroredFreeSecondsSecondary, this.percentAvailableSecondsSecondary, this.percentUnAvailableSecondsSecondary, this.percentDegradedMinutesSecondary, this.delayUnitInterval, this.delayMicroseconds, this.delayKiloFeet, this.delayMiles, this.sigBits[0], this.sigBits[1], this.sigBits[2], this.sigBits[3], this.sigBits[4], this.sigBits[5], this.sigBits[6], this.sigBits[7], this.sigBits[8], this.sigBits[9], this.sigBits[10], this.sigBits[11], this.sigBits[12], this.sigBits[13], this.sigBits[14], this.sigBits[15], this.sigBits[16], this.sigBits[17], this.sigBits[18], this.sigBits[19], this.sigBits[20], this.sigBits[21], this.sigBits[22], this.sigBits[23], this.loopState, this.delayKilometers};
    }

    public Reading[] getReadings() {
        return this.readings;
    }

    public static T1Measurement unpack(DataInput dataInput) throws IOException {
        T1Measurement t1Measurement = T1Measurement.create();
        Reading[] readingArray = t1Measurement.getReadings();
        for (int i = 0; i < readingArray.length - NUM_COMPUTED_READINGS; ++i) {
            readingArray[i].unpack(dataInput);
        }
        t1Measurement.setDelayKilometers();
        return t1Measurement;
    }

    void setDelayKilometers() {
        double d = 1.0E-5;
        double d2 = this.delayMiles.floatValue() - -1.0f;
        double d3 = -1.0;
        if (Math.abs(d2) > d) {
            d3 = T1Measurement.convertMilesToKilometers(this.delayMiles.floatValue());
        }
        this.delayKilometers.setValue(d3);
    }

    private static double convertMilesToKilometers(float f) {
        return (double)f * 1.61;
    }

    static T1Measurement create() {
        T1Measurement t1Measurement = (T1Measurement)pool.dequeue();
        if (t1Measurement == null) {
            return new T1Measurement();
        }
        return t1Measurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    int getCurrentAlarmIndicators() {
        return this.currentAlarmIndicators.intValue();
    }

    public void setCurrentAlarmIndicator(int n, boolean bl) {
        this.currentAlarmIndicators.setBitValue(n, bl);
    }

    void setCurrentAlarmIndicators(int n) {
        this.currentAlarmIndicators.setValue(n);
    }

    int getCurrentStatusIndicators() {
        return this.currentStatusIndicators.intValue();
    }

    void setCurrentStatusIndicators(int n) {
        this.currentStatusIndicators.setValue(n);
    }

    int getCurrentErrorIndicators() {
        return this.currentErrorIndicators.intValue();
    }

    void setCurrentErrorIndicators(int n) {
        this.currentErrorIndicators.setValue(n);
    }

    int getMiscellaneousIndicatorsIntValue() {
        return this.miscellaneousIndicators.intValue();
    }

    BitFieldReading getMiscellaneousIndicators() {
        return this.miscellaneousIndicators;
    }

    void setMiscellaneousIndicators(int n) {
        this.miscellaneousIndicators.setValue(n);
    }

    public int getReceivedLevelPeaktoPeak() {
        return this.receivedLevelPeaktoPeak.intValue();
    }

    public int getReceivedLeveldBdsx() {
        return this.receivedLeveldBdsx.intValue();
    }

    public int getReceivedFrequencyInHx() {
        return this.receivedFrequencyInHx.intValue();
    }

    public int getElapsedTime() {
        return this.elapsedTime.intValue();
    }

    public int getbPVErrCount1() {
        return this.bPVErrCount1.intValue();
    }

    public double getbPVErrRate1() {
        return this.bPVErrRate1.doubleValue();
    }

    public int getbPVErrSeconds1() {
        return this.bPVErrSeconds1.intValue();
    }

    public int getbPVErrCount2() {
        return this.bPVErrCount2.intValue();
    }

    public double getbPVErrRate2() {
        return this.bPVErrRate2.doubleValue();
    }

    public int getbPVErrSeconds2() {
        return this.bPVErrSeconds2.intValue();
    }

    public int getFrameErrCount1() {
        return this.frameErrCount1.intValue();
    }

    public double getFrameErr1() {
        return this.frameErr1.doubleValue();
    }

    public int getFrameErrSec1() {
        return this.frameErrSec1.intValue();
    }

    public int getFrameErrCount2() {
        return this.frameErrCount2.intValue();
    }

    public double getFrameErr2() {
        return this.frameErr2.doubleValue();
    }

    public int getFrameErrSec2() {
        return this.frameErrSec2.intValue();
    }

    public int getcRCErrCount1() {
        return this.cRCErrCount1.intValue();
    }

    public double getcRCErr1() {
        return this.cRCErr1.doubleValue();
    }

    public int getcRCErrSeconds1() {
        return this.cRCErrSeconds1.intValue();
    }

    public int getcRCErrCount2() {
        return this.cRCErrCount2.intValue();
    }

    public double getcRCErr2() {
        return this.cRCErr2.doubleValue();
    }

    public int getcRCErrSeconds2() {
        return this.cRCErrSeconds2.intValue();
    }

    public int getSignalLoss1() {
        return this.signalLoss1.intValue();
    }

    public int getFrameSyncLoss1() {
        return this.frameSyncLoss1.intValue();
    }

    public int getPatternLoss1() {
        return this.patternLoss1IsAlways0.intValue();
    }

    public int getAllOnes1() {
        return this.allOnes1.intValue();
    }

    public int getExcessZeros1() {
        return this.excessZeros1.intValue();
    }

    public int getYellow1() {
        return this.yellow1.intValue();
    }

    public int getSignalLoss2() {
        return this.signalLoss2.intValue();
    }

    public int getFrameSyncLoss2() {
        return this.frameSyncLoss2.intValue();
    }

    public int getPatternLoss2() {
        return this.patternLoss2IsAlways0.intValue();
    }

    public int getAllOnes2() {
        return this.allOnes2.intValue();
    }

    public int getExcessZeros2() {
        return this.excessZeros2.intValue();
    }

    public int getYellow2() {
        return this.yellow2.intValue();
    }

    public int getErrFree1() {
        return this.errFree1.intValue();
    }

    public int getErrored1() {
        return this.errored1.intValue();
    }

    public int getSeverelyErrored1() {
        return this.severelyErrored1.intValue();
    }

    public int getAvailable1() {
        return this.available1.intValue();
    }

    public int getUnavailable1() {
        return this.unavailable1.intValue();
    }

    public int getDegradedMin1() {
        return this.degradedMin1.intValue();
    }

    public int getErrFree2() {
        return this.errFree2.intValue();
    }

    public int getErrored2() {
        return this.errored2.intValue();
    }

    public int getSeverelyErrored2() {
        return this.severelyErrored2.intValue();
    }

    public int getAvailable2() {
        return this.available2.intValue();
    }

    public int getUnavailable2() {
        return this.unavailable2.intValue();
    }

    public int getDegradedMin2() {
        return this.degradedMin2.intValue();
    }

    public int getClockSlips() {
        return this.clockSlips.intValue();
    }

    public double getClockSlipRate() {
        return this.clockSlipRate.doubleValue();
    }

    public int getPeakPosWander() {
        return this.peakPosWander.intValue();
    }

    public int getPeakNegWander() {
        return this.peakNegWander.intValue();
    }

    public int getPlusFrameSlips() {
        return this.plusFrameSlips.intValue();
    }

    public int getMinusFrameSlips() {
        return this.minusFrameSlips.intValue();
    }

    public int getBitErrors() {
        return this.bitErrors.intValue();
    }

    public double getBitErrorRate() {
        return this.bitErrorRate.doubleValue();
    }

    public int getBitErroredSec() {
        return this.bitErroredSec.intValue();
    }

    public int getPatternSyncLoss() {
        return this.patternSyncLoss.intValue();
    }

    public int getTestPattern() {
        return this.testPattern.intValue();
    }

    public int getTestDataRate() {
        return this.testDataRate.intValue();
    }

    public float getPercentErrorFreeSecondsPrimary() {
        return this.percentErrorFreeSecondsPrimary.floatValue();
    }

    public float getPercentErroredSecondsPrimary() {
        return this.percentErroredSecondsPrimary.floatValue();
    }

    public float getPercentSeverelyErroredFreeSecondsPrimary() {
        return this.percentSeverelyErroredFreeSecondsPrimary.floatValue();
    }

    public float getPercentAvailableSecondsPrimary() {
        return this.percentAvailableSecondsPrimary.floatValue();
    }

    public float getPercentUnAvailableSeconds() {
        return this.percentUnAvailableSeconds.floatValue();
    }

    public float getPercentDegradedMinutesPrimary() {
        return this.percentDegradedMinutesPrimary.floatValue();
    }

    public float getPercentErrorFreeSecondsSecondary() {
        return this.percentErrorFreeSecondsSecondary.floatValue();
    }

    public float getPercentErroredSecondsSecondary() {
        return this.percentErroredSecondsSecondary.floatValue();
    }

    public float getPercentSeverelyErroredFreeSecondsSecondary() {
        return this.percentSeverelyErroredFreeSecondsSecondary.floatValue();
    }

    public float getPercentAvailableSecondsSecondary() {
        return this.percentAvailableSecondsSecondary.floatValue();
    }

    public float getPercentUnAvailableSecondsSecondary() {
        return this.percentUnAvailableSecondsSecondary.floatValue();
    }

    public float getPercentDegradedMinutesSecondary() {
        return this.percentDegradedMinutesSecondary.floatValue();
    }

    public boolean getCurrentAlarmIndicator(int n) {
        return this.currentAlarmIndicators.bitValue(n);
    }

    public boolean getCurrentStatusIndicator(int n) {
        return this.currentStatusIndicators.bitValue(n);
    }

    public boolean getCurrentErrorIndicator(int n) {
        return this.currentErrorIndicators.bitValue(n);
    }

    public boolean getMiscErrorIndicator(int n) {
        return this.miscellaneousIndicators.bitValue(n);
    }

    public int getDelayUnitInterval() {
        return this.delayUnitInterval.intValue();
    }

    public float getDelayMicroseconds() {
        return this.delayMicroseconds.floatValue();
    }

    public float getKiloFeet() {
        return this.delayKiloFeet.floatValue();
    }

    public float getDelayMiles() {
        return this.delayMiles.floatValue();
    }

    public double getDelayKilometers() {
        return this.delayKilometers.doubleValue();
    }

    public void setElapsedTime(int n) {
        this.elapsedTime.setValue(n);
    }

    public void setbPVErrCount1(int n) {
        this.bPVErrCount1.setValue(n);
    }

    public void setbPVErrRate1(double d) {
        this.bPVErrRate1.setValue(d);
    }

    public void setbPVErrSeconds1(int n) {
        this.bPVErrSeconds1.setValue(n);
    }

    public void setFrameErrCount1(int n) {
        this.frameErrCount1.setValue(n);
    }

    public void setFrameErr1(double d) {
        this.frameErr1.setValue(d);
    }

    public void setFrameErrSec1(int n) {
        this.frameErrSec1.setValue(n);
    }

    public void setReceivedLevelPeaktoPeak(int n) {
        this.receivedLevelPeaktoPeak.setValue(n);
    }

    public void setReceivedLeveldBdsx(int n) {
        this.receivedLeveldBdsx.setValue(n);
    }

    public void setReceivedFrequencyInHx(int n) {
        this.receivedFrequencyInHx.setValue(n);
    }

    public void setbPVErrCount2(int n) {
        this.bPVErrCount2.setValue(n);
    }

    public void setbPVErrRate2(double d) {
        this.bPVErrRate2.setValue(d);
    }

    public void setbPVErrSeconds2(int n) {
        this.bPVErrSeconds2.setValue(n);
    }

    public void setFrameErrCount2(int n) {
        this.frameErrCount2.setValue(n);
    }

    public void setFrameErr2(double d) {
        this.frameErr2.setValue(d);
    }

    public void setFrameErrSec2(int n) {
        this.frameErrSec2.setValue(n);
    }

    public void setcRCErrCount1(int n) {
        this.cRCErrCount1.setValue(n);
    }

    public void setcRCErr1(double d) {
        this.cRCErr1.setValue(d);
    }

    public void setcRCErrSeconds1(int n) {
        this.cRCErrSeconds1.setValue(n);
    }

    public void setcRCErrCount2(int n) {
        this.cRCErrCount2.setValue(n);
    }

    public void setcRCErr2(double d) {
        this.cRCErr2.setValue(d);
    }

    public void setcRCErrSeconds2(int n) {
        this.cRCErrSeconds2.setValue(n);
    }

    public void setSignalLoss1(int n) {
        this.signalLoss1.setValue(n);
    }

    public void setFrameSyncLoss1(int n) {
        this.frameSyncLoss1.setValue(n);
    }

    public void setPatternLoss1(int n) {
        this.patternLoss1IsAlways0.setValue(n);
    }

    public void setAllOnes1(int n) {
        this.allOnes1.setValue(n);
    }

    public void setExcessZeros1(int n) {
        this.excessZeros1.setValue(n);
    }

    public void setYellow1(int n) {
        this.yellow1.setValue(n);
    }

    public void setSignalLoss2(int n) {
        this.signalLoss2.setValue(n);
    }

    public void setFrameSyncLoss2(int n) {
        this.frameSyncLoss2.setValue(n);
    }

    public void setPatternLoss2(int n) {
        this.patternLoss2IsAlways0.setValue(n);
    }

    public void setAllOnes2(int n) {
        this.allOnes2.setValue(n);
    }

    public void setExcessZeros2(int n) {
        this.excessZeros2.setValue(n);
    }

    public void setYellow2(int n) {
        this.yellow2.setValue(n);
    }

    public void setErrFree1(int n) {
        this.errFree1.setValue(n);
    }

    public void setErrored1(int n) {
        this.errored1.setValue(n);
    }

    public void setSeverelyErrored1(int n) {
        this.severelyErrored1.setValue(n);
    }

    public void setAvailable1(int n) {
        this.available1.setValue(n);
    }

    public void setUnavailable1(int n) {
        this.unavailable1.setValue(n);
    }

    public void setDegradedMin1(int n) {
        this.degradedMin1.setValue(n);
    }

    public void setErrFree2(int n) {
        this.errFree2.setValue(n);
    }

    public void setErrored2(int n) {
        this.errored2.setValue(n);
    }

    public void setSeverelyErrored2(int n) {
        this.severelyErrored2.setValue(n);
    }

    public void setAvailable2(int n) {
        this.available2.setValue(n);
    }

    public void setUnavailable2(int n) {
        this.unavailable2.setValue(n);
    }

    public void setDegradedMin2(int n) {
        this.degradedMin2.setValue(n);
    }

    public void setClockSlips(int n) {
        this.clockSlips.setValue(n);
    }

    public void setClockSlipRate(double d) {
        this.clockSlipRate.setValue(d);
    }

    public void setPeakPosWander(int n) {
        this.peakPosWander.setValue(n);
    }

    public void setPeakNegWander(int n) {
        this.peakNegWander.setValue(n);
    }

    public void setPlusFrameSlips(int n) {
        this.plusFrameSlips.setValue(n);
    }

    public void setMinusFrameSlips(int n) {
        this.minusFrameSlips.setValue(n);
    }

    public void setBitErrors(int n) {
        this.bitErrors.setValue(n);
    }

    public void setBitErrorRate(double d) {
        this.bitErrorRate.setValue(d);
    }

    public void setBitErroredSec(int n) {
        this.bitErroredSec.setValue(n);
    }

    public void setPatternSyncLoss(int n) {
        this.patternSyncLoss.setValue(n);
    }

    public void setTestPattern(int n) {
        this.testPattern.setValue(n);
    }

    public void setTestDataRate(int n) {
        this.testDataRate.setValue(n);
    }

    public void setPercentErrorFreeSecondsPrimary(float f) {
        this.percentErrorFreeSecondsPrimary.setValue(f);
    }

    public void setPercentErroredSecondsPrimary(float f) {
        this.percentErroredSecondsPrimary.setValue(f);
    }

    public void setPercentSeverelyErroredFreeSecondsPrimary(float f) {
        this.percentSeverelyErroredFreeSecondsPrimary.setValue(f);
    }

    public void setPercentAvailableSecondsPrimary(float f) {
        this.percentAvailableSecondsPrimary.setValue(f);
    }

    public void setPercentUnAvailableSecondsPrimary(float f) {
        this.percentUnAvailableSeconds.setValue(f);
    }

    public void setPercentDegradedMinutesPrimary(float f) {
        this.percentDegradedMinutesPrimary.setValue(f);
    }

    public void setPercentErrorFreeSecondsSecondary(float f) {
        this.percentErrorFreeSecondsSecondary.setValue(f);
    }

    public void setPercentErroredSecondsSecondary(float f) {
        this.percentErroredSecondsSecondary.setValue(f);
    }

    public void setPercentSeverelyErroredFreeSecondsSecondary(float f) {
        this.percentSeverelyErroredFreeSecondsSecondary.setValue(f);
    }

    public void setPercentAvailableSecondsSecondary(float f) {
        this.percentAvailableSecondsSecondary.setValue(f);
    }

    public void setPercentUnAvailableSecondsSecondary(float f) {
        this.percentUnAvailableSecondsSecondary.setValue(f);
    }

    public void setPercentDegradedMinutesSecondary(float f) {
        this.percentDegradedMinutesSecondary.setValue(f);
    }

    public void setDelayUnitInterval(int n) {
        this.delayUnitInterval.setValue(n);
    }

    public void setDelayMiles(float f) {
        this.delayMiles.setValue(f);
        this.setDelayKilometers();
    }

    public void setDelayMicroseconds(float f) {
        this.delayMicroseconds.setValue(f);
    }

    public void setDelayKiloFeet(float f) {
        this.delayKiloFeet.setValue(f);
    }

    public float getDelayKiloFeet() {
        return this.delayKiloFeet.floatValue();
    }

    public void setCurrentErrorIndicator(int n, boolean bl) {
        this.currentErrorIndicators.setBitValue(n, bl);
    }

    public void setCurrentStatusIndicator(int n, boolean bl) {
        this.currentStatusIndicators.setBitValue(n, bl);
    }

    public void setMiscIndicator(int n, boolean bl) {
        this.miscellaneousIndicators.setBitValue(n, bl);
    }

    public String getMeasurementTitle() {
        return Text.T1;
    }

    public int getLoopState() {
        return this.loopState.intValue();
    }

    public void setLoopDown() {
        this.loopState.setValue(0);
    }

    public void setLoopUp() {
        this.loopState.setValue(1);
    }

    public void setLoopDownCompleted() {
        this.setLoopDown();
    }

    public void setLoopUpCompleted() {
        this.setLoopUp();
    }

    protected void setUnknownTestPatttern() {
        this.setTestPattern(12);
    }

    protected int getRomTestBit() {
        return 13;
    }

    protected int getRamTestBit() {
        return 14;
    }

    protected int getSelfTestBit() {
        return 15;
    }
}

