/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;
import elgato.measurement.backhaul.T1Measurement;

public class T1MeasurementSettings
extends CommonBackhaulMeasurementSettings {
    private static T1MeasurementSettings instance;
    private static final Logger logger;
    public static final String TOPIC = "t1Analyzer";
    public static final String TOPIC_DISPLAY = "display.t1Analyzer";
    private static final int VALUE_LOOP_DOWN_COMPLETED = 0;
    private static final int VALUE_LOOP_UP_COMPLETED = 1;
    private static final int VALUE_PRE_EXISTING_LOOP = 2;
    private static final int VALUE_LOOP_TIMEOUT = 3;
    private static final int VALUE_SENDING_LOOP_UP = 91;
    private static final int VALUE_SENDING_LOOP_DOWN = 92;
    private static final int VALUE_LOOP_BACK_STATE_UNKNOWN = 69;
    public static final int VALUE_T1_CONTROL_MODE_END_TO_END_FULL_T1_BERT = 0;
    public static final int VALUE_T1_CONTROL_MODE_END_TO_END_CHANNEL_BERT = 1;
    public static final int VALUE_T1_CONTROL_MODE_END_TO_END_CHANNEL_TONE = 2;
    public static final int VALUE_T1_CONTROL_MODE_CSU_FULL_T1_BERT = 3;
    public static final int VALUE_T1_CONTROL_MODE_CSU_CHANNEL_BERT = 4;
    public static final int VALUE_T1_CONTROL_MODE_CSU_CHANNEL_TONE = 5;
    public static final int VALUE_T1_CONTROL_MODE_NIU_FULL_T1_BERT = 6;
    public static final int VALUE_T1_CONTROL_MODE_NIU_CHANNEL_BERT = 7;
    public static final int VALUE_T1_CONTROL_MODE_NIU_CHANNEL_TONE = 8;
    public static final int VALUE_T1_CONTROL_MODE_MONITOR_FULL_T1_BERT = 9;
    public static final int VALUE_T1_CONTROL_MODE_MONITOR_CHANNEL_BERT = 10;
    public static final int VALUE_T1_CONTROL_MODE_MONITOR_CHANNEL_TONE = 11;
    public static final int VALUE_T1_CONTROL_MODE_DROP_AND_INSERT_CHANNEL = 12;
    public static final int VALUE_T1_CONTROL_MODE_DROP_AND_INSERT_CHANNEL_TONE = 13;
    public static final int VALUE_T1_CONTROL_MODE_EMULATE_CSU = 14;
    public static final int VALUE_T1_CONTROL_MODE_EMULATE_NIU = 15;
    public static final int VALUE_T1_CONTROL_MODE_DELAY_FULL_T1 = 16;
    public static final int VALUE_T1_CONTROL_MODE_NUMBER_OF_MODES = 17;
    public static final int VALUE_LINE_CODE_NA = 2;
    public static final int VALUE_LINE_CODE_B8ZS = 1;
    public static final int VALUE_LINE_CODE_AMI = 0;
    public static final int VALUE_T1_CONTROL_LOSS_OF_SIGNAL = 0;
    public static final int VALUE_T1_CONTROL_LOSS_OF_FRAME = 1;
    public static final int VALUE_T1_CONTROL_YELLOW_ALARM = 2;
    public static final int VALUE_T1_CONTROL_AIS_ALARM = 3;
    public static final int VALUE_T1_CONTROL_IDLE_ALARM = 4;
    public static final int VALUE_T1_CONTROL_BPV_ERROR = 5;
    public static final int VALUE_T1_CONTROL_FRAME_ERROR = 6;
    public static final int VALUE_T1_CONTROL_CRC_ERROR = 7;
    public static final int VALUE_T1_CONTROL_PATTERN_ERROR = 8;
    public static final int VALUE_T1_UNKNOWN_PATTERN = 12;
    public static final int VALUE_TEST_PATTERN_ALTERNATING = 11;
    public static final String KEY_T1_RESTART = "measState";
    public static final String KEY_T1_RX_INPUT = "rxInput";
    public static final String KEY_T1_LINE_CODE = "lineCoding";
    public static final String KEY_T1_FRAMING = "frameFormat";
    public static final String KEY_T1_PATTERN = "testPattern";
    public static final String KEY_T1_TX_CLOCK = "txClockSrc";
    public static final String KEY_T1_TX_LBO = "txOutput";
    public static final String KEY_T1_ESF_CODE = "esfLoopCode";
    public static final String KEY_T1_SECOND_TX = "line2TxSrc";
    public static final String KEY_T1_SLIP_REF = "refClockSrc";
    public static final String KEY_T1_FILL_DATA = "fillData";
    public static final String KEY_T1_STATUS = "status";
    public static final String KEY_T1_ALARMS = "alarms";
    public static final String KEY_T1_EMULATION_RESULTS = "emulationResults";
    public static final String KEY_T1_SETUP_MODE = "setupMode";
    public static final String KEY_T1_ALARM_MODE = "alarmMode";
    public static final String KEY_T1_ERROR_MODE = "errorMode";
    public static final String KEY_T1_INJECT_STATE = "injectState";
    public static final String KEY_T1_CHANNEL = "chanNum";
    public static final String KEY_T1_LOOP_STATE = "loopState";
    public static final String KEY_T1_AUTO_CONFIG = "autoConfig";
    public static final String KEY_T1_INJECT_TYPE = "injectType";
    public static int VALUE_DISPLAYED_RESULTS_EMULATE_RESULTS;
    public static int VALUE_DISPLAYED_RESULTS_EMULATE_PRIMARY_ERROR_SUMMARY;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_SUMMARY = 0;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_LEVEL_FREQUENCY = 1;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_ERROR_SUMMARY = 2;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_ERROR_SUMMARY = 3;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_BPV_FRAME_ERRORS = 4;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_BPV_FRAME_ERRORS = 5;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_CRC_ERRORS = 6;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_CRC_ERRORS = 7;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_ALARM_SECONDS = 8;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_ALARM_SECONDS = 9;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_PERFORMANCE = 10;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_PERFORMANCE = 11;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_CLOCK_FRAME_SLIPS = 12;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_TEST_PATTERN = 13;
    public static final int FRAMING_UNFRAMED = 0;
    public static final int FRAMING_D3_D4 = 1;
    public static final int FRAMING_ESF = 2;
    public static final String KEY_T1_CONTROL_MODE = "T1 Control Mode";
    private boolean loopbackReceived;
    private ListActuator loopbackLoopState;
    private LongActuator channel;
    private ListActuator txLbo;
    private ListActuator esfCode;
    public static final String KEY_STATE = "t1State";
    private ListActuator moduleState;
    private ListActuator emulationPanel;
    static /* synthetic */ Class class$elgato$measurement$backhaul$T1MeasurementSettings;

    public T1MeasurementSettings() {
        super(TOPIC);
        this.controlMode.addValueListener(new ValueListener(){
            private final String listenerName = "T1.controlMode";

            public String getListenerName() {
                return "T1.controlMode";
            }

            public void valueChanged(ValueInterface valueInterface) {
                T1MeasurementSettings.this.setLoopDown();
                T1MeasurementSettings.this.setLoopBackStateUnknown();
                if (T1MeasurementSettings.this.isEmulateMode()) {
                    T1MeasurementSettings.this.resultPanel.send(0);
                }
            }
        });
        this.channel.setValidator(new RangeValidator(1L, 24L));
    }

    protected void addAdditionalActuators() {
        this.createActuators();
        this.add(this.lineCode);
        this.add(this.testPattern);
        this.add(this.loopState);
        this.add(this.channel);
        this.add(this.controlMode);
        this.add(this.txLbo);
        this.add(this.framing);
        this.add(this.esfCode);
        this.add(this.loopbackLoopState);
        this.add(this.moduleState);
        this.add(this.emulationPanel);
    }

    protected Value[] getResultValues() {
        return new Value[]{Value.createValue(Text.Pri_Error, Text.Primary_Summary, 0), Value.createValue(Text.Pri + " " + Text.Lev_slash_Freq, Text.Primary + " " + Text.Level_Frequency, 1), Value.createValue(Text.Pri_Error, Text.Primary_Error_Summary, 2), Value.createValue(Text.Sec_Error, Text.Secondary + " " + Text.Error_Summary, 3), Value.createValue(Text.Pri + " " + Text.BPV_slash_Frame, Text.Primary + " " + Text.BPV_and_Frame_Errors, 4), Value.createValue(Text.Sec + " " + Text.BPV_slash_Frame, Text.Secondary + " " + Text.BPV_and_Frame_Errors, 5), Value.createValue(Text.Pri + " " + Text.CRC, Text.Primary + " " + Text.CRC_Errors, 6), Value.createValue(Text.Sec + " " + Text.CRC, Text.Secondary + " " + Text.CRC_Errors, 7), Value.createValue(Text.Pri + " " + Text.Alarm, Text.Primary + " " + Text.Alarm_Seconds, 8), Value.createValue(Text.Sec + " " + Text.Alarm, Text.Secondary + " " + Text.Alarm_Seconds, 9), Value.createValue(Text.Pri + " " + Text.Perform, Text.Primary + " " + Text.Performance, 10), Value.createValue(Text.Sec + " " + Text.Perform, Text.Secondary + " " + Text.Performance, 11), Value.createValue(Text.Pri + " " + Text.Clock, Text.Primary + " " + Text.Clock_and_Frame_Slips, 12), Value.createValue(Text.Pri + " " + Text.Pattern, Text.Primary + " " + Text.Test_Pattern, 13)};
    }

    private void createActuators() {
        this.moduleState = new ListActuator(TOPIC, KEY_STATE, Text.State, new Value[]{Value.createValue(Text.Off, 0), Value.createValue(Text.On, 1), Value.createValue(Text.ROM_Test, 2), Value.createValue(Text.RAM_Test, 3), Value.createValue(Text.Loop_Test, 4)});
        this.lineCode = new ListActuator(TOPIC, KEY_T1_LINE_CODE, Text.Line_Code, new Value[]{Value.createValue(Text.AMI, 0), Value.createValue(Text.B8ZS, 1), Value.createValue(Text.NA, 2)});
        this.testPattern = new ListActuator(TOPIC, KEY_T1_PATTERN, Text.Pattern, new Value[]{Value.createValue(Text._1_colon_7, 1), Value.createValue(Text._2_in_8, 2), Value.createValue(Text._3_in_24, 3), Value.createValue(Text.All_1s, 4), Value.createValue(Text.All_0s, 0), Value.createValue(Text.QRSS, 5), Value.createValue(Text.T1_DALY, 6), Value.createValue(Text._55_Octet, 7), Value.createValue(Text._2E15_1, 8), Value.createValue(Text._2E20_1, 9), Value.createValue(Text._2E23_1, 10), Value.createValue(Text.Alternating_n_1s_and_0s, Text.Alternating_Ones_and_Zeroes, 11), Value.createValue(Text.Unknown_Pattern_live, 12)});
        this.loopState = new ListActuator(this.getTopic(), KEY_T1_LOOP_STATE, "emulate loop state", new Value[]{Value.createValue(Text.Loop_Down, 0), Value.createValue(Text.Loop_Up, 1)});
        this.channel = new LongActuator(TOPIC, KEY_T1_CHANNEL, Text.Channel, 1L);
        this.controlMode = new ListActuator(TOPIC, "mode", Text.Control, new Value[]{Value.createValue(Text.Full_T1_n_BERT, 0), Value.createValue(Text.Channel_n_Bert, 1), Value.createValue("EECT", 2), Value.createValue(Text.CSU_n_Full_T1_BERT, 3), Value.createValue(Text.CSU_n_Chan_BERT, 4), Value.createValue("CCT", 5), Value.createValue(Text.NIU_n_Full_T1_BERT, 6), Value.createValue(Text.NIU_n_Chan_BERT, 7), Value.createValue("NCT", 8), Value.createValue(Text.Monitor_n_Full_T1, 9), Value.createValue(Text.Monitor_n_Channel, 10), Value.createValue("MCT", 11), Value.createValue("DIC", 12), Value.createValue("DICT", 13), Value.createValue(Text.Emulate_n_CSU, 14), Value.createValue(Text.Emulate_n_NIU, 15), Value.createValue(Text.Full_T1, 16)});
        this.txLbo = new ListActuator(TOPIC, KEY_T1_TX_LBO, Text.TX_LBO, new Value[]{Value.createValue(Text.zero_db, 0), Value.createValue(Text.minus_7_5_dB, 1), Value.createValue(Text.minus_15_dB, 2)});
        this.framing = new ListActuator(TOPIC, KEY_T1_FRAMING, Text.Framing, new Value[]{Value.createValue(Text.Unframed, 0), Value.createValue(Text.D3_slash_D4, 1), Value.createValue(Text.ESF, 2)});
        this.esfCode = new ListActuator(TOPIC, KEY_T1_ESF_CODE, Text.Loop_Code, new Value[]{Value.createValue(Text.ESF_Datalink, 1), Value.createValue(Text.In_dash_band, 0)});
        this.injectType = new ListActuator(TOPIC, KEY_T1_INJECT_TYPE, Text.Alarm_slash_Error, new Value[]{Value.createValue(Text.Loss_of_Signal, Text.Loss_of_Signal_Alarm, 0), Value.createValue(Text.Loss_of_Frame, Text.Loss_of_Frame_Alarm, 1), Value.createValue(Text.Yellow, Text.Yellow_Alarm, 2), Value.createValue(Text.AIS, Text.AIS_Alarm, 3), Value.createValue(Text.Idle, Text.Idle_Alarm, 4), Value.createValue(Text.BPV, Text.BPV_Error, 5), Value.createValue(Text.Frame, Text.Frame_Error, 6), Value.createValue(Text.CRC, Text.CRC_Error, 7), Value.createValue(Text.Pattern, Text.Pattern_Error, 8)});
        this.loopbackLoopState = new ListActuator(TOPIC, KEY_T1_LOOP_STATE, "loopback loop state", new Value[]{Value.createValue(Text.Loop_Down_Completed, 0), Value.createValue(Text.Loop_Up_Completed, 1), Value.createValue(Text.Pre_existing_Loop, 2), Value.createValue(Text.Loop_Up_Timeout, 3), Value.createValue(Text.Sending_Loop_Up, 91), Value.createValue(Text.Sending_Loop_Down, 92), Value.createValue("", 69)});
        this.emulationPanel = new ListActuator(TOPIC_DISPLAY, KEY_T1_EMULATION_RESULTS, Text.Results, new Value[]{Value.createValue(Text.Emulation, Text.Emulation_Results, VALUE_DISPLAYED_RESULTS_EMULATE_RESULTS), Value.createValue(Text.Pri_Error, Text.Primary_Error_Summary, VALUE_DISPLAYED_RESULTS_EMULATE_PRIMARY_ERROR_SUMMARY)});
        this.emulationPanel.addValueListener(new ValueListener(){
            private final String listenerName = "T1.emulationPanel";

            public String getListenerName() {
                return "T1.emulationPanel";
            }

            public void valueChanged(ValueInterface valueInterface) {
                T1MeasurementSettings.this.resultPanel.send(valueInterface.intValue());
            }
        });
    }

    public void measurementReceived(Measurement measurement) {
        logger.debug("T1Measurement received.");
        if (RuntimeConfiguration.runningInStubMode()) {
            return;
        }
        T1Measurement t1Measurement = (T1Measurement)measurement;
        this.setPulses(t1Measurement.getCurrentStatusIndicator(0));
        if (this.isLoopbackMode()) {
            logger.debug("Setting loopback loop state to " + t1Measurement.getLoopState());
            if (this.loopbackReceived) {
                this.loopbackLoopState.setValue(t1Measurement.getLoopState());
                logger.debug("Loopback loop state set to " + this.loopbackLoopState.toString());
            }
        } else if (this.isEmulateMode()) {
            logger.debug("Setting self loop state to " + t1Measurement.getLoopState());
            this.loopState.setValue(t1Measurement.getLoopState());
            logger.debug("Self loop state set to " + this.loopState.toString());
        }
        if (t1Measurement.getTestPattern() == 12) {
            this.testPattern.send();
        }
    }

    public void commandReceived(Command command) {
        int n = this.testPattern.getSelectedValue().intValue();
        int n2 = this.lineCode.getSelectedValue().intValue();
        if (command.propertyExists(this.loopState.getPropertyName()) && this.isLoopbackMode() && !this.loopbackReceived) {
            this.loopbackReceived = true;
        }
        super.commandReceived(command);
        if (this.newTestPatternUnknown(command)) {
            this.testPattern.send(n);
            if (!this.newLineCodeB8ZS(command)) {
                this.lineCode.send(n2);
            }
        } else if (this.newLineCodeNA(command, 2)) {
            this.lineCode.send(n2);
        }
    }

    public void setLineCodeB8ZS() {
        this.lineCode.setValue(1);
    }

    private boolean newTestPatternUnknown(Command command) {
        String string;
        return command.propertyExists(this.testPattern.getPropertyName()) && (string = command.getProperty(this.testPattern.getPropertyName())) != null && Integer.parseInt(string) == 12;
    }

    private boolean newLineCodeB8ZS(Command command) {
        String string;
        return command.propertyExists(this.lineCode.getPropertyName()) && (string = command.getProperty(this.lineCode.getPropertyName())) != null && Integer.parseInt(command.getProperty(this.lineCode.getPropertyName())) == 1;
    }

    public void setLoopState(int n) {
        if (this.loopState.intValue() == n) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 91: 
            case 92: {
                this.loopState.setValue(n);
                break;
            }
            default: {
                this.loopState.setValue(69);
            }
        }
    }

    public void setSendingLoopUp() {
        this.loopbackLoopState.setValue(91);
        this.loopbackReceived = false;
    }

    public void setSendingLoopDown() {
        this.loopbackLoopState.setValue(92);
        this.loopbackReceived = false;
    }

    public boolean isLoopUp() {
        return this.loopState.intValue() == 1;
    }

    public ListActuator getLoopState() {
        return this.loopState;
    }

    public void sendLoopDown() {
        this.loopbackLoopState.send(0);
    }

    public void sendLoopUp() {
        this.loopbackLoopState.send(1);
    }

    private void setLoopBackStateUnknown() {
        this.loopbackLoopState.setValue(69);
    }

    public LongActuator getChannel() {
        return this.channel;
    }

    public ListActuator getTxLbo() {
        return this.txLbo;
    }

    public boolean isEsfFraming() {
        return this.framing.intValue() == 2;
    }

    public ListActuator getEsfCode() {
        return this.esfCode;
    }

    public boolean isMonitorMode() {
        int n = this.controlMode.intValue();
        return n == 10 || n == 9 || n == 11;
    }

    public boolean isAlarmType(int n) {
        return n == 3 || n == 4 || n == 0 || n == 1 || n == 2;
    }

    public boolean isChannelMode() {
        int n = this.controlMode.intValue();
        return n == 1 || n == 4 || n == 10 || n == 7;
    }

    public boolean isDelayMode() {
        return this.controlMode.intValue() == 16;
    }

    public boolean isLoopbackMode() {
        int n = this.controlMode.intValue();
        return n == 4 || n == 5 || n == 3 || n == 7 || n == 8 || n == 6;
    }

    public boolean isEmulateMode() {
        int n = this.controlMode.intValue();
        return n == 14 || n == 15;
    }

    public boolean isEndToEndMode() {
        int n = this.controlMode.intValue();
        return n == 1 || n == 2 || n == 0;
    }

    public void setDelayMode() {
        this.controlMode.setValue(16);
    }

    public void setEmulateCsuMode() {
        this.controlMode.setValue(14);
    }

    public void setEndToEndChannelBertMode() {
        this.controlMode.setValue(1);
    }

    public void setCsuChannelBertMode() {
        this.controlMode.setValue(4);
    }

    public void setEmulateNiuMode() {
        this.controlMode.setValue(15);
    }

    public void setTestPatternAlternating() {
        this.testPattern.setValue(11);
    }

    public void setMonitorFullT1BertMode() {
        this.controlMode.setValue(9);
    }

    public void setDelayFullT1Mode() {
        this.controlMode.setValue(16);
    }

    public void setFraming_unframed() {
        this.framing.setValue(0);
    }

    public void setFraming_ESF() {
        this.framing.setValue(2);
    }

    public void setFraming_D3_D4() {
        this.framing.setValue(1);
    }

    public void setPreExistingLoop() {
        this.loopbackLoopState.setValue(2);
    }

    public ListActuator getLoopbackLoopState() {
        return this.loopbackLoopState;
    }

    public void setLoopUpCompleted() {
        this.loopbackLoopState.setValue(1);
    }

    public void setLoopTimeout() {
        this.loopbackLoopState.setValue(3);
    }

    public boolean isSendingLoopUp() {
        return this.loopbackLoopState.intValue() == 91;
    }

    public boolean isSendingLoopDown() {
        return this.loopbackLoopState.intValue() == 92;
    }

    public boolean isLoopBackStateUnkown() {
        return this.loopbackLoopState.intValue() == 69;
    }

    public void setLineCodeNA() {
        this.lineCode.setValue(2);
    }

    public static T1MeasurementSettings instance() {
        if (instance == null) {
            instance = new T1MeasurementSettings();
        }
        return instance;
    }

    public static void setInstance(T1MeasurementSettings t1MeasurementSettings) {
        instance = t1MeasurementSettings;
    }

    public boolean isUnframed() {
        return this.framing.intValue() == 0;
    }

    public boolean isD3D4Frammed() {
        return this.framing.intValue() == 1;
    }

    public boolean isFrameError() {
        return this.injectType.intValue() == 6;
    }

    public boolean isCRCError() {
        return this.injectType.intValue() == 7;
    }

    public ListActuator getModuleState() {
        return this.moduleState;
    }

    public ListActuator getEmulationPanel() {
        return this.emulationPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger = LogManager.getLogger(class$elgato$measurement$backhaul$T1MeasurementSettings == null ? (class$elgato$measurement$backhaul$T1MeasurementSettings = T1MeasurementSettings.class$("elgato.measurement.backhaul.T1MeasurementSettings")) : class$elgato$measurement$backhaul$T1MeasurementSettings);
        VALUE_DISPLAYED_RESULTS_EMULATE_RESULTS = 0;
        VALUE_DISPLAYED_RESULTS_EMULATE_PRIMARY_ERROR_SUMMARY = 1;
    }
}

