/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.menu.DynamicMenuButton;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.backhaul.CommonBackhaulMenuMgr;
import elgato.measurement.backhaul.T1Analyzer;
import elgato.measurement.backhaul.T1ControlMenuAbstractFactory;
import elgato.measurement.backhaul.T1MeasurementSettings;
import elgato.measurement.backhaul.T1Screen;

public abstract class T1MenuMgr
extends CommonBackhaulMenuMgr {
    private ValueListener controlModeListener;
    private MenuItem displayButton;
    public ValueListener setupModeListener;

    public T1MenuMgr(T1Screen t1Screen, T1MeasurementSettings t1MeasurementSettings, T1Analyzer t1Analyzer) {
        super(t1Screen, t1MeasurementSettings, t1Analyzer);
    }

    public Menu buildLeftMenu() {
        this.menuFactory = new T1ControlMenuAbstractFactory((T1Screen)this.scn);
        this.displayButton = this.createDisplayButton();
        this.controlMenuButton = this.menuFactory.createControlMenuButton();
        return new Menu(this.getLeftMenuName(), new MenuItem[]{this.createTestModeMenuButton(), this.getAutoConfigButton(), this.createSetupButton(), this.displayButton, this.controlMenuButton, this.createTestsButton(), this.createRestartButton()});
    }

    protected Menu[] createDisplayMenus() {
        Menu[] menuArray = new Menu[]{new Menu(Text.Display, new MenuItem[]{this.statusButton, this.alarmsButton, this.createResultsButton(), null, null, this.soundButton, this.volumeButton}), new Menu(Text.Display, new MenuItem[0]), new Menu(Text.Display, new MenuItem[]{this.statusButton, this.alarmsButton, this.createEmulationResultsButton(), null, null, this.soundButton, this.volumeButton})};
        return menuArray;
    }

    protected boolean autoConfigValid() {
        return ((T1MeasurementSettings)this.settings).isEndToEndMode() || this.settings.isMonitorMode();
    }

    public MenuItem createResultsButton() {
        return super.createResultsButton();
    }

    public MenuItem createEmulationResultsButton() {
        return new ListActuatorButton(((T1MeasurementSettings)this.settings).getEmulationPanel(), this.getContextString("backhaul.results"), this.getListenerBaseName() + ".emulationResultsButton");
    }

    public MenuItem createTestModeMenuButton() {
        SimpleMenuButton simpleMenuButton = new SimpleMenuButton(Text.Get_Started_slash_n_Test_Mode, this.getContextString("test.mode"), new Menu(Text.Test_Mode, new MenuItem[]{this.createGetStartedButton("T1ModeDisplayMain.html"), this.createEndToEndManLoopModeButton(), this.createLoopbackModeButton(), this.createMonitorModeButton(), this.createEmulateModeButton(), this.createDelayModeButton()}));
        simpleMenuButton.addActionListener(this.createLoadBackhaulAnalyzerActionListener());
        return simpleMenuButton;
    }

    protected SubMenuButton createEndToEndManLoopModeButton() {
        return new CommonBackhaulMenuMgr.SubMenuButtonWithDisplay(Text.Hard_Loop_n_End_End, this.getContextString("test.mode"), "T1ModeEndToEndManLoop.html", new Menu(Text.Hard_Loop, new MenuItem[]{this.createModeActionButton(Text.Full_T1_n_BERT, "full.backhaul.bert", 0), this.createModeActionButton(Text.Channel_n_Bert, "channel.bert", 1), null, null, null, null, null}));
    }

    protected SubMenuButton createLoopbackModeButton() {
        return new CommonBackhaulMenuMgr.SubMenuButtonWithDisplay(Text.Loopback_n_CSU_slash_NIU, this.getContextString("test.mode"), "T1ModeLoopback.html", new Menu(Text.Loopback, new MenuItem[]{this.createModeActionButton(Text.CSU_n_Full_T1_BERT, "csu.full.backhaul.bert", 3), this.createModeActionButton(Text.CSU_n_Chan_BERT, "csu.channel.bert", 4), null, this.createModeActionButton(Text.NIU_n_Full_T1_BERT, "niu.full.backhaul.bert", 6), this.createModeActionButton(Text.NIU_n_Chan_BERT, "niu.channel.bert", 7), null, null}));
    }

    protected SubMenuButton createMonitorModeButton() {
        return new CommonBackhaulMenuMgr.SubMenuButtonWithDisplay(Text.Monitor, this.getContextString("test.mode"), "T1ModeMonitor.html", new Menu(Text.Monitor, new MenuItem[]{this.createT1MonitorModeActionButton(Text.Monitor_n_Full_T1, "monitor.full.backhaul.bert", 9), this.createT1MonitorModeActionButton(Text.Monitor_n_Channel, "monitor.channel.bert", 10), null, null, null, null, null}));
    }

    protected SubMenuButton createEmulateModeButton() {
        return new CommonBackhaulMenuMgr.SubMenuButtonWithDisplay(Text.Emulate_n_CSU_slash_NIU, this.getContextString("test.mode"), "T1ModeEmulate.html", new Menu(Text.Emulate, new MenuItem[]{this.createModeActionButton(Text.Emulate_n_CSU, "emulate.csu", 14), this.createModeActionButton(Text.Emulate_n_NIU, "emulate.niu", 15), null, null, null, null, null}));
    }

    protected String getMeasurementName() {
        return "t1Analyzer";
    }

    protected String getLeftMenuName() {
        return Text.T1_Analyzer;
    }

    protected SubMenuButton createDelayModeButton() {
        return new CommonBackhaulMenuMgr.SubMenuButtonWithDisplay(Text.Delay, this.getContextString("test.mode"), "T1ModeDelay.html", new Menu(Text.Delay, new MenuItem[]{this.createModeActionButton(Text.Full_T1, "delay.full", 16), null, null, null, null, null, null}));
    }

    private ValueListener createControlModeListener() {
        return new ValueListener(){
            private final String listenerName = "T1Screen.controlModeListener";

            public String getListenerName() {
                return "T1Screen.controlModeListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (T1MenuMgr.this.settings.isEmulateMode()) {
                    T1MenuMgr.this.alarmsButton.setCurrentState(0);
                    T1MenuMgr.this.statusButton.setCurrentState(0);
                    T1MenuMgr.this.statusButton.setEnabled(false);
                    T1MenuMgr.this.alarmsButton.setEnabled(false);
                } else {
                    T1MenuMgr.this.statusButton.setEnabled(true);
                    T1MenuMgr.this.alarmsButton.setEnabled(true);
                }
                if (T1MenuMgr.this.settings.isDelayMode()) {
                    T1MenuMgr.this.controlMenuButton.setEnabled(false);
                } else {
                    T1MenuMgr.this.controlMenuButton.setEnabled(true);
                }
                T1MenuMgr.this.enableOrDisableAutoConfigButton(T1MenuMgr.this.autoConfigButton);
            }
        };
    }

    protected void addValueListeners() {
        super.addValueListeners();
        this.controlModeListener = this.createControlModeListener();
        this.settings.getControlMode().addValueListener(this.controlModeListener);
        this.controlModeListener.valueChanged(Value.createValue(this.settings.getControlMode().getLabel(), this.settings.getControlMode().intValue()));
    }

    public void removeValueListeners() {
        super.removeValueListeners();
        if (this.menuFactory != null) {
            ((T1ControlMenuAbstractFactory)this.menuFactory).dispose();
        }
        this.settings.getControlMode().removeValueListener(this.controlModeListener);
    }

    MenuItem getDisplayButton() {
        return this.displayButton;
    }

    MenuItem getControlMenuButton() {
        return this.controlMenuButton;
    }

    protected DynamicMenuButton.MenuSelector createMap() {
        return new DynamicMenuButton.MenuSelector(){

            public int getCurrentMenuIndex() {
                if (T1MenuMgr.this.settings.isEmulateMode()) {
                    return 2;
                }
                return T1MenuMgr.this.settings.isDelayMode() ? 1 : 0;
            }
        };
    }
}

