/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.backhaul.SetupMenuMgr;
import elgato.measurement.backhaul.SetupScreen;
import elgato.measurement.backhaul.T1MeasurementSettings;
import elgato.measurement.backhaul.T1SetupScreen;

public class T1SetupMenuMgr
extends SetupMenuMgr {
    private ValueListener esfButtonValueListener = new ValueListener(){
        private final String listenerName = "T1SetupScreen.esfButtonValueListener";

        public String getListenerName() {
            return "T1SetupScreen.esfButtonValueListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            T1SetupMenuMgr.this.enableEsfButton(T1SetupMenuMgr.this.esfCodeButton);
        }
    };
    private MenuItem esfCodeButton;

    public T1SetupMenuMgr(T1SetupScreen t1SetupScreen, T1MeasurementSettings t1MeasurementSettings) {
        super(t1SetupScreen, t1MeasurementSettings);
    }

    protected Menu createFirstSetupMenu() {
        return new Menu(Text.Setup, new MenuItem[]{this.createRxInputButton(), this.createLineCodeButton(), this.createFramingButton(), this.createPatternSetupButton(), this.createTxClockButton(), this.createTxLboButton()});
    }

    protected void addAdditionalValueListeners() {
        ((T1MeasurementSettings)this.settings).getChannel().addValueListener(this.valueListener);
        ((T1MeasurementSettings)this.settings).getEsfCode().addValueListener(this.valueListener);
        ((T1MeasurementSettings)this.settings).getTxLbo().addValueListener(this.valueListener);
        this.settings.getControlMode().addValueListener(this.esfButtonValueListener);
        this.settings.getFraming().addValueListener(this.esfButtonValueListener);
    }

    protected void removeAdditionalValueListeners() {
        ((T1MeasurementSettings)this.settings).getEsfCode().removeValueListener(this.valueListener);
        ((T1MeasurementSettings)this.settings).getTxLbo().removeValueListener(this.valueListener);
        ((T1MeasurementSettings)this.settings).getChannel().removeValueListener(this.valueListener);
        this.settings.getControlMode().removeValueListener(this.esfButtonValueListener);
        this.settings.getFraming().removeValueListener(this.esfButtonValueListener);
    }

    protected Menu createSecondSetupMenu() {
        this.esfCodeButton = this.createSetupButton(((T1MeasurementSettings)this.settings).getEsfCode(), SetupScreen.getContextString("esfcode"));
        this.enableEsfButton(this.esfCodeButton);
        Menu menu = new Menu(Text.Setup, new MenuItem[]{this.createChannelButton(), this.createFillDataButton(), this.esfCodeButton, this.createSlipRefButton(), this.createSecondTxButton(), null, this.createMoreButton(this.firstSetupMenu, Text.More_n_2_of_2)});
        return menu;
    }

    protected MenuItem createTxClockButton() {
        ActuatorSubMenuButton actuatorSubMenuButton = (ActuatorSubMenuButton)this.createSetupButton(this.settings.getTxClock(), SetupScreen.getContextString("txclock"));
        actuatorSubMenuButton.setEnabled(!this.settings.isDelayMode() && !this.settings.isEmulateMode());
        if (this.settings.isMonitorMode()) {
            MenuItem[] menuItemArray = actuatorSubMenuButton.getMenu().getItems();
            menuItemArray[0].setEnabled(false);
            menuItemArray[2].setEnabled(false);
        }
        return actuatorSubMenuButton;
    }

    private MenuItem createTxLboButton() {
        MenuItem menuItem = this.createSetupButton(((T1MeasurementSettings)this.settings).getTxLbo(), SetupScreen.getContextString("txlbo"));
        return menuItem;
    }

    private MenuItem createChannelButton() {
        MenuItem menuItem = this.createSetupButton(((T1MeasurementSettings)this.settings).getChannel(), SetupScreen.getContextString("channel"));
        menuItem.setEnabled(this.settings.isChannelMode());
        return menuItem;
    }

    private void enableEsfButton(MenuItem menuItem) {
        menuItem.setEnabled(((T1MeasurementSettings)this.settings).isEsfFraming() && (this.settings.isEmulateMode() || this.settings.isLoopbackMode()));
    }

    public void cleanup() {
        super.cleanup();
    }
}

