/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.backhaul.BackhaulMeasurement;
import elgato.measurement.backhaul.PanelProperties;
import elgato.measurement.backhaul.TestListener;
import java.awt.Color;

public class VerificationTests {
    public static int NUMBER_OF_TESTS = 3;
    private Test[] testsToPerform;
    protected ELabel waitLabel = new ELabel("", Color.white, PanelProperties.SUMMARY_FONT);
    private boolean continueTestSuite = true;
    TestListener testListener;
    TestListener stopTestListener;
    static /* synthetic */ Class class$elgato$measurement$backhaul$T1Measurement;

    public VerificationTests() {
        this.initializeTests();
    }

    public void stopTestSuite(TestListener testListener) {
        this.continueTestSuite = false;
        this.waitLabel.setChunk(0, Text.Stopping_Tests);
        this.stopTestListener = testListener;
    }

    public ELabel[] getLabels() {
        return new ELabel[]{this.testsToPerform[0].label, this.testsToPerform[1].label, this.testsToPerform[2].label};
    }

    public ELabel[] getValues() {
        return new ELabel[]{this.testsToPerform[0].value, this.testsToPerform[1].value, this.testsToPerform[2].value};
    }

    public ELabel getWaitMessage() {
        return this.waitLabel;
    }

    public void startTest(Class clazz, TestListener testListener) {
        this.testListener = testListener;
        new VerificationTester(clazz);
    }

    private void initializeTests() {
        this.testsToPerform = new Test[]{new Test(Text.ROM_Test, 2, Text.Performing_ROM_Testdotdotdot), new Test(Text.RAM_Test, 3, Text.Performing_RAM_Testdotdotdot), new Test(Text.Loop_Test, 4, Text.Performing_Loop_Testdotdotdot)};
    }

    static /* synthetic */ boolean access$400(VerificationTests verificationTests) {
        return verificationTests.continueTestSuite;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class VerificationTester
    implements MeasurementListener {
        private CommandListener verificationCommandListener;
        private Class measurementType;

        public VerificationTester(Class clazz) {
            this.measurementType = clazz;
            this.performTest(((VerificationTests)VerificationTests.this).testsToPerform[0].stateValue, this, 0);
        }

        private void performTest(int n, MeasurementListener measurementListener, int n2) {
            MeasurementFactory.instance().getMeasurementReader().removeMeasurementListener(measurementListener, this.measurementType);
            this.sendSetStateCommand(0);
            this.sendSetStateCommand(n);
            VerificationTests.this.waitLabel.setChunk(0, VerificationTests.this.testsToPerform[n2].waitMessage);
            this.verificationCommandListener = new CommandListener(this, n2, measurementListener){
                private final /* synthetic */ int val$indexTest;
                private final /* synthetic */ MeasurementListener val$listener;
                private final /* synthetic */ VerificationTester this$1;
                {
                    this.this$1 = verificationTester;
                    this.val$indexTest = n;
                    this.val$listener = measurementListener;
                }

                public void commandReceived(Command command) {
                    if (command.getProperty("event").equals("bhRomTestComplete") || command.getProperty("event").equals("bhRamTestComplete") || command.getProperty("event").equals("bhLoopTestComplete")) {
                        VerificationTester.access$200(this.this$1, 1);
                        if (VerificationTests.access$400(VerificationTester.access$300(this.this$1))) {
                            VerificationTests.access$000((VerificationTests)VerificationTester.access$300((VerificationTester)this.this$1))[this.val$indexTest].testRequested = true;
                            MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(this.val$listener, VerificationTester.access$500(this.this$1));
                        } else {
                            for (int i = 0; i < VerificationTests.access$000(VerificationTester.access$300(this.this$1)).length; ++i) {
                                VerificationTests.access$000((VerificationTests)VerificationTester.access$300((VerificationTester)this.this$1))[i].testRequested = true;
                            }
                            if (VerificationTester.access$300((VerificationTester)this.this$1).stopTestListener != null) {
                                VerificationTester.access$300((VerificationTester)this.this$1).stopTestListener.testsDone();
                            }
                        }
                        MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
                    }
                }
            };
            MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(this.verificationCommandListener);
        }

        public void measurementReceived(Measurement measurement) {
            if (((VerificationTests)VerificationTests.this).testsToPerform[0].testRequested && !((VerificationTests)VerificationTests.this).testsToPerform[1].testRequested) {
                ((VerificationTests)VerificationTests.this).testsToPerform[0].value.setChunk(0, ((BackhaulMeasurement)measurement).getRomTestResult());
                this.performTest(((VerificationTests)VerificationTests.this).testsToPerform[1].stateValue, this, 1);
            } else if (((VerificationTests)VerificationTests.this).testsToPerform[1].testRequested && !((VerificationTests)VerificationTests.this).testsToPerform[2].testRequested) {
                ((VerificationTests)VerificationTests.this).testsToPerform[1].value.setChunk(0, ((BackhaulMeasurement)measurement).getRamTestResult());
                this.performTest(((VerificationTests)VerificationTests.this).testsToPerform[2].stateValue, this, 2);
            } else if (((VerificationTests)VerificationTests.this).testsToPerform[2].testRequested) {
                ((VerificationTests)VerificationTests.this).testsToPerform[2].value.setChunk(0, ((BackhaulMeasurement)measurement).getSelfTestResult());
                VerificationTests.this.waitLabel.setChunk(0, Text.Tests_Complete);
                VerificationTests.this.testListener.testsDone();
                MeasurementFactory.instance().getMeasurementReader().removeMeasurementListener(this, this.measurementType);
            }
        }

        private void sendSetStateCommand(int n) {
            Command command;
            if (this.measurementType.getName().equals((class$elgato$measurement$backhaul$T1Measurement == null ? (class$elgato$measurement$backhaul$T1Measurement = VerificationTests.class$("elgato.measurement.backhaul.T1Measurement")) : class$elgato$measurement$backhaul$T1Measurement).getName())) {
                command = Command.makeSetCommand("t1Analyzer");
                command.addProperty("t1State", n);
            } else {
                command = Command.makeSetCommand("e1Analyzer");
                command.addProperty("e1State", n);
            }
            MeasurementFactory.instance().getCommandProcessor().send(command);
        }

        static /* synthetic */ void access$200(VerificationTester verificationTester, int n) {
            verificationTester.sendSetStateCommand(n);
        }

        static /* synthetic */ VerificationTests access$300(VerificationTester verificationTester) {
            return verificationTester.VerificationTests.this;
        }

        static /* synthetic */ Class access$500(VerificationTester verificationTester) {
            return verificationTester.measurementType;
        }
    }

    private class Test {
        protected boolean testRequested = false;
        protected int stateValue;
        protected ELabel label;
        protected ELabel value;
        private String waitMessage;

        public Test(String string, int n, String string2) {
            this.stateValue = n;
            this.waitMessage = string2;
            this.label = new ELabel(string, Color.white, PanelProperties.SUMMARY_FONT);
            this.value = new ELabel("--------", Color.white, PanelProperties.SUMMARY_FONT);
        }
    }
}

