/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.analyzer.SpectralChart;
import elgato.infrastructure.analyzer.SpectralChartPanel;
import elgato.infrastructure.analyzer.TopNChart;
import elgato.infrastructure.analyzer.TopNPanel;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.GrayScaleColorFlipFilter;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.cdma.CdmaChart;
import elgato.measurement.cdma.CdmaMeasurement;
import elgato.measurement.cdma.CdmaMeasurementSettings;
import elgato.measurement.cdma.CdmaMetricsTable;
import elgato.measurement.cdma.CdmaOverAirMeasurement;
import elgato.measurement.cdma.CdmaOverAirMetricsTable;
import elgato.measurement.cdma.CdmaTopNChart;
import elgato.measurement.cdma.CommonCdmaMeasurementSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CdmaAnalyzer
extends TraceAnalyzer {
    private static int yTop = 0;
    private static int yBottom = -50000;
    private static final DecibelStrategy dbmStrategy = new DecibelStrategy(1, true);
    private static final DecibelStrategy dbStrategy0 = new DecibelStrategy(0, false);
    private static final DecibelStrategy dbStrategy1 = new DecibelStrategy(1, false);
    private static final DecibelStrategy rfInStrategy = new DecibelStrategy(1, false);
    private static final String ANALYZER_CARD = "analyzer";
    private static final String CODOGRAM_CARD = "codogram";
    public static final String[] channelTypeNames = new String[]{Text.Unknown, Text.IS95, Text.CDMA2K, Text.Pilot, Text.Page, Text.Sync, Text.QPage, Text.Noise};
    private CdmaMeasurement measurement;
    private Container analyzerCard;
    private Container cardPanel;
    private Container chartPanel;
    private CdmaChart chart;
    private CdmaTopNChart topNChart;
    private BasicMeasurementMetrics metrics;
    private SpectralChartPanel spectralChartPanel;
    private TraceChart[] traceCharts;
    private boolean isOverAir;
    private CommonCdmaMeasurementSettings measurementSettings;
    private long lastcodogramTraceCapturedAt;
    private CardLayout cardLayout;
    private BorderLayout bottomCardLayout;
    private String currentCard;
    private Container bottomCardPanel;
    private Component bottomPanel;
    private Component bottomLimitsPanel;
    private JLabel passFailLabel;
    protected String listenerBaseName;
    private CodogramEnabledListener codogramEnabledListener;
    private CodogramPaletteListener codogramPaletteListener;
    private LimitStateListener limitStateListener;
    private CdmaOverAirTopNPanel cdmaOverAirTopNPanel;
    private final NumberFieldStrategy channelStrategy = new NumberFieldStrategy(){

        public String format(long l) {
            String string;
            int n = (int)l;
            int n2 = CdmaAnalyzer.this.getCdmaMeasurement().getIndexForXValue(n);
            int n3 = CdmaAnalyzer.this.getCdmaMeasurement().getChannelWidths()[n2];
            int n4 = 128 / n3;
            int n5 = CdmaAnalyzer.this.getCdmaMeasurement().getChannelTypes()[n2];
            StringBuffer stringBuffer = new StringBuffer(32);
            switch (n5) {
                default: {
                    string = Text.Unknown;
                    break;
                }
                case 1: {
                    string = Text.IS_dash_95_Traffic;
                    break;
                }
                case 2: {
                    string = Text.cdma2000_Traffic;
                    break;
                }
                case 3: {
                    string = Text.Pilot;
                    break;
                }
                case 4: {
                    string = Text.Page;
                    break;
                }
                case 5: {
                    string = Text.Sync;
                    break;
                }
                case 6: {
                    string = Text.QPage;
                    break;
                }
                case 7: {
                    string = Text.Noise;
                }
            }
            stringBuffer.append(n).append(", ").append(string);
            if (n5 == 2) {
                stringBuffer.append(" sf ").append(n4);
            }
            return stringBuffer.toString();
        }
    };

    public CdmaAnalyzer(boolean bl, CommonCdmaMeasurementSettings commonCdmaMeasurementSettings) {
        super(bl ? "CdmaAnalyzer" : "CdmaOaAnalyzer");
        this.isOverAir = bl;
        this.measurementSettings = commonCdmaMeasurementSettings;
        this.listenToActuator(this.measurementSettings.getReference());
        this.listenToActuator(this.measurementSettings.getScaleDiv());
        this.chartPanel = this.makeCdmaOverAirChartPanel(bl);
        this.analyzerCard = new JPanel();
        this.analyzerCard.setBackground(Color.black);
        this.analyzerCard.setLayout(new BorderLayout(0, 4));
        this.analyzerCard.add((Component)new BorderWrapper(this.chartPanel, TraceAnalyzer.getChartBorder(), true), "Center");
        this.bottomCardLayout = new BorderLayout();
        this.bottomCardPanel = new JPanel(this.bottomCardLayout);
        this.bottomPanel = this.createBottomPanel();
        this.bottomLimitsPanel = this.createBottomLimitsPanel();
        this.bottomLimitsPanel.setVisible(false);
        this.bottomCardPanel.add(this.bottomPanel, "North");
        this.bottomCardPanel.add(this.bottomLimitsPanel, "South");
        this.analyzerCard.add((Component)this.bottomCardPanel, "South");
        Container container = this.makeCodogramCard();
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setBackground(Color.black);
        this.cardPanel.add((Component)this.analyzerCard, ANALYZER_CARD);
        this.cardPanel.add((Component)container, CODOGRAM_CARD);
        if (bl) {
            this.analyzerCard.add((Component)this.createTopNSection(), "East");
            this.traceCharts = new TraceChart[]{this.chart, this.spectralChartPanel.getTraceChart(), this.topNChart};
        } else {
            this.traceCharts = new TraceChart[]{this.chart, this.spectralChartPanel.getTraceChart()};
        }
        this.codogramEnabledListener = new CodogramEnabledListener(this);
        this.codogramPaletteListener = new CodogramPaletteListener(this);
        this.measurementSettings.getCodogramEnabled().addValueListener(this.codogramEnabledListener);
        this.codogramEnabledListener.valueChanged(this.measurementSettings.getCodogramEnabled());
        this.measurementSettings.getCodogramPalette().addValueListener(this.codogramPaletteListener);
        this.limitStateListener = new LimitStateListener(this);
        for (int i = 0; i < 8; ++i) {
            this.measurementSettings.limitsToggleAt(i).addValueListener(this.limitStateListener);
        }
        this.updateCodogramPalette();
        this.updateChartVerticalRange();
    }

    public void dispose() {
        if (this.measurementSettings != null) {
            this.measurementSettings.getCodogramEnabled().removeValueListener(this.codogramEnabledListener);
            this.measurementSettings.getCodogramPalette().removeValueListener(this.codogramPaletteListener);
            for (int i = 0; i < 8; ++i) {
                this.measurementSettings.limitsToggleAt(i).removeValueListener(this.limitStateListener);
            }
        }
        this.codogramEnabledListener = null;
        this.codogramPaletteListener = null;
        this.limitStateListener = null;
        if (this.chart != null) {
            this.chart.dispose();
            this.chart.removeAll();
            this.chart = null;
        }
        if (this.analyzerCard != null) {
            this.analyzerCard.removeAll();
            this.analyzerCard = null;
        }
        this.cdmaOverAirTopNPanel = null;
        this.topNChart = null;
        this.metrics = null;
        this.spectralChartPanel = null;
        this.traceCharts = null;
        this.measurementSettings = null;
        if (this.measurement != null) {
            this.measurement.dispose();
        }
        super.dispose();
    }

    private Container makeCodogramCard() {
        JPanel jPanel = new JPanel(new TableLayout(new float[][]{{-1.0f}, {-2.0f, -2.0f}}));
        jPanel.add((Component)this.createMarkerDescriptionLabel(), "0,0");
        jPanel.add((Component)this.createRFInLossLabel(), "0,1");
        jPanel.setBackground(null);
        this.spectralChartPanel = new SpectralChartPanel(new SpectralChart(128), new CdmaChart(this), null, null);
        this.spectralChartPanel.getSpectralChart().setXAxisLinearity(false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.black);
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.spectralChartPanel, "Center");
        return jPanel2;
    }

    private Container makeCdmaOverAirChartPanel(boolean bl) {
        ELabel eLabel;
        this.chart = new CdmaChart(this);
        if (bl) {
            this.chart.addDLabel(new TraceAnalyzer.AverageDynamicLabel(33, 34, 49), 388, 8);
        } else {
            this.chart.setDrawYAxisLabels(true);
            this.chart.setyAxisStrategy(dbStrategy0);
            this.chart.addDLabel(new TraceAnalyzer.AverageDynamicLabel(22, 23, 31), 392, 12);
        }
        JPanel jPanel = new JPanel(new TableLayout(new float[][]{{75.0f, -1.0f, -1.0f}, {-2.0f, -2.0f, -1.0f}}));
        if (bl) {
            eLabel = this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

                protected String formatValue(Measurement measurement) {
                    if (!CdmaAnalyzer.this.isRelative()) {
                        return Text.Ref + " " + dbmStrategy.format(yTop);
                    }
                    return Text.Ref + " " + dbStrategy0.format(yTop);
                }
            });
            ELabel eLabel2 = this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

                protected String formatValue(Measurement measurement) {
                    return dbStrategy0.format(CdmaAnalyzer.this.measurementSettings.getScaleDiv().intValue()) + "/";
                }
            });
            jPanel.add((Component)eLabel, "0,0");
            jPanel.add((Component)eLabel2, "0,1");
        }
        eLabel = this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                CdmaMeasurement cdmaMeasurement = (CdmaMeasurement)measurement;
                if (CdmaAnalyzer.this.isRelative()) {
                    return Text.Threshold + " " + dbStrategy1.format(cdmaMeasurement.getCdpTraceThreshold());
                }
                return Text.Threshold + " " + dbmStrategy.format(cdmaMeasurement.getAbsCdpTraceThreshold());
            }
        });
        jPanel.add((Component)eLabel, "1,1");
        jPanel.add((Component)this.createMarkerDescriptionLabel(), "1,0,2,0");
        jPanel.add((Component)this.createRFInLossLabel(), "2,1");
        jPanel.add((Component)this.chart, "0,2,2,2");
        return jPanel;
    }

    private ELabel createMarkerDescriptionLabel() {
        return this.addLabel(new DynamicLabel("marker", 4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return CdmaAnalyzer.this.getCurrentMarkerDescription();
            }
        });
    }

    private ELabel createRFInLossLabel() {
        return this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return Text.RF_IN_Loss + " " + rfInStrategy.format(CdmaAnalyzer.this.measurementSettings.getRfInLoss().longValue());
            }
        });
    }

    protected TraceChart[] getCharts() {
        return this.traceCharts;
    }

    private Component createBottomPanel() {
        this.metrics = this.isOverAirMeasurement() ? new CdmaOverAirMetricsTable(this) : new CdmaMetricsTable(this);
        BorderWrapper borderWrapper = new BorderWrapper(this.metrics, MeasurementMetrics.BORDER, true);
        return borderWrapper;
    }

    private Component createBottomLimitsPanel() {
        JPanel jPanel = new JPanel();
        this.passFailLabel = new JLabel();
        jPanel.add(this.passFailLabel);
        return new BorderWrapper(jPanel, MeasurementMetrics.BORDER, true);
    }

    public void swapBottomPanel(boolean bl) {
        this.bottomLimitsPanel.setVisible(bl);
    }

    protected void setPassFailLabel() {
        if (this.areAllWithinLimits()) {
            this.passFailLabel.setForeground(MeasurementMetrics.DARK_GREEN);
            this.passFailLabel.setText("ALL PASS");
        } else {
            this.passFailLabel.setForeground(Color.red);
            this.passFailLabel.setText("FAILURE");
        }
    }

    private Container createTopNSection() {
        this.topNChart = new CdmaTopNChart();
        this.topNChart.setVerticalRange(10000, 0);
        this.cdmaOverAirTopNPanel = new CdmaOverAirTopNPanel(this.topNChart, this);
        return new BorderWrapper(this.cdmaOverAirTopNPanel, Resources.getResources("elgato.measurement.cdma.topn").getBorderConfig("border"), true);
    }

    public boolean isRelative() {
        return this.measurementSettings.getReference().intValue() == 0;
    }

    public void updateChartVerticalRange() {
        if (this.measurement == null | this.isRelative()) {
            yTop = 0;
            this.chart.setyAxisStrategy(dbStrategy1);
        } else {
            yTop = this.measurement.getChannelPower();
            this.chart.setyAxisStrategy(dbmStrategy);
        }
        yBottom = yTop - this.measurementSettings.getScaleDiv().intValue() * 10;
        this.chart.setVerticalRange(yTop, yBottom);
        this.chart.setReference(this.isRelative());
        if (!this.isRelative() & this.measurement != null) {
            this.spectralChartPanel.setVerticalLegendOffset(this.measurement.getChannelPower(), dbmStrategy);
        } else {
            this.spectralChartPanel.setVerticalLegendOffset(0, dbStrategy1);
        }
        this.spectralChartPanel.setVerticalRange(0, -this.measurementSettings.getScaleDiv().intValue() * 10);
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected void setMeasurement(Measurement measurement) {
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        this.measurement = (CdmaMeasurement)measurement;
    }

    protected void updateChartMeasurements() {
        boolean bl;
        super.updateChartMeasurements();
        long l = this.measurementSettings.getCodogramCaptureInterval().longValue() * 1000L;
        long l2 = System.currentTimeMillis();
        if (l == 0L) {
            bl = true;
        } else {
            long l3 = this.lastcodogramTraceCapturedAt;
            if (l3 <= 0L) {
                bl = true;
            } else {
                boolean bl2 = bl = l2 >= l3 + l;
            }
        }
        if (bl) {
            this.lastcodogramTraceCapturedAt = l2;
            int[] nArray = new int[128];
            int[] nArray2 = new int[128];
            int n = this.measurement.getNumBars();
            int n2 = 0;
            for (int i = 0; i < n && n2 < nArray.length; ++i) {
                int n3 = this.measurement.getChannelWidths()[i];
                int n4 = this.measurement.getChannelLevels()[i];
                int n5 = this.measurement.getAbsBarPower(i);
                int n6 = n2 + n3;
                if (n6 > nArray.length) break;
                while (n2 < n6) {
                    nArray[n2] = n4;
                    nArray2[n2] = n5;
                    ++n2;
                }
            }
            this.spectralChartPanel.addTrace(nArray, nArray2, this.measurement.getChannelPower());
            this.updateChartVerticalRange();
        }
    }

    protected void doUpdateChartMarkers() {
        super.doUpdateChartMarkers();
        this.spectralChartPanel.getSpectralChart().setMarkers(this.getMarkerButtonFactory().getMarkers());
    }

    private void updateCodogramPalette() {
        SpectralChart.PaletteMaker[] paletteMakerArray = SpectralChart.getAllPalettes();
        int n = this.measurementSettings.getCodogramPalette().intValue();
        this.spectralChartPanel.getSpectralChart().setPalette(paletteMakerArray[n].createPalette());
    }

    public void clearCodogramHistory() {
        this.spectralChartPanel.clearSpectrogramHistory();
    }

    protected Component getPane() {
        return this.cardPanel;
    }

    protected TraceChart getChart() {
        return this.chart;
    }

    protected Color getDataBackgroundColor() {
        return MenuPanel.BG_COLOR;
    }

    public MeasurementMetrics getMeasurementMetrics() {
        return this.metrics;
    }

    Container getMainPane() {
        return this.analyzerCard;
    }

    public boolean isOverAirMeasurement() {
        return this.isOverAir;
    }

    public TabDelimitable[] createReadingFields() {
        TabDelimitable[] tabDelimitableArray;
        block11: {
            int n;
            TabDelimitable[] tabDelimitableArray2;
            block10: {
                int n2;
                String string;
                String string2;
                int n3;
                int n4 = 0;
                int n5 = 0;
                int[] nArray = null;
                int[] nArray2 = null;
                if (this.isOverAir) {
                    n4 = this.measurement.getNumBars();
                    nArray = ((CdmaOverAirMeasurement)this.measurement).getTopPnOffsets();
                    nArray2 = ((CdmaOverAirMeasurement)this.measurement).getTopNPilotsValues();
                    n5 = nArray.length;
                } else {
                    n4 = this.measurement.getNumBars();
                }
                int n6 = 0;
                int n7 = 0;
                tabDelimitableArray2 = this.metrics.getTabDelimitables();
                n = tabDelimitableArray2.length;
                if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() != 1) break block10;
                if (this.isOverAir) {
                    n6 = 8;
                    tabDelimitableArray = new TabDelimitable[n + n4 + n6 + n5];
                } else {
                    n6 = 5;
                    tabDelimitableArray = new TabDelimitable[n + n4 + n6];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    tabDelimitableArray[n7++] = tabDelimitableArray2[n3];
                }
                n3 = CdmaMeasurementSettings.instance().getReference().intValue() == 0 ? 1 : 0;
                int n8 = n3 != 0 ? this.measurement.getIntegerReadingValue(11) : this.measurement.getAbsCdpTraceThreshold();
                float f = this.convertPowerToFloat(n8);
                if (n3 != 0) {
                    string2 = "Channel Power (dB)";
                    string = "dB";
                } else {
                    string2 = "Channel Power (dBm)";
                    string = "dBm";
                }
                tabDelimitableArray[n7++] = new TraceSaveTabDelimitable("");
                tabDelimitableArray[n7++] = new TraceSaveTabDelimitable("Trace Data");
                tabDelimitableArray[n7++] = new TraceSaveTabDelimitable("Bar Count\t" + String.valueOf(n4));
                tabDelimitableArray[n7++] = new TraceSaveTabDelimitable("CDP Power Threshold\t" + String.valueOf(f) + '\t' + string);
                tabDelimitableArray[n7++] = new TraceSaveTabDelimitable("Bar #\tChannel Number\t" + string2 + "\tChannel Width\tChannel Type");
                int[] nArray3 = this.measurement.getChannelTypes();
                int[] nArray4 = this.measurement.getChannelWidths();
                int[] nArray5 = this.measurement.getChannelNumbers();
                for (n2 = 0; n2 < n4; ++n2) {
                    int n9 = n3 != 0 ? this.measurement.getRelBarPower(n2) : this.measurement.getAbsBarPower(n2);
                    float f2 = this.convertPowerToFloat(n9);
                    String string3 = String.valueOf(n2 + 1) + '\t' + String.valueOf(nArray5[n2]) + '\t' + String.valueOf(f2) + '\t' + String.valueOf(nArray4[n2]) + '\t' + channelTypeNames[nArray3[n2]];
                    tabDelimitableArray[n7++] = new TraceSaveTabDelimitable(string3);
                }
                if (!this.isOverAir) break block11;
                tabDelimitableArray[n7++] = new TraceSaveTabDelimitable("");
                tabDelimitableArray[n7++] = new TraceSaveTabDelimitable("PN Offsets (3 strongest)");
                tabDelimitableArray[n7++] = new TraceSaveTabDelimitable("Bar #\tPN Offset\tRelative Powers (dB)");
                for (n2 = 0; n2 < n5; ++n2) {
                    float f3 = this.convertPowerToFloat(nArray2[n2]);
                    String string4 = String.valueOf(n2 + 1) + '\t' + String.valueOf(nArray[n2]) + '\t' + String.valueOf(f3);
                    tabDelimitableArray[n7++] = new TraceSaveTabDelimitable(string4);
                }
                break block11;
            }
            tabDelimitableArray = new TabDelimitable[n];
            for (int i = 0; i < n; ++i) {
                tabDelimitableArray[n7++] = tabDelimitableArray2[i];
            }
        }
        return tabDelimitableArray;
    }

    public NumberFieldStrategy getYAxisNormalStrategy() {
        return this.isRelative() ? dbStrategy1 : dbmStrategy;
    }

    public NumberFieldStrategy getYAxisDeltaStrategy() {
        return dbStrategy1;
    }

    private CdmaMeasurement getCdmaMeasurement() {
        return (CdmaMeasurement)this.getMeasurement();
    }

    public NumberFieldStrategy getXAxisStrategy() {
        return this.channelStrategy;
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        if (this.currentCard == CODOGRAM_CARD) {
            GrayScaleColorFlipFilter grayScaleColorFlipFilter = new GrayScaleColorFlipFilter(rectangle, true, false);
            return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), grayScaleColorFlipFilter));
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle = this.chartPanel.getBounds();
        rectangle.x += n;
        rectangle.y += n2;
        return super.filterPrintImage(image, rectangle);
    }

    public boolean isLimitOn(int n) {
        return this.measurementSettings.limitsToggleAt(n).getSelectedValue().longValue() == 1L;
    }

    public boolean areAllWithinLimits() {
        if (this.isLimitOn(0) && !this.isFreqErrorWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(1) && !this.isTimeOffsetWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(2) && !this.isEstRhoWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(3) && !this.isCarrFeedthruWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(4) && !this.isNoiseFloorWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(5) && !this.isPilotPowerWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(6) && !this.isPagePowerWithinLimits()) {
            return false;
        }
        return !this.isLimitOn(7) || this.isSyncPowerWithinLimits();
    }

    public boolean isFreqErrorWithinLimits() {
        int n = this.measurement.getFreqError() / 1000;
        return this.measurement.isCdpValid() && this.measurementSettings.getFreqErrorUpperLimit().longValue() >= (long)n && (long)n >= this.measurementSettings.getFreqErrorLowerLimit().longValue();
    }

    public boolean isTimeOffsetWithinLimits() {
        long l = UIHelper.chipsToNanoseconds(this.measurement.getPilotDelay());
        return this.measurement.isCdpValid() && this.measurementSettings.getTimeOffsetUpperLimit().longValue() >= l && l >= this.measurementSettings.getTimeOffsetLowerLimit().longValue();
    }

    public boolean isEstRhoWithinLimits() {
        return this.measurement.isCdpValid() && 1000 >= this.measurement.getEstimatedRho() && (long)this.measurement.getEstimatedRho() >= this.measurementSettings.getEstRhoLowerLimit().longValue() / 100L;
    }

    public boolean isCarrFeedthruWithinLimits() {
        return this.measurement.isCdpValid() && (long)this.measurement.getCarrierFeedthrough() <= this.measurementSettings.getCarrFeedthruUpperLimit().longValue();
    }

    public boolean isNoiseFloorWithinLimits() {
        return this.measurement.isCdpValid() && (long)this.measurement.getNoiseFloor() <= this.measurementSettings.getNoiseFloorUpperLimit().longValue();
    }

    public boolean isPilotPowerWithinLimits() {
        int n = this.measurement.getPilotPower();
        return this.measurement.isCdpValid() && this.measurementSettings.getPilotPowerUpperLimit().longValue() >= (long)n && (long)n >= this.measurementSettings.getPilotPowerLowerLimit().longValue();
    }

    public boolean isPagePowerWithinLimits() {
        return this.measurement.isCdpValid() && this.measurementSettings.getPagePowerUpperLimit().longValue() >= (long)this.measurement.getDiffPagePower() && (long)this.measurement.getDiffPagePower() >= this.measurementSettings.getPagePowerLowerLimit().longValue();
    }

    public boolean isSyncPowerWithinLimits() {
        return this.measurement.isCdpValid() && this.measurementSettings.getSyncPowerUpperLimit().longValue() >= (long)this.measurement.getDiffSyncPower() && (long)this.measurement.getDiffSyncPower() >= this.measurementSettings.getSyncPowerLowerLimit().longValue();
    }

    public static int getChannelType(String string) {
        int n = -1;
        for (int i = 0; i < channelTypeNames.length; ++i) {
            if (!channelTypeNames[i].equals(string)) continue;
            n = i;
        }
        return n;
    }

    private class CdmaOverAirTopNPanel
    extends TopNPanel {
        CdmaOverAirTopNPanel(TopNChart topNChart, TraceAnalyzer traceAnalyzer) {
            super(topNChart, traceAnalyzer);
        }

        public int getPilotDominance(Measurement measurement) {
            return ((CdmaOverAirMeasurement)measurement).getPilotDominance();
        }

        public boolean isPilotDominanceAboveLimit(Measurement measurement) {
            return ((CdmaOverAirMeasurement)measurement).isPilotDominanceAboveLimit();
        }

        public int getMultipathPower(Measurement measurement) {
            return ((CdmaOverAirMeasurement)measurement).getMultipathPower();
        }

        public boolean isMultipathPowerBelowLimit(Measurement measurement) {
            return ((CdmaOverAirMeasurement)measurement).isMultipathPowerBelowLimit();
        }
    }

    private static class LimitStateListener
    implements ValueListener {
        private String listenerName = ".limitsSummaryListener";
        private String baseName = null;
        private CdmaAnalyzer analyzer;

        public LimitStateListener(CdmaAnalyzer cdmaAnalyzer) {
            this.analyzer = cdmaAnalyzer;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.analyzer.swapBottomPanel(this.analyzer.measurementSettings.getLimitsSummaryState());
        }
    }

    private static class CodogramPaletteListener
    implements ValueListener {
        private String listenerName = ".codogramPaletteListener";
        private String baseName = null;
        private CdmaAnalyzer analyzer;

        public CodogramPaletteListener(CdmaAnalyzer cdmaAnalyzer) {
            this.analyzer = cdmaAnalyzer;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.analyzer.updateCodogramPalette();
        }
    }

    private static class CodogramEnabledListener
    implements ValueListener {
        private String listenerName = ".codogramEnabledListener";
        private String baseName = null;
        private CdmaAnalyzer analyzer;

        public CodogramEnabledListener(CdmaAnalyzer cdmaAnalyzer) {
            this.analyzer = cdmaAnalyzer;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            if (valueInterface.booleanValue()) {
                this.analyzer.currentCard = CdmaAnalyzer.CODOGRAM_CARD;
            } else {
                this.analyzer.currentCard = CdmaAnalyzer.ANALYZER_CARD;
            }
            this.analyzer.cardLayout.show(this.analyzer.cardPanel, this.analyzer.currentCard);
        }
    }
}

