/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.analyzer.BarChart;
import elgato.infrastructure.marker.Marker;
import elgato.measurement.cdma.CdmaAnalyzer;
import elgato.measurement.cdma.CdmaMeasurement;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

final class CdmaChart
extends BarChart {
    private static final int SLOT_COUNT = 128;
    int slot_spacing = 1;
    boolean relative = true;
    private final Font walshFont = new Font("SansSerif", 0, 9);
    private int[] xPts = new int[128];
    private int[] yPts = new int[128];
    private CdmaAnalyzer analyzer;
    private static final Color DARK_BLUE = new Color(0, 0, 228);
    private static final Color LIGHT_BLUE = new Color(120, 120, 255);
    private static final Color DARK_ORANGE = new Color(255, 140, 0);

    public CdmaChart(CdmaAnalyzer cdmaAnalyzer) {
        this.analyzer = cdmaAnalyzer;
    }

    public void dispose() {
        this.analyzer = null;
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        CdmaMeasurement cdmaMeasurement = (CdmaMeasurement)this.getMeasurement();
        int n6 = cdmaMeasurement.getNumBars();
        int[] nArray = cdmaMeasurement.getChannelTypes();
        int[] nArray2 = cdmaMeasurement.getChannelWidths();
        int[] nArray3 = cdmaMeasurement.getChannelNumbers();
        int n7 = this.getUnitBarWidth();
        int n8 = this.getYTop();
        int n9 = this.getYBottom() - n8;
        if (n4 == 0 || n9 == 0) {
            return;
        }
        if (n3 <= 130) {
            this.slot_spacing = 0;
        }
        int n10 = n;
        for (n5 = 0; n5 < n6; ++n5) {
            int n11 = this.relative ? cdmaMeasurement.getRelBarPower(n5) : cdmaMeasurement.getAbsBarPower(n5);
            int n12 = (n11 - n8) * n4 / n9;
            int n13 = nArray2[n5];
            int n14 = n13 * n7 + (n13 - 1) * this.slot_spacing;
            int n15 = nArray[n5];
            Color color = CdmaChart.colorForChanType(n15);
            graphics.setColor(color);
            graphics.fillRect(n10, n2 + n12, n14, n4 - n12);
            this.xPts[n5] = n10 + (n14 >> 1);
            this.yPts[n5] = n2 + n12;
            if (n3 > 130 & n15 != 7) {
                this.drawWalshCode(graphics, n5, n10, n2, n4, n14, Integer.toString(nArray3[n5]));
            }
            n10 += n14 + this.slot_spacing;
        }
        n5 = this.relative ? cdmaMeasurement.getRelCdpTraceThreshold() : cdmaMeasurement.getAbsCdpTraceThreshold();
        this.drawThresholdLine(graphics, n5, n, n2, n3, n4);
        this.drawMarkers(graphics);
    }

    private void drawMarkers(Graphics graphics) {
        Marker[] markerArray = this.getMarkers();
        if (markerArray == null) {
            return;
        }
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i].paint(this, graphics, this.xPts, this.yPts);
        }
    }

    protected Font getXAxisFont() {
        return this.walshFont;
    }

    protected int getXAxisRows() {
        return 3;
    }

    protected int getSlotCount() {
        return 128;
    }

    protected int getSlotSpacing() {
        return this.slot_spacing;
    }

    public void setReference(boolean bl) {
        this.relative = bl;
    }

    private static Color colorForChanType(int n) {
        switch (n) {
            case 1: {
                return Color.yellow;
            }
            case 2: {
                return DARK_ORANGE;
            }
            case 3: {
                return Color.red;
            }
            case 4: {
                return Color.green;
            }
            case 5: {
                return DARK_BLUE;
            }
            case 6: {
                return LIGHT_BLUE;
            }
            case 7: {
                return BarChart.NOISE_COLOR;
            }
        }
        return BarChart.UNKNOWN_COLOR;
    }

    protected void showLimits(Graphics graphics, int n, int n2) {
        this.analyzer.setPassFailLabel();
    }
}

