/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.peakSearch.DiscretePeakFinder;
import elgato.infrastructure.peakSearch.PeakFinder;
import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.LongReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.readings.UnsignedByteArrayReading;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.measurement.cdma.CdmaAnalyzer;
import elgato.measurement.cdma.CdmaUnpacker;
import java.io.DataInput;
import java.io.IOException;

public class CdmaMeasurement
extends TraceMeasurement {
    private static final long serialVersionUID = -8610619437180698168L;
    private static boolean VERIFY = "true".equals(System.getProperty("CdmaMeasurement.verify"));
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$cdma$CdmaMeasurement == null ? (class$elgato$measurement$cdma$CdmaMeasurement = CdmaMeasurement.class$("elgato.measurement.cdma.CdmaMeasurement")) : class$elgato$measurement$cdma$CdmaMeasurement);
    private static final Queue pool = new Queue(3);
    public static final int MAX_CHANNELS = 128;
    public static final int CHANNEL_TYPE_UNKNOWN = 0;
    public static final int CHANNEL_TYPE_IS95 = 1;
    public static final int CHANNEL_TYPE_CDMA2K = 2;
    public static final int CHANNEL_TYPE_PILOT = 3;
    public static final int CHANNEL_TYPE_PAGE = 4;
    public static final int CHANNEL_TYPE_SYNC = 5;
    public static final int CHANNEL_TYPE_QPAGE = 6;
    public static final int CHANNEL_TYPE_NOISE = 7;
    protected IntegerReading pnOffset = new IntegerReading();
    protected IntegerReading freqError = new IntegerReading();
    protected IntegerReading channelPower = new IntegerReading();
    protected IntegerReading pilotDelay = new IntegerReading();
    protected IntegerReading estimatedRho = new IntegerReading();
    protected IntegerReading carrierFeedthrough = new IntegerReading();
    protected IntegerReading noiseFloor = new IntegerReading();
    protected IntegerReading pilotPower = new IntegerReading();
    protected IntegerReading diffSyncPower = new IntegerReading();
    protected IntegerReading diffPagePower = new IntegerReading();
    protected IntegerReading diffQuickPagePower = new IntegerReading();
    protected IntegerReading cdpTraceThreshold = new IntegerReading();
    protected LongReading centerFreq = new LongReading();
    protected IntegerReading pnIncrement = new IntegerReading();
    protected IntegerReading pnOffsetActuator = new IntegerReading();
    protected BooleanReading autoPnOffset = new BooleanReading();
    protected IntegerReading thresholdOffset = new IntegerReading();
    protected IntegerReading thresholdSetting = new IntegerReading();
    protected BooleanReading autoThreshold = new BooleanReading();
    protected IntegerReading measurementLoss = new IntegerReading();
    protected IntegerReading radioConfig = new IntegerReading();
    protected IntegerReading measurementTime = new IntegerReading();
    protected BooleanReading averagingState = new BooleanReading();
    protected IntegerReading numAverages = new IntegerReading();
    protected IntegerReading pagingChannels = new IntegerReading();
    protected IntegerReading quickPagingChannels = new IntegerReading();
    protected IntegerReading numBars = new IntegerReading();
    protected UnsignedByteArrayReading channelTypes = new UnsignedByteArrayReading(128);
    protected UnsignedByteArrayReading channelWidths = new UnsignedByteArrayReading(128);
    protected UnsignedByteArrayReading channelNumbers = new UnsignedByteArrayReading(128);
    protected IntegerArrayReading channelLevels = new IntegerArrayReading(128);
    protected IntegerReading averageCount = new IntegerReading();
    public static final int PN_OffSET = 0;
    public static final int FREQ_ERROR = 1;
    public static final int CHANNEL_POWER = 2;
    public static final int PILOT_DELAY = 3;
    public static final int ESTIMATED_RHO = 4;
    public static final int CARRIER_FEED_THROUGH = 5;
    public static final int NOISE_FLOOR = 6;
    public static final int PILOT_POWER = 7;
    public static final int DIFF_SYNC_POWER = 8;
    public static final int DIFF_PAGE_POWER = 9;
    public static final int DIFF_QUICK_PAGE_POWER = 10;
    public static final int CDP_TRACE_THRESHOLD = 11;
    public static final int CENTER_FREQ = 12;
    public static final int PN_INCREMENT = 13;
    public static final int PN_OFFSET_ACTUATOR = 14;
    public static final int AUTO_PN_OFFSET = 15;
    public static final int THRESHOLD_OFFSET = 16;
    public static final int THRESHOLD_SETTING = 17;
    public static final int AUTO_THRESHOLD = 18;
    public static final int MEASUREMENT_LOSS = 19;
    public static final int RADIO_CONFIG = 20;
    public static final int MEASUREMENT_TIME = 21;
    public static final int AVERAGING_STATE = 22;
    public static final int NUM_AVERAGES = 23;
    public static final int PAGING_CHANNELS = 24;
    public static final int QUICK_PAGING_CHANNELS = 25;
    public static final int NUM_BARS = 26;
    public static final int CHANNEL_TYPES = 27;
    public static final int CHANNEL_WIDTHS = 28;
    public static final int CHANNEL_NUMBERS = 29;
    public static final int CHANNEL_LEVELS = 30;
    public static final int AVERAGE_COUNT = 31;
    private Reading[] readings = this.createReadings();
    static /* synthetic */ Class class$elgato$measurement$cdma$CdmaMeasurement;

    public static CdmaMeasurement unpack(DataInput dataInput) throws IOException {
        CdmaUnpacker cdmaUnpacker = CdmaUnpacker.instance();
        CdmaMeasurement cdmaMeasurement = CdmaMeasurement.create();
        cdmaMeasurement = cdmaUnpacker.unpackMeasurement(cdmaMeasurement, dataInput);
        if (VERIFY) {
            cdmaMeasurement.verify();
        }
        return cdmaMeasurement;
    }

    static CdmaMeasurement create() {
        CdmaMeasurement cdmaMeasurement = (CdmaMeasurement)pool.dequeue();
        if (cdmaMeasurement == null) {
            return new CdmaMeasurement();
        }
        return cdmaMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public void dispose() {
        for (int i = 0; i < pool.size(); ++i) {
            CdmaMeasurement cdmaMeasurement = (CdmaMeasurement)pool.dequeue();
            if (cdmaMeasurement == null || cdmaMeasurement == this) continue;
            cdmaMeasurement.disposeArrays();
        }
        this.disposeArrays();
    }

    public void disposeArrays() {
        this.channelTypes = null;
        this.channelPower = null;
        this.channelLevels = null;
        this.channelWidths = null;
        this.channelNumbers = null;
    }

    public int getPnOffset() {
        return this.pnOffset.intValue();
    }

    public int getFreqError() {
        return this.freqError.intValue();
    }

    public int getChannelPower() {
        return this.channelPower.intValue();
    }

    public int getPilotDelay() {
        return this.pilotDelay.intValue();
    }

    public int getEstimatedRho() {
        return this.estimatedRho.intValue();
    }

    public int getCarrierFeedthrough() {
        return this.carrierFeedthrough.intValue();
    }

    public int getNoiseFloor() {
        return this.noiseFloor.intValue();
    }

    public int getPilotPower() {
        return this.pilotPower.intValue();
    }

    public int getDiffSyncPower() {
        return this.diffSyncPower.intValue();
    }

    public int getDiffPagePower() {
        return this.diffPagePower.intValue();
    }

    public int getDiffQuickPagePower() {
        return this.diffQuickPagePower.intValue();
    }

    public int getCdpTraceThreshold() {
        return this.cdpTraceThreshold.intValue();
    }

    public long getCenterFreq() {
        return this.centerFreq.longValue();
    }

    public int getPnIncrement() {
        return this.pnIncrement.intValue();
    }

    public int getPnOffsetActuator() {
        return this.pnOffsetActuator.intValue();
    }

    public boolean isAutoPnOffset() {
        return this.autoPnOffset.booleanValue();
    }

    public int getThresholdOffset() {
        return this.thresholdOffset.intValue();
    }

    public int getThresholdSetting() {
        return this.thresholdSetting.intValue();
    }

    public int getMeasurementLoss() {
        return this.measurementLoss.intValue();
    }

    public int getRadioConfig() {
        return this.radioConfig.intValue();
    }

    public int getMeasurementTime() {
        return this.measurementTime.intValue();
    }

    public boolean isAveragingState() {
        return this.averagingState.booleanValue();
    }

    public int getNumAverages() {
        return this.numAverages.intValue();
    }

    public int getAverageCount() {
        return this.averageCount.intValue();
    }

    public int getPagingChannels() {
        return this.pagingChannels.intValue();
    }

    public int getQuickPagingChannels() {
        return this.quickPagingChannels.intValue();
    }

    public int getNumBars() {
        return this.numBars.intValue();
    }

    public int[] getChannelTypes() {
        return this.channelTypes.getTrace();
    }

    public int[] getChannelWidths() {
        return this.channelWidths.getTrace();
    }

    public int[] getChannelNumbers() {
        return this.channelNumbers.getTrace();
    }

    public int[] getChannelLevels() {
        return this.channelLevels.getTrace();
    }

    boolean verify() {
        boolean bl = true;
        int n = this.getNumBars();
        if (n < 1 || n > 128) {
            bl = false;
            logger.warn("verify: bad numBars: " + n);
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getChannelWidths()[i];
            if (this.getChannelWidths()[i] < 1) {
                bl = false;
                logger.warn("verify: bad channel width for index " + i + " width=" + this.getChannelWidths()[i]);
                continue;
            }
            if (this.getChannelTypes()[i] == 2 || this.getChannelWidths()[i] == 1) continue;
            bl = false;
            logger.warn("verify: bad channel width for index " + i + " type=" + this.getChannelWidths()[i] + " width=" + this.getChannelWidths()[i]);
        }
        if (n2 != 128) {
            bl = false;
            logger.warn("verify: invalid sum of channel widths: " + n2);
        }
        return bl;
    }

    protected void setPnOffset(int n) {
        this.pnOffset.setValue(n);
    }

    protected void setFreqError(int n) {
        this.freqError.setValue(n);
    }

    protected void setChannelPower(int n) {
        this.channelPower.setValue(n);
    }

    protected void setPilotDelay(int n) {
        this.pilotDelay.setValue(n);
    }

    protected void setEstimatedRho(int n) {
        this.estimatedRho.setValue(n);
    }

    protected void setCarrierFeedthrough(int n) {
        this.carrierFeedthrough.setValue(n);
    }

    protected void setNoiseFloor(int n) {
        this.noiseFloor.setValue(n);
    }

    protected void setPilotPower(int n) {
        this.pilotPower.setValue(n);
    }

    protected void setDiffSyncPower(int n) {
        this.diffSyncPower.setValue(n);
    }

    protected void setDiffPagePower(int n) {
        this.diffPagePower.setValue(n);
    }

    protected void setDiffQuickPagePower(int n) {
        this.diffQuickPagePower.setValue(n);
    }

    protected void setCenterFreq(long l) {
        this.centerFreq.setValue(l);
    }

    public boolean isValidForMetricDisplay() {
        return this.isCdpValid();
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public double getDoubleReadingValue(int n) {
        return this.getReadings()[n].doubleValue();
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    public long getLongReadingValue(int n) {
        return this.getReadings()[n].longValue();
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        return ((IntegerArrayReading)this.getReadings()[n]).getTrace()[n2];
    }

    protected Reading[] getFirstSensorReadings() {
        return new Reading[]{this.pnOffset, this.freqError, this.channelPower, this.pilotDelay, this.estimatedRho, this.carrierFeedthrough, this.noiseFloor, this.pilotPower, this.diffSyncPower, this.diffPagePower, this.diffQuickPagePower, this.cdpTraceThreshold};
    }

    protected Reading[] getActuatorReadings() {
        return new Reading[]{this.centerFreq, this.pnIncrement, this.pnOffsetActuator, this.autoPnOffset, this.thresholdOffset, this.thresholdSetting, this.autoThreshold, this.measurementLoss, this.radioConfig, this.measurementTime, this.averagingState, this.numAverages, this.pagingChannels, this.quickPagingChannels};
    }

    protected Reading[] getSecondSensorReadings() {
        return new Reading[]{this.numBars, this.channelTypes, this.channelWidths, this.channelNumbers, this.channelLevels, this.averageCount};
    }

    public Reading[] createReadings() {
        int n = this.getFirstSensorReadings().length;
        int n2 = this.getActuatorReadings().length;
        int n3 = this.getSecondSensorReadings().length;
        Reading[] readingArray = new Reading[n + n2 + n3];
        System.arraycopy(this.getFirstSensorReadings(), 0, readingArray, 0, n);
        System.arraycopy(this.getActuatorReadings(), 0, readingArray, n, n2);
        System.arraycopy(this.getSecondSensorReadings(), 0, readingArray, n + n2, n3);
        return readingArray;
    }

    protected Reading[] getReadings() {
        return this.readings;
    }

    public String getMeasurementTitle() {
        return Text.CDMA;
    }

    public int getIndexForXValue(long l) {
        int n = (int)l;
        int[] nArray = this.channelNumbers.getTrace();
        int[] nArray2 = this.channelWidths.getTrace();
        int n2 = this.numBars.intValue();
        for (int i = 0; i <= 7; ++i) {
            int n3 = 127 >>> i | 0xFFFFFF80;
            int n4 = n & n3;
            int n5 = 1 << i;
            for (int j = 0; j < n2; ++j) {
                if (nArray[j] != n4 || nArray2[j] != n5) continue;
                return j;
            }
        }
        return -1;
    }

    public int linearizeXValue(int n) {
        if (n > 128 || n == 0) {
            return this.getChannelWidths()[0];
        }
        int n2 = 0;
        for (int i = 0; i < n - 1; ++i) {
            n2 += this.getChannelWidths()[i];
        }
        return n2 + this.getChannelWidths()[n] / 2 + 1;
    }

    public long getXValueForIndex(int n) {
        int n2 = this.numBars.intValue();
        if (n < 0 || n >= n2) {
            return Integer.MIN_VALUE;
        }
        return this.channelNumbers.getTrace()[n];
    }

    public boolean isCdpValid() {
        return this.estimatedRho.intValue() >= 100;
    }

    public int[] getTrace() {
        return this.getChannelLevels();
    }

    public int getTraceLength() {
        return 128;
    }

    public long getTraceStartValue() {
        return 0L;
    }

    public long getTraceStopValue() {
        return 127L;
    }

    public PeakFinder createPeakFinder() {
        return new DiscretePeakFinder(128);
    }

    public int convertToAbsolutePower(int n) {
        return this.channelPower.intValue() + n;
    }

    public int getAbsCdpTraceThreshold() {
        return this.convertToAbsolutePower(this.cdpTraceThreshold.intValue());
    }

    public int getRelCdpTraceThreshold() {
        return this.cdpTraceThreshold.intValue();
    }

    public int getRelBarPower(int n) {
        return this.channelLevels.getTrace()[n];
    }

    public int getAbsBarPower(int n) {
        return this.convertToAbsolutePower(this.getRelBarPower(n));
    }

    public int getChannelTypeIndex(String string) {
        int n = CdmaAnalyzer.getChannelType(string);
        for (int i = 0; i < this.getChannelTypes().length; ++i) {
            if (this.getChannelTypes()[i] != n) continue;
            return i;
        }
        return -1;
    }

    public String getMaxNoise(double d) {
        int n = Integer.MIN_VALUE;
        int n2 = -1;
        int n3 = CdmaAnalyzer.getChannelType(Text.Noise);
        for (int i = 0; i < this.getChannelTypes().length; ++i) {
            if (this.getChannelTypes()[i] != n3 || this.getChannelLevels()[i] <= n) continue;
            n = this.getChannelLevels()[i];
            n2 = this.getChannelNumbers()[i];
        }
        return MeasurementScreen.createResultLine(n, d, Double.NEGATIVE_INFINITY, "TX Max Noise Lev (Chan " + n2 + ")", "dB");
    }

    public int[] getIndexOfSixLargestCdma2kLevels() {
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6};
        int n = CdmaAnalyzer.getChannelType(Text.CDMA2K);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < this.getChannelTypes().length; ++j) {
                if (this.getChannelTypes()[j] != n || this.getChannelLevels()[j] <= this.getChannelLevels()[nArray[i]] || !this.indexNotEqualToPreviousMaximums(i, nArray, j)) continue;
                nArray[i] = j;
            }
        }
        return nArray;
    }

    private boolean indexNotEqualToPreviousMaximums(int n, int[] nArray, int n2) {
        for (int i = 0; i < n; ++i) {
            if (n2 != nArray[i]) continue;
            return false;
        }
        return true;
    }

    public int findPosition(int n) {
        int[] nArray = this.getChannelTypes();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

