/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.infrastructure.util.BitTwiddler;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Timer;
import elgato.measurement.cdma.CdmaMeasurement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;

public class CdmaMeasurementGenerator
extends MeasurementGenerator {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$cdma$CdmaMeasurementGenerator == null ? (class$elgato$measurement$cdma$CdmaMeasurementGenerator = CdmaMeasurementGenerator.class$("elgato.measurement.cdma.CdmaMeasurementGenerator")) : class$elgato$measurement$cdma$CdmaMeasurementGenerator);
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    public boolean fixedData;
    Random rand = new Random();
    private Timer writePayload_timer = new Timer("writePayload");
    private int[] shuffled = new int[128];
    static /* synthetic */ Class class$elgato$measurement$cdma$CdmaMeasurementGenerator;

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return CdmaMeasurement.unpack(dataInput);
    }

    protected int maybeUnmeasured(int n) {
        return this.maybeUnmeasured(n, -333);
    }

    private int maybeUnmeasured(int n, int n2) {
        if (!this.fixedData && (this.rand.nextInt() & 0xFF) < 32) {
            return n2;
        }
        return n;
    }

    protected void writePayload(DataOutput dataOutput) throws IOException {
        int n;
        int n2;
        this.writePayload_timer.start();
        int n3 = 0;
        int n4 = -40000;
        dataOutput.writeInt(this.maybeUnmeasured(0));
        dataOutput.writeInt(this.maybeUnmeasured(1, Integer.MAX_VALUE));
        dataOutput.writeInt(this.maybeUnmeasured(200));
        dataOutput.writeInt(this.maybeUnmeasured(3));
        dataOutput.writeInt(this.fixedData ? 4 : this.maybeUnmeasured(this.rand.nextInt() & 0x3FF));
        dataOutput.writeInt(this.maybeUnmeasured(5));
        dataOutput.writeInt(this.maybeUnmeasured(6));
        dataOutput.writeInt(this.maybeUnmeasured(7000));
        dataOutput.writeInt(this.maybeUnmeasured(8));
        dataOutput.writeInt(this.maybeUnmeasured(9));
        dataOutput.writeInt(this.maybeUnmeasured(10));
        dataOutput.writeInt(-32500);
        this.writeOverAirSensorChunk(dataOutput);
        dataOutput.writeInt((this.rand.nextInt() & Integer.MAX_VALUE) % 1250000 + 750000);
        dataOutput.writeInt((this.rand.nextInt() & Integer.MAX_VALUE) % 1000);
        dataOutput.writeInt(this.maybeUnmeasured(13));
        dataOutput.writeInt(this.maybeUnmeasured(14));
        dataOutput.writeInt(1);
        dataOutput.writeInt(this.maybeUnmeasured(15));
        dataOutput.writeInt(this.maybeUnmeasured(16));
        dataOutput.writeInt(0);
        dataOutput.writeInt(this.maybeUnmeasured(17));
        dataOutput.writeInt(this.maybeUnmeasured(18));
        dataOutput.writeInt(this.maybeUnmeasured(19));
        dataOutput.writeInt(1);
        dataOutput.writeInt(20);
        dataOutput.writeInt(this.maybeUnmeasured(21));
        dataOutput.writeInt(this.maybeUnmeasured(22));
        this.writeOverAirActuatorChunk(dataOutput);
        int n5 = Math.abs(this.rand.nextInt());
        int n6 = n5 % 64 + 65;
        dataOutput.writeInt(n6);
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            nArray[n2] = (this.rand.nextInt() & 0xFFFF) < 24576 ? (n2 + n5) % 8 : 7;
        }
        nArray[n5 % n6] = 2;
        for (n2 = 0; n2 < n6; ++n2) {
            nArray2[n2] = nArray[n2] == 2 ? 1 << (Math.abs(n2 + n5 * n5) & 3) : 1;
        }
        for (n2 = 0; n2 < n6; ++n2) {
            n = CdmaMeasurementGenerator.sum(nArray2, n2);
            nArray3[n2] = BitTwiddler.rev7(n & 0x7F);
        }
        for (n2 = 0; n2 < n6; ++n2) {
            n = n3 - n4;
            if (nArray[n2] == 7) {
                n /= 3;
            }
            int n7 = (this.rand.nextInt() & Integer.MAX_VALUE) % n;
            nArray4[n2] = n4 + n7;
        }
        this.stretch(n6, nArray, nArray2);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            dataOutput.writeByte(nArray[n2]);
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            dataOutput.writeByte(nArray2[n2]);
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            dataOutput.writeByte(nArray3[n2]);
        }
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            dataOutput.writeInt(nArray4[n2]);
        }
        dataOutput.writeInt(23);
        this.writePayload_timer.stop();
    }

    void writeOverAirActuatorChunk(DataOutput dataOutput) throws IOException {
    }

    void writeOverAirSensorChunk(DataOutput dataOutput) throws IOException {
    }

    private static int sum(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i];
        }
        return n2;
    }

    private void stretch(int n, int[] nArray, int[] nArray2) {
        int n2;
        while ((n2 = 128 - CdmaMeasurementGenerator.sum(nArray2, n)) != 0) {
            this.shuffle(n);
            int n3 = CdmaMeasurementGenerator.sgn(n2);
            this.addToABarWidth(n3, nArray, nArray2, n);
        }
    }

    private static int sgn(int n) {
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    private void shuffle(int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            this.shuffled[n2] = n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = Math.abs(this.rand.nextInt()) % n;
            int n4 = this.shuffled[n3];
            this.shuffled[n3] = this.shuffled[n2];
            this.shuffled[n2] = n4;
        }
    }

    private void addToABarWidth(int n, int[] nArray, int[] nArray2, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.shuffled[i];
            boolean bl = nArray[n3] == 2 ? (n > 0 ? true : nArray2[n3] > 1) : false;
            if (!bl) continue;
            int n4 = n3;
            nArray2[n4] = nArray2[n4] + n;
            return;
        }
        logger.error("Couldn't add: " + n);
    }

    public Measurement generateInvalid() {
        CdmaMeasurement cdmaMeasurement = (CdmaMeasurement)super.generate();
        cdmaMeasurement.setEstimatedRho(0);
        return cdmaMeasurement;
    }

    public Measurement generateValid() {
        CdmaMeasurement cdmaMeasurement = (CdmaMeasurement)super.generate();
        cdmaMeasurement.setEstimatedRho(200);
        cdmaMeasurement.channelLevels.getTrace()[0] = 2000;
        return cdmaMeasurement;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

