/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.actuators.TrimodeActuatorButton;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.menu.LevelButtonFactory;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.units.PrefixedUnitsConversion;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.cdma.CdmaAnalyzer;
import elgato.measurement.cdma.CdmaScreen;
import elgato.measurement.cdma.CommonCdmaMeasurementSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class CdmaMenuMgr
extends MeasurementMenuMgr {
    protected static final Logger logger = LogManager.getLogger(class$elgato$measurement$cdma$CdmaMenuMgr == null ? (class$elgato$measurement$cdma$CdmaMenuMgr = CdmaMenuMgr.class$("elgato.measurement.cdma.CdmaMenuMgr")) : class$elgato$measurement$cdma$CdmaMenuMgr);
    protected final CdmaAnalyzer analyzer;
    final CommonCdmaMeasurementSettings settings;
    private MarkerButtonFactory markerButtonFactory;
    private MultiStateActuatorButton measTimeButton;
    protected MenuButton setupButton;
    protected MenuButton levelMenuButton;
    protected Menu freqChanMenu;
    private Menu codogramMenu;
    protected Menu more1of2Menu;
    protected Menu more2of2Menu;
    private final ValueListener codogramEnabledListener = new ValueListener(){
        private String listenerName = ".codogramEnabledListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = CdmaMenuMgr.this.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            boolean bl = valueInterface.booleanValue();
            MenuItem[] menuItemArray = CdmaMenuMgr.this.codogramMenu.getItems();
            for (int i = 1; i < menuItemArray.length && i != 6; ++i) {
                if (menuItemArray[i] == null) continue;
                menuItemArray[i].setEnabled(bl);
            }
        }
    };
    static /* synthetic */ Class class$elgato$measurement$cdma$CdmaMenuMgr;

    public CdmaMenuMgr(CdmaScreen cdmaScreen, CommonCdmaMeasurementSettings commonCdmaMeasurementSettings, CdmaAnalyzer cdmaAnalyzer) {
        super(cdmaScreen);
        this.settings = commonCdmaMeasurementSettings;
        this.analyzer = cdmaAnalyzer;
        this.markerButtonFactory = this.createMarkerButtonFactory();
    }

    protected abstract MenuButton createFreqChanButton();

    protected abstract MenuButton createLevelMenuButton();

    protected abstract MenuButton createSetupButton();

    protected MenuButton createDisplayButton() {
        return null;
    }

    protected String getMeasurementName() {
        return "cdmaAn";
    }

    protected Menu cdmaBuildLeftMenu() {
        String string = ((CdmaScreen)this.scn).isDoingOverAir() ? Text.CDMA_Over_Air : Text.CDMA_Analyzer;
        return new Menu(string, new MenuItem[]{this.createFreqChanButton(), this.createLevelMenuButton(), null, null, this.createAvgSweepButton(), this.createSetupButton(), this.createMarkerButton()});
    }

    protected Menu buildLeftMenu() {
        Menu menu = this.cdmaBuildLeftMenu();
        menu.setMenuItem(this.createDisplayButton(), 2);
        return menu;
    }

    protected MenuButton createAvgSweepButton() {
        return this.createAverageSweepButton(this.settings.getNumAverages(), this.settings.getAveraging());
    }

    protected MenuButton createMarkerButton() {
        return this.markerButtonFactory.getMenuButton();
    }

    ActuatorEditor createCenterFrequencyButton() {
        return new ActuatorEditor(this.settings.getCenterFreq(), this.getContextString("cdmaFrequencyChannel.cdmaFrequency"), this.getListenerBaseName() + ".cfButton");
    }

    protected Menu createRightMenuWithTimeRef() {
        return new Menu(Text.Freq_slash_Chan, new MenuItem[]{this.createCenterFrequencyButton(), null, this.createPNOffsetButton(this.getContextString("cdmaFrequencyChannel.pnOffset")), this.createPnIncButton(), this.createTimeFreqRefButton(), this.createChanStdButton(), this.createFreqChanUnitsButton()}, 0);
    }

    MenuItem createPnIncButton() {
        return new ActuatorEditor(this.settings.getPnInc(), this.getContextString("cdmaFrequencyChannel.pnInc"), this.getListenerBaseName() + ".pnIncButton");
    }

    MenuItem createPNOffsetButton(String string) {
        return new TrimodeActuatorButton((ValueListInterface)this.settings.getPnOffsetAuto(), string, this.settings.getPnOffsetManual(), this.getListenerBaseName() + ".pnOffsetButton");
    }

    protected MenuItem createRfInsertionLossButton() {
        return MeasurementMenuMgr.createLossButton(DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), this.settings.getRfInLoss(), DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.getContextString("rf.in.loss"), this.getListenerBaseName() + ".RfInLossButton");
    }

    protected MultiStateActuatorButton createReferenceButton() {
        return new MultiStateActuatorButton(this.settings.getReference(), this.getContextString("ref.level"), this.getListenerBaseName() + ".refLevelButton");
    }

    protected ActuatorEditor createScaleDivButton() {
        return new ActuatorEditor(this.settings.getScaleDiv(), this.getContextString("level.scaleDivision"), this.getListenerBaseName() + ".scaleDivButton");
    }

    protected MenuItem createGpsLocationButton() {
        return LevelButtonFactory.createGpsLocationButton(this.scn);
    }

    public Menu createCodogramMenu() {
        this.codogramMenu = new Menu(Text.Codogram, new MenuItem[]{new MultiStateActuatorButton(this.settings.getCodogramEnabled(), this.getContextString("codogram.enabled"), this.getListenerBaseName() + ".codogramEnabledButton"), this.createResetCodogramButton("codogramResetMetrics"), new ActuatorEditor(this.settings.getCodogramCaptureInterval(), "codogramCaptureInterval", this.getListenerBaseName() + ".captureIntervalButton"), null, new ActuatorSubMenuButton(this.settings.getCodogramPalette(), this.getContextString("codogram.palette"), true, this.getListenerBaseName() + ".paletteButton")});
        return this.codogramMenu;
    }

    private MenuItem createResetCodogramButton(String string) {
        return new PushButton(Text.Reset_n_Codogram, string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CdmaMenuMgr.this.analyzer.clearCodogramHistory();
            }
        });
    }

    protected MenuItem createThresholdOffsetButton() {
        return new ActuatorEditor(this.settings.getThreshOffset(), this.getContextString("cdmaSetup.thresholdOffset"), this.getListenerBaseName() + ".threshOffsetButton");
    }

    protected MenuItem createThresholdButton() {
        return new TrimodeActuatorButton((ValueListInterface)this.settings.getAutoThreshold(), this.getContextString("cdmaSetup.thresholdLevel"), this.settings.getThresholdLevel(), this.getListenerBaseName() + ".threshLevelButton");
    }

    protected MultiStateActuatorButton createMeasTimeButton() {
        this.measTimeButton = new MultiStateActuatorButton(this.settings.getMeasTime(), this.getContextString("meas.time"), this.getListenerBaseName() + ".measTimeButton");
        return this.measTimeButton;
    }

    protected MultiStateActuatorButton createQuickPageButton() {
        return new MultiStateActuatorButton(this.settings.getQuickPageChannels(), this.getContextString("cdmaSetup.quickPageChannel"), this.getListenerBaseName() + ".quickPageChButton");
    }

    protected MenuItem createLimitsButton() {
        this.more1of2Menu = new Menu(Text.Limits, new MenuItem[]{this.createFreqErrorLimitsButton(), this.createTimeOffsetLimitsButton(), this.createEstRhoLimitsButton(), this.createCarrFeedthruButton(), this.createMoreButton(Text.More_n_1_of_2), null, null});
        this.more2of2Menu = new Menu(Text.Limits, new MenuItem[]{this.createNoiseFloorLimitsButton(), this.createPilotPowerLimitsButton(), this.createPagePowerLimitsButton(), this.createSyncPowerLimitsButton(), this.createMore2Button(Text.More_n_2_of_2), null, null});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Limits, this.getContextString("Limits"), this.more1of2Menu, true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        subMenuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CdmaMenuMgr.this.settings.setAllLimits();
            }
        });
        return subMenuButton;
    }

    protected PushButton createMoreButton(String string) {
        return new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CdmaMenuMgr.this.scn.getScreenManager().installRightMenu(CdmaMenuMgr.this.more2of2Menu);
            }
        });
    }

    protected PushButton createMore2Button(String string) {
        return new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CdmaMenuMgr.this.scn.getScreenManager().installRightMenu(CdmaMenuMgr.this.more1of2Menu);
            }
        });
    }

    private MenuItem createOnOffLimitsButton(int n) {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(this.settings.limitsToggleAt(n), "", this.getListenerBaseName() + ".linOnOff");
        this.setSettingsShowLimits();
        multiStateActuatorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CdmaMenuMgr.this.setSettingsShowLimits();
                CdmaMenuMgr.this.settings.allowValidationNow();
            }
        });
        return multiStateActuatorButton;
    }

    public void setSettingsShowLimits() {
        this.analyzer.swapBottomPanel(this.settings.getLimitsSummaryState());
    }

    private MenuItem createFreqErrorLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Freq_Error_Limits, this.getContextString("freqErrorLimits"), new Menu(Text.Freq_Error, new MenuItem[]{this.createOnOffLimitsButton(0), new ActuatorEditor(this.settings.getFreqErrorUpperLimit(), this.getContextString("freqErrorLimits"), this.getListenerBaseName() + ".freqErrorULimits"), new ActuatorEditor(this.settings.getFreqErrorLowerLimit(), this.getContextString("freqErrorLimits"), this.getListenerBaseName() + ".freqErrorLLimits")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createTimeOffsetLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Time_Offset_Limits, this.getContextString("timeOffsetLimits"), new Menu(Text.Time_Offset, new MenuItem[]{this.createOnOffLimitsButton(1), new ActuatorEditor(this.settings.getTimeOffsetUpperLimit(), this.getContextString("timeOffsetLimits"), this.getListenerBaseName() + ".timeOffsetULimits"), new ActuatorEditor(this.settings.getTimeOffsetLowerLimit(), this.getContextString("timeOffsetLimits"), this.getListenerBaseName() + ".timeOffsetLLimits")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createEstRhoLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Est_Rho_Limits, this.getContextString("estRhoLimits"), new Menu(Text.Est_Rho, new MenuItem[]{this.createOnOffLimitsButton(2), this.createEstRhoLowerLimit()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createEstRhoLowerLimit() {
        return new ActuatorEditor(this.settings.getEstRhoLowerLimit(), this.getContextString("estRhoLimits"), this.getListenerBaseName() + ".estRhoLimits");
    }

    private MenuItem createCarrFeedthruButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Carr_Feedthru_Limits, this.getContextString("carrFeedthruLimits"), new Menu(Text.Carr_Feedthru, new MenuItem[]{this.createOnOffLimitsButton(3), this.createCarrFeedthruLimits()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createCarrFeedthruLimits() {
        return new ActuatorEditor(this.settings.getCarrFeedthruUpperLimit(), this.getContextString("carrFeedthruLimits"), this.getListenerBaseName() + ".carrFeedthruLimits");
    }

    private MenuItem createNoiseFloorLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Noise_Floor_Limits, this.getContextString("noiseFloorLimits"), new Menu(Text.Noise_Floor, new MenuItem[]{this.createOnOffLimitsButton(4), this.createNoiseFloorUpperLimit()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createNoiseFloorUpperLimit() {
        return new ActuatorEditor(this.settings.getNoiseFloorUpperLimit(), this.getContextString("noiseFloorLimits"), this.getListenerBaseName() + ".noiseFloorLimits");
    }

    private MenuItem createPilotPowerLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Pilot_Pwr_Limits, this.getContextString("pilotPowerLimits"), new Menu(Text.Pilot_Pwr, new MenuItem[]{this.createOnOffLimitsButton(5), this.createPilotPowerUpperLimits(), this.createPilotPowerLowerLimits()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createPilotPowerUpperLimits() {
        return new ActuatorEditor(this.settings.getPilotPowerUpperLimit(), this.getContextString("pilotPowerLimits"), this.getListenerBaseName() + ".pilotPowerUpperLimits");
    }

    protected ActuatorEditor createPilotPowerLowerLimits() {
        return new ActuatorEditor(this.settings.getPilotPowerLowerLimit(), this.getContextString("pilotPowerLimits"), this.getListenerBaseName() + ".pilotPowerLowerLimits");
    }

    private MenuItem createPagePowerLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.DeltaSymbol_Page_Pwr_Limits, this.getContextString("pagePowerLimits"), new Menu(Text.DeltaSymbol_Page_Pwr, new MenuItem[]{this.createOnOffLimitsButton(6), this.createPagePowerUpperLimit(), this.createPagePowerLowerLimit()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createPagePowerUpperLimit() {
        return new ActuatorEditor(this.settings.getPagePowerUpperLimit(), this.getContextString("pagePowerLimits"), this.getListenerBaseName() + ".pageUpperPowerLimits");
    }

    protected ActuatorEditor createPagePowerLowerLimit() {
        return new ActuatorEditor(this.settings.getPagePowerLowerLimit(), this.getContextString("pagePowerLimits"), this.getListenerBaseName() + ".pageLowerPowerLimits");
    }

    private MenuItem createSyncPowerLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.DeltaSymbol_Sync_Pwr_Limits, this.getContextString("syncPowerLimits"), new Menu(Text.DeltaSymbol_Sync_Pwr, new MenuItem[]{this.createOnOffLimitsButton(7), this.createSyncPowerUpperLimit(), this.createSyncPowerLowerLimit()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createSyncPowerLowerLimit() {
        return new ActuatorEditor(this.settings.getSyncPowerLowerLimit(), this.getContextString("syncPowerLimits"), this.getListenerBaseName() + ".syncLowerPowerLimits");
    }

    protected ActuatorEditor createSyncPowerUpperLimit() {
        return new ActuatorEditor(this.settings.getSyncPowerUpperLimit(), this.getContextString("syncPowerLimits"), this.getListenerBaseName() + ".syncUpperPowerLimits");
    }

    public MarkerButtonFactory createMarkerButtonFactory() {
        LongActuator longActuator = new LongActuator("", "", "");
        longActuator.setConversion(new PrefixedUnitsConversion(Text.Chan));
        this.markerButtonFactory = new MarkerButtonFactory((MeasurementScreen)this.scn, null, null, longActuator, false);
        return this.markerButtonFactory;
    }

    public MarkerButtonFactory getMarkerButtonFactory() {
        return this.markerButtonFactory;
    }

    public void setupFreqChanUnitsListener() {
        this.setupFreqChanUnitsListener(this.freqChanMenu, 1);
    }

    public void prolog() {
        this.setupFreqChanUnitsListener();
        this.addValueListeners();
    }

    public void cleanup() {
        this.removeValueListeners();
        super.cleanup();
    }

    public void addValueListeners() {
        this.settings.getCodogramEnabled().addValueListener(this.codogramEnabledListener);
        this.codogramEnabledListener.valueChanged(this.settings.getCodogramEnabled());
    }

    public void removeValueListeners() {
        this.settings.getCodogramEnabled().removeValueListener(this.codogramEnabledListener);
    }

    public MultiStateActuatorButton getMeasTimeButton() {
        return this.measTimeButton;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

