/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.measurement.cdma.CdmaAnalyzer;
import elgato.measurement.cdma.CdmaMeasurement;
import java.awt.Color;

public class CdmaMetricsTable
extends BasicMeasurementMetrics {
    private CdmaAnalyzer analyzer;

    protected ValueSource[][] createValueSources() {
        FrequencyStrategy frequencyStrategy = new FrequencyStrategy();
        DecibelStrategy decibelStrategy = new DecibelStrategy(1, true);
        FixedPointNumberFieldStrategy fixedPointNumberFieldStrategy = new FixedPointNumberFieldStrategy(1, "dBc");
        DecibelStrategy decibelStrategy2 = new DecibelStrategy(1);
        NumberFieldStrategy numberFieldStrategy = new NumberFieldStrategy();
        ValueSource valueSource = this.createFreqValueSource(frequencyStrategy, Text.Freq);
        ValueSource valueSource2 = this.createChanPowerValueSource(decibelStrategy);
        ValueSource valueSource3 = this.createPilotPowerValueSource(decibelStrategy);
        ValueSource valueSource4 = this.createFreqErrorValueSource(frequencyStrategy);
        ValueSource valueSource5 = this.createRhoValueSource();
        ValueSource valueSource6 = this.createDiffPagePowerValueSource(decibelStrategy2);
        ValueSource valueSource7 = this.createPnOffsetValueSource(numberFieldStrategy);
        ValueSource valueSource8 = this.createCarrierFeedthruValueSource(fixedPointNumberFieldStrategy);
        ValueSource valueSource9 = this.createDiffSyncPowerValueSource(decibelStrategy2);
        ValueSource valueSource10 = this.createPilotDelayValueSource();
        ValueSource valueSource11 = this.createNoiseFloorValueSource(decibelStrategy2);
        ValueSource valueSource12 = this.createDiffQuickPagePower(decibelStrategy2);
        return new ValueSource[][]{{valueSource, valueSource4, valueSource7, valueSource10}, {valueSource2, valueSource5, valueSource8, valueSource11}, {valueSource3, valueSource6, valueSource9, valueSource12}};
    }

    public CdmaMetricsTable(CdmaAnalyzer cdmaAnalyzer) {
        this.analyzer = cdmaAnalyzer;
    }

    protected boolean isMeasurementValid() {
        return ((CdmaMeasurement)this.getMeasurement()).isValidForMetricDisplay();
    }

    private CdmaMeasurement getCdmaMeasurement() {
        return (CdmaMeasurement)this.getMeasurement();
    }

    protected ValueSource createDiffQuickPagePower(NumberFieldStrategy numberFieldStrategy) {
        return this.createDiffQuickPagePower(numberFieldStrategy, Text.DeltaSymbol_QPCH_Pk_Pwr);
    }

    protected ValueSource createDiffSyncPowerValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createDiffSyncPowerValueSource(numberFieldStrategy, Text.DeltaSymbol_Sync_Pwr);
    }

    protected ValueSource createDiffPagePowerValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createDiffPagePowerValueSource(numberFieldStrategy, Text.DeltaSymbol_Page_Pwr);
    }

    protected ValueSource createPilotPowerValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createPilotPowerValueSource(numberFieldStrategy, Text.Pilot_Pwr);
    }

    protected ValueSource createChanPowerValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createChanPowerValueSource(numberFieldStrategy, Text.Chan_Pwr);
    }

    protected ValueSource createNoiseFloorValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createNoiseFloorValueSource(numberFieldStrategy, Text.Noise_Floor);
    }

    protected ValueSource createCarrierFeedthruValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createCarrierFeedthruValueSource(numberFieldStrategy, Text.Carr_Feedthru);
    }

    protected ValueSource createRhoValueSource() {
        return this.createRhoValueSource(Text.Est_Rho);
    }

    protected ValueSource createPilotDelayValueSource() {
        return this.createPilotDelayValueSource(Text.Time_Offset);
    }

    protected ValueSource createPnOffsetValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createPnOffsetValueSource(numberFieldStrategy, Text.PN_Offset);
    }

    protected ValueSource createFreqErrorValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createFreqErrorValueSource(numberFieldStrategy, Text.Freq_Err);
    }

    private ValueSource createDiffQuickPagePower(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getDiffQuickPagePower();
            }
        };
    }

    private ValueSource createNoiseFloorValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getNoiseFloor();
            }

            public Color getValueColor() {
                if (CdmaMetricsTable.this.analyzer.isLimitOn(4)) {
                    return CdmaMetricsTable.this.analyzer.isNoiseFloorWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + CdmaMetricsTable.this.getPassFailText(CdmaMetricsTable.this.analyzer.isLimitOn(4), CdmaMetricsTable.this.analyzer.isNoiseFloorWithinLimits());
            }
        };
    }

    private ValueSource createPilotDelayValueSource(String string) {
        return new GrayableValueSource(string, new FixedPointNumberFieldStrategy(2, "\u03bcs"), false){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getPilotDelay();
            }

            protected long cookValue(long l) {
                return UIHelper.chipsToNanoseconds((int)l);
            }

            public void compute(boolean bl) {
                super.compute(bl);
            }

            public Color getValueColor() {
                if (CdmaMetricsTable.this.analyzer.isLimitOn(1)) {
                    return CdmaMetricsTable.this.analyzer.isTimeOffsetWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + CdmaMetricsTable.this.getPassFailText(CdmaMetricsTable.this.analyzer.isLimitOn(1), CdmaMetricsTable.this.analyzer.isTimeOffsetWithinLimits());
            }
        };
    }

    private String getPassFailText(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? " (P)" : " (F)";
        }
        return "";
    }

    private ValueSource createDiffSyncPowerValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getDiffSyncPower();
            }

            public Color getValueColor() {
                if (CdmaMetricsTable.this.analyzer.isLimitOn(7)) {
                    return CdmaMetricsTable.this.analyzer.isSyncPowerWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + CdmaMetricsTable.this.getPassFailText(CdmaMetricsTable.this.analyzer.isLimitOn(7), CdmaMetricsTable.this.analyzer.isSyncPowerWithinLimits());
            }
        };
    }

    private ValueSource createCarrierFeedthruValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getCarrierFeedthrough();
            }

            public Color getValueColor() {
                if (CdmaMetricsTable.this.analyzer.isLimitOn(3)) {
                    return CdmaMetricsTable.this.analyzer.isCarrFeedthruWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + CdmaMetricsTable.this.getPassFailText(CdmaMetricsTable.this.analyzer.isLimitOn(3), CdmaMetricsTable.this.analyzer.isCarrFeedthruWithinLimits());
            }
        };
    }

    private ValueSource createPnOffsetValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getPnOffset();
            }

            public void compute(boolean bl) {
                super.compute(true);
            }
        };
    }

    private ValueSource createDiffPagePowerValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getDiffPagePower();
            }

            public Color getValueColor() {
                if (CdmaMetricsTable.this.analyzer.isLimitOn(6)) {
                    return CdmaMetricsTable.this.analyzer.isPagePowerWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + CdmaMetricsTable.this.getPassFailText(CdmaMetricsTable.this.analyzer.isLimitOn(6), CdmaMetricsTable.this.analyzer.isPagePowerWithinLimits());
            }
        };
    }

    private ValueSource createRhoValueSource(String string) {
        return new GrayableValueSource(string, new FixedPointNumberFieldStrategy(3), true){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getEstimatedRho();
            }

            public Color getValueColor() {
                if (CdmaMetricsTable.this.analyzer.isLimitOn(2)) {
                    return CdmaMetricsTable.this.analyzer.isEstRhoWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + CdmaMetricsTable.this.getPassFailText(CdmaMetricsTable.this.analyzer.isLimitOn(2), CdmaMetricsTable.this.analyzer.isEstRhoWithinLimits());
            }
        };
    }

    private ValueSource createFreqErrorValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, false){

            protected long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getFreqError();
            }

            protected long cookValue(long l) {
                return l / 1000L;
            }

            public Color getValueColor() {
                if (CdmaMetricsTable.this.analyzer.isLimitOn(0)) {
                    return CdmaMetricsTable.this.analyzer.isFreqErrorWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + CdmaMetricsTable.this.getPassFailText(CdmaMetricsTable.this.analyzer.isLimitOn(0), CdmaMetricsTable.this.analyzer.isFreqErrorWithinLimits());
            }
        };
    }

    private ValueSource createPilotPowerValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getPilotPower();
            }

            public Color getValueColor() {
                if (CdmaMetricsTable.this.analyzer.isLimitOn(5)) {
                    return CdmaMetricsTable.this.analyzer.isPilotPowerWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + CdmaMetricsTable.this.getPassFailText(CdmaMetricsTable.this.analyzer.isLimitOn(5), CdmaMetricsTable.this.analyzer.isPilotPowerWithinLimits());
            }
        };
    }

    private ValueSource createChanPowerValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getChannelPower();
            }

            public void compute(boolean bl) {
                super.compute(true);
            }
        };
    }

    protected ValueSource createFreqValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return CdmaMetricsTable.this.getCdmaMeasurement().getCenterFreq();
            }
        };
    }

    protected boolean shouldGrayOutValues() {
        return false;
    }

    protected abstract class GrayableValueSource
    extends ValueSource {
        public GrayableValueSource(String string, NumberFieldStrategy numberFieldStrategy, boolean bl) {
            super(string, numberFieldStrategy, bl);
        }

        public Color getValueColor() {
            return CdmaMetricsTable.this.shouldGrayOutValues() ? Color.gray : Color.black;
        }
    }
}

