/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.util.Text;
import elgato.measurement.cdma.CommonCdmaMeasurementSettings;

public class CdmaOaMeasurementSettings
extends CommonCdmaMeasurementSettings {
    private static CdmaOaMeasurementSettings instance;
    public static final String TOPIC_CDMA_OA = "cdmaOa";
    public static final String KEY_CDMAOA_PWR_THLD = "maxMp";
    public static final String KEY_CDMAOA_PLT_DOM = "minPltDom";
    public static final String KEY_CDMAOA_AMP_CAP = "ampCapState";
    public static final String KEY_CDMAOA_PLT_PWR = "pilotPwr";
    public static final String KEY_CDMAOA_MAX_PA = "ampCap";
    public static final String KEY_CDMAOA_DELTA_PAGE_PWR = "pagePwr";
    public static final String KEY_CDMAOA_DELTA_SYNC_PWR = "syncPwr";
    public static final String KEY_CDMAOA_FEET_METER = "feetMeter";
    public static final String KEY_CDMAOA_RESET_METRICS = "resetMetrics";
    public static final int VALUE_CDMAOA_RESET_METRICS = 1;
    private LongActuator resetMetrics;
    private LongActuator ampCap;
    private LongActuator pilotPower;
    private LongActuator pagePower;
    private LongActuator syncPower;
    private LongActuator pilotDominance;
    private LongActuator multipathPower;

    protected CdmaOaMeasurementSettings() {
        super(TOPIC_CDMA_OA);
        this.resetMetrics = new LongActuator(this.TOPIC, KEY_CDMAOA_RESET_METRICS, Text.Reset_n_Metrics);
        this.ampCap = LongActuator.createWattsPower(this.TOPIC, KEY_CDMAOA_MAX_PA, Text.Max_PA_Pwr, "0.1", "300");
        this.pilotPower = LongActuator.createWattsPower(this.TOPIC, KEY_CDMAOA_PLT_PWR, Text.Pilot_Pwr, "0.1", "100");
        this.pagePower = LongActuator.createPower(this.TOPIC, KEY_CDMAOA_DELTA_PAGE_PWR, Text.DeltaSymbol_Page_Pwr);
        this.syncPower = LongActuator.createPower(this.TOPIC, KEY_CDMAOA_DELTA_SYNC_PWR, Text.DeltaSymbol_Sync_Pwr);
        this.pilotDominance = LongActuator.createPower(this.TOPIC, KEY_CDMAOA_PLT_DOM, Text.Plt_Dom);
        this.multipathPower = LongActuator.createPower(this.TOPIC, KEY_CDMAOA_PWR_THLD, Text.Mp_Pwr);
        this.add(this.resetMetrics);
        this.add(this.ampCap);
        this.add(this.pilotPower);
        this.add(this.pagePower);
        this.add(this.syncPower);
        this.add(this.pilotDominance);
        this.add(this.multipathPower);
        this.pagePower.setValidator(new RangeValidator(-50000L, 10000L));
        this.syncPower.setValidator(new RangeValidator(-50000L, 10000L));
        this.pagePower.setIncrement(1000);
        this.syncPower.setIncrement(1000);
        this.pilotDominance.setValidator(new RangeValidator(0L, 20000L));
        this.pilotDominance.setIncrement(100);
        this.multipathPower.setValidator(new RangeValidator(0L, 2000L));
        this.multipathPower.setIncrement(10);
        this.refresh();
    }

    public static CdmaOaMeasurementSettings instance() {
        if (instance == null) {
            instance = new CdmaOaMeasurementSettings();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public LongActuator getResetMetrics() {
        return this.resetMetrics;
    }

    public LongActuator getAmpCap() {
        return this.ampCap;
    }

    public LongActuator getPilotPower() {
        return this.pilotPower;
    }

    public LongActuator getPagePower() {
        return this.pagePower;
    }

    public LongActuator getSyncPower() {
        return this.syncPower;
    }

    public LongActuator getPilotDominance() {
        return this.pilotDominance;
    }

    public LongActuator getMultipathPower() {
        return this.multipathPower;
    }
}

