/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.measurement.cdma.CdmaMeasurement;
import elgato.measurement.cdma.CdmaOverAirUnpacker;
import java.io.DataInput;
import java.io.IOException;

public class CdmaOverAirMeasurement
extends CdmaMeasurement {
    private static final long serialVersionUID = -3505941290581929945L;
    private static final Queue pool = new Queue(3);
    private IntegerReading currentPercentAmplifierCapacity = new IntegerReading();
    private IntegerReading peakPercentAmplifierCapacity = new IntegerReading();
    private IntegerReading averagePercentAmplifierCapacity = new IntegerReading();
    private IntegerReading currentPercentUtilization = new IntegerReading();
    private IntegerReading peakPercentUtilization = new IntegerReading();
    private IntegerReading averagePercentUtilization = new IntegerReading();
    private IntegerArrayReading topNPnOffsets = new IntegerArrayReading(3);
    private IntegerArrayReading topNPilots = new IntegerArrayReading(3);
    private BooleanReading cdpValid = new BooleanReading();
    private IntegerReading pilotDominance = new IntegerReading();
    private IntegerReading multipathPower = new IntegerReading();
    private BooleanReading resetMetrics = new BooleanReading();
    private IntegerReading pilotPowerActuator = new IntegerReading();
    private IntegerReading maxAmplifierCapacity = new IntegerReading();
    private IntegerReading pilotDominanceThreshold = new IntegerReading();
    private IntegerReading multipathPowerThreshold = new IntegerReading();
    private IntegerReading syncChannelPower = new IntegerReading();
    private IntegerReading pageChannelPower = new IntegerReading();
    public static final int PN_OFFSET = 0;
    public static final int FREQ_ERROR = 1;
    public static final int CHANNEL_POWER = 2;
    public static final int PILOT_DELAY = 3;
    public static final int ESTIMATED_RHO = 4;
    public static final int CARRIER_FEED_THROUGH = 5;
    public static final int NOISE_FLOOR = 6;
    public static final int PILOT_POWER = 7;
    public static final int DIFF_SYNC_POWER = 8;
    public static final int DIFF_PAGE_POWER = 9;
    public static final int DIFF_QUICK_PAGE_POWER = 10;
    public static final int CDP_TRACE_THRESHOLD = 11;
    public static final int CURRENT_PERCENT_AMPLIFIER_CAPACITY = 12;
    public static final int PEAKER_PERCENT_AMPLIFIER_CAPACITY = 13;
    public static final int AVERAGE_PERCENT_AMPLIFIER_CAPACITY = 14;
    public static final int CURRENT_PERCENT_UTILIZATION = 15;
    public static final int PEAKER_PERCENT_UTILIZATION = 16;
    public static final int AVERAGE_PERCENT_UTILIZATION = 17;
    public static final int TOP_N_PNOFFSET = 18;
    public static final int TOP_N_PILOTS = 19;
    public static final int CDP_VALID = 20;
    public static final int PILOT_DOMINANCE = 21;
    public static final int MULT_PATH_POWER = 22;
    public static final int CENTER_FREQ = 23;
    public static final int PN_INCREMENT = 24;
    public static final int PN_OFFSET_ACTUATOR = 25;
    public static final int AUTO_PN_OFFSET = 26;
    public static final int THRESHOLD_OFFSET = 27;
    public static final int THRESHOLD_SETTING = 28;
    public static final int AUTO_THRESHOLD = 29;
    public static final int MEASUREMENT_LOSS = 30;
    public static final int RADIO_CONFIG = 31;
    public static final int MEASUREMENT_TIME = 32;
    public static final int AVERAGING_STATE = 33;
    public static final int NUM_AVERAGES = 34;
    public static final int PAGING_CHANNELS = 35;
    public static final int QUICK_PAGING_CHANNELS = 36;
    public static final int RESET_METRICS = 37;
    public static final int PILOT_POWER_ACTUATOR = 38;
    public static final int MAX_AMPLIFIER_CAPACITY = 39;
    public static final int PILOT_DOMINANCE_THRESHOLD = 40;
    public static final int MULTI_PATH_POWER_THRESHOLD = 41;
    public static final int SYNC_CHANNEL_POWER = 42;
    public static final int PAGE_CHANNEL_POWER = 43;
    public static final int NUM_BARS = 44;
    public static final int CHANNEL_TYPES = 45;
    public static final int CHANNEL_WIDTHS = 46;
    public static final int CHANNEL_NUMBERS = 47;
    public static final int CHANNEL_LEVELS = 48;
    public static final int AVERAGE_COUNT = 49;
    private Reading[] readings = this.createReadings();

    public static CdmaMeasurement unpack(DataInput dataInput) throws IOException {
        CdmaOverAirUnpacker cdmaOverAirUnpacker = CdmaOverAirUnpacker.instance();
        CdmaOverAirMeasurement cdmaOverAirMeasurement = CdmaOverAirMeasurement.createOA();
        cdmaOverAirMeasurement = cdmaOverAirUnpacker.unpackMeasurement(cdmaOverAirMeasurement, dataInput);
        return cdmaOverAirMeasurement;
    }

    protected Reading[] getReadingsBetweenFirstSensorAndActuator() {
        return new Reading[]{this.currentPercentAmplifierCapacity, this.peakPercentAmplifierCapacity, this.averagePercentAmplifierCapacity, this.currentPercentUtilization, this.peakPercentUtilization, this.averagePercentUtilization, this.topNPnOffsets, this.topNPilots, this.cdpValid, this.pilotDominance, this.multipathPower};
    }

    protected Reading[] getReadingsBetweenActuatorAndSecondSensor() {
        return new Reading[]{this.resetMetrics, this.pilotPowerActuator, this.maxAmplifierCapacity, this.pilotDominanceThreshold, this.multipathPowerThreshold, this.syncChannelPower, this.pageChannelPower};
    }

    public Reading[] createReadings() {
        int n = this.getFirstSensorReadings().length;
        int n2 = this.getReadingsBetweenFirstSensorAndActuator().length;
        int n3 = this.getActuatorReadings().length;
        int n4 = this.getReadingsBetweenActuatorAndSecondSensor().length;
        int n5 = this.getSecondSensorReadings().length;
        Reading[] readingArray = new Reading[n + n2 + n3 + n5 + n4];
        System.arraycopy(this.getFirstSensorReadings(), 0, readingArray, 0, n);
        System.arraycopy(this.getReadingsBetweenFirstSensorAndActuator(), 0, readingArray, n, n2);
        System.arraycopy(this.getActuatorReadings(), 0, readingArray, n + n2, n3);
        System.arraycopy(this.getReadingsBetweenActuatorAndSecondSensor(), 0, readingArray, n + n2 + n3, n4);
        System.arraycopy(this.getSecondSensorReadings(), 0, readingArray, n + n2 + n3 + n4, n5);
        return readingArray;
    }

    static CdmaOverAirMeasurement createOA() {
        CdmaOverAirMeasurement cdmaOverAirMeasurement = (CdmaOverAirMeasurement)pool.dequeue();
        if (cdmaOverAirMeasurement == null) {
            return new CdmaOverAirMeasurement();
        }
        return cdmaOverAirMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int getCurrentPercentAmplifierCapacity() {
        return this.currentPercentAmplifierCapacity.intValue();
    }

    public int getPeakPercentAmplifierCapacity() {
        return this.peakPercentAmplifierCapacity.intValue();
    }

    public int getAveragePercentAmplifierCapacity() {
        return this.averagePercentAmplifierCapacity.intValue();
    }

    public int getCurrentPercentUtilization() {
        return this.currentPercentUtilization.intValue();
    }

    public int getPeakPercentUtilization() {
        return this.peakPercentUtilization.intValue();
    }

    public int getAveragePercentUtilization() {
        return this.averagePercentUtilization.intValue();
    }

    public int[] getTopNPilotsValues() {
        return this.topNPilots.getTrace();
    }

    public int getPilotDominance() {
        return this.pilotDominance.intValue();
    }

    public int getMultipathPower() {
        return this.multipathPower.intValue();
    }

    public boolean isResetMetrics() {
        return this.resetMetrics.booleanValue();
    }

    public int getPilotPowerActuator() {
        return this.pilotPowerActuator.intValue();
    }

    public int getMaxAmplifierCapacity() {
        return this.maxAmplifierCapacity.intValue();
    }

    public int getPilotDominanceThreshold() {
        return this.pilotDominanceThreshold.intValue();
    }

    public int getMultipathPowerThreshold() {
        return this.multipathPowerThreshold.intValue();
    }

    protected void setCurrentPercentAmplifierCapacity(int n) {
        this.currentPercentAmplifierCapacity.setValue(n);
    }

    protected void setPeakPercentAmplifierCapacity(int n) {
        this.peakPercentAmplifierCapacity.setValue(n);
    }

    protected void setAveragePercentAmplifierCapacity(int n) {
        this.averagePercentAmplifierCapacity.setValue(n);
    }

    protected void setCurrentPercentUtilization(int n) {
        this.currentPercentUtilization.setValue(n);
    }

    protected void setPeakPercentUtilization(int n) {
        this.peakPercentUtilization.setValue(n);
    }

    protected void setAveragePercentUtilization(int n) {
        this.averagePercentUtilization.setValue(n);
    }

    public void setTopNPilotValues(int[] nArray) {
        this.topNPilots.setTrace(nArray);
    }

    void setCdpValid(boolean bl) {
        this.cdpValid.setValue(bl);
    }

    void setPilotDominance(int n) {
        this.pilotDominance.setValue(n);
    }

    void setMultipathPower(int n) {
        this.multipathPower.setValue(n);
    }

    void setResetMetrics(boolean bl) {
        this.resetMetrics.setValue(bl);
    }

    void setPilotPowerActuator(int n) {
        this.pilotPowerActuator.setValue(n);
    }

    void setMaxAmplifierCapacity(int n) {
        this.maxAmplifierCapacity.setValue(n);
    }

    void setPilotDominanceThreshold(int n) {
        this.pilotDominanceThreshold.setValue(n);
    }

    void setMultipathPowerThreshold(int n) {
        this.multipathPowerThreshold.setValue(n);
    }

    public int[] getTopPnOffsets() {
        return this.topNPnOffsets.getTrace();
    }

    public void setTopNPnOffsets(int[] nArray) {
        this.topNPnOffsets.setTrace(nArray);
    }

    public boolean isPilotDominanceAboveLimit() {
        return this.pilotDominance.intValue() > this.pilotDominanceThreshold.intValue();
    }

    public boolean isMultipathPowerBelowLimit() {
        return this.multipathPower.intValue() < this.multipathPowerThreshold.intValue();
    }

    public boolean isValidForMetricDisplay() {
        return super.isValidForMetricDisplay() && this.topNPilots.getTrace()[0] > -21000;
    }

    public Reading[] getReadings() {
        return this.readings;
    }

    public String getMeasurementTitle() {
        return Text.CDMA_Over_Air;
    }

    public void invalidatePilotDominance() {
        this.pilotDominance.setValue(-1);
    }
}

