/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Text;
import elgato.measurement.cdma.CdmaAnalyzer;
import elgato.measurement.cdma.CdmaMenuMgr;
import elgato.measurement.cdma.CdmaOaMeasurementSettings;
import elgato.measurement.cdma.CdmaOverAirScreen;
import elgato.measurement.cdma.CommonCdmaMeasurementSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class CdmaOverAirMenuMgr
extends CdmaMenuMgr {
    protected MenuItem locationAmpCapButton;

    public CdmaOverAirMenuMgr(CdmaOverAirScreen cdmaOverAirScreen, CommonCdmaMeasurementSettings commonCdmaMeasurementSettings, CdmaAnalyzer cdmaAnalyzer) {
        super(cdmaOverAirScreen, commonCdmaMeasurementSettings, cdmaAnalyzer);
    }

    protected abstract MenuItem createResetAmpCapButton();

    protected Menu buildLeftMenu() {
        Menu menu = super.buildLeftMenu();
        menu.setMenuItem(this.createResetAmpCapButton(), 2);
        return menu;
    }

    protected String getMeasurementName() {
        return "cdmaOa";
    }

    protected MenuItem createMetricsResetButton() {
        return new PushButton(Text.Reset_n_Metrics, this.getContextString("reset.metrics"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CdmaOaMeasurementSettings.instance().getResetMetrics().send(1L);
            }
        });
    }

    protected SubMenuButton createCodogramSubMenuButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Codogram, this.getContextString("display"), this.createCodogramMenu(), true);
        subMenuButton.getCancelButton().setText(Text.Back);
        return subMenuButton;
    }

    protected MenuItem createAmpCapOnOffButton() {
        return new MultiStateActuatorButton(SystemMeasurementSettings.instance().getAmpCap(), this.getContextString("amp.cap.on.off"), this.getListenerBaseName() + ".ampCapEnabledButton");
    }

    protected ActuatorEditor createMultipathPowerThresholdButton(SettingsModel settingsModel) {
        return new ActuatorEditor(CdmaOaMeasurementSettings.instance().getMultipathPower(), "pwr.thresh", this.getListenerBaseName() + ".pwrThreshButton");
    }

    protected ActuatorEditor createPilotDominanceThresholdButton(SettingsModel settingsModel) {
        return new ActuatorEditor(CdmaOaMeasurementSettings.instance().getPilotDominance(), "plt.dom", this.getListenerBaseName() + ".pilotDomButton");
    }

    protected ActuatorEditor createPilotPowerButton() {
        return new ActuatorEditor(CdmaOaMeasurementSettings.instance().getPilotPower(), "plt.power", this.getListenerBaseName() + ".pltPwrButton");
    }

    protected ActuatorEditor createMaxPaPowerButton() {
        return new ActuatorEditor(CdmaOaMeasurementSettings.instance().getAmpCap(), "max.pa.power", this.getListenerBaseName() + ".maxPaPwrButton");
    }

    protected ActuatorEditor createDeltaPagePowerButton() {
        return new ActuatorEditor(CdmaOaMeasurementSettings.instance().getPagePower(), "delta.page.power", this.getListenerBaseName() + ".pagePwrButton");
    }

    protected ActuatorEditor createDeltaSyncPowerButton() {
        return new ActuatorEditor(CdmaOaMeasurementSettings.instance().getSyncPower(), "delta.sync.power", this.getListenerBaseName() + ".syncPwrButton");
    }
}

