/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.measurement.cdma.CdmaAnalyzer;
import elgato.measurement.cdma.CdmaMetricsTable;
import elgato.measurement.cdma.CdmaOverAirMeasurement;

public class CdmaOverAirMetricsTable
extends CdmaMetricsTable {
    ValueSource frequency = this.createFreqValueSource(new FrequencyStrategy(), Text.Freq);

    protected ValueSource[][] createValueSources() {
        FixedPointNumberFieldStrategy fixedPointNumberFieldStrategy = new FixedPointNumberFieldStrategy(1, " %");
        DecibelStrategy decibelStrategy = new DecibelStrategy(1);
        DecibelStrategy decibelStrategy2 = new DecibelStrategy(1, true);
        MaybeBlankValueSource maybeBlankValueSource = new MaybeBlankValueSource((NumberFieldStrategy)fixedPointNumberFieldStrategy, Text.Amp_Cap){

            public long getRawValue() {
                return CdmaOverAirMetricsTable.this.getCdmaOaMeasurement().getCurrentPercentAmplifierCapacity();
            }
        };
        MaybeBlankValueSource maybeBlankValueSource2 = new MaybeBlankValueSource((NumberFieldStrategy)fixedPointNumberFieldStrategy, Text.Pk_Amp_Cap){

            public long getRawValue() {
                return CdmaOverAirMetricsTable.this.getCdmaOaMeasurement().getPeakPercentAmplifierCapacity();
            }
        };
        MaybeBlankValueSource maybeBlankValueSource3 = new MaybeBlankValueSource((NumberFieldStrategy)fixedPointNumberFieldStrategy, Text.Avg_Amp_Cap){

            public long getRawValue() {
                return CdmaOverAirMetricsTable.this.getCdmaOaMeasurement().getAveragePercentAmplifierCapacity();
            }
        };
        CdmaMetricsTable.GrayableValueSource grayableValueSource = new CdmaMetricsTable.GrayableValueSource(Text.Utilization, (NumberFieldStrategy)fixedPointNumberFieldStrategy, true){

            public long getRawValue() {
                return CdmaOverAirMetricsTable.this.getCdmaOaMeasurement().getCurrentPercentUtilization();
            }
        };
        CdmaMetricsTable.GrayableValueSource grayableValueSource2 = new CdmaMetricsTable.GrayableValueSource(Text.Pk_Util, (NumberFieldStrategy)fixedPointNumberFieldStrategy, true){

            public long getRawValue() {
                return CdmaOverAirMetricsTable.this.getCdmaOaMeasurement().getPeakPercentUtilization();
            }
        };
        CdmaMetricsTable.GrayableValueSource grayableValueSource3 = new CdmaMetricsTable.GrayableValueSource(Text.Avg_Util, (NumberFieldStrategy)fixedPointNumberFieldStrategy, true){

            public long getRawValue() {
                return CdmaOverAirMetricsTable.this.getCdmaOaMeasurement().getAveragePercentUtilization();
            }
        };
        CdmaMetricsTable.GrayableValueSource grayableValueSource4 = new CdmaMetricsTable.GrayableValueSource(Text.Pilot_Ec_slash_Io, (NumberFieldStrategy)decibelStrategy, true){

            public long getRawValue() {
                return CdmaOverAirMetricsTable.this.getCdmaOaMeasurement().getPilotPower() - CdmaOverAirMetricsTable.this.getCdmaOaMeasurement().getChannelPower();
            }
        };
        ValueSource[] valueSourceArray = new ValueSource[]{this.createFreqErrorValueSource(new FrequencyStrategy()), this.createPnOffsetValueSource(new NumberFieldStrategy()), this.createPilotDelayValueSource(), this.createRhoValueSource(), this.createCarrierFeedthruValueSource(new FixedPointNumberFieldStrategy(1, "dBc")), this.createNoiseFloorValueSource(decibelStrategy)};
        ValueSource[] valueSourceArray2 = new ValueSource[]{this.createChanPowerValueSource(decibelStrategy2), this.createPilotPowerValueSource(decibelStrategy2), grayableValueSource4, this.createDiffPagePowerValueSource(decibelStrategy), this.createDiffSyncPowerValueSource(decibelStrategy), this.createDiffQuickPagePower(decibelStrategy)};
        ValueSource[] valueSourceArray3 = new ValueSource[]{maybeBlankValueSource, maybeBlankValueSource2, maybeBlankValueSource3, grayableValueSource, grayableValueSource2, grayableValueSource3};
        return new ValueSource[][]{valueSourceArray, valueSourceArray2, valueSourceArray3};
    }

    public CdmaOverAirMetricsTable(CdmaAnalyzer cdmaAnalyzer) {
        super(cdmaAnalyzer);
    }

    public void setMeasurement(Measurement measurement) {
        super.setMeasurement(measurement);
        this.frequency.compute(this.isMeasurementValid());
    }

    public TabDelimitable[] getTabDelimitables() {
        TabDelimitable[] tabDelimitableArray = super.getTabDelimitables();
        TabDelimitable[] tabDelimitableArray2 = new TabDelimitable[tabDelimitableArray.length + 1];
        tabDelimitableArray2[0] = this.frequency;
        System.arraycopy(tabDelimitableArray, 0, tabDelimitableArray2, 1, tabDelimitableArray.length);
        return tabDelimitableArray2;
    }

    private CdmaOverAirMeasurement getCdmaOaMeasurement() {
        return (CdmaOverAirMeasurement)this.getMeasurement();
    }

    protected boolean shouldGrayOutValues() {
        return !this.getCdmaOaMeasurement().isMultipathPowerBelowLimit() || !this.getCdmaOaMeasurement().isPilotDominanceAboveLimit();
    }

    private abstract class MaybeBlankValueSource
    extends CdmaMetricsTable.GrayableValueSource {
        public MaybeBlankValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
            super(string, numberFieldStrategy, true);
        }

        public void compute(boolean bl) {
            if (SystemMeasurementSettings.displayAmpCap()) {
                super.compute(bl);
            } else {
                this.setResultsEmpty();
            }
        }
    }
}

