/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.html.HtmlTable;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.ProductFactory;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.measurement.cdma.CdmaAnalyzer;
import elgato.measurement.cdma.CdmaMeasurement;
import elgato.measurement.cdma.CdmaMeasurementSettings;
import elgato.measurement.cdma.CdmaMenuMgr;
import elgato.measurement.cdma.CommonCdmaMeasurementSettings;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;

public class CdmaScreen
extends MeasurementScreen {
    protected CdmaAnalyzer analyzer;
    protected CdmaMenuMgr menuMgr;
    static /* synthetic */ Class class$elgato$measurement$cdma$CdmaMeasurement;

    protected Command[] getInitialGetCommands() {
        return new Command[0];
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.menuMgr.prolog();
    }

    public void uninstallScreen(ScreenManager screenManager) {
        if (this.menuMgr != null) {
            this.menuMgr.cleanup();
        }
        super.uninstallScreen(screenManager);
        this.menuMgr = null;
        this.analyzer = null;
    }

    protected CdmaMenuMgr createMenuMgr() {
        this.menuMgr = ProductFactory.getInstance().createCdmaMenuMgr(this, this.getCdmaMeasurementSettings(), (CdmaAnalyzer)this.getAnalyzer());
        return this.menuMgr;
    }

    protected void refreshMeasurementSettings() {
        this.getCdmaMeasurementSettings().refresh();
    }

    protected String getMeasurementName() {
        return "cdmaAn";
    }

    protected void setupAnalyzer() {
        this.analyzer = new CdmaAnalyzer(this.isDoingOverAir(), this.getCdmaMeasurementSettings());
        this.createMenuMgr();
        this.analyzer.setMarkerButtonFactory(this.menuMgr.getMarkerButtonFactory());
    }

    protected boolean isDoingOverAir() {
        return false;
    }

    protected Component getAnalyzerPanel() {
        return this.analyzer;
    }

    protected Class getMeasurementClass() {
        return class$elgato$measurement$cdma$CdmaMeasurement == null ? (class$elgato$measurement$cdma$CdmaMeasurement = CdmaScreen.class$("elgato.measurement.cdma.CdmaMeasurement")) : class$elgato$measurement$cdma$CdmaMeasurement;
    }

    protected String getTitle() {
        return Text.CDMA_Analyzer;
    }

    protected Menu buildLeftMenu() {
        return this.menuMgr.buildLeftMenu();
    }

    protected CommonCdmaMeasurementSettings getCdmaMeasurementSettings() {
        return CdmaMeasurementSettings.instance();
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        return this.analyzer.filterPrintImage(image, rectangle);
    }

    public String getTestResults(ScreenManager screenManager, String string) {
        CdmaMeasurement cdmaMeasurement = (CdmaMeasurement)this.getAnalyzer().getMeasurement();
        if (cdmaMeasurement == null) {
            this.displayErrorMessageScreen(screenManager);
            return "";
        }
        double d = (double)CdmaMeasurementSettings.instance().getEstRhoLowerLimit().intValue() / 100000.0;
        double d2 = (double)CdmaMeasurementSettings.instance().getTimeOffsetLowerLimit().intValue() / 1000.0;
        double d3 = (double)CdmaMeasurementSettings.instance().getTimeOffsetUpperLimit().intValue() / 1000.0;
        double d4 = CdmaMeasurementSettings.instance().getFreqErrorLowerLimit().intValue();
        double d5 = CdmaMeasurementSettings.instance().getFreqErrorUpperLimit().intValue();
        double d6 = (double)CdmaMeasurementSettings.instance().getCarrFeedthruUpperLimit().intValue() / 1000.0;
        int[] nArray = cdmaMeasurement.getIndexOfSixLargestCdma2kLevels();
        String string2 = "";
        String string3 = "TX OCNS";
        if (string.startsWith("OCNS Channels")) {
            string2 = MeasurementScreen.createResultLine(cdmaMeasurement.getChannelPower(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, "TX Channel Power", "dBm");
            int n = cdmaMeasurement.findPosition(CdmaAnalyzer.getChannelType(Text.Pilot));
            string2 = n >= 0 ? string2 + MeasurementScreen.createResultLine(cdmaMeasurement.getChannelLevels()[n], Double.POSITIVE_INFINITY, (double)this.getCdmaMeasurementSettings().getPilotPowerLowerLimit().longValue() / 1000.0, "TX Pilot Channel Level", "dB") : string2 + this.formatLine("\n!!! No Pilot Channel Found !!!\n");
            n = cdmaMeasurement.findPosition(CdmaAnalyzer.getChannelType(Text.Sync));
            string2 = n >= 0 ? string2 + MeasurementScreen.createResultLine(cdmaMeasurement.getDiffSyncPower(), Double.POSITIVE_INFINITY, (double)this.getCdmaMeasurementSettings().getSyncPowerLowerLimit().longValue() / 1000.0, "TX Sync Channel Level", "dB") : string2 + this.formatLine("\n!!! No Sync Channel Found !!!\n");
            for (int i = 0; i < nArray.length; ++i) {
                string2 = string2 + MeasurementScreen.createResultLine(cdmaMeasurement.getChannelLevels()[nArray[i]], Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, "TX Channel " + cdmaMeasurement.getChannelNumbers()[nArray[i]] + " Level", "dB");
                int n2 = cdmaMeasurement.getChannelWidths()[nArray[i]];
                int n3 = 128 / n2 * 1000;
                string2 = string2 + MeasurementScreen.createResultLine(n3, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, "TX Channel " + cdmaMeasurement.getChannelNumbers()[nArray[i]] + " sf", "");
            }
            n = cdmaMeasurement.findPosition(CdmaAnalyzer.getChannelType(Text.Page));
            string2 = n >= 0 ? string2 + MeasurementScreen.createResultLine(cdmaMeasurement.getDiffPagePower(), Double.POSITIVE_INFINITY, (double)this.getCdmaMeasurementSettings().getPagePowerLowerLimit().longValue() / 1000.0, "TX Paging Channel Level", "dB") : string2 + this.formatLine("\n!!! No Paging Channel Found !!!\n");
            string2 = string2 + cdmaMeasurement.getMaxNoise((double)this.getCdmaMeasurementSettings().getNoiseFloorUpperLimit().longValue() / 1000.0);
        } else {
            string3 = "MFRM Multi Carrier OCNS";
        }
        string2 = string2 + this.writeFourChannelResults(cdmaMeasurement, d, d3, d2, d5, d4, d6, string3);
        return string2;
    }

    private String formatLine(String string) {
        HtmlTable htmlTable = new HtmlTable();
        htmlTable.addRow(new String[]{string, "", "", "", Text.FAIL});
        return htmlTable.getRow(0);
    }

    private String writeFourChannelResults(CdmaMeasurement cdmaMeasurement, double d, double d2, double d3, double d4, double d5, double d6, String string) {
        String string2 = MeasurementScreen.createResultLine(cdmaMeasurement.getEstimatedRho(), Double.POSITIVE_INFINITY, d, string + " Estimated Rho", "");
        string2 = string2 + MeasurementScreen.createResultLine(UIHelper.chipsToNanoseconds(cdmaMeasurement.getPilotDelay()), d2, d3, string + " Time Offset", "usec");
        string2 = string2 + MeasurementScreen.createResultLine(cdmaMeasurement.getFreqError(), d4, d5, string + " Frequency Error", "Hz");
        string2 = string2 + MeasurementScreen.createResultLine(cdmaMeasurement.getCarrierFeedthrough(), d6, Double.NEGATIVE_INFINITY, string + " Carrier Feedthru", "dB");
        return string2;
    }

    public void showPassFailPanel() {
        this.analyzer.swapBottomPanel(true);
    }

    public CdmaMenuMgr getMenuMgr() {
        return this.menuMgr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

