/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.readings.UnsignedByteArrayReading;
import elgato.measurement.cdma.CdmaMeasurement;
import java.io.DataInput;
import java.io.IOException;

class CdmaUnpacker {
    private static CdmaUnpacker cdmaUnpacker;

    CdmaUnpacker() {
    }

    public static CdmaUnpacker instance() {
        if (cdmaUnpacker == null) {
            cdmaUnpacker = new CdmaUnpacker();
        }
        return cdmaUnpacker;
    }

    CdmaMeasurement unpackMeasurement(CdmaMeasurement cdmaMeasurement, DataInput dataInput) throws IOException {
        this.setFirstSensorReadings(cdmaMeasurement, dataInput);
        this.setActuatorReadings(cdmaMeasurement, dataInput);
        this.setSecondSensorReadings(cdmaMeasurement, dataInput);
        return cdmaMeasurement;
    }

    protected void setFirstSensorReadings(CdmaMeasurement cdmaMeasurement, DataInput dataInput) throws IOException {
        Reading[] readingArray = cdmaMeasurement.getFirstSensorReadings();
        this.setReadings(readingArray, dataInput);
    }

    public void setActuatorReadings(CdmaMeasurement cdmaMeasurement, DataInput dataInput) throws IOException {
        Reading[] readingArray = cdmaMeasurement.getActuatorReadings();
        this.setReadings(readingArray, dataInput);
    }

    public void setSecondSensorReadings(CdmaMeasurement cdmaMeasurement, DataInput dataInput) throws IOException {
        Reading[] readingArray = cdmaMeasurement.getSecondSensorReadings();
        if (readingArray[0] == null) {
            return;
        }
        readingArray[0].unpack(dataInput);
        int n = readingArray[0].intValue();
        if (readingArray[1] != null) {
            ((UnsignedByteArrayReading)readingArray[1]).setLength(n);
        }
        if (readingArray[2] != null) {
            ((UnsignedByteArrayReading)readingArray[2]).setLength(n);
        }
        if (readingArray[3] != null) {
            ((UnsignedByteArrayReading)readingArray[3]).setLength(n);
        }
        if (readingArray[4] != null) {
            ((IntegerArrayReading)readingArray[4]).setLength(n);
        }
        for (int i = 1; i < readingArray.length; ++i) {
            if (readingArray[i] == null) continue;
            readingArray[i].unpack(dataInput);
        }
    }

    public void setReadings(Reading[] readingArray, DataInput dataInput) throws IOException {
        for (int i = 0; i < readingArray.length; ++i) {
            if (readingArray[i] == null) continue;
            readingArray[i].unpack(dataInput);
        }
    }
}

