/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma;

import elgato.infrastructure.actuators.CenterFrequencyActuator;
import elgato.infrastructure.actuators.FreqChanActuatorConfigurator;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.ScaleDivActuator;
import elgato.infrastructure.analyzer.SpectralChart;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.util.Vector;

public class CommonCdmaMeasurementSettings
extends MeasurementSettings {
    protected final String TOPIC = this.getTopic();
    protected final String DISPLAY_TOPIC = "display." + this.TOPIC;
    public static final String KEY_CDMA_PN_OFFSET_AUTO = "pnAuto";
    public static final String KEY_CDMA_THRESHOLD_LEVEL_AUTO = "threshAuto";
    public static final int REF_REL_SELECTED = 0;
    public static final int REF_ABS_SELECTED = 1;
    public static final int CDMA_LIMIT_SIZE = 8;
    public static final int LIMIT_FREQ_ERROR = 0;
    public static final int LIMIT_TIME_OFFSET = 1;
    public static final int LIMIT_EST_RHO = 2;
    public static final int LIMIT_CARR_FEEDTHRU = 3;
    public static final int LIMIT_NOISE_FLOOR = 4;
    public static final int LIMIT_PILOT_POWER = 5;
    public static final int LIMIT_PAGE_POWER = 6;
    public static final int LIMIT_SYNC_POWER = 7;
    private boolean doingLimitSetAll = true;
    private boolean bLimitsSummaryState = false;
    private static final String KEY_FREQ_ERROR_LOW_LIMIT = "freqErrorLowerLimit";
    private static final String KEY_FREQ_ERROR_UP_LIMIT = "freqErrorUpperLimit";
    private static final String KEY_TIME_OFFSET_LOW_LIMIT = "timeOffsetLowerLimit";
    private static final String KEY_TIME_OFFSET_UP_LIMIT = "timeOffsetUpperLimit";
    private static final String KEY_EST_RHO_LOW_LIMIT = "estRhoLowerLimit";
    private static final String KEY_CARRIER_FEEDTHRU_UP_LIMIT = "carrFeedthruUpperLimit";
    private static final String KEY_NOISE_FLOOR_UP_LIMIT = "noiseFloorUpperLimit";
    private static final String KEY_PILOT_POWER_LOW_LIMIT = "pilotPowerLowerLimit";
    private static final String KEY_PILOT_POWER_UP_LIMIT = "pilotPowerUpperLimit";
    private static final String KEY_PAGE_POWER_LOW_LIMIT = "pagePowerLowerLimit";
    private static final String KEY_PAGE_POWER_UP_LIMIT = "pagePowerUpperLimit";
    private static final String KEY_SYNC_POWER_LOW_LIMIT = "syncPowerLowerLimit";
    private static final String KEY_SYNC_POWER_UP_LIMIT = "syncPowerUpperLimit";
    private final DisplayGlobalMeasurementSettings globalDisplaySettings = DisplayGlobalMeasurementSettings.instance();
    private LongActuator thresholdLevel = new LongActuator(this.TOPIC, "threshLv", Text.Threshold_Level, -30000L);
    private ListActuator thresholdAuto = new ListActuator(this.TOPIC, "threshAuto", Text.Thresh_Lvl, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private LongActuator pnOffsetManual = new LongActuator(this.TOPIC, "pn", Text.PN_Offset, 1L);
    private ListActuator pnOffsetAuto = new ListActuator(this.TOPIC, "pnAuto", Text.PN_Offset, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private LongActuator pnInc = new LongActuator(this.TOPIC, "pnInc", Text.PN_Inc, 1L);
    private LongActuator threshOffset = new LongActuator(this.TOPIC, "threshOffset", Text.Auto_Thres_n_Offset, 0L);
    private FrequencyActuator centerFreq = CenterFrequencyActuator.createCenterFrequencyActuator(this.TOPIC, "cf");
    private LongActuator numAverages = LongActuator.createNumAverages(this.TOPIC, 100);
    private ListActuator averaging = ListActuator.createAveragingOffOn(this.TOPIC);
    private ListActuator measTime = new ListActuator(this.TOPIC, "measTime", Text.Meas_Time, new Value[]{Value.createValue(Text.Slow, 0), Value.createValue(Text.Avg, 1), Value.createValue(Text.Fast, 2)});
    private ListActuator quickPageChannels = new ListActuator(this.TOPIC, "qPageChs", Text.Quick_Page_n_Channel, new Value[]{Value.createValue(Text.Off, 0), Value.createValue(Text.Ch_88, 1)});
    private ListActuator reference = new ListActuator(this.DISPLAY_TOPIC, "refLevel", Text.Reference, new Value[]{Value.createValue(Text.Abs, 1), Value.createValue(Text.Rel, 0)});
    private final ScaleDivActuator scaleDiv = new ScaleDivActuator(this.DISPLAY_TOPIC, 5000);
    private LongActuator rfInLoss = LongActuator.createLoss(this.TOPIC, "atten", Text.RF_IN_Loss, 0);
    private ListActuator codogramEnabled = new ListActuator(this.DISPLAY_TOPIC, "codogramEnabled", Text.Codogram, this.createOnOffValueSet());
    private ListActuator codogramPalette = new ListActuator(this.DISPLAY_TOPIC, "codogramPalette", Text.Palette, SpectralChart.createPaletteValues());
    private final LongActuator codogramCaptureInterval = new LongActuator(this.DISPLAY_TOPIC, "codogramCaptureInterval", Text.Update_n_Interval);
    private Vector limitsToggles = new Vector();
    private FrequencyActuator freqErrorLowerLimit = new FrequencyActuator(this.DISPLAY_TOPIC, "freqErrorLowerLimit", Text.Low_Limit);
    private FrequencyActuator freqErrorUpperLimit = new FrequencyActuator(this.DISPLAY_TOPIC, "freqErrorUpperLimit", Text.High_Limit);
    private LongActuator timeOffsetLowerLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "timeOffsetLowerLimit", Text.Low_Limit, "usec", 1000);
    private LongActuator timeOffsetUpperLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "timeOffsetUpperLimit", Text.High_Limit, "usec", 1000);
    private LongActuator estRhoLowerLimit = LongActuator.createEstRho(this.DISPLAY_TOPIC, "estRhoLowerLimit", Text.Low_Limit, " ", 100000);
    private LongActuator carrFeedthruUpperLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "carrFeedthruUpperLimit", Text.High_Limit, "dBc", 1000);
    private LongActuator noiseFloorUpperLimit = LongActuator.createPower(this.DISPLAY_TOPIC, "noiseFloorUpperLimit", Text.High_Limit);
    private LongActuator pilotPowerLowerLimit = LongActuator.createPower(this.DISPLAY_TOPIC, "pilotPowerLowerLimit", Text.Low_Limit, new RangeValidator(-150000L, 50000L), "dBm", 100);
    private LongActuator pilotPowerUpperLimit = LongActuator.createPower(this.DISPLAY_TOPIC, "pilotPowerUpperLimit", Text.High_Limit, new RangeValidator(-150000L, 50000L), "dBm", 100);
    private LongActuator pagePowerLowerLimit = LongActuator.createPower(this.DISPLAY_TOPIC, "pagePowerLowerLimit", Text.Low_Limit);
    private LongActuator pagePowerUpperLimit = LongActuator.createPower(this.DISPLAY_TOPIC, "pagePowerUpperLimit", Text.High_Limit);
    private LongActuator syncPowerLowerLimit = LongActuator.createPower(this.DISPLAY_TOPIC, "syncPowerLowerLimit", Text.Low_Limit);
    private LongActuator syncPowerUpperLimit = LongActuator.createPower(this.DISPLAY_TOPIC, "syncPowerUpperLimit", Text.High_Limit);

    public CommonCdmaMeasurementSettings(String string) {
        super(string);
        this.add(this.thresholdLevel);
        this.add(this.thresholdAuto);
        this.add(this.pnOffsetManual);
        this.add(this.pnOffsetAuto);
        this.add(this.pnInc);
        this.add(this.averaging);
        this.add(this.numAverages);
        this.add(this.threshOffset);
        this.add(this.centerFreq);
        this.add(this.measTime);
        this.add(this.quickPageChannels);
        this.add(this.reference);
        this.add(this.scaleDiv);
        this.add(this.rfInLoss);
        this.add(this.codogramEnabled);
        this.add(this.codogramPalette);
        this.add(this.codogramCaptureInterval);
        this.add(this.freqErrorLowerLimit);
        this.add(this.freqErrorUpperLimit);
        this.add(this.timeOffsetLowerLimit);
        this.add(this.timeOffsetUpperLimit);
        this.add(this.estRhoLowerLimit);
        this.add(this.carrFeedthruUpperLimit);
        this.add(this.noiseFloorUpperLimit);
        this.add(this.pilotPowerLowerLimit);
        this.add(this.pilotPowerUpperLimit);
        this.add(this.pagePowerLowerLimit);
        this.add(this.pagePowerUpperLimit);
        this.add(this.syncPowerLowerLimit);
        this.add(this.syncPowerUpperLimit);
        this.thresholdLevel.setConversion(new FactorConversion("dB", 1000L));
        this.thresholdLevel.setPalette(Palette.createSignedInteger());
        this.thresholdLevel.setValidator(new RangeValidator(-45000L, 0L));
        this.thresholdLevel.setIncrement(1000);
        this.pnOffsetManual.setValidator(new RangeValidator(0L, 511L));
        this.pnInc.setValidator(new RangeValidator(1L, 15L));
        this.threshOffset.setValidator(new RangeValidator(-20000L, 20000L));
        this.threshOffset.setConversion(new FactorConversion("dB", 1000L));
        this.threshOffset.setPalette(Palette.createSignedInteger());
        this.threshOffset.setIncrement(1000);
        this.setValidatorToFreqCalLimits(this.centerFreq);
        this.makeStashedLossActuatorSet(DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.rfInLoss, DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), string + ".RfInLossListener");
        new FreqChanActuatorConfigurator(this.centerFreq, this.globalDisplaySettings.getChanFreqUnits(), this.globalDisplaySettings.getChanStd(), this.globalDisplaySettings.getChannelStep(), this.globalDisplaySettings.getFrequencyStep(), BandSelector.getGlobalBandSelector(), string + ".cfListener");
        this.freqErrorLowerLimit.addValueListener(new CdmaValueListener(KEY_FREQ_ERROR_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.freqErrorUpperLimit.addValueListener(new CdmaValueListener(KEY_FREQ_ERROR_UP_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.timeOffsetLowerLimit.addValueListener(new CdmaValueListener(KEY_TIME_OFFSET_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.timeOffsetUpperLimit.addValueListener(new CdmaValueListener(KEY_TIME_OFFSET_UP_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.estRhoLowerLimit.addValueListener(new CdmaValueListener(KEY_EST_RHO_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.carrFeedthruUpperLimit.addValueListener(new CdmaValueListener(KEY_CARRIER_FEEDTHRU_UP_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.noiseFloorUpperLimit.addValueListener(new CdmaValueListener(KEY_NOISE_FLOOR_UP_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.pilotPowerLowerLimit.addValueListener(new CdmaValueListener(KEY_PILOT_POWER_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.pagePowerLowerLimit.addValueListener(new CdmaValueListener(KEY_PAGE_POWER_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.syncPowerLowerLimit.addValueListener(new CdmaValueListener(KEY_SYNC_POWER_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.pilotPowerUpperLimit.addValueListener(new CdmaValueListener(KEY_PILOT_POWER_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.pagePowerUpperLimit.addValueListener(new CdmaValueListener(KEY_PAGE_POWER_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.syncPowerUpperLimit.addValueListener(new CdmaValueListener(KEY_SYNC_POWER_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdmaMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdmaMeasurementSettings.this.setAllLimits();
                }
            }
        });
        RangeValidator rangeValidator = new RangeValidator(0L, Integer.MAX_VALUE);
        this.codogramCaptureInterval.setUnitsFactory(new MeasurementSettings.UpdateIntervalUnitSystem());
        this.codogramCaptureInterval.setValidator(rangeValidator);
    }

    public LongActuator[] getStorableActuators() {
        return new LongActuator[]{this.freqErrorLowerLimit, this.freqErrorUpperLimit, this.timeOffsetLowerLimit, this.timeOffsetUpperLimit, this.estRhoLowerLimit, this.carrFeedthruUpperLimit, this.noiseFloorUpperLimit, this.pilotPowerLowerLimit, this.pilotPowerUpperLimit, this.pagePowerLowerLimit, this.pagePowerUpperLimit, this.syncPowerLowerLimit, this.syncPowerUpperLimit};
    }

    public void allowValidationNow() {
        this.doingLimitSetAll = false;
    }

    public void setAllLimits() {
        if (MeasurementSettings.suspendValidation) {
            return;
        }
        this.doingLimitSetAll = true;
        this.freqErrorLowerLimit.setValidator(new RangeValidator(Long.MIN_VALUE, 0L));
        this.freqErrorUpperLimit.setValidator(new RangeValidator(0L, Long.MAX_VALUE));
        this.timeOffsetLowerLimit.setValidator(new RangeValidator(Long.MIN_VALUE, Long.MAX_VALUE));
        this.timeOffsetUpperLimit.setValidator(new RangeValidator(Long.MIN_VALUE, Long.MAX_VALUE));
        this.estRhoLowerLimit.setValidator(new RangeValidator(0L, 100000L));
        RangeValidator rangeValidator = new RangeValidator(-150000L, 100000L);
        this.carrFeedthruUpperLimit.setValidator(rangeValidator);
        this.noiseFloorUpperLimit.setValidator(rangeValidator);
        this.pilotPowerLowerLimit.setValidator(rangeValidator);
        this.pilotPowerUpperLimit.setValidator(rangeValidator);
        this.pagePowerLowerLimit.setValidator(rangeValidator);
        this.pagePowerUpperLimit.setValidator(rangeValidator);
        this.syncPowerLowerLimit.setValidator(rangeValidator);
        this.syncPowerUpperLimit.setValidator(rangeValidator);
        this.doingLimitSetAll = false;
    }

    public boolean getLimitsSummaryState() {
        this.bLimitsSummaryState = false;
        for (int i = 0; i < 8; ++i) {
            if (this.limitsToggleAt(i).getSelectedValue().longValue() != 1L) continue;
            this.bLimitsSummaryState = true;
            break;
        }
        return this.bLimitsSummaryState;
    }

    public LongActuator getThresholdLevel() {
        return this.thresholdLevel;
    }

    public ListActuator getAutoThreshold() {
        return this.thresholdAuto;
    }

    public LongActuator getPnOffsetManual() {
        return this.pnOffsetManual;
    }

    public ListActuator getPnOffsetAuto() {
        return this.pnOffsetAuto;
    }

    public LongActuator getPnInc() {
        return this.pnInc;
    }

    public LongActuator getThreshOffset() {
        return this.threshOffset;
    }

    public FrequencyActuator getCenterFreq() {
        return this.centerFreq;
    }

    public ListActuator getAveraging() {
        return this.averaging;
    }

    public LongActuator getNumAverages() {
        return this.numAverages;
    }

    public ListActuator getMeasTime() {
        return this.measTime;
    }

    public ListActuator getQuickPageChannels() {
        return this.quickPageChannels;
    }

    public ListActuator getReference() {
        return this.reference;
    }

    public boolean isRelative() {
        return this.reference.intValue() == 0;
    }

    public LongActuator getScaleDiv() {
        return this.scaleDiv;
    }

    public LongActuator getRfInLoss() {
        return this.rfInLoss;
    }

    public ListActuator getCodogramEnabled() {
        return this.codogramEnabled;
    }

    public ListActuator getCodogramPalette() {
        return this.codogramPalette;
    }

    public LongActuator getCodogramCaptureInterval() {
        return this.codogramCaptureInterval;
    }

    public ListActuator limitsToggleAt(int n) {
        ListActuator listActuator;
        this.limitsToggles.setSize(8);
        try {
            listActuator = (ListActuator)this.limitsToggles.elementAt(n);
            if (listActuator == null) {
                listActuator = new ListActuator(this.DISPLAY_TOPIC, "limitsToggle" + n, Text.Limits, this.createOnOffValueSet());
                listActuator.setValue(0);
                this.add(listActuator);
                listActuator.addValueListener(new CdmaValueListener("limitsToggle" + n){

                    public void valueChanged(ValueInterface valueInterface) {
                        CommonCdmaMeasurementSettings.this.setAllLimits();
                        CommonCdmaMeasurementSettings.this.bLimitsSummaryState = CommonCdmaMeasurementSettings.this.bLimitsSummaryState && valueInterface.booleanValue();
                    }
                });
                listActuator.setValue(0);
                this.limitsToggles.setElementAt(listActuator, n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            listActuator = null;
        }
        return listActuator;
    }

    public FrequencyActuator getFreqErrorUpperLimit() {
        return this.freqErrorUpperLimit;
    }

    public FrequencyActuator getFreqErrorLowerLimit() {
        return this.freqErrorLowerLimit;
    }

    public LongActuator getTimeOffsetUpperLimit() {
        return this.timeOffsetUpperLimit;
    }

    public LongActuator getTimeOffsetLowerLimit() {
        return this.timeOffsetLowerLimit;
    }

    public LongActuator getEstRhoLowerLimit() {
        return this.estRhoLowerLimit;
    }

    public LongActuator getCarrFeedthruUpperLimit() {
        return this.carrFeedthruUpperLimit;
    }

    public LongActuator getNoiseFloorUpperLimit() {
        return this.noiseFloorUpperLimit;
    }

    public LongActuator getPilotPowerLowerLimit() {
        return this.pilotPowerLowerLimit;
    }

    public LongActuator getPilotPowerUpperLimit() {
        return this.pilotPowerUpperLimit;
    }

    public LongActuator getPagePowerLowerLimit() {
        return this.pagePowerLowerLimit;
    }

    public LongActuator getPagePowerUpperLimit() {
        return this.pagePowerUpperLimit;
    }

    public LongActuator getSyncPowerLowerLimit() {
        return this.syncPowerLowerLimit;
    }

    public LongActuator getSyncPowerUpperLimit() {
        return this.syncPowerUpperLimit;
    }

    protected abstract class CdmaValueListener
    implements ValueListener {
        private final String listenerName;

        public CdmaValueListener(String string) {
            this.listenerName = CommonCdmaMeasurementSettings.this.TOPIC + "." + string + ".listener";
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public abstract /* synthetic */ void valueChanged(ValueInterface var1);
    }
}

