/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma1xev;

import elgato.infrastructure.analyzer.SpectralChart;
import elgato.infrastructure.analyzer.SpectralChartPanel;
import elgato.infrastructure.analyzer.TopNChart;
import elgato.infrastructure.analyzer.TopNPanel;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.readings.IntegerReadingField;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.GrayScaleColorFlipFilter;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.cdma1xev.Cdma1xevChart;
import elgato.measurement.cdma1xev.Cdma1xevMeasurement;
import elgato.measurement.cdma1xev.Cdma1xevMeasurementSettings;
import elgato.measurement.cdma1xev.Cdma1xevMetricsTable;
import elgato.measurement.cdma1xev.Cdma1xevTopNChart;
import elgato.measurement.cdma1xev.CommonCdma1xevMeasurementSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Cdma1xevAnalyzer
extends TraceAnalyzer {
    private static int yTop = 0;
    private static int yBottom = -50000;
    private final FixedPointNumberFieldStrategy dbStrategyTraceSave = new FixedPointNumberFieldStrategy(1);
    private static final DecibelStrategy dbmStrategy = new DecibelStrategy(1, true);
    private static final DecibelStrategy dbStrategy0 = new DecibelStrategy(0, false);
    private static final DecibelStrategy dbStrategy1 = new DecibelStrategy(1, false);
    private static final DecibelStrategy rfInStrategy = new DecibelStrategy(1, false);
    private static final String ANALYZER_CARD = "analyzer";
    private static final String CODOGRAM_CARD = "codogram";
    public static final String[] channelTypeNames = new String[]{Text.Noise, Text.RA, Text.RPC, Text.Pilot, Text.Data, Text.Preamble, Text.Unknown};
    private Cdma1xevMeasurement measurement;
    private static Container analyzerCard;
    private Container cardPanel;
    private Container chartPanel;
    private JPanel traceChartsPanel;
    private static BorderWrapper chartPanelBorder;
    private CdpMetricsListener cdpMetricsListener;
    private Cdma1xevChart chart;
    private BasicMeasurementMetrics metrics;
    private SpectralChartPanel spectralChartPanel;
    private TraceChart[] traceCharts;
    private CommonCdma1xevMeasurementSettings measurementSettings;
    private long lastcodogramTraceCapturedAt;
    private CardLayout cardLayout;
    private BorderLayout bottomCardLayout;
    private String currentCard;
    private Container bottomCardPanel;
    private Component bottomPanel;
    private Component bottomLimitsPanel;
    private JLabel passFailLabel;
    private JLabel macCdpXAxisLabel;
    private JLabel cdpPlotLabel;
    protected String listenerBaseName;
    private CodogramEnabledListener codogramEnabledListener;
    private CodogramPaletteListener codogramPaletteListener;
    private MacCdpXAxisListener macCdpXAxisListener;
    private CdpTypeListener cdpTypeListener;
    private LimitStateListener limitStateListener;
    private static BorderWrapper topNChartBorder;
    private Cdma1xevTopNChart topNChart;
    private OtaPNScannerListener otaPNScannerListener;
    private Cdma1xevTopNPanel cdma1xevTopNPanel;
    private final NumberFieldStrategy channelStrategy = new NumberFieldStrategy(){

        public String format(long l) {
            String string;
            int n = (int)l;
            if (n <= 0) {
                n = 0;
            } else if (n >= Cdma1xevAnalyzer.this.getCdma1xevMeasurement().getChannelTypes().length) {
                n = Cdma1xevAnalyzer.this.getCdma1xevMeasurement().getChannelTypes().length - 1;
            }
            int n2 = Cdma1xevAnalyzer.this.getCdma1xevMeasurement().getChannelTypes()[n];
            StringBuffer stringBuffer = new StringBuffer(32);
            switch (n2) {
                default: {
                    string = Text.Unknown;
                    break;
                }
                case 1: {
                    string = Text.RA;
                    break;
                }
                case 2: {
                    string = Text.RPC;
                    break;
                }
                case 3: {
                    string = Text.Pilot;
                    break;
                }
                case 4: {
                    string = Text.Data;
                    break;
                }
                case 5: {
                    string = Text.Preamble;
                    break;
                }
                case 0: {
                    string = Text.Noise;
                }
            }
            stringBuffer.append(n).append(", ").append(string);
            return stringBuffer.toString();
        }
    };

    public Cdma1xevAnalyzer(boolean bl, CommonCdma1xevMeasurementSettings commonCdma1xevMeasurementSettings) {
        super("Cdma1xevAnalyzer");
        this.measurementSettings = commonCdma1xevMeasurementSettings;
        this.listenToActuator(this.measurementSettings.getReference());
        this.listenToActuator(this.measurementSettings.getScaleDiv());
        this.chartPanel = this.makeCdmaOverAirChartPanel(bl);
        analyzerCard = new JPanel();
        analyzerCard.setBackground(Color.black);
        analyzerCard.setLayout(new BorderLayout(0, 4));
        chartPanelBorder = new BorderWrapper(this.chartPanel, TraceAnalyzer.getChartBorder(), true);
        this.traceChartsPanel = new JPanel();
        analyzerCard.add((Component)this.traceChartsPanel, "Center");
        this.bottomCardLayout = new BorderLayout();
        this.bottomCardPanel = new JPanel(this.bottomCardLayout);
        this.bottomPanel = this.createBottomPanel();
        this.bottomLimitsPanel = this.createBottomLimitsPanel();
        this.bottomLimitsPanel.setVisible(false);
        this.bottomCardPanel.add(this.bottomPanel, "North");
        this.bottomCardPanel.add(this.bottomLimitsPanel, "South");
        analyzerCard.add((Component)this.bottomCardPanel, "South");
        Container container = this.makeCodogramCard();
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setBackground(Color.black);
        this.cardPanel.add((Component)analyzerCard, ANALYZER_CARD);
        this.cardPanel.add((Component)container, CODOGRAM_CARD);
        this.currentCard = ANALYZER_CARD;
        this.createTopNSection();
        this.traceCharts = new TraceChart[]{this.chart, this.spectralChartPanel.getTraceChart(), this.topNChart};
        int n = bl ? 1 : 0;
        this.measurementSettings.setOtaPNScanner(n);
        this.otaPNScannerListener = new OtaPNScannerListener(this, this.measurementSettings);
        this.measurementSettings.getOTAPNScanner().addValueListener(this.otaPNScannerListener);
        this.cdpMetricsListener = new CdpMetricsListener(this, this.measurementSettings);
        this.measurementSettings.getCdpMetrics().addValueListener(this.cdpMetricsListener);
        this.measurementSettings.getOTAPNScanner().fireValueChanged();
        this.measurementSettings.getCdpMetrics().fireValueChanged();
        this.codogramEnabledListener = new CodogramEnabledListener(this);
        this.codogramPaletteListener = new CodogramPaletteListener(this);
        this.measurementSettings.getCodogramEnabled().addValueListener(this.codogramEnabledListener);
        this.codogramEnabledListener.valueChanged(this.measurementSettings.getCodogramEnabled());
        this.measurementSettings.getCodogramPalette().addValueListener(this.codogramPaletteListener);
        this.macCdpXAxisListener = new MacCdpXAxisListener(this);
        this.measurementSettings.getMacCdpXAxis().addValueListener(this.macCdpXAxisListener);
        this.cdpTypeListener = new CdpTypeListener(this);
        this.measurementSettings.getCdpType().addValueListener(this.cdpTypeListener);
        this.limitStateListener = new LimitStateListener(this);
        for (int i = 0; i < 6; ++i) {
            this.measurementSettings.limitsToggleAt(i).addValueListener(this.limitStateListener);
        }
        this.updateCodogramPalette();
        this.updateChartVerticalRange();
    }

    public void dispose() {
        this.measurementSettings.getCodogramEnabled().removeValueListener(this.codogramEnabledListener);
        this.measurementSettings.getCodogramPalette().removeValueListener(this.codogramPaletteListener);
        this.measurementSettings.getMacCdpXAxis().removeValueListener(this.macCdpXAxisListener);
        this.measurementSettings.getCdpType().removeValueListener(this.cdpTypeListener);
        this.measurementSettings.getOTAPNScanner().removeValueListener(this.otaPNScannerListener);
        this.measurementSettings.getCdpMetrics().removeValueListener(this.cdpMetricsListener);
        for (int i = 0; i < 6; ++i) {
            this.measurementSettings.limitsToggleAt(i).removeValueListener(this.limitStateListener);
        }
        this.topNChart.dispose();
        this.chart.dispose();
        this.codogramEnabledListener = null;
        this.codogramPaletteListener = null;
        this.macCdpXAxisListener = null;
        this.cdpTypeListener.dispose();
        this.cdpTypeListener = null;
        this.limitStateListener = null;
        this.otaPNScannerListener.dispose();
        this.otaPNScannerListener = null;
        this.cdpMetricsListener.dispose();
        this.cdpMetricsListener = null;
        this.chart = null;
        this.metrics = null;
        this.spectralChartPanel = null;
        this.traceCharts = null;
        this.topNChart = null;
        this.measurement = null;
        super.dispose();
    }

    private Container makeCodogramCard() {
        JPanel jPanel = new JPanel(new TableLayout(new float[][]{{-1.0f}, {-2.0f, -2.0f}}));
        jPanel.add((Component)this.createMarkerDescriptionLabel(), "0,0");
        jPanel.add((Component)this.createRFInLossLabel(), "0,1");
        jPanel.setBackground(null);
        this.spectralChartPanel = new SpectralChartPanel(new SpectralChart(128), new Cdma1xevChart(this), null, null);
        this.spectralChartPanel.getSpectralChart().setXAxisLinearity(false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.black);
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.spectralChartPanel, "Center");
        return jPanel2;
    }

    private Container makeCdmaOverAirChartPanel(boolean bl) {
        JComponent jComponent;
        ELabel eLabel;
        this.chart = new Cdma1xevChart(this);
        this.chart.setDrawYAxisLabels(true);
        this.chart.setyAxisStrategy(dbStrategy0);
        this.chart.addDLabel(new TraceAnalyzer.AverageDynamicLabel(28, 29, 18), 392, 12);
        JPanel jPanel = new JPanel(new TableLayout(new float[][]{{75.0f, -1.0f, -1.0f}, {-2.0f, -2.0f, -1.0f, -3.0f}}));
        if (bl) {
            eLabel = this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

                protected String formatValue(Measurement measurement) {
                    if (!Cdma1xevAnalyzer.this.isRelative()) {
                        return Text.Ref + " " + dbmStrategy.format(yTop);
                    }
                    return Text.Ref + " " + dbStrategy0.format(yTop);
                }
            });
            jComponent = this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

                protected String formatValue(Measurement measurement) {
                    return dbStrategy0.format(Cdma1xevAnalyzer.this.measurementSettings.getScaleDiv().intValue()) + "/";
                }
            });
            jPanel.add((Component)eLabel, "0,0");
            jPanel.add((Component)jComponent, "0,1");
        }
        eLabel = this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                Cdma1xevMeasurement cdma1xevMeasurement = (Cdma1xevMeasurement)measurement;
                if (Cdma1xevAnalyzer.this.isRelative()) {
                    return Text.Threshold + " " + dbStrategy1.format(cdma1xevMeasurement.getCdpTraceThreshold());
                }
                return Text.Threshold + " " + dbmStrategy.format(cdma1xevMeasurement.getAbsCdpTraceThreshold());
            }
        });
        jPanel.add((Component)eLabel, "1,1");
        jPanel.add((Component)this.createMarkerDescriptionLabel(), "1,0,2,0");
        jPanel.add((Component)this.createRFInLossLabel(), "2,1");
        jPanel.add((Component)this.chart, "0,2,2,2");
        ((Component)jPanel).setBackground(Color.black);
        this.macCdpXAxisLabel = new JLabel();
        this.macCdpXAxisLabel.setForeground(TraceAnalyzer.VALUE_COLOR);
        this.macCdpXAxisLabel.setFont(TraceAnalyzer.VALUE_FONT);
        this.setMacCdpXAxisLabel();
        jPanel.add((Component)this.macCdpXAxisLabel, "1,3,R,R");
        this.cdpPlotLabel = new JLabel();
        this.cdpPlotLabel.setForeground(Color.red);
        this.cdpPlotLabel.setFont(TraceAnalyzer.VALUE_FONT);
        this.setCdpPlotLabel();
        jComponent = new JPanel(new BorderLayout(0, 0));
        jComponent.add((Component)this.cdpPlotLabel, "North");
        jComponent.add((Component)jPanel, "Center");
        return jComponent;
    }

    private ELabel createMarkerDescriptionLabel() {
        return this.addLabel(new DynamicLabel("marker", 4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return Cdma1xevAnalyzer.this.getCurrentMarkerDescription();
            }
        });
    }

    private ELabel createRFInLossLabel() {
        return this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return Text.RF_IN_Loss + " " + rfInStrategy.format(Cdma1xevAnalyzer.this.measurementSettings.getRfInLoss().longValue());
            }
        });
    }

    protected TraceChart[] getCharts() {
        return this.traceCharts;
    }

    private Component createBottomPanel() {
        this.metrics = new Cdma1xevMetricsTable(this);
        BorderWrapper borderWrapper = new BorderWrapper(this.metrics, MeasurementMetrics.BORDER, true);
        return borderWrapper;
    }

    private Component createBottomLimitsPanel() {
        JPanel jPanel = new JPanel();
        this.passFailLabel = new JLabel();
        jPanel.add(this.passFailLabel);
        return new BorderWrapper(jPanel, MeasurementMetrics.BORDER, true);
    }

    public void swapBottomPanel(boolean bl) {
        this.bottomLimitsPanel.setVisible(bl);
    }

    protected void setPassFailLabel() {
        if (this.areAllWithinLimits()) {
            this.passFailLabel.setForeground(MeasurementMetrics.DARK_GREEN);
            this.passFailLabel.setText("ALL PASS");
        } else {
            this.passFailLabel.setForeground(Color.red);
            this.passFailLabel.setText("FAILURE");
        }
    }

    protected void setMacCdpXAxisLabel() {
        if ((this.measurementSettings.getCdpType().intValue() == 1 || this.measurementSettings.getCdpType().intValue() == 0) && this.measurementSettings.getMacCdpXAxis().intValue() == 0) {
            this.macCdpXAxisLabel.setText("MAC Index");
        } else {
            this.macCdpXAxisLabel.setText("Walsh Code");
        }
    }

    protected void setCdpPlotLabel() {
        switch (this.measurementSettings.getCdpType().intValue()) {
            case 0: 
            case 1: {
                this.cdpPlotLabel.setText("MAC Code Domain");
                break;
            }
            case 2: {
                this.cdpPlotLabel.setText("Pilot Code Domain");
                break;
            }
            default: {
                this.cdpPlotLabel.setText("Data Code Domain");
            }
        }
    }

    public int getChannelWidth() {
        return this.measurementSettings.channelWidth;
    }

    public void setChannelWidth() {
        switch (this.measurementSettings.getCdpType().intValue()) {
            case 0: {
                this.measurementSettings.channelWidth = 1;
                break;
            }
            case 1: {
                this.measurementSettings.channelWidth = 2;
                break;
            }
            case 2: {
                this.measurementSettings.channelWidth = 4;
                break;
            }
            default: {
                this.measurementSettings.channelWidth = 8;
            }
        }
    }

    public boolean isRelative() {
        return this.measurementSettings.getReference().intValue() == 0;
    }

    public void updateChartVerticalRange() {
        if (this.measurement == null | this.isRelative()) {
            yTop = 0;
            this.chart.setyAxisStrategy(dbStrategy1);
        } else {
            yTop = this.measurement.getCdpReferencePower();
            this.chart.setyAxisStrategy(dbmStrategy);
        }
        yBottom = yTop - this.measurementSettings.getScaleDiv().intValue() * 10;
        this.chart.setVerticalRange(yTop, yBottom);
        this.chart.setReference(this.isRelative());
        if (!this.isRelative() & this.measurement != null) {
            this.spectralChartPanel.setVerticalLegendOffset(this.measurement.getCdpReferencePower(), dbmStrategy);
        } else {
            this.spectralChartPanel.setVerticalLegendOffset(0, dbStrategy1);
        }
        this.spectralChartPanel.setVerticalRange(0, -this.measurementSettings.getScaleDiv().intValue() * 10);
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected void setMeasurement(Measurement measurement) {
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        this.measurement = (Cdma1xevMeasurement)measurement;
    }

    protected void updateChartMeasurements() {
        boolean bl;
        super.updateChartMeasurements();
        long l = this.measurementSettings.getCodogramCaptureInterval().longValue() * 1000L;
        long l2 = System.currentTimeMillis();
        if (l == 0L) {
            bl = true;
        } else {
            long l3 = this.lastcodogramTraceCapturedAt;
            if (l3 <= 0L) {
                bl = true;
            } else {
                boolean bl2 = bl = l2 >= l3 + l;
            }
        }
        if (bl) {
            this.lastcodogramTraceCapturedAt = l2;
            int[] nArray = new int[128];
            int[] nArray2 = new int[128];
            int n = this.getNumberOfBars();
            int n2 = 0;
            for (int i = 0; i < n && n2 < nArray.length; ++i) {
                int n3 = this.getChannelWidth();
                int n4 = this.measurement.getChannelLevels()[i];
                int n5 = this.measurement.getAbsBarPower(i);
                int n6 = n2 + n3;
                if (n6 > nArray.length) break;
                while (n2 < n6) {
                    nArray[n2] = n4;
                    nArray2[n2] = n5;
                    ++n2;
                }
            }
            this.spectralChartPanel.addTrace(nArray, nArray2, this.measurement.getCdpReferencePower());
            this.updateChartVerticalRange();
        }
    }

    protected void doUpdateChartMarkers() {
        super.doUpdateChartMarkers();
        this.spectralChartPanel.getSpectralChart().setMarkers(this.getMarkerButtonFactory().getMarkers());
    }

    private void updateCodogramPalette() {
        SpectralChart.PaletteMaker[] paletteMakerArray = SpectralChart.getAllPalettes();
        int n = this.measurementSettings.getCodogramPalette().intValue();
        this.spectralChartPanel.getSpectralChart().setPalette(paletteMakerArray[n].createPalette());
    }

    public void clearCodogramHistory() {
        this.spectralChartPanel.clearSpectrogramHistory();
    }

    protected Component getPane() {
        return this.cardPanel;
    }

    protected TraceChart getChart() {
        return this.chart;
    }

    protected Color getDataBackgroundColor() {
        return MenuPanel.BG_COLOR;
    }

    public MeasurementMetrics getMeasurementMetrics() {
        return this.metrics;
    }

    Container getMainPane() {
        return analyzerCard;
    }

    public TabDelimitable[] createReadingFields() {
        TabDelimitable[] tabDelimitableArray;
        block12: {
            int n;
            int n2;
            int n3;
            TabDelimitable[] tabDelimitableArray2;
            ReadingField[] readingFieldArray;
            block11: {
                String string;
                int n4;
                String string2;
                String string3;
                int n5;
                Cdma1xevMeasurementSettings cdma1xevMeasurementSettings = Cdma1xevMeasurementSettings.instance();
                boolean bl = cdma1xevMeasurementSettings.getOTAPNScanner().booleanValue();
                readingFieldArray = null;
                int n6 = this.getNumberOfBars();
                int n7 = 0;
                int n8 = 0;
                tabDelimitableArray2 = this.metrics.getTabDelimitables();
                n3 = tabDelimitableArray2.length;
                n2 = 0;
                if (bl) {
                    readingFieldArray = this.createOtaReadingFields();
                    n2 = readingFieldArray.length;
                }
                if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() != 1) break block11;
                n7 = 5;
                if (bl) {
                    n2 += 13;
                }
                tabDelimitableArray = new TabDelimitable[n3 + n6 + n7 + n2];
                for (n5 = 0; n5 < n3; ++n5) {
                    tabDelimitableArray[n8++] = tabDelimitableArray2[n5];
                }
                if (bl) {
                    for (n5 = 0; n5 < readingFieldArray.length; ++n5) {
                        tabDelimitableArray[n8++] = readingFieldArray[n5];
                    }
                }
                n5 = cdma1xevMeasurementSettings.getReference().intValue() == 0 ? 1 : 0;
                int n9 = n5 != 0 ? this.measurement.getIntegerReadingValue(17) : this.measurement.getAbsCdpTraceThreshold();
                float f = this.convertPowerToFloat(n9);
                if (n5 != 0) {
                    string3 = "Channel Power (dB)";
                    string2 = "dB";
                } else {
                    string3 = "Channel Power (dBm)";
                    string2 = "dBm";
                }
                tabDelimitableArray[n8++] = new TraceSaveTabDelimitable("");
                tabDelimitableArray[n8++] = new TraceSaveTabDelimitable("Trace Data");
                tabDelimitableArray[n8++] = new TraceSaveTabDelimitable("Bar Count\t" + String.valueOf(n6));
                tabDelimitableArray[n8++] = new TraceSaveTabDelimitable("CDP Power Threshold\t" + String.valueOf(f) + '\t' + string2);
                tabDelimitableArray[n8++] = new TraceSaveTabDelimitable("Bar #\tChannel Number\t" + string3 + "\tChannel Type");
                int[] nArray = this.measurement.getChannelTypes();
                int[] nArray2 = this.measurement.getChannelNumbers();
                for (n4 = 0; n4 < n6; ++n4) {
                    int n10 = n5 != 0 ? this.measurement.getRelBarPower(n4) : this.measurement.getAbsBarPower(n4);
                    float f2 = this.convertPowerToFloat(n10);
                    string = String.valueOf(n4 + 1) + '\t' + String.valueOf(nArray2[n4]) + '\t' + String.valueOf(f2) + '\t' + channelTypeNames[nArray[n4]];
                    tabDelimitableArray[n8++] = new TraceSaveTabDelimitable(string);
                }
                if (!bl) break block12;
                tabDelimitableArray[n8++] = new TraceSaveTabDelimitable("");
                tabDelimitableArray[n8++] = new TraceSaveTabDelimitable("PN Offsets (Top 10)");
                tabDelimitableArray[n8++] = new TraceSaveTabDelimitable("Bar #\tPN Offset\tRelative Powers (dB)");
                for (n4 = 0; n4 < 10; ++n4) {
                    int[] nArray3 = this.measurement.getTopPnOffsets();
                    int[] nArray4 = this.measurement.getTopNPilotsValues();
                    string = String.valueOf(n4 + 1) + '\t' + String.valueOf(nArray3[n4]) + '\t' + this.dbStrategyTraceSave.format(nArray4[n4]);
                    tabDelimitableArray[n8++] = new TraceSaveTabDelimitable(string);
                }
                break block12;
            }
            tabDelimitableArray = new TabDelimitable[n3 + n2];
            for (n = 0; n < n3; ++n) {
                tabDelimitableArray[n8++] = tabDelimitableArray2[n];
            }
            for (n = 0; n < n2; ++n) {
                tabDelimitableArray[n8++] = readingFieldArray[n];
            }
        }
        return tabDelimitableArray;
    }

    private ReadingField[] createOtaReadingFields() {
        return new ReadingField[]{new IntegerReadingField(this, Text.Pilot_Dominance, "dB", 37, 1000.0, 1), new IntegerReadingField(this, Text.Multipath_Power, "dB", 38, 1000.0, 1)};
    }

    public NumberFieldStrategy getYAxisNormalStrategy() {
        return this.isRelative() ? dbStrategy1 : dbmStrategy;
    }

    public NumberFieldStrategy getYAxisDeltaStrategy() {
        return dbStrategy1;
    }

    private Cdma1xevMeasurement getCdma1xevMeasurement() {
        return (Cdma1xevMeasurement)this.getMeasurement();
    }

    public NumberFieldStrategy getXAxisStrategy() {
        return this.channelStrategy;
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        if (this.currentCard == CODOGRAM_CARD) {
            GrayScaleColorFlipFilter grayScaleColorFlipFilter = new GrayScaleColorFlipFilter(rectangle, true, false);
            return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), grayScaleColorFlipFilter));
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle = this.traceChartsPanel.getBounds();
        rectangle.x += n;
        rectangle.y += n2;
        return super.filterPrintImage(image, rectangle);
    }

    public boolean isLimitOn(int n) {
        return this.measurementSettings.limitsToggleAt(n).getSelectedValue().longValue() == 1L;
    }

    public boolean areAllWithinLimits() {
        if (this.isLimitOn(0) && !this.isFreqErrorWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(1) && !this.isTimeOffsetWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(2) && !this.isOnOffPwrRatioWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(3) && !this.isPilotRhoWithinLimits()) {
            return false;
        }
        if (this.isLimitOn(4) && !this.isMacRhoWithinLimits()) {
            return false;
        }
        return !this.isLimitOn(5) || this.isMaxInactiveChWithinLimits();
    }

    public boolean isFreqErrorWithinLimits() {
        int n = this.measurement.getFreqError() / 1000;
        return this.measurementSettings.getFreqErrorUpperLimit().longValue() >= (long)n && (long)n >= this.measurementSettings.getFreqErrorLowerLimit().longValue();
    }

    public boolean isTimeOffsetWithinLimits() {
        long l = UIHelper.chipsToNanoseconds(this.measurement.getPilotDelay());
        return this.measurementSettings.getTimeOffsetUpperLimit().longValue() >= l && l >= this.measurementSettings.getTimeOffsetLowerLimit().longValue();
    }

    public boolean isPilotRhoWithinLimits() {
        return 1000 >= this.measurement.getPilotRho() && (long)this.measurement.getPilotRho() >= this.measurementSettings.getPilotRhoLowerLimit().longValue() / 100L;
    }

    public boolean isMacRhoWithinLimits() {
        return 1000 >= this.measurement.getMacRho() && (long)this.measurement.getMacRho() >= this.measurementSettings.getMacRhoLowerLimit().longValue() / 100L;
    }

    public boolean isOnOffPwrRatioWithinLimits() {
        return (long)this.measurement.getOnOffRatio() >= this.measurementSettings.getIdleOnOffPowerRatioLowerLimit().longValue();
    }

    public boolean isMaxInactiveChWithinLimits() {
        long l = this.measurement.getCdpType() == 2 ? this.measurementSettings.getMaxInactivePilotHighLimit().longValue() : this.measurementSettings.getMaxInactiveMACHighLimit().longValue();
        return (long)this.measurement.getMaxInactive() <= l;
    }

    public static int getChannelType(String string) {
        int n = -1;
        for (int i = 0; i < channelTypeNames.length; ++i) {
            if (!channelTypeNames[i].equals(string)) continue;
            n = i;
        }
        return n;
    }

    public long getViewStopValue() {
        return this.getNumberOfBars() - 1;
    }

    protected int getNumberOfBars() {
        return this.measurementSettings.getNumberOfBars();
    }

    private void createTopNSection() {
        this.topNChart = new Cdma1xevTopNChart(this);
        this.cdma1xevTopNPanel = new Cdma1xevTopNPanel(this.topNChart, this, false);
        topNChartBorder = new BorderWrapper(this.cdma1xevTopNPanel, Resources.getResources("elgato.measurement.cdma1xev.topn").getBorderConfig("border"), true);
    }

    private class Cdma1xevTopNPanel
    extends TopNPanel {
        Cdma1xevTopNPanel(TopNChart topNChart, TraceAnalyzer traceAnalyzer, boolean bl) {
            super(topNChart, traceAnalyzer, bl);
        }

        public int getPilotDominance(Measurement measurement) {
            return ((Cdma1xevMeasurement)measurement).getPilotDominance();
        }

        public boolean isPilotDominanceAboveLimit(Measurement measurement) {
            return ((Cdma1xevMeasurement)measurement).isPilotDominanceAboveLimit();
        }

        public int getMultipathPower(Measurement measurement) {
            return ((Cdma1xevMeasurement)measurement).getMultipathPower();
        }

        public boolean isMultipathPowerBelowLimit(Measurement measurement) {
            return ((Cdma1xevMeasurement)measurement).isMultipathPowerBelowLimit();
        }
    }

    private class CdpMetricsListener
    implements ValueListener {
        private String listenerName = ".cdpMetricsListener";
        private String baseName = null;
        private Cdma1xevAnalyzer analyzer;
        private CommonCdma1xevMeasurementSettings measurementSettings;

        public CdpMetricsListener(Cdma1xevAnalyzer cdma1xevAnalyzer2, CommonCdma1xevMeasurementSettings commonCdma1xevMeasurementSettings) {
            this.analyzer = cdma1xevAnalyzer2;
            this.measurementSettings = commonCdma1xevMeasurementSettings;
        }

        public void dispose() {
            this.analyzer = null;
            this.measurementSettings = null;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            Cdma1xevAnalyzer.this.traceChartsPanel.removeAll();
            if (this.measurementSettings.getOTAPNScanner().booleanValue()) {
                if (!valueInterface.booleanValue()) {
                    Cdma1xevAnalyzer.this.traceChartsPanel.setLayout(new BorderLayout());
                    Cdma1xevAnalyzer.this.traceChartsPanel.add((Component)topNChartBorder, "Center");
                } else {
                    Cdma1xevAnalyzer.this.traceChartsPanel.setLayout(new TableLayout(new float[][]{{-1.0f}, {-2.0f, -1.0f}}));
                    topNChartBorder.setPreferredSize(new Dimension(Cdma1xevAnalyzer.this.traceChartsPanel.getWidth(), 93));
                    Cdma1xevAnalyzer.this.traceChartsPanel.add((Component)chartPanelBorder, "0,1");
                    Cdma1xevAnalyzer.this.traceChartsPanel.add((Component)topNChartBorder, "0,0");
                }
            } else {
                Cdma1xevAnalyzer.this.traceChartsPanel.setLayout(new BorderLayout());
                Cdma1xevAnalyzer.this.traceChartsPanel.add((Component)chartPanelBorder, "Center");
            }
            Cdma1xevAnalyzer.this.traceChartsPanel.doLayout();
            Cdma1xevAnalyzer.this.traceChartsPanel.validate();
            Cdma1xevAnalyzer.this.traceChartsPanel.repaint();
            this.analyzer.validate();
            this.analyzer.repaint();
        }
    }

    private class OtaPNScannerListener
    implements ValueListener {
        private String listenerName = ".otaPNScannerListener";
        private String baseName = null;
        private Cdma1xevAnalyzer analyzer;
        private CommonCdma1xevMeasurementSettings measurementSettings;

        public OtaPNScannerListener(Cdma1xevAnalyzer cdma1xevAnalyzer2, CommonCdma1xevMeasurementSettings commonCdma1xevMeasurementSettings) {
            this.analyzer = cdma1xevAnalyzer2;
            this.measurementSettings = commonCdma1xevMeasurementSettings;
        }

        public void dispose() {
            this.analyzer = null;
            this.measurementSettings = null;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            Cdma1xevAnalyzer.this.traceChartsPanel.removeAll();
            if (valueInterface.booleanValue()) {
                if (!this.measurementSettings.getCdpMetrics().booleanValue()) {
                    Cdma1xevAnalyzer.this.traceChartsPanel.setLayout(new BorderLayout());
                    Cdma1xevAnalyzer.this.traceChartsPanel.add((Component)topNChartBorder, "Center");
                } else {
                    Cdma1xevAnalyzer.this.traceChartsPanel.setLayout(new TableLayout(new float[][]{{-1.0f}, {-2.0f, -1.0f}}));
                    topNChartBorder.setPreferredSize(new Dimension(Cdma1xevAnalyzer.this.traceChartsPanel.getWidth(), 93));
                    Cdma1xevAnalyzer.this.traceChartsPanel.add((Component)topNChartBorder, "0,0");
                    Cdma1xevAnalyzer.this.traceChartsPanel.add((Component)chartPanelBorder, "0,1");
                }
            } else {
                if (!this.measurementSettings.getCdpMetrics().booleanValue()) {
                    this.measurementSettings.setCdpMetrics(1);
                }
                Cdma1xevAnalyzer.this.traceChartsPanel.setLayout(new BorderLayout());
                Cdma1xevAnalyzer.this.traceChartsPanel.add((Component)chartPanelBorder, "Center");
            }
            Cdma1xevAnalyzer.this.traceChartsPanel.doLayout();
            Cdma1xevAnalyzer.this.traceChartsPanel.validate();
            Cdma1xevAnalyzer.this.traceChartsPanel.repaint();
            this.analyzer.validate();
            this.analyzer.repaint();
        }
    }

    private static class CdpTypeListener
    implements ValueListener {
        private String listenerName = ".cdpTypeListener";
        private String baseName = null;
        private Cdma1xevAnalyzer analyzer;

        public CdpTypeListener(Cdma1xevAnalyzer cdma1xevAnalyzer) {
            this.analyzer = cdma1xevAnalyzer;
        }

        public void dispose() {
            this.analyzer = null;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.analyzer.setChannelWidth();
            this.analyzer.getNumberOfBars();
            this.analyzer.setCdpPlotLabel();
            this.analyzer.setMacCdpXAxisLabel();
            this.analyzer.clearCodogramHistory();
        }
    }

    private static class MacCdpXAxisListener
    implements ValueListener {
        private String listenerName = ".macCdpXAxisListener";
        private String baseName = null;
        private Cdma1xevAnalyzer analyzer;

        public MacCdpXAxisListener(Cdma1xevAnalyzer cdma1xevAnalyzer) {
            this.analyzer = cdma1xevAnalyzer;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.analyzer.setMacCdpXAxisLabel();
            this.analyzer.clearCodogramHistory();
        }
    }

    private static class CodogramPaletteListener
    implements ValueListener {
        private String listenerName = ".codogramPaletteListener";
        private String baseName = null;
        private Cdma1xevAnalyzer analyzer;

        public CodogramPaletteListener(Cdma1xevAnalyzer cdma1xevAnalyzer) {
            this.analyzer = cdma1xevAnalyzer;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.analyzer.updateCodogramPalette();
        }
    }

    private static class CodogramEnabledListener
    implements ValueListener {
        private String listenerName = ".codogramEnabledListener";
        private String baseName = null;
        private Cdma1xevAnalyzer analyzer;

        public CodogramEnabledListener(Cdma1xevAnalyzer cdma1xevAnalyzer) {
            this.analyzer = cdma1xevAnalyzer;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            if (valueInterface.booleanValue()) {
                this.analyzer.currentCard = Cdma1xevAnalyzer.CODOGRAM_CARD;
            } else {
                this.analyzer.currentCard = Cdma1xevAnalyzer.ANALYZER_CARD;
            }
            this.analyzer.cardLayout.show(this.analyzer.cardPanel, this.analyzer.currentCard);
        }
    }

    private static class LimitStateListener
    implements ValueListener {
        private String listenerName = ".limitsSummaryListener";
        private String baseName = null;
        private Cdma1xevAnalyzer analyzer;

        public LimitStateListener(Cdma1xevAnalyzer cdma1xevAnalyzer) {
            this.analyzer = cdma1xevAnalyzer;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.analyzer.swapBottomPanel(this.analyzer.measurementSettings.getLimitsSummaryState());
        }
    }
}

