/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma1xev;

import elgato.infrastructure.analyzer.BarChart;
import elgato.infrastructure.marker.Marker;
import elgato.measurement.cdma1xev.Cdma1xevAnalyzer;
import elgato.measurement.cdma1xev.Cdma1xevMeasurement;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

final class Cdma1xevChart
extends BarChart {
    private static final int SLOT_COUNT = 128;
    int slot_spacing = 1;
    boolean relative = true;
    private final Font walshFont = new Font("SansSerif", 0, 9);
    private int[] xPts = new int[128];
    private int[] yPts = new int[128];
    private Cdma1xevAnalyzer analyzer;
    private static final Color DARK_BLUE = new Color(0, 0, 228);
    private static final Color LIGHT_BLUE = new Color(120, 120, 255);
    private static final Color DARK_ORANGE = new Color(255, 140, 0);

    public Cdma1xevChart(Cdma1xevAnalyzer cdma1xevAnalyzer) {
        this.analyzer = cdma1xevAnalyzer;
    }

    public void dispose() {
        this.analyzer = null;
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        Cdma1xevMeasurement cdma1xevMeasurement = (Cdma1xevMeasurement)this.getMeasurement();
        int n6 = this.analyzer.getNumberOfBars();
        if (n6 != cdma1xevMeasurement.getNumberOfBars()) {
            n6 = 0;
        }
        int[] nArray = cdma1xevMeasurement.getChannelTypes();
        int n7 = this.analyzer.getChannelWidth();
        int[] nArray2 = cdma1xevMeasurement.getChannelNumbers();
        int n8 = this.getUnitBarWidth();
        int n9 = this.getYTop();
        int n10 = this.getYBottom() - n9;
        if (n4 == 0 || n10 == 0) {
            return;
        }
        if (n3 <= 130) {
            this.slot_spacing = 0;
        }
        int n11 = n;
        for (n5 = 0; n5 < n6; ++n5) {
            int n12 = this.relative ? cdma1xevMeasurement.getRelBarPower(n5) : cdma1xevMeasurement.getAbsBarPower(n5);
            int n13 = (n12 - n9) * n4 / n10;
            int n14 = n7 * n8 + (n7 - 1) * this.slot_spacing;
            int n15 = nArray[n5];
            Color color = Cdma1xevChart.colorForChanType(cdma1xevMeasurement.getMacCdpXAxis() == 0, n5, n15);
            graphics.setColor(color);
            graphics.fillRect(n11, n2 + n13, n14, n4 - n13);
            this.xPts[n5] = n11 + (n14 >> 1);
            this.yPts[n5] = n2 + n13;
            if (n3 > 130 & n15 != 0) {
                this.drawWalshCode(graphics, n5, n11, n2, n4, n14, Integer.toString(nArray2[n5]));
            }
            n11 += n14 + this.slot_spacing;
        }
        n5 = this.relative ? cdma1xevMeasurement.getRelCdpTraceThreshold() : cdma1xevMeasurement.getAbsCdpTraceThreshold();
        this.drawThresholdLine(graphics, n5, n, n2, n3, n4);
        this.drawMarkers(graphics);
    }

    private void drawMarkers(Graphics graphics) {
        Marker[] markerArray = this.getMarkers();
        if (markerArray == null) {
            return;
        }
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i].paint(this, graphics, this.xPts, this.yPts);
        }
    }

    protected Font getXAxisFont() {
        return this.walshFont;
    }

    protected int getXAxisRows() {
        return 3;
    }

    protected int getSlotCount() {
        return 128;
    }

    protected int getSlotSpacing() {
        return this.slot_spacing;
    }

    public void setReference(boolean bl) {
        this.relative = bl;
    }

    private static Color colorForChanType(boolean bl, int n, int n2) {
        Color color = BarChart.UNKNOWN_COLOR;
        switch (n2) {
            case 1: {
                color = LIGHT_BLUE;
                break;
            }
            case 2: {
                color = DARK_ORANGE;
                break;
            }
            case 3: {
                color = Color.red;
                break;
            }
            case 4: {
                color = Color.green;
                break;
            }
            case 5: {
                color = DARK_BLUE;
                break;
            }
            case 0: {
                color = BarChart.NOISE_COLOR;
                break;
            }
            default: {
                return BarChart.UNKNOWN_COLOR;
            }
        }
        return color;
    }

    protected void showLimits(Graphics graphics, int n, int n2) {
        this.analyzer.setPassFailLabel();
    }
}

