/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma1xev;

import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.peakSearch.DiscretePeakFinder;
import elgato.infrastructure.peakSearch.PeakFinder;
import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.LongReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.measurement.cdma1xev.Cdma1xevAnalyzer;
import elgato.measurement.cdma1xev.Cdma1xevMeasurementSettings;
import elgato.measurement.cdma1xev.Cdma1xevUnpacker;
import java.io.DataInput;
import java.io.IOException;

public class Cdma1xevMeasurement
extends TraceMeasurement {
    private static final long serialVersionUID = -8610619437180698168L;
    private static boolean VERIFY = "true".equals(System.getProperty("Cdma1xevMeasurement.verify"));
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$cdma1xev$Cdma1xevMeasurement == null ? (class$elgato$measurement$cdma1xev$Cdma1xevMeasurement = Cdma1xevMeasurement.class$("elgato.measurement.cdma1xev.Cdma1xevMeasurement")) : class$elgato$measurement$cdma1xev$Cdma1xevMeasurement);
    private static final Queue pool = new Queue(3);
    public static final int MAX_CHANNELS = 128;
    public static final int CHANNEL_TYPE_NOISE = 0;
    public static final int CHANNEL_TYPE_MAC_RA = 1;
    public static final int CHANNEL_TYPE_MAC_RPC = 2;
    public static final int CHANNEL_TYPE_PILOT = 3;
    public static final int CHANNEL_TYPE_DATA = 4;
    public static final int CHANNEL_TYPE_PREAMBLE = 5;
    public static final int CHANNEL_TYPE_UNKNOWN = 6;
    public static final int MOD_TYPE_UNKNOWN = -1;
    public static final int MOD_TYPE_QPSK = 0;
    public static final int MOD_TYPE_8PSK = 1;
    public static final int MOD_TYPE_16QAM = 2;
    protected IntegerReading pnOffset = new IntegerReading();
    protected IntegerReading freqError = new IntegerReading();
    protected IntegerReading cdpReferencePower = new IntegerReading();
    protected IntegerReading pilotDelay = new IntegerReading();
    protected IntegerReading nonIdlePower = new IntegerReading();
    protected IntegerReading pilotMacPower = new IntegerReading();
    protected IntegerReading onOffRatio = new IntegerReading();
    protected IntegerReading idleDataPower = new IntegerReading();
    protected IntegerReading idleSlots = new IntegerReading();
    protected IntegerReading pilotRho = new IntegerReading();
    protected IntegerReading macRho = new IntegerReading();
    protected IntegerReading maxInactive = new IntegerReading();
    protected IntegerReading noiseFloor = new IntegerReading();
    protected IntegerReading modType = new IntegerReading();
    protected IntegerArrayReading channelTypes = new IntegerArrayReading(128);
    protected IntegerArrayReading channelNumbers = new IntegerArrayReading(128);
    protected IntegerArrayReading channelLevels = new IntegerArrayReading(128);
    protected IntegerReading cdpTraceThreshold = new IntegerReading();
    protected IntegerReading averageCount = new IntegerReading();
    private IntegerArrayReading topNPnOffsets = new IntegerArrayReading(10);
    private IntegerArrayReading topNPilots = new IntegerArrayReading(10);
    private IntegerReading pilotDominance = new IntegerReading();
    private IntegerReading multipathPower = new IntegerReading();
    protected BooleanReading cdpValid = new BooleanReading();
    protected LongReading centerFreq = new LongReading();
    protected IntegerReading pnIncrement = new IntegerReading();
    protected IntegerReading pnOffsetActuator = new IntegerReading();
    protected BooleanReading autoPnOffset = new BooleanReading();
    protected IntegerReading thresholdOffset = new IntegerReading();
    protected IntegerReading thresholdSetting = new IntegerReading();
    protected BooleanReading autoThreshold = new BooleanReading();
    protected IntegerReading measurementLoss = new IntegerReading();
    protected IntegerReading measurementTime = new IntegerReading();
    protected BooleanReading averagingState = new BooleanReading();
    protected IntegerReading numAverages = new IntegerReading();
    protected IntegerReading slotThreshold = new IntegerReading();
    protected IntegerReading cdpType = new IntegerReading();
    protected IntegerReading macCdpXAxis = new IntegerReading();
    protected IntegerReading measurementOffset = new IntegerReading();
    protected IntegerReading cdpMetrics = new IntegerReading();
    protected IntegerReading pilotDominanceThreshold = new IntegerReading();
    protected IntegerReading multipathPowerThreshold = new IntegerReading();
    protected IntegerReading pnScanner = new IntegerReading();
    protected IntegerReading pnScannerSensitivity = new IntegerReading();
    public static final int PN_OFFSET = 0;
    public static final int FREQ_ERROR = 1;
    public static final int CHANNEL_POWER = 2;
    public static final int PILOT_DELAY = 3;
    public static final int NON_IDLE_PWR = 4;
    public static final int PILOT_MAC_PWR = 5;
    public static final int ON_OFF_RATIO = 6;
    public static final int IDLE_DATA_PWR = 7;
    public static final int IDLE_SLOTS = 8;
    public static final int PILOT_RHO = 9;
    public static final int MAC_RHO = 10;
    public static final int MAX_INACTIVE = 11;
    public static final int NOISE_FLOOR = 12;
    public static final int MOD_TYPE = 13;
    public static final int CHANNEL_TYPES = 14;
    public static final int CHANNEL_NUMBERS = 15;
    public static final int CHANNEL_LEVELS = 16;
    public static final int CDP_TRACE_THRESHOLD = 17;
    public static final int AVERAGE_COUNT = 18;
    public static final int CENTER_FREQ = 19;
    public static final int PN_INCREMENT = 20;
    public static final int PN_OFFSET_ACTUATOR = 21;
    public static final int AUTO_PN_OFFSET = 22;
    public static final int THRESHOLD_OFFSET = 23;
    public static final int THRESHOLD_SETTING = 24;
    public static final int AUTO_THRESHOLD = 25;
    public static final int MEASUREMENT_LOSS = 26;
    public static final int MEASUREMENT_TIME = 27;
    public static final int AVERAGING_STATE = 28;
    public static final int NUM_AVERAGES = 29;
    public static final int SLOT_THRESHOLD_SETTING = 30;
    public static final int CDP_TYPE = 31;
    public static final int MAC_CDP_X_AXIS = 32;
    public static final int MEASUREMENT_OFFSET = 33;
    public static final int CDP_METRICS = 34;
    public static final int TOPN_PN_OFFSET_ARRAY = 35;
    public static final int TOPN_PILOT_ARRAY = 36;
    public static final int PILOT_DOMINANCE = 37;
    public static final int MULTIPATH_PWR = 38;
    public static final int PILOT_POWER_THREHOLD = 39;
    public static final int MULTIPATH_POWER_THRESHOLD = 40;
    public static final int PN_SCANNER = 41;
    public static final int PN_SCANNER_SENSITIVITY = 42;
    public static final int CDP_VALID = 43;
    private Reading[] readings = this.createReadings();
    static /* synthetic */ Class class$elgato$measurement$cdma1xev$Cdma1xevMeasurement;

    public static Cdma1xevMeasurement unpack(DataInput dataInput) throws IOException {
        Cdma1xevUnpacker cdma1xevUnpacker = Cdma1xevUnpacker.instance();
        Cdma1xevMeasurement cdma1xevMeasurement = Cdma1xevMeasurement.create();
        cdma1xevMeasurement = cdma1xevUnpacker.unpackMeasurement(cdma1xevMeasurement, dataInput);
        if (VERIFY) {
            cdma1xevMeasurement.verify();
        }
        return cdma1xevMeasurement;
    }

    static Cdma1xevMeasurement create() {
        Cdma1xevMeasurement cdma1xevMeasurement = (Cdma1xevMeasurement)pool.dequeue();
        if (cdma1xevMeasurement == null) {
            return new Cdma1xevMeasurement();
        }
        return cdma1xevMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int getPnOffset() {
        return this.pnOffset.intValue();
    }

    public int getFreqError() {
        return this.freqError.intValue();
    }

    public int getCdpReferencePower() {
        return this.cdpReferencePower.intValue();
    }

    public int getPilotDelay() {
        return this.pilotDelay.intValue();
    }

    public String getModType() {
        String string;
        switch (this.modType.intValue()) {
            case 0: {
                string = Text.QPSK;
                break;
            }
            case 1: {
                string = Text._8PSK;
                break;
            }
            case 2: {
                string = Text._16QAM;
                break;
            }
            default: {
                string = Text.Unknown;
            }
        }
        return string;
    }

    public int getNonIdlePower() {
        return this.nonIdlePower.intValue();
    }

    public int getPilotMacPower() {
        return this.pilotMacPower.intValue();
    }

    public int getOnOffRatio() {
        return this.onOffRatio.intValue();
    }

    public int getIdleDataPower() {
        return this.idleDataPower.intValue();
    }

    public int getIdleSlots() {
        return this.idleSlots.intValue();
    }

    public int getPilotRho() {
        return this.pilotRho.intValue();
    }

    public int getMacRho() {
        return this.macRho.intValue();
    }

    public int getMaxInactive() {
        return this.maxInactive.intValue();
    }

    public int getNoiseFloor() {
        return this.noiseFloor.intValue();
    }

    public int[] getChannelTypes() {
        return this.channelTypes.getTrace();
    }

    public int[] getChannelNumbers() {
        return this.channelNumbers.getTrace();
    }

    public int[] getChannelLevels() {
        return this.channelLevels.getTrace();
    }

    public int getCdpTraceThreshold() {
        return this.cdpTraceThreshold.intValue();
    }

    public int getAverageCount() {
        return this.averageCount.intValue();
    }

    public long getCenterFreq() {
        return this.centerFreq.longValue();
    }

    public int getPnIncrement() {
        return this.pnIncrement.intValue();
    }

    public int getPnOffsetActuator() {
        return this.pnOffsetActuator.intValue();
    }

    public boolean isAutoPnOffset() {
        return this.autoPnOffset.booleanValue();
    }

    public int getThresholdOffset() {
        return this.thresholdOffset.intValue();
    }

    public int getThresholdSetting() {
        return this.thresholdSetting.intValue();
    }

    public int getMeasurementLoss() {
        return this.measurementLoss.intValue();
    }

    public int getMeasurementTime() {
        return this.measurementTime.intValue();
    }

    public boolean isAveragingState() {
        return this.averagingState.booleanValue();
    }

    public int getNumAverages() {
        return this.numAverages.intValue();
    }

    public int getSlotThreshold() {
        return this.slotThreshold.intValue();
    }

    public int getCdpType() {
        return this.cdpType.intValue();
    }

    public int getMacCdpXAxis() {
        return this.macCdpXAxis.intValue();
    }

    public int getMeasOffset() {
        return this.measurementOffset.intValue();
    }

    public boolean getCdpMetrics() {
        return this.cdpMetrics.intValue() == 1;
    }

    boolean verify() {
        return true;
    }

    protected void setPnOffset(int n) {
        this.pnOffset.setValue(n);
    }

    protected void setFreqError(int n) {
        this.freqError.setValue(n);
    }

    protected void setCdpReferencePower(int n) {
        this.cdpReferencePower.setValue(n);
    }

    protected void setPilotDelay(int n) {
        this.pilotDelay.setValue(n);
    }

    protected void setModType(int n) {
        this.modType.setValue(n);
    }

    protected void setNonIdlePower(int n) {
        this.nonIdlePower.setValue(n);
    }

    protected void setPilotMacPower(int n) {
        this.pilotMacPower.setValue(n);
    }

    protected void setOnOffRatio(int n) {
        this.onOffRatio.setValue(n);
    }

    protected void setIdleDataPower(int n) {
        this.idleDataPower.setValue(n);
    }

    protected void setIdleSlots(int n) {
        this.idleSlots.setValue(n);
    }

    protected void setPilotRho(int n) {
        this.pilotRho.setValue(n);
    }

    protected void setMacRho(int n) {
        this.macRho.setValue(n);
    }

    protected void setMaxInactive(int n) {
        this.maxInactive.setValue(n);
    }

    protected void setNoiseFloor(int n) {
        this.noiseFloor.setValue(n);
    }

    protected void setCenterFreq(long l) {
        this.centerFreq.setValue(l);
    }

    public boolean isValidForMetricDisplay() {
        return true;
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public double getDoubleReadingValue(int n) {
        return this.getReadings()[n].doubleValue();
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    public long getLongReadingValue(int n) {
        return this.getReadings()[n].longValue();
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        return ((IntegerArrayReading)this.getReadings()[n]).getTrace()[n2];
    }

    protected Reading[] getSensorReadings() {
        return new Reading[]{this.pnOffset, this.freqError, this.cdpReferencePower, this.pilotDelay, this.nonIdlePower, this.pilotMacPower, this.onOffRatio, this.idleDataPower, this.idleSlots, this.pilotRho, this.macRho, this.maxInactive, this.noiseFloor, this.modType, this.channelTypes, this.channelNumbers, this.channelLevels, this.cdpTraceThreshold, this.averageCount};
    }

    protected Reading[] getActuatorReadings() {
        return new Reading[]{this.centerFreq, this.pnIncrement, this.pnOffsetActuator, this.autoPnOffset, this.thresholdOffset, this.thresholdSetting, this.autoThreshold, this.measurementLoss, this.measurementTime, this.averagingState, this.numAverages, this.slotThreshold, this.cdpType, this.macCdpXAxis, this.measurementOffset, this.cdpMetrics};
    }

    protected Reading[] getSecondSensorReadings() {
        return new Reading[]{this.topNPnOffsets, this.topNPilots, this.pilotDominance, this.multipathPower};
    }

    protected Reading[] getSecondActuatorReadings() {
        return new Reading[]{this.pilotDominanceThreshold, this.multipathPowerThreshold, this.pnScanner, this.pnScannerSensitivity};
    }

    protected Reading[] getThirdSensorReadings() {
        return new Reading[]{this.cdpValid};
    }

    public Reading[] createReadings() {
        int n = this.getSensorReadings().length;
        int n2 = this.getActuatorReadings().length;
        int n3 = this.getSecondSensorReadings().length;
        int n4 = this.getSecondActuatorReadings().length;
        int n5 = this.getThirdSensorReadings().length;
        Reading[] readingArray = new Reading[n + n2 + n3 + n4 + n5];
        System.arraycopy(this.getSensorReadings(), 0, readingArray, 0, n);
        System.arraycopy(this.getActuatorReadings(), 0, readingArray, n, n2);
        System.arraycopy(this.getSecondSensorReadings(), 0, readingArray, n + n2, n3);
        System.arraycopy(this.getSecondActuatorReadings(), 0, readingArray, n + n2 + n3, n4);
        System.arraycopy(this.getThirdSensorReadings(), 0, readingArray, n + n2 + n3 + n4, n5);
        return readingArray;
    }

    protected Reading[] getReadings() {
        return this.readings;
    }

    public String getMeasurementTitle() {
        if (Cdma1xevMeasurementSettings.instance().getOTAPNScanner().booleanValue()) {
            return Text.CDMA1XEVDO_Over_Air;
        }
        return Text.CDMA1XEVDO;
    }

    public int getIndexForXValue(long l) {
        if (l < 0L || l > 128L) {
            l = -1L;
        }
        return (int)l;
    }

    public int linearizeXValue(int n) {
        Cdma1xevMeasurementSettings cdma1xevMeasurementSettings = Cdma1xevMeasurementSettings.instance();
        if (n > 128 || n == 0) {
            return cdma1xevMeasurementSettings.channelWidth;
        }
        int n2 = 0;
        for (int i = 0; i < n - 1; ++i) {
            n2 += cdma1xevMeasurementSettings.channelWidth;
        }
        return n2 + cdma1xevMeasurementSettings.channelWidth / 2 + 1;
    }

    public long getXValueForIndex(int n) {
        if (n < 0 || n >= Cdma1xevMeasurementSettings.instance().getNumberOfBars()) {
            return Integer.MIN_VALUE;
        }
        return this.channelNumbers.getTrace()[n];
    }

    public boolean isCdpValid() {
        return this.cdpValid.booleanValue();
    }

    public int[] getTrace() {
        return this.getChannelLevels();
    }

    public int getTraceLength() {
        return Cdma1xevMeasurementSettings.instance().getNumberOfBars();
    }

    public long getTraceStartValue() {
        return 0L;
    }

    public long getTraceStopValue() {
        return 127L;
    }

    protected int getNumberOfBars() {
        int n;
        switch (this.cdpType.intValue()) {
            case 0: {
                n = 128;
                break;
            }
            case 2: {
                n = 32;
                break;
            }
            case 3: {
                n = 16;
                break;
            }
            default: {
                n = 64;
            }
        }
        return n;
    }

    public PeakFinder createPeakFinder() {
        return new DiscretePeakFinder(128);
    }

    public int convertToAbsolutePower(int n) {
        return this.cdpReferencePower.intValue() + n;
    }

    public int getAbsCdpTraceThreshold() {
        return this.convertToAbsolutePower(this.cdpTraceThreshold.intValue());
    }

    public int getRelCdpTraceThreshold() {
        return this.cdpTraceThreshold.intValue();
    }

    public int getRelBarPower(int n) {
        return this.channelLevels.getTrace()[n];
    }

    public int getAbsBarPower(int n) {
        return this.convertToAbsolutePower(this.getRelBarPower(n));
    }

    public int getChannelTypeIndex(String string) {
        int n = Cdma1xevAnalyzer.getChannelType(string);
        for (int i = 0; i < this.getChannelTypes().length; ++i) {
            if (this.getChannelTypes()[i] != n) continue;
            return i;
        }
        return -1;
    }

    public String getMaxNoise(double d) {
        int n = Integer.MIN_VALUE;
        int n2 = -1;
        int n3 = Cdma1xevAnalyzer.getChannelType(Text.Noise);
        for (int i = 0; i < this.getChannelTypes().length; ++i) {
            if (this.getChannelTypes()[i] != n3 || this.getChannelLevels()[i] <= n) continue;
            n = this.getChannelLevels()[i];
            n2 = this.getChannelNumbers()[i];
        }
        return MeasurementScreen.createResultLine(n, d, Double.NEGATIVE_INFINITY, "TX Max Noise Lev (Chan " + n2 + ")", "dB");
    }

    public int[] getIndexOfSixLargestCdma2kLevels() {
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6};
        int n = Cdma1xevAnalyzer.getChannelType(Text.CDMA2K);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < this.getChannelTypes().length; ++j) {
                if (this.getChannelTypes()[j] != n || this.getChannelLevels()[j] <= this.getChannelLevels()[nArray[i]] || !this.indexNotEqualToPreviousMaximums(i, nArray, j)) continue;
                nArray[i] = j;
            }
        }
        return nArray;
    }

    private boolean indexNotEqualToPreviousMaximums(int n, int[] nArray, int n2) {
        for (int i = 0; i < n; ++i) {
            if (n2 != nArray[i]) continue;
            return false;
        }
        return true;
    }

    public int findPosition(int n) {
        int[] nArray = this.getChannelTypes();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int[] getTopNPilotsValues() {
        return this.topNPilots.getTrace();
    }

    public int[] getTopPnOffsets() {
        return this.topNPnOffsets.getTrace();
    }

    public int getPilotDominance() {
        return this.pilotDominance.intValue();
    }

    public int getMultipathPower() {
        return this.multipathPower.intValue();
    }

    public boolean isPilotDominanceAboveLimit() {
        return this.pilotDominance.intValue() > this.pilotDominanceThreshold.intValue();
    }

    public boolean isMultipathPowerBelowLimit() {
        return this.multipathPower.intValue() < this.multipathPowerThreshold.intValue();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

