/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma1xev;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.actuators.TrimodeActuatorButton;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.menu.LevelButtonFactory;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.units.PrefixedUnitsConversion;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.cdma1xev.Cdma1xevAnalyzer;
import elgato.measurement.cdma1xev.Cdma1xevScreen;
import elgato.measurement.cdma1xev.CommonCdma1xevMeasurementSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class Cdma1xevMenuMgr
extends MeasurementMenuMgr {
    protected static final Logger logger = LogManager.getLogger(class$elgato$measurement$cdma1xev$Cdma1xevMenuMgr == null ? (class$elgato$measurement$cdma1xev$Cdma1xevMenuMgr = Cdma1xevMenuMgr.class$("elgato.measurement.cdma1xev.Cdma1xevMenuMgr")) : class$elgato$measurement$cdma1xev$Cdma1xevMenuMgr);
    protected final Cdma1xevAnalyzer analyzer;
    final CommonCdma1xevMeasurementSettings settings;
    private MarkerButtonFactory markerButtonFactory;
    private MultiStateActuatorButton measTimeButton;
    protected MultiStateActuatorButton cdpMetricsButton;
    protected MenuButton setupButton;
    protected MenuButton levelMenuButton;
    protected MenuButton displayButton;
    protected Menu freqChanMenu;
    private Menu codogramMenu;
    protected Menu limitsMenu;
    protected Menu setupMenu1;
    protected Menu setupMenu2;
    private ValueListener codogramEnabledListener = new ValueListener(){
        private String listenerName = ".codogramEnabledListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = Cdma1xevMenuMgr.this.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            boolean bl = valueInterface.booleanValue();
            MenuItem[] menuItemArray = Cdma1xevMenuMgr.this.codogramMenu.getItems();
            for (int i = 1; i < menuItemArray.length && i != 6; ++i) {
                if (menuItemArray[i] == null) continue;
                menuItemArray[i].setEnabled(bl);
            }
        }
    };
    private ValueListener otaPNScannerListener = new ValueListener(){
        private String listenerName = ".otaPNScannerListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = Cdma1xevMenuMgr.this.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            Cdma1xevMenuMgr.this.cdpMetricsButton.setEnabled(valueInterface.booleanValue());
        }
    };
    static /* synthetic */ Class class$elgato$measurement$cdma1xev$Cdma1xevMenuMgr;

    public Cdma1xevMenuMgr(Cdma1xevScreen cdma1xevScreen, CommonCdma1xevMeasurementSettings commonCdma1xevMeasurementSettings, Cdma1xevAnalyzer cdma1xevAnalyzer) {
        super(cdma1xevScreen);
        this.settings = commonCdma1xevMeasurementSettings;
        this.analyzer = cdma1xevAnalyzer;
        this.markerButtonFactory = this.createMarkerButtonFactory();
    }

    protected abstract MenuButton createFreqChanButton();

    protected abstract MenuButton createLevelMenuButton();

    protected abstract MenuButton createSetupButton();

    protected MenuButton createDisplayButton() {
        return null;
    }

    protected String getMeasurementName() {
        return "cdma1xEvdoAn";
    }

    protected Menu cdmaBuildLeftMenu() {
        String string = Text.CDMA1XEVDO_Anl_dot_;
        return new Menu(string, new MenuItem[]{this.createFreqChanButton(), this.createLevelMenuButton(), this.createDisplayButton(), null, this.createAvgSweepButton(), this.createSetupButton(), this.createMarkerButton()});
    }

    protected Menu buildLeftMenu() {
        Menu menu = this.cdmaBuildLeftMenu();
        return menu;
    }

    protected MenuButton createAvgSweepButton() {
        return this.createAverageSweepButton(this.settings.getNumAverages(), this.settings.getAveraging());
    }

    protected MenuButton createMarkerButton() {
        return this.markerButtonFactory.getMenuButton();
    }

    ActuatorEditor createCenterFrequencyButton() {
        return new ActuatorEditor(this.settings.getCenterFreq(), this.getContextString("cdmaFrequencyChannel.cdmaFrequency"), this.getListenerBaseName() + ".cfButton");
    }

    protected Menu createRightMenuWithTimeRef() {
        return new Menu(Text.Freq_slash_Chan, new MenuItem[]{this.createCenterFrequencyButton(), null, this.createPNOffsetButton(this.getContextString("cdmaFrequencyChannel.pnOffset")), this.createPnIncButton(), this.createTimeFreqRefButton(), this.createChanStdButton(), this.createFreqChanUnitsButton()}, 0);
    }

    MenuItem createPnIncButton() {
        return new ActuatorEditor(this.settings.getPnInc(), this.getContextString("cdmaFrequencyChannel.pnInc"), this.getListenerBaseName() + ".pnIncButton");
    }

    MenuItem createPNOffsetButton(String string) {
        return new TrimodeActuatorButton((ValueListInterface)this.settings.getPnOffsetAuto(), string, this.settings.getPnOffsetManual(), this.getListenerBaseName() + ".pnOffsetButton");
    }

    protected MenuItem createRfInsertionLossButton() {
        return MeasurementMenuMgr.createLossButton(DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), this.settings.getRfInLoss(), DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.getContextString("rf.in.loss"), this.getListenerBaseName() + ".RfInLossButton");
    }

    protected MultiStateActuatorButton createReferenceButton() {
        return new MultiStateActuatorButton(this.settings.getReference(), this.getContextString("ref.level"), this.getListenerBaseName() + ".refLevelButton");
    }

    protected ActuatorEditor createScaleDivButton() {
        return new ActuatorEditor(this.settings.getScaleDiv(), this.getContextString("level.scaleDivision"), this.getListenerBaseName() + ".scaleDivButton");
    }

    protected MenuItem createGpsLocationButton() {
        return LevelButtonFactory.createGpsLocationButton(this.scn);
    }

    public Menu createCodogramMenu() {
        this.codogramMenu = new Menu(Text.Codogram, new MenuItem[]{new MultiStateActuatorButton(this.settings.getCodogramEnabled(), this.getContextString("codogram.enabled"), this.getListenerBaseName() + ".codogramEnabledButton"), this.createResetCodogramButton("codogramResetMetrics"), new ActuatorEditor(this.settings.getCodogramCaptureInterval(), "codogramCaptureInterval", this.getListenerBaseName() + ".captureIntervalButton"), null, new ActuatorSubMenuButton(this.settings.getCodogramPalette(), this.getContextString("codogram.palette"), true, this.getListenerBaseName() + ".paletteButton")});
        return this.codogramMenu;
    }

    private MenuItem createResetCodogramButton(String string) {
        return new PushButton(Text.Reset_n_Codogram, string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Cdma1xevMenuMgr.this.analyzer.clearCodogramHistory();
            }
        });
    }

    protected MenuItem createThresholdOffsetButton() {
        return new ActuatorEditor(this.settings.getThreshOffset(), this.getContextString("cdmaSetup.thresholdOffset"), this.getListenerBaseName() + ".threshOffsetButton");
    }

    protected MenuItem createThresholdButton() {
        return new TrimodeActuatorButton((ValueListInterface)this.settings.getAutoThreshold(), this.getContextString("cdmaSetup.thresholdLevel"), this.settings.getThresholdLevel(), this.getListenerBaseName() + ".threshLevelButton");
    }

    protected MultiStateActuatorButton createMeasTimeButton() {
        this.measTimeButton = new MultiStateActuatorButton(this.settings.getMeasTime(), this.getContextString("meas.time"), this.getListenerBaseName() + ".measTimeButton");
        return this.measTimeButton;
    }

    protected MenuItem createMeasOffsetButton() {
        return new ActuatorEditor(this.settings.getMeasOffset(), this.getContextString("cdma1xEvdoSetup.measOffset"), this.getListenerBaseName() + ".measOffsetButton");
    }

    protected MenuItem createSlotThresholdButton() {
        return new ActuatorEditor(this.settings.getSlotThresholdLevel(), this.getContextString("cdma1xEvdoSetup.slotThresholdLevel"), this.getListenerBaseName() + ".slotThreshLevelButton");
    }

    protected MenuItem createCdpTypeButton() {
        return new ActuatorSubMenuButton(this.settings.getCdpType(), this.getContextString("cdma1xEvdoAn.cdpType"), true, this.getListenerBaseName() + ".cdpTypeButton");
    }

    protected PushButton createSetupMore1Button(String string) {
        return new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Cdma1xevMenuMgr.this.scn.getScreenManager().installRightMenu(Cdma1xevMenuMgr.this.setupMenu2);
            }
        });
    }

    protected PushButton createSetupMore2Button(String string) {
        return new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Cdma1xevMenuMgr.this.scn.getScreenManager().installRightMenu(Cdma1xevMenuMgr.this.setupMenu1);
            }
        });
    }

    protected MenuItem createMacCdpXAxisButton() {
        return new MultiStateActuatorButton(this.settings.getMacCdpXAxis(), this.getContextString("cdma1xEvdo.macCdpXAxis"), this.getListenerBaseName() + ".macCdpXAxisButton");
    }

    protected MenuItem createLimitsButton() {
        this.limitsMenu = new Menu(Text.Limits, new MenuItem[]{this.createFreqErrorLimitsButton(), this.createTimeOffsetLimitsButton(), this.createIdleOnOffPwrRatioLimitsButton(), this.createPilotRhoLimitsButton(), this.createMacRhoLimitsButton(), this.createMaxInactiveChLimitsButton()});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Limits, this.getContextString("Limits"), this.limitsMenu, true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        subMenuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Cdma1xevMenuMgr.this.settings.setAllLimits();
            }
        });
        return subMenuButton;
    }

    private MenuItem createOnOffLimitsButton(int n) {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(this.settings.limitsToggleAt(n), "", this.getListenerBaseName() + ".linOnOff");
        this.setSettingsShowLimits();
        multiStateActuatorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Cdma1xevMenuMgr.this.setSettingsShowLimits();
                Cdma1xevMenuMgr.this.settings.allowValidationNow();
            }
        });
        return multiStateActuatorButton;
    }

    public void setSettingsShowLimits() {
        this.analyzer.swapBottomPanel(this.settings.getLimitsSummaryState());
    }

    private MenuItem createFreqErrorLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Freq_Error_Limits, this.getContextString("freqErrorLimits"), new Menu(Text.Freq_Error, new MenuItem[]{this.createOnOffLimitsButton(0), new ActuatorEditor(this.settings.getFreqErrorUpperLimit(), this.getContextString("freqErrorLimits"), this.getListenerBaseName() + ".freqErrorULimits"), new ActuatorEditor(this.settings.getFreqErrorLowerLimit(), this.getContextString("freqErrorLimits"), this.getListenerBaseName() + ".freqErrorLLimits")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createTimeOffsetLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Time_Offset_Limits, this.getContextString("timeOffsetLimits"), new Menu(Text.Time_Offset, new MenuItem[]{this.createOnOffLimitsButton(1), new ActuatorEditor(this.settings.getTimeOffsetUpperLimit(), this.getContextString("timeOffsetLimits"), this.getListenerBaseName() + ".timeOffsetULimits"), new ActuatorEditor(this.settings.getTimeOffsetLowerLimit(), this.getContextString("timeOffsetLimits"), this.getListenerBaseName() + ".timeOffsetLLimits")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createIdleOnOffPwrRatioLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.OnOff_Ratio_n_Limits, this.getContextString("idleOnOffPwrRatioLimits"), new Menu(Text.On_Off_Ratio, new MenuItem[]{this.createOnOffLimitsButton(2), this.createIdleOnOffPwrRatioLowerLimit()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createIdleOnOffPwrRatioLowerLimit() {
        return new ActuatorEditor(this.settings.getIdleOnOffPowerRatioLowerLimit(), this.getContextString("idleOnOffPwrRatioLimits"), this.getListenerBaseName() + ".idleOnOffPwrRatioLimits");
    }

    private MenuItem createPilotRhoLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Est_Pilot_n_Rho_Limits, this.getContextString("pilotRhoLimits"), new Menu(Text.Est_Pilot_Rho, new MenuItem[]{this.createOnOffLimitsButton(3), this.createPilotRhoLowerLimit()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createPilotRhoLowerLimit() {
        return new ActuatorEditor(this.settings.getPilotRhoLowerLimit(), this.getContextString("pilotRhoLimits"), this.getListenerBaseName() + ".pilotRhoLimits");
    }

    private MenuItem createMacRhoLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Est_MAC_n_Rho_Limits, this.getContextString("macRhoLimits"), new Menu(Text.Est_MAC_Rho, new MenuItem[]{this.createOnOffLimitsButton(4), this.createMacRhoLowerLimit()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createMacRhoLowerLimit() {
        return new ActuatorEditor(this.settings.getMacRhoLowerLimit(), this.getContextString("macRhoLimits"), this.getListenerBaseName() + ".macRhoLimits");
    }

    private MenuItem createMaxInactiveChLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Max_Inactive_n_Ch_Limits, this.getContextString("maxInactiveChLimits"), new Menu(Text.Max_Inact_dot_Ch, new MenuItem[]{this.createOnOffLimitsButton(5), this.createMaxInactiveMACLimits(), this.createMaxInactivePilotLimits()}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createMaxInactiveMACLimits() {
        return new ActuatorEditor(this.settings.getMaxInactiveMACHighLimit(), this.getContextString("maxInactiveChLimits"), this.getListenerBaseName() + ".maxInactiveChLimits");
    }

    protected ActuatorEditor createMaxInactivePilotLimits() {
        return new ActuatorEditor(this.settings.getMaxInactivePilotHighLimit(), this.getContextString("maxInactiveChLimits"), this.getListenerBaseName() + ".maxInactiveChLimits");
    }

    protected MultiStateActuatorButton createOTAPNScannerButton() {
        return new MultiStateActuatorButton(this.settings.getOTAPNScanner(), this.getContextString("cdma1xEvdoSetup.otaPNScanner"), this.getListenerBaseName() + ".otaPNScannerButton");
    }

    protected MultiStateActuatorButton createCdpMetricsButton() {
        this.cdpMetricsButton = new MultiStateActuatorButton(this.settings.getCdpMetrics(), this.getContextString("cdma1xEvdoSetup.cdpMetrics"), this.getListenerBaseName() + ".cdpMetricsButton");
        return this.cdpMetricsButton;
    }

    public MarkerButtonFactory createMarkerButtonFactory() {
        LongActuator longActuator = new LongActuator("", "", "");
        longActuator.setConversion(new PrefixedUnitsConversion(Text.Chan));
        this.markerButtonFactory = new MarkerButtonFactory((MeasurementScreen)this.scn, null, null, longActuator, false);
        return this.markerButtonFactory;
    }

    public MarkerButtonFactory getMarkerButtonFactory() {
        return this.markerButtonFactory;
    }

    public void setupFreqChanUnitsListener() {
        this.setupFreqChanUnitsListener(this.freqChanMenu, 1);
    }

    public void prolog() {
        this.setupFreqChanUnitsListener();
        this.addValueListeners();
    }

    public void cleanup() {
        this.removeValueListeners();
        super.cleanup();
    }

    public void addValueListeners() {
        this.settings.getCodogramEnabled().addValueListener(this.codogramEnabledListener);
        this.codogramEnabledListener.valueChanged(this.settings.getCodogramEnabled());
        this.settings.getOTAPNScanner().addValueListener(this.otaPNScannerListener);
        this.otaPNScannerListener.valueChanged(this.settings.getOTAPNScanner());
    }

    public void removeValueListeners() {
        this.settings.getCodogramEnabled().removeValueListener(this.codogramEnabledListener);
        this.codogramEnabledListener = null;
        this.settings.getOTAPNScanner().removeValueListener(this.otaPNScannerListener);
        this.otaPNScannerListener = null;
    }

    public MultiStateActuatorButton getMeasTimeButton() {
        return this.measTimeButton;
    }

    public ActuatorEditor createMultipathPowerThresholdButton() {
        return new ActuatorEditor(this.settings.getMultipathPower(), "pwr.thresh", this.getListenerBaseName() + ".pwrThreshButton");
    }

    public ActuatorEditor createPilotDominanceThresholdButton() {
        return new ActuatorEditor(this.settings.getPilotDominance(), "plt.dom", this.getListenerBaseName() + ".pilotDomButton");
    }

    public MultiStateActuatorButton createPNScannerSensitivityButton() {
        return new MultiStateActuatorButton(this.settings.getPNScannerSensitivity(), this.getContextString("pnScannerSensitivity"), this.getListenerBaseName() + ".pnScannerSensitivity");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

