/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma1xev;

import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.LabelOnlyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.measurement.cdma1xev.Cdma1xevAnalyzer;
import elgato.measurement.cdma1xev.Cdma1xevMeasurement;
import elgato.measurement.cdma1xev.Cdma1xevMeasurementSettings;
import java.awt.Color;

public class Cdma1xevMetricsTable
extends BasicMeasurementMetrics {
    private Cdma1xevAnalyzer analyzer;

    protected ValueSource[][] createValueSources() {
        FrequencyStrategy frequencyStrategy = new FrequencyStrategy();
        DecibelStrategy decibelStrategy = new DecibelStrategy(1, true);
        FixedPointNumberFieldStrategy fixedPointNumberFieldStrategy = new FixedPointNumberFieldStrategy(1, "dBc");
        DecibelStrategy decibelStrategy2 = new DecibelStrategy(1);
        NumberFieldStrategy numberFieldStrategy = new NumberFieldStrategy();
        FixedPointNumberFieldStrategy fixedPointNumberFieldStrategy2 = new FixedPointNumberFieldStrategy(1, "%");
        ValueSource valueSource = this.createFreqValueSource(frequencyStrategy, Text.Freq);
        ValueSource valueSource2 = this.createFreqErrorValueSource(frequencyStrategy);
        ValueSource valueSource3 = this.createPnOffsetValueSource(numberFieldStrategy);
        ValueSource valueSource4 = this.createPilotDelayValueSource();
        ValueSource valueSource5 = this.createNonIdlePowerValueSource(decibelStrategy);
        ValueSource valueSource6 = this.createPilotPlusMacPowerValueSource(decibelStrategy);
        ValueSource valueSource7 = this.createOnOffRatioValueSource(decibelStrategy2);
        ValueSource valueSource8 = this.createIdleDataPowerValueSource(decibelStrategy);
        ValueSource valueSource9 = this.createIdleSlotsValueSource(fixedPointNumberFieldStrategy2);
        ValueSource valueSource10 = this.createPilotRhoValueSource();
        ValueSource valueSource11 = this.createMacRhoValueSource();
        ValueSource valueSource12 = this.createMaxInactiveChPwrValueSource(fixedPointNumberFieldStrategy);
        ValueSource valueSource13 = this.createNoiseFloorValueSource(fixedPointNumberFieldStrategy);
        ValueSource valueSource14 = this.createModTypeValueSource();
        return new ValueSource[][]{{valueSource, valueSource2, valueSource3, valueSource4}, {valueSource5, valueSource6, valueSource7, valueSource8, valueSource9}, {valueSource10, valueSource11, valueSource12, valueSource13, valueSource14}};
    }

    public Cdma1xevMetricsTable(Cdma1xevAnalyzer cdma1xevAnalyzer) {
        this.analyzer = cdma1xevAnalyzer;
    }

    protected boolean isMeasurementValid() {
        return ((Cdma1xevMeasurement)this.getMeasurement()).isValidForMetricDisplay();
    }

    private Cdma1xevMeasurement getCdma1xevMeasurement() {
        return (Cdma1xevMeasurement)this.getMeasurement();
    }

    protected ValueSource createFreqErrorValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createFreqErrorValueSource(numberFieldStrategy, Text.Freq_Err);
    }

    protected ValueSource createPnOffsetValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createPnOffsetValueSource(numberFieldStrategy, Text.PN_Offset);
    }

    protected ValueSource createPilotDelayValueSource() {
        return this.createPilotDelayValueSource(Text.Time_Offset);
    }

    protected ValueSource createNonIdlePowerValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createNonIdlePowerValueSource(numberFieldStrategy, Text.Non_Idle_Pwr);
    }

    protected ValueSource createPilotPlusMacPowerValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createPilotPlusMacPowerValueSource(numberFieldStrategy, Text.Pilot_plus_MAC_Pwr);
    }

    protected ValueSource createOnOffRatioValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createOnOffRatioValueSource(numberFieldStrategy, Text.On_Off_Ratio);
    }

    protected ValueSource createIdleSlotsValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createIdleSlotsValueSource(numberFieldStrategy, Text.Idle_Slots);
    }

    protected ValueSource createIdleDataPowerValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createIdleDataPowerValueSource(numberFieldStrategy, Text.Idle_Data_Pwr);
    }

    protected ValueSource createPilotRhoValueSource() {
        return this.createPilotRhoValueSource(Text.Est_Pilot_Rho);
    }

    protected ValueSource createMacRhoValueSource() {
        return this.createMacRhoValueSource(Text.Est_MAC_Rho);
    }

    protected ValueSource createMaxInactiveChPwrValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createMaxInactiveChPwrValueSource(numberFieldStrategy, Text.Max_Inact_dot_Ch);
    }

    protected ValueSource createNoiseFloorValueSource(NumberFieldStrategy numberFieldStrategy) {
        return this.createNoiseFloorValueSource(numberFieldStrategy, Text.Noise_Floor);
    }

    protected ValueSource createModTypeValueSource() {
        return this.createModTypeValueSource(Text.Data_Ch_Mod);
    }

    protected ValueSource createFreqValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCenterFreq();
            }
        };
    }

    private ValueSource createFreqErrorValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, false){

            protected long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getFreqError();
            }

            protected long cookValue(long l) {
                return l / 1000L;
            }

            public Color getValueColor() {
                if (Cdma1xevMetricsTable.this.analyzer.isLimitOn(0) && Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCdpMetrics()) {
                    return Cdma1xevMetricsTable.this.analyzer.isFreqErrorWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                if (Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCdpMetrics()) {
                    return super.getFormattedUnits() + Cdma1xevMetricsTable.this.getPassFailText(Cdma1xevMetricsTable.this.analyzer.isLimitOn(0), Cdma1xevMetricsTable.this.analyzer.isFreqErrorWithinLimits());
                }
                return super.getFormattedUnits();
            }
        };
    }

    private ValueSource createPnOffsetValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getPnOffset();
            }

            public void compute(boolean bl) {
                bl = this.getRawValue() != -1L;
                super.compute(bl);
            }
        };
    }

    private ValueSource createPilotDelayValueSource(String string) {
        return new GrayableValueSource(string, new FixedPointNumberFieldStrategy(2, "\u03bcs"), false){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getPilotDelay();
            }

            protected long cookValue(long l) {
                return UIHelper.chipsToNanoseconds((int)l);
            }

            public void compute(boolean bl) {
                super.compute(bl && Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getPnOffset() != -1);
            }

            public Color getValueColor() {
                if (Cdma1xevMetricsTable.this.analyzer.isLimitOn(1)) {
                    return Cdma1xevMetricsTable.this.analyzer.isTimeOffsetWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + Cdma1xevMetricsTable.this.getPassFailText(Cdma1xevMetricsTable.this.analyzer.isLimitOn(1), Cdma1xevMetricsTable.this.analyzer.isTimeOffsetWithinLimits());
            }
        };
    }

    private ValueSource createNonIdlePowerValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getNonIdlePower();
            }

            public void compute(boolean bl) {
                super.compute(true);
            }
        };
    }

    private ValueSource createPilotPlusMacPowerValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getPilotMacPower();
            }

            public void compute(boolean bl) {
                super.compute(true);
            }
        };
    }

    private ValueSource createOnOffRatioValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getOnOffRatio();
            }

            public Color getValueColor() {
                if (Cdma1xevMetricsTable.this.analyzer.isLimitOn(2) && Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCdpMetrics()) {
                    return Cdma1xevMetricsTable.this.analyzer.isOnOffPwrRatioWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                if (Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCdpMetrics()) {
                    return super.getFormattedUnits() + Cdma1xevMetricsTable.this.getPassFailText(Cdma1xevMetricsTable.this.analyzer.isLimitOn(2), Cdma1xevMetricsTable.this.analyzer.isOnOffPwrRatioWithinLimits());
                }
                return super.getFormattedUnits();
            }
        };
    }

    private ValueSource createIdleSlotsValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getIdleSlots();
            }
        };
    }

    private ValueSource createPilotRhoValueSource(String string) {
        return new GrayableValueSource(string, new FixedPointNumberFieldStrategy(3), true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getPilotRho();
            }

            public Color getValueColor() {
                if (Cdma1xevMetricsTable.this.analyzer.isLimitOn(3) && Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCdpMetrics()) {
                    return Cdma1xevMetricsTable.this.analyzer.isPilotRhoWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                if (Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCdpMetrics()) {
                    return super.getFormattedUnits() + Cdma1xevMetricsTable.this.getPassFailText(Cdma1xevMetricsTable.this.analyzer.isLimitOn(3), Cdma1xevMetricsTable.this.analyzer.isPilotRhoWithinLimits());
                }
                return super.getFormattedUnits();
            }
        };
    }

    private ValueSource createMacRhoValueSource(String string) {
        return new GrayableValueSource(string, new FixedPointNumberFieldStrategy(3), true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getMacRho();
            }

            public Color getValueColor() {
                if (Cdma1xevMetricsTable.this.analyzer.isLimitOn(4) && Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCdpMetrics()) {
                    return Cdma1xevMetricsTable.this.analyzer.isMacRhoWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                if (Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCdpMetrics()) {
                    return super.getFormattedUnits() + Cdma1xevMetricsTable.this.getPassFailText(Cdma1xevMetricsTable.this.analyzer.isLimitOn(4), Cdma1xevMetricsTable.this.analyzer.isMacRhoWithinLimits());
                }
                return super.getFormattedUnits();
            }
        };
    }

    private ValueSource createMaxInactiveChPwrValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getMaxInactive();
            }

            public Color getValueColor() {
                if (Cdma1xevMetricsTable.this.analyzer.isLimitOn(5) && Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCdpMetrics()) {
                    return Cdma1xevMetricsTable.this.analyzer.isMaxInactiveChWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                if (Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getCdpMetrics()) {
                    return super.getFormattedUnits() + Cdma1xevMetricsTable.this.getPassFailText(Cdma1xevMetricsTable.this.analyzer.isLimitOn(5), Cdma1xevMetricsTable.this.analyzer.isMaxInactiveChWithinLimits());
                }
                return super.getFormattedUnits();
            }
        };
    }

    private ValueSource createNoiseFloorValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getNoiseFloor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits();
            }
        };
    }

    protected ValueSource createModTypeValueSource(String string) {
        return new GrayableValueSource(string, new LabelOnlyStrategy(), true){

            public long getRawValue() {
                return 0L;
            }

            public void compute(boolean bl) {
                String string = Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getModType();
                this.isMeasurementValid = bl;
                boolean bl2 = this.validValue = !string.equals(Text.Unknown);
                if (bl && this.validValue) {
                    if (string.equals(Text._16QAM) && Cdma1xevMetricsTable.this.analyzer.isLimitOn(5)) {
                        string = Text._16QAM_short;
                    }
                    this.result[0] = string;
                    this.result[1] = "";
                } else {
                    this.dashMetric();
                }
            }
        };
    }

    private ValueSource createIdleDataPowerValueSource(NumberFieldStrategy numberFieldStrategy, String string) {
        return new GrayableValueSource(string, numberFieldStrategy, true){

            public long getRawValue() {
                return Cdma1xevMetricsTable.this.getCdma1xevMeasurement().getIdleDataPower();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits();
            }
        };
    }

    private String getPassFailText(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? " (P)" : " (F)";
        }
        return "";
    }

    protected boolean shouldGrayOutValues() {
        if (Cdma1xevMeasurementSettings.instance().getOTAPNScanner().booleanValue()) {
            return !this.getCdma1xevMeasurement().isCdpValid();
        }
        return false;
    }

    protected abstract class GrayableValueSource
    extends ValueSource {
        public GrayableValueSource(String string, NumberFieldStrategy numberFieldStrategy, boolean bl) {
            super(string, numberFieldStrategy, bl);
        }

        public Color getValueColor() {
            return Cdma1xevMetricsTable.this.shouldGrayOutValues() ? Color.gray : Color.black;
        }
    }
}

