/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma1xev;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.ProductFactory;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.util.UIHelper;
import elgato.measurement.cdma1xev.Cdma1xevAnalyzer;
import elgato.measurement.cdma1xev.Cdma1xevMeasurement;
import elgato.measurement.cdma1xev.Cdma1xevMeasurementSettings;
import elgato.measurement.cdma1xev.Cdma1xevMenuMgr;
import elgato.measurement.cdma1xev.CommonCdma1xevMeasurementSettings;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;

public class Cdma1xevScreen
extends MeasurementScreen {
    protected Cdma1xevAnalyzer analyzer;
    protected Cdma1xevMenuMgr menuMgr;
    static /* synthetic */ Class class$elgato$measurement$cdma1xev$Cdma1xevMeasurement;

    protected Command[] getInitialGetCommands() {
        return new Command[0];
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.menuMgr.prolog();
    }

    public void uninstallScreen(ScreenManager screenManager) {
        if (this.menuMgr != null) {
            this.menuMgr.cleanup();
        }
        super.uninstallScreen(screenManager);
        this.menuMgr = null;
        this.analyzer = null;
    }

    protected Cdma1xevMenuMgr createMenuMgr() {
        this.menuMgr = ProductFactory.getInstance().createCdma1xevMenuMgr(this, this.getMeasurementSettings(), (Cdma1xevAnalyzer)this.getAnalyzer());
        return this.menuMgr;
    }

    protected void refreshMeasurementSettings() {
        this.getMeasurementSettings().refresh();
    }

    protected String getMeasurementName() {
        return "cdma1xEvdoAn";
    }

    protected void setupAnalyzer() {
        this.analyzer = new Cdma1xevAnalyzer(this.isDoingOverAir(), this.getMeasurementSettings());
        this.createMenuMgr();
        this.analyzer.setMarkerButtonFactory(this.menuMgr.getMarkerButtonFactory());
    }

    protected boolean isDoingOverAir() {
        ProductFactory.getInstance();
        return ProductFactory.bOverAirTest;
    }

    protected Component getAnalyzerPanel() {
        return this.analyzer;
    }

    protected Class getMeasurementClass() {
        return class$elgato$measurement$cdma1xev$Cdma1xevMeasurement == null ? (class$elgato$measurement$cdma1xev$Cdma1xevMeasurement = Cdma1xevScreen.class$("elgato.measurement.cdma1xev.Cdma1xevMeasurement")) : class$elgato$measurement$cdma1xev$Cdma1xevMeasurement;
    }

    protected Menu buildLeftMenu() {
        return this.menuMgr.buildLeftMenu();
    }

    protected CommonCdma1xevMeasurementSettings getMeasurementSettings() {
        return Cdma1xevMeasurementSettings.instance();
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        return this.analyzer.filterPrintImage(image, rectangle);
    }

    public String getTestResults(ScreenManager screenManager, String string) {
        Cdma1xevMeasurement cdma1xevMeasurement = (Cdma1xevMeasurement)this.getAnalyzer().getMeasurement();
        if (cdma1xevMeasurement == null) {
            this.displayErrorMessageScreen(screenManager);
            return "";
        }
        double d = (double)Cdma1xevMeasurementSettings.instance().getPilotRhoLowerLimit().intValue() / 100000.0;
        double d2 = (double)Cdma1xevMeasurementSettings.instance().getTimeOffsetLowerLimit().intValue() / 1000.0;
        double d3 = (double)Cdma1xevMeasurementSettings.instance().getTimeOffsetUpperLimit().intValue() / 1000.0;
        double d4 = Cdma1xevMeasurementSettings.instance().getFreqErrorLowerLimit().intValue();
        double d5 = Cdma1xevMeasurementSettings.instance().getFreqErrorUpperLimit().intValue();
        String string2 = "";
        string2 = MeasurementScreen.createResultLine(cdma1xevMeasurement.getCdpReferencePower(), Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, "CDP Reference Power", "dBm");
        string2 = string2 + this.writeFourChannelResults(cdma1xevMeasurement, d, d3, d2, d5, d4);
        return string2;
    }

    private String writeFourChannelResults(Cdma1xevMeasurement cdma1xevMeasurement, double d, double d2, double d3, double d4, double d5) {
        String string = MeasurementScreen.createResultLine(cdma1xevMeasurement.getPilotRho(), Double.POSITIVE_INFINITY, d, "Pilot Rho", "");
        string = string + MeasurementScreen.createResultLine(UIHelper.chipsToNanoseconds(cdma1xevMeasurement.getPilotDelay()), d2, d3, "Time Offset", "usec");
        string = string + MeasurementScreen.createResultLine(cdma1xevMeasurement.getFreqError(), d4, d5, "Frequency Error", "Hz");
        return string;
    }

    public Cdma1xevMenuMgr getMenuMgr() {
        return this.menuMgr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

