/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma1xev;

import elgato.infrastructure.analyzer.TopNChart;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.measurement.cdma1xev.Cdma1xevAnalyzer;
import elgato.measurement.cdma1xev.Cdma1xevMeasurement;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurementSettings;
import java.awt.Graphics;

public class Cdma1xevTopNChart
extends TopNChart {
    private Cdma1xevAnalyzer analyzer;

    public Cdma1xevTopNChart(Cdma1xevAnalyzer cdma1xevAnalyzer) {
        this.setBottomRangeForChart(-20000);
        this.dbStrategy = new DecibelStrategy(1);
        this.analyzer = cdma1xevAnalyzer;
    }

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        super.setMeasurement(traceMeasurement);
        if (TimeFreqRefMeasurementSettings.instance().getTimeFreqRef().intValue() == 30 || TimeFreqRefMeasurementSettings.instance().getTimeFreqRef().intValue() == 31) {
            this.setValidReference(true);
        } else {
            this.setValidReference(false);
        }
    }

    public void dispose() {
        this.analyzer = null;
    }

    protected int getXAxisRows() {
        return 1;
    }

    public int[] getTopNPilotsValues() {
        return ((Cdma1xevMeasurement)this.getMeasurement()).getTopNPilotsValues();
    }

    public int[] getTopPnOffsets() {
        return ((Cdma1xevMeasurement)this.getMeasurement()).getTopPnOffsets();
    }

    protected int getSlotCount() {
        return this.getTopPnOffsets().length;
    }

    protected void showLimits(Graphics graphics, int n, int n2) {
        this.analyzer.setPassFailLabel();
    }
}

