/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.cdma1xev;

import elgato.infrastructure.actuators.CenterFrequencyActuator;
import elgato.infrastructure.actuators.FreqChanActuatorConfigurator;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.ScaleDivActuator;
import elgato.infrastructure.analyzer.SpectralChart;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.util.Vector;

public class CommonCdma1xevMeasurementSettings
extends MeasurementSettings {
    protected final String TOPIC = this.getTopic();
    protected final String DISPLAY_TOPIC = "display." + this.TOPIC;
    public static final String KEY_CDMA_PN_OFFSET_AUTO = "pnAuto";
    public static final String KEY_CDMA_THRESHOLD_LEVEL_AUTO = "threshAuto";
    private static final String KEY_SLOT_THRESH_LVL = "slotThresh";
    private static final String KEY_CDP_TYPE = "cdpType";
    private static final String KEY_MAC_CDP_X_AXIS = "macCdpXAxis";
    public static final String KEY_MEAS_OFFSET = "measOffset";
    public static final String KEY_CDP_METRICS = "cdpMetrics";
    public static final String KEY_OTA_PN_SCANNER = "pnScanner";
    public static final String KEY_CDMA_1xEVDO_PWR_THLD = "maxMp";
    public static final String KEY_CDMA_1XEVDO_PLT_DOM = "minPltDom";
    public static final String KEY_OTA_PN_SCANNER_SENSITIVITY = "pnScannerSensitivity";
    public static final int REF_REL_SELECTED = 0;
    public static final int REF_ABS_SELECTED = 1;
    public static final int MAC_INDEX = 0;
    public static final int WALSH_CODE = 1;
    public static final int MAC_128 = 0;
    public static final int MAC_64 = 1;
    public static final int PILOT_CDP = 2;
    public static final int DATA_CDP = 3;
    public static final int CDMA_1XEVDO_LIMIT_SIZE = 6;
    public static final int LIMIT_FREQ_ERROR = 0;
    public static final int LIMIT_TIME_OFFSET = 1;
    public static final int LIMIT_ON_OFF_PWR_RATIO = 2;
    public static final int LIMIT_PILOT_RHO = 3;
    public static final int LIMIT_MAC_RHO = 4;
    public static final int LIMIT_MAX_INACTIVE_CH = 5;
    private boolean doingLimitSetAll = true;
    private boolean bLimitsSummaryState = false;
    public int channelWidth = 1;
    protected int numberOfBars = 64;
    private static final String KEY_FREQ_ERROR_LOW_LIMIT = "freqErrorLowerLimit";
    private static final String KEY_FREQ_ERROR_UP_LIMIT = "freqErrorUpperLimit";
    private static final String KEY_TIME_OFFSET_LOW_LIMIT = "timeOffsetLowerLimit";
    private static final String KEY_TIME_OFFSET_UP_LIMIT = "timeOffsetUpperLimit";
    private static final String KEY_ON_OFF_PWR_RATIO_LOW_LIMIT = "idleOnOffPowerRatioLowerLimit";
    private static final String KEY_PILOT_RHO_LOW_LIMIT = "pilotRhoLowerLimit";
    private static final String KEY_MAC_RHO_LOW_LIMIT = "macRhoLowerLimit";
    private static final String KEY_MAX_INACTIVE_MAC_HIGH_LIMIT = "maxInactiveMACHighLimit";
    private static final String KEY_MAX_INACTIVE_PILOT_HIGH_LIMIT = "maxInactivePilotHighLimit";
    private final DisplayGlobalMeasurementSettings globalDisplaySettings = DisplayGlobalMeasurementSettings.instance();
    private LongActuator thresholdLevel = new LongActuator(this.TOPIC, "threshLv", Text.Threshold_Level, -30000L);
    private ListActuator thresholdAuto = new ListActuator(this.TOPIC, "threshAuto", Text.Thresh_Lvl, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private LongActuator pnOffsetManual = new LongActuator(this.TOPIC, "pn", Text.PN_Offset, 1L);
    private ListActuator pnOffsetAuto = new ListActuator(this.TOPIC, "pnAuto", Text.PN_Offset, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private LongActuator pnInc = new LongActuator(this.TOPIC, "pnInc", Text.PN_Inc, 1L);
    private LongActuator threshOffset = new LongActuator(this.TOPIC, "threshOffset", Text.Auto_Thres_n_Offset, 0L);
    private FrequencyActuator centerFreq = CenterFrequencyActuator.createCenterFrequencyActuator(this.TOPIC, "cf");
    private LongActuator numAverages = LongActuator.createNumAverages(this.TOPIC, 100);
    private ListActuator averaging = ListActuator.createAveragingOffOn(this.TOPIC);
    private ListActuator measTime = new ListActuator(this.TOPIC, "measTime", Text.Meas_Time, new Value[]{Value.createValue(Text.Slow, 0), Value.createValue(Text.Med, 1), Value.createValue(Text.Fast, 2)});
    private ListActuator reference = new ListActuator(this.DISPLAY_TOPIC, "refLevel", Text.Reference, new Value[]{Value.createValue(Text.Abs, 1), Value.createValue(Text.Rel, 0)});
    private final ScaleDivActuator scaleDiv = new ScaleDivActuator(this.DISPLAY_TOPIC, 5000);
    private LongActuator rfInLoss = LongActuator.createLoss(this.TOPIC, "atten", Text.RF_IN_Loss, 0);
    private LongActuator slotThresholdLevel = new LongActuator(this.TOPIC, "slotThresh", Text.Slot_Threshold, -5000L);
    private ListActuator cdpType = new ListActuator(this.TOPIC, "cdpType", Text.CDP_Type, new Value[]{Value.createValue(Text.MAC_128, 0), Value.createValue(Text.MAC_64, 1), Value.createValue(Text.Pilot, 2), Value.createValue(Text.Data, 3)});
    private ListActuator macCdpXAxis = new ListActuator(this.TOPIC, "macCdpXAxis", Text.MAC_CDP_n_X_Axis, new Value[]{Value.createValue(Text.MAC, 0), Value.createValue(Text.Walsh, 1)});
    private LongActuator measOffset = new LongActuator(this.TOPIC, "measOffset", Text.Meas_Offset, 0L);
    private ListActuator codogramEnabled = new ListActuator(this.DISPLAY_TOPIC, "codogramEnabled", Text.Codogram, this.createOnOffValueSet());
    private ListActuator codogramPalette = new ListActuator(this.DISPLAY_TOPIC, "codogramPalette", Text.Palette, SpectralChart.createPaletteValues());
    private final LongActuator codogramCaptureInterval = new LongActuator(this.DISPLAY_TOPIC, "codogramCaptureInterval", Text.Update_n_Interval);
    private Vector limitsToggles = new Vector();
    private FrequencyActuator freqErrorLowerLimit = new FrequencyActuator(this.DISPLAY_TOPIC, "freqErrorLowerLimit", Text.Low_Limit);
    private FrequencyActuator freqErrorUpperLimit = new FrequencyActuator(this.DISPLAY_TOPIC, "freqErrorUpperLimit", Text.High_Limit);
    private LongActuator timeOffsetLowerLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "timeOffsetLowerLimit", Text.Low_Limit, "usec", 1000);
    private LongActuator timeOffsetUpperLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "timeOffsetUpperLimit", Text.High_Limit, "usec", 1000);
    private LongActuator idleOnOffPowerRatioLowerLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "idleOnOffPowerRatioLowerLimit", Text.Low_Limit, "dB", 1000);
    private LongActuator pilotRhoLowerLimit = LongActuator.createEstRho(this.DISPLAY_TOPIC, "pilotRhoLowerLimit", Text.Low_Limit, " ", 100000);
    private LongActuator macRhoLowerLimit = LongActuator.createEstRho(this.DISPLAY_TOPIC, "macRhoLowerLimit", Text.Low_Limit, " ", 100000);
    private LongActuator maxInactiveMACHighLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "maxInactiveMACHighLimit", Text.High_MAC_n_Limit, "dB", 1000);
    private LongActuator maxInactivePilotHighLimit = LongActuator.createDecimal(this.DISPLAY_TOPIC, "maxInactivePilotHighLimit", Text.High_Pilot_n_Limit, "dB", 1000);
    private ListActuator cdpMetrics = new ListActuator(this.TOPIC, "cdpMetrics", Text.Cdp_Metrics, this.createOnOffValueSet());
    private ListActuator otaPNScanner = new ListActuator(this.TOPIC, "pnScanner", Text.OTA_PN_n_Scanner, this.createOnOffValueSet());
    private LongActuator pilotDominance = LongActuator.createPower(this.TOPIC, "minPltDom", Text.Plt_Dom);
    private LongActuator multipathPower = LongActuator.createPower(this.TOPIC, "maxMp", Text.Mp_Pwr);
    private ListActuator pnScannerSensitivity = new ListActuator(this.TOPIC, "pnScannerSensitivity", Text.PN_Scanner_n_Sensitivity, new Value[]{Value.createValue(Text.Low, 0), Value.createValue(Text.Med, 1), Value.createValue(Text.High, 2)});

    public CommonCdma1xevMeasurementSettings(String string) {
        super(string);
        this.add(this.thresholdLevel);
        this.add(this.thresholdAuto);
        this.add(this.pnOffsetManual);
        this.add(this.pnOffsetAuto);
        this.add(this.pnInc);
        this.add(this.averaging);
        this.add(this.numAverages);
        this.add(this.threshOffset);
        this.add(this.centerFreq);
        this.add(this.measTime);
        this.add(this.reference);
        this.add(this.scaleDiv);
        this.add(this.rfInLoss);
        this.add(this.slotThresholdLevel);
        this.add(this.cdpType);
        this.add(this.macCdpXAxis);
        this.add(this.measOffset);
        this.add(this.codogramEnabled);
        this.add(this.codogramPalette);
        this.add(this.codogramCaptureInterval);
        this.add(this.freqErrorLowerLimit);
        this.add(this.freqErrorUpperLimit);
        this.add(this.timeOffsetLowerLimit);
        this.add(this.timeOffsetUpperLimit);
        this.add(this.idleOnOffPowerRatioLowerLimit);
        this.add(this.pilotRhoLowerLimit);
        this.add(this.macRhoLowerLimit);
        this.add(this.maxInactiveMACHighLimit);
        this.add(this.maxInactivePilotHighLimit);
        this.add(this.cdpMetrics);
        this.add(this.otaPNScanner);
        this.add(this.pilotDominance);
        this.add(this.multipathPower);
        this.add(this.pnScannerSensitivity);
        this.thresholdLevel.setConversion(new FactorConversion("dB", 1000L));
        this.thresholdLevel.setPalette(Palette.createSignedInteger());
        this.thresholdLevel.setValidator(new RangeValidator(-45000L, 0L));
        this.thresholdLevel.setIncrement(1000);
        this.pnOffsetManual.setValidator(new RangeValidator(0L, 511L));
        this.pnInc.setValidator(new RangeValidator(1L, 15L));
        this.threshOffset.setValidator(new RangeValidator(-20000L, 20000L));
        this.threshOffset.setConversion(new FactorConversion("dB", 1000L));
        this.threshOffset.setPalette(Palette.createSignedInteger());
        this.threshOffset.setIncrement(1000);
        this.slotThresholdLevel.setConversion(new FactorConversion("dB", 1000L));
        this.slotThresholdLevel.setPalette(Palette.createSignedInteger());
        this.slotThresholdLevel.setValidator(new RangeValidator(-100000L, 0L));
        this.slotThresholdLevel.setIncrement(1000);
        this.measOffset.setValidator(new RangeValidator(0L, 15L));
        this.setValidatorToFreqCalLimits(this.centerFreq);
        this.makeStashedLossActuatorSet(DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.rfInLoss, DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), string + ".RfInLossListener");
        new FreqChanActuatorConfigurator(this.centerFreq, this.globalDisplaySettings.getChanFreqUnits(), this.globalDisplaySettings.getChanStd(), this.globalDisplaySettings.getChannelStep(), this.globalDisplaySettings.getFrequencyStep(), BandSelector.getGlobalBandSelector(), string + ".cfListener");
        this.freqErrorLowerLimit.addValueListener(new Cdma1xevValueListener(KEY_FREQ_ERROR_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdma1xevMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdma1xevMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.freqErrorUpperLimit.addValueListener(new Cdma1xevValueListener(KEY_FREQ_ERROR_UP_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdma1xevMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdma1xevMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.timeOffsetLowerLimit.addValueListener(new Cdma1xevValueListener(KEY_TIME_OFFSET_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdma1xevMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdma1xevMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.timeOffsetUpperLimit.addValueListener(new Cdma1xevValueListener(KEY_TIME_OFFSET_UP_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdma1xevMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdma1xevMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.idleOnOffPowerRatioLowerLimit.addValueListener(new Cdma1xevValueListener(KEY_ON_OFF_PWR_RATIO_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdma1xevMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdma1xevMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.pilotRhoLowerLimit.addValueListener(new Cdma1xevValueListener(KEY_PILOT_RHO_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdma1xevMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdma1xevMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.macRhoLowerLimit.addValueListener(new Cdma1xevValueListener(KEY_MAC_RHO_LOW_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdma1xevMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdma1xevMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.maxInactiveMACHighLimit.addValueListener(new Cdma1xevValueListener(KEY_MAX_INACTIVE_MAC_HIGH_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdma1xevMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdma1xevMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.maxInactivePilotHighLimit.addValueListener(new Cdma1xevValueListener(KEY_MAX_INACTIVE_PILOT_HIGH_LIMIT){

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonCdma1xevMeasurementSettings.this.doingLimitSetAll) {
                    CommonCdma1xevMeasurementSettings.this.setAllLimits();
                }
            }
        });
        RangeValidator rangeValidator = new RangeValidator(0L, Integer.MAX_VALUE);
        this.codogramCaptureInterval.setUnitsFactory(new MeasurementSettings.UpdateIntervalUnitSystem());
        this.codogramCaptureInterval.setValidator(rangeValidator);
        this.pilotDominance.setConversion(new FactorConversion("dB", 1000L));
        this.pilotDominance.setValidator(new RangeValidator(0L, 20000L));
        this.pilotDominance.setIncrement(100);
        this.multipathPower.setConversion(new FactorConversion("dB", 1000L));
        this.multipathPower.setValidator(new RangeValidator(0L, 2000L));
        this.multipathPower.setIncrement(10);
    }

    protected int getNumberOfBars() {
        switch (this.cdpType.intValue()) {
            case 0: {
                this.numberOfBars = 128;
                break;
            }
            case 2: {
                this.numberOfBars = 32;
                break;
            }
            case 3: {
                this.numberOfBars = 16;
                break;
            }
            default: {
                this.numberOfBars = 64;
            }
        }
        return this.numberOfBars;
    }

    public LongActuator[] getStorableActuators() {
        return new LongActuator[]{this.freqErrorLowerLimit, this.freqErrorUpperLimit, this.timeOffsetLowerLimit, this.timeOffsetUpperLimit, this.idleOnOffPowerRatioLowerLimit, this.pilotRhoLowerLimit, this.macRhoLowerLimit, this.maxInactiveMACHighLimit, this.maxInactivePilotHighLimit};
    }

    public void allowValidationNow() {
        this.doingLimitSetAll = false;
    }

    public void setAllLimits() {
        if (MeasurementSettings.suspendValidation) {
            return;
        }
        this.doingLimitSetAll = true;
        this.freqErrorLowerLimit.setValidator(new RangeValidator(Long.MIN_VALUE, 0L));
        this.freqErrorUpperLimit.setValidator(new RangeValidator(0L, Long.MAX_VALUE));
        this.timeOffsetLowerLimit.setValidator(new RangeValidator(-1000000L, 1000000L));
        this.timeOffsetUpperLimit.setValidator(new RangeValidator(-1000000L, 1000000L));
        this.pilotRhoLowerLimit.setValidator(new RangeValidator(0L, 100000L));
        this.macRhoLowerLimit.setValidator(new RangeValidator(0L, 100000L));
        RangeValidator rangeValidator = new RangeValidator(-200000L, 200000L);
        this.idleOnOffPowerRatioLowerLimit.setValidator(rangeValidator);
        this.maxInactiveMACHighLimit.setValidator(rangeValidator);
        this.maxInactivePilotHighLimit.setValidator(rangeValidator);
        this.doingLimitSetAll = false;
    }

    public LongActuator getThresholdLevel() {
        return this.thresholdLevel;
    }

    public ListActuator getAutoThreshold() {
        return this.thresholdAuto;
    }

    public LongActuator getPnOffsetManual() {
        return this.pnOffsetManual;
    }

    public ListActuator getPnOffsetAuto() {
        return this.pnOffsetAuto;
    }

    public LongActuator getPnInc() {
        return this.pnInc;
    }

    public LongActuator getThreshOffset() {
        return this.threshOffset;
    }

    public FrequencyActuator getCenterFreq() {
        return this.centerFreq;
    }

    public ListActuator getAveraging() {
        return this.averaging;
    }

    public LongActuator getNumAverages() {
        return this.numAverages;
    }

    public ListActuator getMeasTime() {
        return this.measTime;
    }

    public ListActuator getReference() {
        return this.reference;
    }

    public boolean isRelative() {
        return this.reference.intValue() == 0;
    }

    public LongActuator getScaleDiv() {
        return this.scaleDiv;
    }

    public LongActuator getRfInLoss() {
        return this.rfInLoss;
    }

    public LongActuator getSlotThresholdLevel() {
        return this.slotThresholdLevel;
    }

    public LongActuator getMeasOffset() {
        return this.measOffset;
    }

    public ListActuator getCdpType() {
        return this.cdpType;
    }

    public ListActuator getMacCdpXAxis() {
        return this.macCdpXAxis;
    }

    public ListActuator getCodogramEnabled() {
        return this.codogramEnabled;
    }

    public ListActuator getCodogramPalette() {
        return this.codogramPalette;
    }

    public LongActuator getCodogramCaptureInterval() {
        return this.codogramCaptureInterval;
    }

    public ListActuator limitsToggleAt(int n) {
        ListActuator listActuator;
        this.limitsToggles.setSize(6);
        try {
            listActuator = (ListActuator)this.limitsToggles.elementAt(n);
            if (listActuator == null) {
                listActuator = new ListActuator(this.DISPLAY_TOPIC, "limitsToggle" + n, Text.Limits, this.createOnOffValueSet());
                listActuator.setValue(0);
                this.add(listActuator);
                listActuator.addValueListener(new Cdma1xevValueListener("limitsToggle" + n){

                    public void valueChanged(ValueInterface valueInterface) {
                        CommonCdma1xevMeasurementSettings.this.setAllLimits();
                        CommonCdma1xevMeasurementSettings.this.bLimitsSummaryState = CommonCdma1xevMeasurementSettings.this.bLimitsSummaryState && valueInterface.booleanValue();
                    }
                });
                listActuator.setValue(0);
                this.limitsToggles.setElementAt(listActuator, n);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            listActuator = null;
        }
        return listActuator;
    }

    public FrequencyActuator getFreqErrorUpperLimit() {
        return this.freqErrorUpperLimit;
    }

    public FrequencyActuator getFreqErrorLowerLimit() {
        return this.freqErrorLowerLimit;
    }

    public LongActuator getTimeOffsetUpperLimit() {
        return this.timeOffsetUpperLimit;
    }

    public LongActuator getTimeOffsetLowerLimit() {
        return this.timeOffsetLowerLimit;
    }

    public LongActuator getPilotRhoLowerLimit() {
        return this.pilotRhoLowerLimit;
    }

    public LongActuator getMacRhoLowerLimit() {
        return this.macRhoLowerLimit;
    }

    public LongActuator getIdleOnOffPowerRatioLowerLimit() {
        return this.idleOnOffPowerRatioLowerLimit;
    }

    public LongActuator getMaxInactiveMACHighLimit() {
        return this.maxInactiveMACHighLimit;
    }

    public LongActuator getMaxInactivePilotHighLimit() {
        return this.maxInactivePilotHighLimit;
    }

    public boolean getLimitsSummaryState() {
        this.bLimitsSummaryState = false;
        if (this.cdpMetrics.booleanValue() || this.limitsToggleAt(1).booleanValue()) {
            for (int i = 0; i < 6; ++i) {
                if (this.limitsToggleAt(i).getSelectedValue().longValue() != 1L) continue;
                this.bLimitsSummaryState = true;
                break;
            }
        }
        return this.bLimitsSummaryState;
    }

    public ListActuator getCdpMetrics() {
        return this.cdpMetrics;
    }

    public void setCdpMetrics(int n) {
        this.cdpMetrics.send(n);
    }

    public ListActuator getOTAPNScanner() {
        return this.otaPNScanner;
    }

    public void setOtaPNScanner(int n) {
        this.otaPNScanner.send(n);
    }

    public LongActuator getPilotDominance() {
        return this.pilotDominance;
    }

    public LongActuator getMultipathPower() {
        return this.multipathPower;
    }

    public ListActuator getPNScannerSensitivity() {
        return this.pnScannerSensitivity;
    }

    protected abstract class Cdma1xevValueListener
    implements ValueListener {
        private final String listenerName;

        public Cdma1xevValueListener(String string) {
            this.listenerName = CommonCdma1xevMeasurementSettings.this.TOPIC + "." + string + ".listener";
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public abstract /* synthetic */ void valueChanged(ValueInterface var1);
    }
}

