/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.channelScanner;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.readings.IntegerArrayReadingField;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.units.ChannelFrequencyConversion;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.FormatLabel;
import elgato.measurement.channelScanner.ChannelScannerChart;
import elgato.measurement.channelScanner.ChannelScannerMeasurement;
import elgato.measurement.channelScanner.ChannelScannerMeasurementSettings;
import elgato.measurement.channelScanner.ChannelScannerScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class ChannelScannerAnalyzer
extends TraceAnalyzer {
    static final int DISPVALUE_OFF = 0;
    static final int DISPVALUE_FREQ = 1;
    static final int DISPVALUE_PWR = 2;
    private ChannelScannerMeasurement measurement;
    private Component pane;
    private ChannelScannerChart chart;

    protected ChannelScannerAnalyzer() {
        super("ChScanAn");
        this.listenToActuator(this.getRefLevel());
        this.listenToActuator(this.getScaleDiv());
        JPanel jPanel = new JPanel();
        ((Component)jPanel).setBackground(null);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new TableLayout(new float[][]{{0.333f, -1.0f, 0.333f}, {-2.0f, -2.0f}}));
        ((Component)jPanel2).setBackground(null);
        jPanel2.add((Component)this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return "Ref " + ChannelScannerMeasurementSettings.instance().getRefLevel().getConversion().toString(ChannelScannerAnalyzer.this.getRefLevel().intValue());
            }
        }), "0,0");
        jPanel2.add((Component)this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return UIHelper.formatFixed(ChannelScannerAnalyzer.this.getScaleDiv().intValue(), 0) + " dB/";
            }
        }), "0,1");
        jPanel2.add((Component)this.addLabel(new FormatLabel(ChannelScannerMeasurementSettings.instance().getFormatType(), ChannelScannerMeasurementSettings.instance().getFormatList())), "1,1");
        jPanel2.add((Component)this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                ChannelScannerMeasurement channelScannerMeasurement = (ChannelScannerMeasurement)measurement;
                return Text.RF_IN_Loss + " " + new DecibelStrategy(1, false).format(channelScannerMeasurement.getAttenuation());
            }
        }), "2,1");
        jPanel.add((Component)jPanel2, "North");
        this.chart = new ChannelScannerChart();
        this.chart.addDLabel(new TraceAnalyzer.AverageDynamicLabel(ChannelScannerMeasurement.AVERAGE_TYPE, ChannelScannerMeasurement.NUM_AVERAGES, ChannelScannerMeasurement.AVERAGE_COUNT), -12, 20);
        this.chart.addDLabel(new TraceAnalyzer.RangeControlDynamicLabel(ChannelScannerMeasurement.RANGE_HOLD, ChannelScannerMeasurement.RANGE_SETTING), 12, 20);
        this.updateChartVerticalRange();
        jPanel.add((Component)this.chart, "Center");
        this.pane = new BorderWrapper(jPanel, TraceAnalyzer.getChartBorder(), true);
    }

    public MeasurementMetrics getMeasurementMetrics() {
        return null;
    }

    private LongActuator getRefLevel() {
        return ChannelScannerMeasurementSettings.instance().getRefLevel();
    }

    private LongActuator getScaleDiv() {
        return ChannelScannerMeasurementSettings.instance().getScaleDiv();
    }

    public void updateChartVerticalRange() {
        this.chart.setVerticalRange(this.getRefLevel().intValue(), this.getRefLevel().intValue() - this.getScaleDiv().intValue() * 10);
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected void setMeasurement(Measurement measurement) {
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        this.measurement = (ChannelScannerMeasurement)measurement;
    }

    protected Component getPane() {
        return this.pane;
    }

    protected TraceChart getChart() {
        return this.chart;
    }

    protected TraceChart[] getCharts() {
        return new TraceChart[]{this.getChart()};
    }

    public TabDelimitable[] createReadingFields() {
        ChannelScannerMeasurement channelScannerMeasurement = (ChannelScannerMeasurement)this.getMeasurement();
        int n = channelScannerMeasurement.getNumChannels();
        int n2 = 4;
        int n3 = 0;
        TabDelimitable[] tabDelimitableArray = new TabDelimitable[n + n2];
        tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("Bar Count\t" + String.valueOf(n));
        tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("Bar #\tChannel #\t\tFrequency\t\tLevel\t\tFreq Error");
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            String string;
            IntegerArrayReadingField integerArrayReadingField;
            IntegerArrayReadingField integerArrayReadingField2;
            FrequencyToChannelReadingField frequencyToChannelReadingField;
            if (ChannelScannerMeasurementSettings.instance().getScanMode().intValue() == 1) {
                frequencyToChannelReadingField = new FrequencyToChannelReadingField("Channel " + (n4 + 1) + " Chan", ChannelScannerMeasurement.FREQUENCY_LIST, n4, true);
                IntegerArrayReadingField integerArrayReadingField3 = new IntegerArrayReadingField(channelScannerMeasurement, "Channel " + (n4 + 1) + " Freq", "MHz", ChannelScannerMeasurement.FREQUENCY_LIST, n4, 10000.0f, 3);
                integerArrayReadingField2 = new IntegerArrayReadingField(channelScannerMeasurement, "Channel " + (n4 + 1) + " Level", "dBm", ChannelScannerMeasurement.CHANNEL_POWER_TRACE, n4, 1000.0f, 1);
                integerArrayReadingField = new IntegerArrayReadingField(channelScannerMeasurement, "Channel " + (n4 + 1) + " Freq Error", "kHz", ChannelScannerMeasurement.CHANNEL_FREQ_ERROR_TRACE, n4, 1000.0f, 1);
                string = String.valueOf(n4 + 1) + '\t' + String.valueOf(frequencyToChannelReadingField.getValue()) + '\t' + String.valueOf(frequencyToChannelReadingField.getUnits()) + '\t' + String.valueOf(integerArrayReadingField3.getValue()) + '\t' + String.valueOf(integerArrayReadingField3.getUnits()) + '\t' + String.valueOf(integerArrayReadingField2.getValue()) + '\t' + String.valueOf(integerArrayReadingField2.getUnits()) + '\t' + String.valueOf(integerArrayReadingField.getValue()) + '\t' + String.valueOf(integerArrayReadingField.getUnits());
                tabDelimitableArray[n3++] = new TraceSaveTabDelimitable(string);
            } else {
                frequencyToChannelReadingField = new FrequencyToChannelReadingField("Channel " + (n4 + 1) + " Chan", ChannelScannerMeasurement.FREQUENCY_LIST, n4, false);
                ChannelScannerFrequencyReadingField channelScannerFrequencyReadingField = new ChannelScannerFrequencyReadingField("Channel " + (n4 + 1) + " Freq", "MHz", ChannelScannerMeasurement.FREQUENCY_LIST, n4, 1000000.0, 3);
                integerArrayReadingField2 = new IntegerArrayReadingField(channelScannerMeasurement, "Channel " + (n4 + 1) + " Level", "dBm", ChannelScannerMeasurement.CHANNEL_POWER_TRACE, n4, 1000.0f, 1);
                integerArrayReadingField = new IntegerArrayReadingField(channelScannerMeasurement, "Channel " + (n4 + 1) + " Freq Error", "kHz", ChannelScannerMeasurement.CHANNEL_FREQ_ERROR_TRACE, n4, 1000.0f, 1);
                string = String.valueOf(n4 + 1) + '\t' + String.valueOf(frequencyToChannelReadingField.getValue()) + '\t' + String.valueOf(frequencyToChannelReadingField.getUnits()) + '\t' + String.valueOf(channelScannerFrequencyReadingField.getValue()) + '\t' + String.valueOf(channelScannerFrequencyReadingField.getUnits()) + '\t' + String.valueOf(integerArrayReadingField2.getValue()) + '\t' + String.valueOf(integerArrayReadingField2.getUnits()) + '\t' + String.valueOf(integerArrayReadingField.getValue()) + '\t' + String.valueOf(integerArrayReadingField.getUnits());
                tabDelimitableArray[n3++] = new TraceSaveTabDelimitable(string);
            }
            ++n4;
            n5 += 4;
        }
        TabDelimitable tabDelimitable = new TabDelimitable(){

            public String toTabDelimitedString() {
                return Text.Channel_Standard + "\t" + ChannelScannerMeasurementSettings.instance().getChanStd().getSelectedValue().getLongLabel();
            }
        };
        tabDelimitableArray[n3++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n3++] = tabDelimitable;
        return tabDelimitableArray;
    }

    public NumberFieldStrategy getYAxisNormalStrategy() {
        throw new RuntimeException("not implemented");
    }

    public NumberFieldStrategy getYAxisDeltaStrategy() {
        throw new RuntimeException("not implemented");
    }

    public NumberFieldStrategy getXAxisStrategy() {
        throw new RuntimeException("not implemented");
    }

    class ChannelScannerFrequencyReadingField
    extends ReadingField {
        private double divisor;
        private int decimalPlace;
        private int channelIndex;

        public ChannelScannerFrequencyReadingField(String string, String string2, int n, int n2, double d, int n3) {
            super(string, string2, n);
            this.divisor = d;
            this.decimalPlace = n3;
            this.channelIndex = n2;
        }

        public String getValue() {
            double d = (double)(ChannelScannerMeasurementSettings.instance().getStartFreq().intValue() + ChannelScannerMeasurementSettings.instance().getStepSize().intValue() * this.channelIndex) / this.divisor;
            return this.formatValue(d, this.decimalPlace);
        }
    }

    class FrequencyToChannelReadingField
    extends ReadingField {
        private ChannelFrequencyConversion fwdConversion = ChannelFrequencyConversion.createForward(ChannelScannerScreen.BAND_SELECTOR);
        private ChannelFrequencyConversion revConversion = ChannelFrequencyConversion.createReverse(ChannelScannerScreen.BAND_SELECTOR);
        private int arrayIndex;
        private boolean isMeasuremnt;

        public FrequencyToChannelReadingField(String string, int n, int n2, boolean bl) {
            super(string, null, n);
            this.arrayIndex = n2;
            this.isMeasuremnt = bl;
        }

        public String getValue() {
            return this.getParsedChannelString()[0];
        }

        public String getUnits() {
            return this.getParsedChannelString()[1];
        }

        private String[] getParsedChannelString() {
            long l = this.getFrequencyInHz();
            String[] stringArray = new String[2];
            ChannelFrequencyConversion channelFrequencyConversion = this.isForwardChannel(l) ? this.fwdConversion : this.revConversion;
            UIHelper.split(channelFrequencyConversion.getChannelValue(l), ' ', stringArray);
            return stringArray;
        }

        private boolean isForwardChannel(long l) {
            return Band.getCurrentBand(ChannelScannerScreen.BAND_SELECTOR).isFrequencyFwdChannel(l);
        }

        private long getFrequencyInHz() {
            long l = this.isMeasuremnt ? (long)ChannelScannerAnalyzer.this.getMeasurement().getIntegerArrayReadingValue(this.getReadingIndex(), this.arrayIndex) * 100L : (long)(ChannelScannerMeasurementSettings.instance().getStartFreq().intValue() + ChannelScannerMeasurementSettings.instance().getStepSize().intValue() * this.arrayIndex);
            return l;
        }
    }
}

