/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.channelScanner;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.analyzer.BarChart;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.FrequencyToChannelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.Value;
import elgato.measurement.channelScanner.ChannelScannerMeasurement;
import elgato.measurement.channelScanner.ChannelScannerMeasurementSettings;
import elgato.measurement.channelScanner.ChannelScannerScreen;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;

class ChannelScannerChart
extends BarChart {
    private static final Resources res = Resources.getResources((class$elgato$measurement$channelScanner$ChannelScannerChart == null ? (class$elgato$measurement$channelScanner$ChannelScannerChart = ChannelScannerChart.class$("elgato.measurement.channelScanner.ChannelScannerChart")) : class$elgato$measurement$channelScanner$ChannelScannerChart).getName());
    private ChannelScannerMeasurementSettings instance = ChannelScannerMeasurementSettings.instance();
    private static final Font YAXIS_FONT = res.getFont("yaxisFont");
    private static final Color YAXIS_COLOR = res.getColor("yaxisColor");
    private static final Color BAR_COLOR = new Color(1057016);
    private static final Color BAR_COLOR_INVALID = new Color(16719920);
    private static final Color BAR_COLOR_VALID = new Color(63488);
    private static final int TOP_OF_BAR_SPACE = 2;
    private static final int INVALID = 0;
    private static final int VALID = 1;
    private static final int NONE = 2;
    static final int GRID_DIVISIONS = 10;
    private final NumberFieldStrategy frequencyFormatter = new FrequencyStrategy();
    private final NumberFieldStrategy frequencyErrorFormatter = FrequencyStrategy.createMillihertzFrequencyStrategy();
    private final NumberFieldStrategy channelFormatter = new FrequencyToChannelStrategy(Value.createValue("", 1), ChannelScannerScreen.BAND_SELECTOR);
    private final String[] result = new String[2];
    static /* synthetic */ Class class$elgato$measurement$channelScanner$ChannelScannerChart;

    ChannelScannerChart() {
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4) {
        Font font = graphics.getFont();
        ChannelScannerMeasurement channelScannerMeasurement = (ChannelScannerMeasurement)this.getMeasurement();
        int n5 = channelScannerMeasurement.getNumChannels();
        int[] nArray = channelScannerMeasurement.getChannelPowerTrace();
        int[] nArray2 = channelScannerMeasurement.getChannelFreqErrorTrace();
        int n6 = this.getYTop();
        int n7 = this.getYBottom() - n6;
        if (n4 == 0 || n7 == 0) {
            return;
        }
        graphics.setFont(YAXIS_FONT);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n8 = this.getUnitBarWidth();
        int n9 = this.getSlotSpacing();
        int n10 = ChannelScannerMeasurementSettings.instance().getDispValue().intValue();
        Conversion conversion = ChannelScannerMeasurementSettings.instance().getRefLevel().getConversion();
        String[] stringArray = this.createBarLabels(channelScannerMeasurement, n8, n5, fontMetrics);
        int n11 = n;
        for (int i = 0; i < n5; ++i) {
            int n12 = (nArray[i] - n6) * n4 / n7;
            Image image = null;
            graphics.setColor(BAR_COLOR);
            if (this.instance.getPowerLimitsToggle().getSelectedValue().longValue() == 1L && this.instance.getDispValue().longValue() == 2L) {
                if ((long)nArray[i] > this.instance.getPowerHighLimit().longValue() || (long)nArray[i] < this.instance.getPowerLowLimit().longValue()) {
                    graphics.setColor(BAR_COLOR_INVALID);
                    image = TraceChart.failImage;
                } else {
                    graphics.setColor(BAR_COLOR_VALID);
                    image = TraceChart.passImage;
                }
                graphics.drawImage(image, n11 + n8 / 2 - 8, n2 + n12 - 2 - 45, null);
            } else if (this.instance.getFrequencyLimitsToggle().getSelectedValue().longValue() == 1L) {
                if (this.determineFrequencyValid(nArray2, i) == 0) {
                    graphics.setColor(BAR_COLOR_INVALID);
                    image = TraceChart.failImage;
                } else if (this.determineFrequencyValid(nArray2, i) == 1) {
                    graphics.setColor(BAR_COLOR_VALID);
                    image = TraceChart.passImage;
                }
            }
            if (image != null) {
                graphics.drawImage(image, n11 + n8 / 2 - 8, n2 + n12 - 2 - 45, null);
            }
            this.setColorForFreq(nArray2, i, graphics);
            graphics.fillRect(n11, n2 + n12, n8, n4 - n12);
            int n13 = n2 + n4 + 1;
            graphics.setColor(YAXIS_COLOR);
            this.result[0] = stringArray[2 * i];
            this.result[1] = stringArray[2 * i + 1];
            TraceChart.drawCenteredStrings(graphics, n11, n13, n8, this.result);
            if (n10 != 0) {
                if (n10 == 1) {
                    this.frequencyErrorFormatter.formatWithUnits(nArray2[i], this.result);
                } else if (n10 == 2) {
                    UIHelper.split(conversion.toString(nArray[i]), ' ', this.result);
                } else {
                    throw new RuntimeException("Unknown dispValue type: " + n10);
                }
                this.setColorForFreq(nArray2, i, graphics);
                TraceChart.drawCenteredStringsBottomJustified(graphics, n11, n2 + n12 - 2, n8, this.result, n2, n2 + n4);
            }
            n11 += n8 + n9;
        }
        graphics.setFont(font);
    }

    private void setColorForFreq(int[] nArray, int n, Graphics graphics) {
        if (this.determineFrequencyValid(nArray, n) == 0) {
            graphics.setColor(BAR_COLOR_INVALID);
        } else if (this.determineFrequencyValid(nArray, n) == 1) {
            graphics.setColor(BAR_COLOR_VALID);
        }
    }

    private int determineFrequencyValid(int[] nArray, int n) {
        if (this.instance.getFrequencyLimitsToggle().getSelectedValue().longValue() == 1L && this.instance.getDispValue().longValue() == 1L) {
            if ((long)nArray[n] > this.instance.getFrequencyHighLimit().longValue() * 1000L || (long)nArray[n] < this.instance.getFrequencyLowLimit().longValue() * 1000L) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    private NumberFieldStrategy getFreqChanStrategy() {
        ListActuator listActuator = ChannelScannerMeasurementSettings.instance().getFreqChanUnits();
        if (listActuator.intValue() == 0) {
            return this.frequencyFormatter;
        }
        return this.channelFormatter;
    }

    protected Font getXAxisFont() {
        return YAXIS_FONT;
    }

    protected int getXAxisRows() {
        return 2;
    }

    protected int getSlotCount() {
        return ((ChannelScannerMeasurement)this.getMeasurement()).getNumChannels();
    }

    protected int getSlotSpacing() {
        return 120 / this.getSlotCount();
    }

    String[] createBarLabels(ChannelScannerMeasurement channelScannerMeasurement, int n, int n2, FontMetrics fontMetrics) {
        NumberFieldStrategy numberFieldStrategy = this.getFreqChanStrategy();
        String[] stringArray = new String[n2 * 2];
        int n3 = n;
        block0: for (int i = 0; i < n2; ++i) {
            int n4;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                stringArray[n4] = "";
            }
            for (n4 = 0; n4 < n2; n4 += i + 1) {
                long l = channelScannerMeasurement.getFrequencyForChannel(n4);
                numberFieldStrategy.formatWithUnits(l, this.result);
                stringArray[n4 * 2] = this.result[0];
                stringArray[n4 * 2 + 1] = this.result[1];
                if (fontMetrics.stringWidth(this.result[0]) <= n3) continue;
                n3 += n;
                continue block0;
            }
        }
        return stringArray;
    }

    protected void showLimits(Graphics graphics, int n, int n2) {
        Insets insets = this.getInsets();
        ChannelScannerMeasurementSettings channelScannerMeasurementSettings = ChannelScannerMeasurementSettings.instance();
        double d = this.getYTop();
        double d2 = (double)this.getYBottom() - d;
        double d3 = ((double)channelScannerMeasurementSettings.getPowerHighLimit().longValue() - d) * (double)(n2 -= insets.top + insets.bottom + 1) / d2;
        graphics.setColor(Color.yellow);
        this.setManualXRange(true);
        if (channelScannerMeasurementSettings.getPowerLimitsToggle().getSelectedValue().longValue() == 1L) {
            graphics.drawLine(insets.left, (int)d3, n - insets.right - 1, (int)d3);
            d3 = ((double)ChannelScannerMeasurementSettings.instance().getPowerLowLimit().longValue() - d) * (double)n2 / d2;
            graphics.drawLine(insets.left, (int)d3, n - insets.right - 1, (int)d3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

