/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.channelScanner;

import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import java.io.DataInput;
import java.io.IOException;

public class ChannelScannerMeasurement
extends TraceMeasurement {
    private static final long serialVersionUID = -8610619437180698168L;
    private static final Queue pool = new Queue(3);
    public static final int SCANTYPE_RANGE = 0;
    public static final int SCANTYPE_LIST = 1;
    private IntegerReading numChannels = new IntegerReading();
    private final IntegerArrayReading channelPowerTrace = new IntegerArrayReading(40);
    private final IntegerArrayReading channelFreqErrorTrace = new IntegerArrayReading(40);
    private IntegerReading scanType = new IntegerReading();
    private IntegerReading attenuation = new IntegerReading();
    private IntegerReading channelWidth = new IntegerReading();
    private IntegerReading measurementTime = new IntegerReading();
    private IntegerReading startCenterFreq = new IntegerReading();
    private IntegerReading stepSize = new IntegerReading();
    private IntegerReading rangeChannelCount = new IntegerReading();
    private final IntegerArrayReading frequencyList = new IntegerArrayReading(40);
    private IntegerReading averageType = new IntegerReading();
    private IntegerReading numAverages = new IntegerReading();
    private IntegerReading sensitivity = new IntegerReading();
    private IntegerReading peakPower = new IntegerReading();
    private IntegerReading rangeHold = new IntegerReading();
    private IntegerReading chanCfOffset = new IntegerReading();
    private IntegerReading noiseCorrection = new IntegerReading();
    private IntegerReading rangeSetting = new IntegerReading();
    private IntegerReading averageCount = new IntegerReading();
    private IntegerReading rangeUpDown = new IntegerReading();
    private static int readingCount = 0;
    public static final int NUM_CHANNELS = readingCount++;
    public static final int CHANNEL_POWER_TRACE = readingCount++;
    public static final int CHANNEL_FREQ_ERROR_TRACE = readingCount++;
    public static final int SCAN_TYPE = readingCount++;
    public static final int ATTENUATION = readingCount++;
    public static final int CHANNELWIDTH = readingCount++;
    public static final int MEASUREMENT_TIME = readingCount++;
    public static final int START_CENTER_FREQ = readingCount++;
    public static final int STEP_SIZE = readingCount++;
    public static final int RANGE_CHANNEL_COUNT = readingCount++;
    public static final int FREQUENCY_LIST = readingCount++;
    public static final int AVERAGE_TYPE = readingCount++;
    public static final int NUM_AVERAGES = readingCount++;
    public static final int SENSITIVITY = readingCount++;
    public static final int PEAK_POWER = readingCount++;
    public static final int RANGE_HOLD = readingCount++;
    public static final int CHAN_CF_OFFSET = readingCount++;
    public static final int NOISE_CORRECTION = readingCount++;
    public static final int RANGE_SETTING = readingCount++;
    public static final int AVERAGE_COUNT = readingCount++;
    public static final int RANGE_UPDOWN = readingCount++;
    private Reading[] readings = new Reading[]{this.numChannels, this.channelPowerTrace, this.channelFreqErrorTrace, this.scanType, this.attenuation, this.channelWidth, this.measurementTime, this.startCenterFreq, this.stepSize, this.rangeChannelCount, this.frequencyList, this.averageType, this.numAverages, this.sensitivity, this.peakPower, this.rangeHold, this.chanCfOffset, this.noiseCorrection, this.rangeSetting, this.averageCount, this.rangeUpDown};

    protected ChannelScannerMeasurement() {
    }

    public Reading[] getReadings() {
        return this.readings;
    }

    public static ChannelScannerMeasurement unpack(DataInput dataInput) throws IOException {
        ChannelScannerMeasurement channelScannerMeasurement = ChannelScannerMeasurement.create();
        Reading[] readingArray = channelScannerMeasurement.getReadings();
        for (int i = 0; i < readingArray.length; ++i) {
            readingArray[i].unpack(dataInput);
        }
        return channelScannerMeasurement;
    }

    private static ChannelScannerMeasurement create() {
        ChannelScannerMeasurement channelScannerMeasurement = (ChannelScannerMeasurement)pool.dequeue();
        if (channelScannerMeasurement == null) {
            return new ChannelScannerMeasurement();
        }
        return channelScannerMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int[] getTrace() {
        return this.channelPowerTrace.getTrace();
    }

    public int getTraceLength() {
        return this.numChannels.intValue();
    }

    public int getNumChannels() {
        return this.numChannels.intValue();
    }

    public int[] getChannelPowerTrace() {
        return this.channelPowerTrace.getTrace();
    }

    public int[] getChannelFreqErrorTrace() {
        return this.channelFreqErrorTrace.getTrace();
    }

    public int getScanType() {
        return this.scanType.intValue();
    }

    public int getAttenuation() {
        return this.attenuation.intValue();
    }

    public int getChannelWidth() {
        return this.channelWidth.intValue();
    }

    public int getMeasurementTime() {
        return this.measurementTime.intValue();
    }

    public int getStartCenterFreq() {
        return this.startCenterFreq.intValue();
    }

    public int getStepSize() {
        return this.stepSize.intValue();
    }

    public int getRangeChannelCount() {
        return this.rangeChannelCount.intValue();
    }

    public int[] getFrequencyList() {
        return this.frequencyList.getTrace();
    }

    public int getAverageType() {
        return this.averageType.intValue();
    }

    public int getNumAverages() {
        return this.numAverages.intValue();
    }

    public IntegerArrayReading getChannelPowerTraceReading() {
        return this.channelPowerTrace;
    }

    public IntegerArrayReading getChannelFreqErrorTraceReading() {
        return this.channelFreqErrorTrace;
    }

    public IntegerArrayReading getFrequencyListReading() {
        return this.frequencyList;
    }

    public long getFrequencyForChannel(int n) {
        long l;
        if (this.getScanType() == 0) {
            if (n < 0 || n >= this.getNumChannels()) {
                throw new IndexOutOfBoundsException("illegal channel " + n + ", numChannels=" + this.numChannels);
            }
            l = (long)(this.getStartCenterFreq() + this.getStepSize() * n) * 100L + this.chanCfOffset.longValue();
        } else if (this.getScanType() == 1) {
            l = (long)this.getFrequencyList()[n] * 100L + this.chanCfOffset.longValue();
        } else {
            throw new IllegalStateException("Invalid scanType: " + this.scanType);
        }
        return l;
    }

    public long getTraceStartValue() {
        throw new RuntimeException("Not yet implemented");
    }

    public long getTraceStopValue() {
        throw new RuntimeException("Not yet implemented");
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public double getDoubleReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        return ((IntegerArrayReading)this.getReadings()[n]).getTrace()[n2];
    }

    public long getLongReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public String getMeasurementTitle() {
        return Text.Channel_Scanner;
    }

    public int getSensitivity() {
        return this.sensitivity.intValue();
    }

    public int getPeakPower() {
        return this.peakPower.intValue();
    }

    public int getRangeHold() {
        return this.rangeHold.intValue();
    }

    public int getChanCfOffset() {
        return this.chanCfOffset.intValue();
    }

    public int getNoiseCorrection() {
        return this.noiseCorrection.intValue();
    }
}

