/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.channelScanner;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.infrastructure.util.FastMath;
import elgato.measurement.channelScanner.ChannelScannerMeasurement;
import elgato.measurement.channelScanner.ChannelScannerMeasurementSettings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;

public class ChannelScannerMeasurementGenerator
extends MeasurementGenerator {
    static final int POWER_MIN = 10000;
    static final int POWER_MAX = 30000;
    private Random rand = new Random();
    private int phase = 0;

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return ChannelScannerMeasurement.unpack(dataInput);
    }

    protected void writePayload(DataOutput dataOutput) throws IOException {
        int n;
        int n2 = 20000;
        int n3 = ChannelScannerMeasurementSettings.instance().getNumChans().intValue();
        dataOutput.writeInt(n3);
        for (n = 0; n < 40; ++n) {
            int n4 = (n + this.phase) * 32768 / 40;
            int n5 = (FastMath.sin(n4) >> 1) + 32768;
            dataOutput.writeInt(n5 * n2 / 65536 + 10000);
        }
        for (n = 0; n < 40; ++n) {
            dataOutput.writeInt(this.rand.nextInt() & 0x3FF);
        }
        dataOutput.writeInt(ChannelScannerMeasurementSettings.instance().getScanMode().intValue());
        dataOutput.writeInt(3);
        dataOutput.writeInt(4);
        dataOutput.writeInt(5);
        dataOutput.writeInt(ChannelScannerMeasurementSettings.instance().getStartFreq().intValue() / 1000);
        dataOutput.writeInt(ChannelScannerMeasurementSettings.instance().getStepSize().intValue() / 1000);
        dataOutput.writeInt(n3);
        for (n = 0; n < 40; ++n) {
            dataOutput.writeInt(850000 + n * 1000);
        }
        dataOutput.writeInt(1);
        dataOutput.writeInt(66);
        dataOutput.writeInt(77);
        dataOutput.writeInt(88);
        dataOutput.writeInt(2);
        ++this.phase;
        dataOutput.writeInt(0);
        dataOutput.writeInt(99);
        dataOutput.writeInt(-20000);
        dataOutput.writeInt(111);
        dataOutput.writeInt(0);
    }
}

