/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.channelScanner;

import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.ScaleDivActuator;
import elgato.infrastructure.actuators.StringActuator;
import elgato.infrastructure.commChannel.WebplugConversions;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.units.DbmUnitsFactory;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandNotFoundException;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.acp.ACPMeasurementSettings;
import elgato.measurement.channelScanner.ChannelScannerFormat;
import elgato.measurement.channelScanner.ChannelScannerFormats;
import java.util.Vector;

public class ChannelScannerMeasurementSettings
extends MeasurementSettings {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$channelScanner$ChannelScannerMeasurementSettings == null ? (class$elgato$measurement$channelScanner$ChannelScannerMeasurementSettings = ChannelScannerMeasurementSettings.class$("elgato.measurement.channelScanner.ChannelScannerMeasurementSettings")) : class$elgato$measurement$channelScanner$ChannelScannerMeasurementSettings);
    public static final String TOPIC_CHANNELSCANNER = "chScan";
    static final String DISPLAY_TOPIC = "display.chScan";
    static final int LEVEL_DBM_UNIT = 0;
    static final int LEVEL_WATTS_UNIT = 1;
    public static final String KEY_CHANNELSCANNER_LEVELUNITS = "levelUnits";
    public static final String KEY_CHANNELSCANNER_SCANMODE = "scanType";
    public static final String KEY_CHANNELSCANNER_STEP_SIZE = "chStep";
    public static final String KEY_CHANNELSCANNER_START_CF = "startCf";
    public static final String KEY_CHANNELSCANNER_MEASBW = "chanWidth";
    public static final String KEY_CHANNELSCANNER_CUST_MEASBW = "custChanWidth";
    public static final String KEY_CHANNELSCANNER_FREQLIST = "chFreqList";
    public static final String KEY_CHANNELSCANNER_RANGECOUNT = "rangeCount";
    public static final String KEY_CHANNELSCANNER_MEASTIME = "measTime";
    public static final String KEY_CHANNELSCANNER_CUST_MEASTIME = "custMeasTime";
    public static final String KEY_CHANNELSCANNER_DISPVALUE = "dispValue";
    public static final String KEY_CHANNELSCANNER_CHANSTD = "chanScanChanStd";
    public static final String KEY_CHANNELSCANNER_UNITS = "csUnits";
    private boolean doingLimitSetAll = true;
    private static ChannelScannerMeasurementSettings instance;
    private ScaleDivActuator scaleDiv = new ScaleDivActuator("display.chScan", 15000);
    private LongActuator refLevel = LongActuator.createRefLevelActuator("display.chScan", 20000, "dBm", -100000, 100000, this.scaleDiv);
    private ListActuator dBmWattsUnits = new ListActuator("display.chScan", "levelUnits", Text.Units, new Value[]{Value.createValue(Text.dBm, 0), Value.createValue(Text.Watts, 1)});
    private ChannelScannerFormat gsmFormat = new ChannelScannerFormats().getFormatByName("GSM");
    private FrequencyActuator measBW = FrequencyActuator.createHectohertz("chScan", "chanWidth", Text.Meas_BW);
    private LongActuator custMeasBW = new LongActuator("display.chScan", "custChanWidth", "", this.gsmFormat.getBandwidth());
    private LongActuator measTime = new LongActuator("chScan", "measTime", Text.Meas_Time, FactorConversion.createFixedPoint("ms", 1000));
    private LongActuator custMeasTime = new LongActuator("display.chScan", "custMeasTime", "", this.gsmFormat.getTimeInterval());
    private ListActuator freqChanUnits = new ListActuator("display.chScan", "csUnits", Text.CS_Units, new Value[]{Value.createValue("Freq", 0), Value.createValue("Chan", 1)});
    private ListActuator chanStd = DisplayGlobalMeasurementSettings.createChanStd("display.chScan", "chanScanChanStd", Text.CS_Chan_Std);
    private ListActuator scanMode = new ListActuator("chScan", "scanType", Text.Scan_Mode, new Value[]{Value.createValue(Text.List, 1), Value.createValue(Text.Range, 0)});
    private FrequencyActuator startFreq = new FrequencyActuator("chScan", "startCf", Text.Start_Freq);
    private FrequencyActuator stepSize = FrequencyActuator.createHectohertz("chScan", "chStep", Text.CS_Step_Size);
    private LongActuator numChans = new LongActuator("chScan", "rangeCount", Text.Num_Chans, 3L);
    private StringActuator channelList = StringActuator.makeStringActuator("chScan", "chFreqList", "", "");
    private LongActuator rfInLoss = LongActuator.createLoss("chScan", "atten", Text.RF_IN_Loss, 0);
    private ListActuator averaging = ListActuator.createStandardAveraging("chScan");
    private LongActuator numAverages = LongActuator.createNumAverages("chScan", 100);
    private ListActuator dispValue = new ListActuator("display.chScan", "dispValue", Text.Disp_Value, new Value[]{Value.createValue(Text.Off, 0), Value.createValue(Text.Freq, 1), Value.createValue(Text.Pwr, 2)});
    private ListActuator powerDetector = ListActuator.createpowerDetector("chScan");
    private ListActuator formatType = ListActuator.createFormatType("display.chScan");
    private ListActuator formatList = ListActuator.createFormatList("display.chScan", ChannelScannerMeasurementSettings.loadFormatList());
    private ListActuator sensitivity = ListActuator.createSensitivity("chScan");
    private ListActuator rangeHold = ListActuator.createRangeHold("chScan");
    private final LongActuator rangeUpDown = new LongActuator("chScan", "rangeUpDown", "RangeUpDown");
    private LongActuator chanCfOffset = new LongActuator("chScan", "chanCfOffset", "Channel CF Offset");
    private ListActuator noiseCorrection = ListActuator.createNoiseCorrection("chScan");
    private ListActuator powerLimitsToggle = new ListActuator("display.chScan", "powerLimitsToggle", Text.Power_n_Limits, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private LongActuator powerLowLimit = LongActuator.createPower("display.chScan", "powerLowLimit", Text.Power_n_Low_Limit, "dBm");
    private LongActuator powerHighLimit = LongActuator.createPower("display.chScan", "powerHighLimit", Text.Power_n_High_Limit, "dBm");
    private ListActuator frequencyLimitsToggle = new ListActuator("display.chScan", "frequencyLimitsToggle", Text.Freq_Error_n_Limits, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private FrequencyActuator frequencyLowLimit = new FrequencyActuator("display.chScan", "frequencyLowLimit", Text.Frequency_Error_n_Low_Limit);
    private FrequencyActuator frequencyHighLimit = new FrequencyActuator("display.chScan", "frequencyHighLimit", Text.Frequency_Error_n_High_Limit);
    static /* synthetic */ Class class$elgato$measurement$channelScanner$ChannelScannerMeasurementSettings;

    private ChannelScannerMeasurementSettings() {
        super(TOPIC_CHANNELSCANNER);
        this.add(this.scaleDiv);
        this.add(this.refLevel);
        this.add(this.dBmWattsUnits);
        this.add(this.noiseCorrection);
        this.add(this.measBW);
        this.add(this.measTime);
        this.add(this.freqChanUnits);
        this.add(this.chanStd);
        this.add(this.scanMode);
        this.add(this.startFreq);
        this.add(this.stepSize);
        this.add(this.numChans);
        this.add(this.channelList);
        this.add(this.rfInLoss);
        this.add(this.averaging);
        this.add(this.numAverages);
        this.add(this.dispValue);
        this.add(this.formatType);
        this.add(this.formatList);
        this.add(this.sensitivity);
        this.add(this.powerDetector);
        this.add(this.rangeHold);
        this.add(this.rangeUpDown);
        this.add(this.chanCfOffset);
        this.add(this.custMeasBW);
        this.add(this.custMeasTime);
        this.add(this.powerLimitsToggle);
        this.add(this.powerLowLimit);
        this.add(this.powerHighLimit);
        this.add(this.frequencyLimitsToggle);
        this.add(this.frequencyLowLimit);
        this.add(this.frequencyHighLimit);
        this.powerLimitsToggle.setValue(0);
        this.frequencyLimitsToggle.setValue(0);
        this.makeStashedLossActuatorSet(DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.rfInLoss, DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), "ChScan.RfInLoss");
        this.sensitivity.setValue(1);
        this.refLevel.setUnitsFactory(new DbmUnitsFactory());
        this.refLevel.setIncrement(this.scaleDiv.intValue() / 10);
        this.measBW.setValidator(new RangeValidator(0L, Integer.MAX_VALUE));
        this.measBW.setIncrement(1000);
        this.addDBmWattsUnitsValueListeners();
        this.numChans.setValidator(new RangeValidator(1L, 20L));
        this.configureMeasTimeActuator(this.measTime);
        this.startFreq.setValidator(new RangeValidator(10000000L, 2500000000L));
        this.startFreq.setWebPlugConversion(new HectohertzWithOffsetConversion(this.startFreq));
        this.stepSize.setIncrement(1000);
        this.stepSize.setValidator(new RangeValidator(100L, 2000000000L));
        this.freqChanUnits.addValueListener(new ChScanValueListener("freqChanUnitsListener"){

            public void valueChanged(ValueInterface valueInterface) {
                ChannelScannerMeasurementSettings.this.configStartFreqAndStepSize();
            }
        });
        this.frequencyLimitsToggle.addValueListener(new ChScanValueListener("frequencyLimitsToggle"){

            public void valueChanged(ValueInterface valueInterface) {
                ChannelScannerMeasurementSettings.this.setAllLimits();
            }
        });
        this.powerLimitsToggle.addValueListener(new ChScanValueListener("powerLimitsToggle"){

            public void valueChanged(ValueInterface valueInterface) {
                ChannelScannerMeasurementSettings.this.setAllLimits();
            }
        });
        this.chanStd.addValueListener(new ChScanValueListener("chanStdListener"){

            public void valueChanged(ValueInterface valueInterface) {
                try {
                    ChannelScannerMeasurementSettings.this.chanCfOffset.send(Band.getBandByIndex(valueInterface.intValue()).getChannelOffset());
                    ChannelScannerMeasurementSettings.this.configStartFreqAndStepSize();
                }
                catch (BandNotFoundException bandNotFoundException) {
                    logger.error("Could not find band for index: " + valueInterface.intValue());
                }
            }
        });
        this.scaleDiv.addValueListener(new ChScanValueListener("scaleDivListener"){

            public void valueChanged(ValueInterface valueInterface) {
                ChannelScannerMeasurementSettings.this.refLevel.setIncrement(ChannelScannerMeasurementSettings.this.scaleDiv.intValue() / 10);
            }
        });
        this.measBW.addValueListener(ACPMeasurementSettings.createCustomUpdaterValueListener(this.custMeasBW, this.formatType, "ChanScan.measBW"));
        this.measTime.addValueListener(ACPMeasurementSettings.createCustomUpdaterValueListener(this.custMeasTime, this.formatType, "ChanScan.measTime"));
        this.powerHighLimit.setValidator(new RangeValidator(-150000L, 100000L));
        this.powerLowLimit.setValidator(new RangeValidator(-150000L, 100000L));
        this.frequencyHighLimit.setValidator(new RangeValidator(0L, Long.MAX_VALUE));
        this.frequencyLowLimit.setValidator(new RangeValidator(Long.MIN_VALUE, 0L));
        this.refLevel.addValueListener(new ChScanValueListener("refLevel"){

            public void valueChanged(ValueInterface valueInterface) {
                if (!ChannelScannerMeasurementSettings.this.doingLimitSetAll) {
                    ChannelScannerMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.scaleDiv.addValueListener(new ChScanValueListener("scaleDiv"){

            public void valueChanged(ValueInterface valueInterface) {
                if (!ChannelScannerMeasurementSettings.this.doingLimitSetAll) {
                    ChannelScannerMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.refresh();
    }

    public void allowValidationNow() {
        this.doingLimitSetAll = false;
    }

    private void configureMeasTimeActuator(LongActuator longActuator) {
        longActuator.setValidator(new RangeValidator(1000L, Integer.MAX_VALUE));
        longActuator.setIncrement(1000);
        longActuator.setPalette(Palette.createUnsignedDecimal());
    }

    private void configStartFreqAndStepSize() {
        BandSelector bandSelector = this.getBandSelector();
        if (this.freqChanUnits.intValue() == 1) {
            this.startFreq.configureForChannels(Text.Start_Chan, bandSelector, Value.createValue("", 1));
            this.startFreq.setIncrement((int)Band.getCurrentBandChannelWidth(this.getBandSelector()));
            this.stepSize.configureForChannelCount(Text.CS_Step_Size, bandSelector);
        } else {
            this.startFreq.configureForFreq(Text.Start_Freq);
            this.startFreq.setIncrement(1000);
            this.stepSize.configureForFreq(Text.CS_Step_Size);
        }
    }

    public BandSelector getBandSelector() {
        return BandSelector.getCustomBandSelector(this.chanStd);
    }

    private void addDBmWattsUnitsValueListeners() {
        this.dBmWattsUnits.addValueListener(new ChScanValueListener("dBmWattsUnitsListener"){

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() == 1) {
                    ChannelScannerMeasurementSettings.this.refLevel.setConversion(DbmUnitsFactory.getWattsConversion());
                } else {
                    ChannelScannerMeasurementSettings.this.refLevel.setConversion(DbmUnitsFactory.getDbmConversion());
                }
                ChannelScannerMeasurementSettings.this.refLevel.setValue(ChannelScannerMeasurementSettings.this.refLevel.intValue());
            }
        });
    }

    public static ChannelScannerMeasurementSettings instance() {
        if (instance == null) {
            instance = new ChannelScannerMeasurementSettings();
            logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    public LongActuator getScaleDiv() {
        return this.scaleDiv;
    }

    public LongActuator getRefLevel() {
        return this.refLevel;
    }

    public ListActuator getdBmWattsUnits() {
        return this.dBmWattsUnits;
    }

    public LongActuator getNumChans() {
        return this.numChans;
    }

    public StringActuator getChannelList() {
        return this.channelList;
    }

    public LongActuator getNumAverages() {
        return this.numAverages;
    }

    public LongActuator getMeasBW() {
        return this.measBW;
    }

    public LongActuator getMeasTime() {
        return this.measTime;
    }

    public ListActuator getFreqChanUnits() {
        return this.freqChanUnits;
    }

    public ListActuator getChanStd() {
        return this.chanStd;
    }

    public ListActuator getScanMode() {
        return this.scanMode;
    }

    public FrequencyActuator getStartFreq() {
        return this.startFreq;
    }

    public FrequencyActuator getStepSize() {
        return this.stepSize;
    }

    public LongActuator getRfInLoss() {
        return this.rfInLoss;
    }

    public ListActuator getAveraging() {
        return this.averaging;
    }

    public ListActuator getDispValue() {
        return this.dispValue;
    }

    public ListActuator getFormatType() {
        return this.formatType;
    }

    public ListActuator getFormatList() {
        return this.formatList;
    }

    public ListActuator getSensitivity() {
        return this.sensitivity;
    }

    public ListActuator getPowerDetector() {
        return this.powerDetector;
    }

    public ListActuator getRangeHold() {
        return this.rangeHold;
    }

    public LongActuator getRangeUpDown() {
        return this.rangeUpDown;
    }

    public LongActuator getChanCfOffset() {
        return this.chanCfOffset;
    }

    public ListActuator getPowerLimitsToggle() {
        return this.powerLimitsToggle;
    }

    public LongActuator getPowerLowLimit() {
        return this.powerLowLimit;
    }

    public LongActuator getPowerHighLimit() {
        return this.powerHighLimit;
    }

    public ListActuator getFrequencyLimitsToggle() {
        return this.frequencyLimitsToggle;
    }

    public LongActuator getFrequencyLowLimit() {
        return this.frequencyLowLimit;
    }

    public LongActuator getFrequencyHighLimit() {
        return this.frequencyHighLimit;
    }

    private static Value[] loadFormatList() {
        Vector vector = new ChannelScannerFormats().getFormats();
        Object[] objectArray = new Value[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Actuator getCustMeasBW() {
        return this.custMeasBW;
    }

    public Actuator getCustMeasTime() {
        return this.custMeasTime;
    }

    public ListActuator getNoiseCorrection() {
        return this.noiseCorrection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected abstract class ChScanValueListener
    implements ValueListener {
        private final String listenerName;

        public ChScanValueListener(String string) {
            this.listenerName = "chScan." + string + ".listener";
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public abstract /* synthetic */ void valueChanged(ValueInterface var1);
    }

    private class HectohertzWithOffsetConversion
    extends WebplugConversions.LongConversion {
        public HectohertzWithOffsetConversion(LongActuator longActuator) {
            super(longActuator, longActuator.getTopic(), longActuator.getPropertyName(), 100);
        }

        protected long receiveValue(long l) {
            return super.receiveValue(l) + ChannelScannerMeasurementSettings.this.chanCfOffset.longValue();
        }
    }
}

