/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.channelScanner;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.actuators.StringActuator;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.menu.FreqChanListButton;
import elgato.infrastructure.menu.FrequencyChannelButtonFactory;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.LevelButtonFactory;
import elgato.infrastructure.menu.ListButton;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.RangeControlMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandNotFoundException;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.EListModel;
import elgato.infrastructure.widgets.VectorEListModel;
import elgato.measurement.channelScanner.ChannelScannerAnalyzer;
import elgato.measurement.channelScanner.ChannelScannerFormat;
import elgato.measurement.channelScanner.ChannelScannerMeasurementSettings;
import elgato.measurement.channelScanner.ChannelScannerScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class ChannelScannerMenuMgr
extends MeasurementMenuMgr {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$channelScanner$ChannelScannerScreen == null ? (class$elgato$measurement$channelScanner$ChannelScannerScreen = ChannelScannerMenuMgr.class$("elgato.measurement.channelScanner.ChannelScannerScreen")) : class$elgato$measurement$channelScanner$ChannelScannerScreen);
    protected final ChannelScannerAnalyzer analyzer;
    protected final ChannelScannerMeasurementSettings settings;
    static final BandSelector BAND_SELECTOR = ChannelScannerMeasurementSettings.instance().getBandSelector();
    static final int LEVEL_DBM = 0;
    static final int LEVEL_WATTS = 1;
    protected MenuItem startFrequencyButton;
    protected FreqChanListButton freqchanListButton;
    protected ActuatorEditor stepSizeButton;
    private ValueListener displayValueListener;
    private MultiStateActuatorButton displayButton;
    private ListActuator scanMode;
    protected MultiStateActuatorButton scanModeButton;
    private ValueListener scanTypeValueListener;
    private ValueListener formatTypeValueListener;
    private MultiStateActuatorButton formatTypeButton;
    private ListActuatorButton formatListButton;
    private MenuItem measBWButton;
    private MenuItem measTimeButton;
    private MenuItem chanStdButton;
    private MultiStateActuatorButton onOffFreqButton;
    private MultiStateActuatorButton onOffButton;
    static /* synthetic */ Class class$elgato$measurement$channelScanner$ChannelScannerScreen;

    public ChannelScannerMenuMgr(MeasurementScreen measurementScreen, ChannelScannerMeasurementSettings channelScannerMeasurementSettings, ChannelScannerAnalyzer channelScannerAnalyzer) {
        super(measurementScreen);
        this.settings = channelScannerMeasurementSettings;
        this.analyzer = channelScannerAnalyzer;
        this.createMiscButtons();
    }

    protected abstract MenuButton createFreqChanButton();

    protected abstract MenuItem createSetupButton();

    protected abstract MenuButton createFormatBWButton();

    protected Menu buildLeftMenu() {
        Menu menu = new Menu(Text.Channel_Scanner, new MenuItem[]{this.createFreqChanButton(), this.createLevelButton(), this.createFormatBWButton(), null, this.createAverageSweepButton(this.settings.getNumAverages(), this.settings.getAveraging()), this.createSetupButton()});
        return menu;
    }

    protected void createMiscButtons() {
        this.freqchanListButton = this.createFreqchanListButton();
        this.startFrequencyButton = this.createStartFrequencyButton();
        this.stepSizeButton = this.createStepSizeButton();
        ActuatorEditor actuatorEditor = this.createNumChanButton(this.settings.getNumChans(), this.getContextString("frequencyChannel.num"));
        this.scanModeButton = this.createScanModeButton(this.freqchanListButton, this.startFrequencyButton, this.stepSizeButton, actuatorEditor);
        this.onOffFreqButton = new MultiStateActuatorButton(this.settings.getFrequencyLimitsToggle(), this.getContextString("frequencyLimits"), this.getListenerBaseName() + ".freqLimitsOnOff");
        this.onOffButton = new MultiStateActuatorButton(this.settings.getPowerLimitsToggle(), this.getContextString("powerLimits"), this.getListenerBaseName() + ".pwrqLimitsOnOff");
    }

    public MenuItem createUnitsButton() {
        return new MultiStateActuatorButton(this.settings.getFreqChanUnits(), "units", this.getListenerBaseName() + ".unitsButton");
    }

    public void cleanup() {
        this.removeValueListener();
    }

    void removeValueListener() {
        this.displayButton.getActuator().removeValueListener(this.displayValueListener);
        this.scanMode.removeValueListener(this.scanTypeValueListener);
        this.formatTypeButton.getActuator().removeValueListener(this.formatTypeValueListener);
    }

    protected RangeControlMenuButton createRangeControlMenuButton() {
        return new RangeControlMenuButton(this.scn, this.settings.getRangeHold(), this.settings.getRangeUpDown());
    }

    protected MultiStateActuatorButton createNoiseCorrectionButton() {
        return new MultiStateActuatorButton(this.settings.getNoiseCorrection(), this.getContextString("noiseCorrection"), this.getListenerBaseName() + ".noiseCorrButton");
    }

    protected MenuItem createDispValueButton() {
        this.displayButton = new MultiStateActuatorButton(this.settings.getDispValue(), this.getContextString("setup.dispvalue"), this.getListenerBaseName() + ".displayButton");
        this.displayValueListener = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = ChannelScannerMenuMgr.this.getListenerBaseName() + "displayValueListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                ((ChannelScannerScreen)ChannelScannerMenuMgr.this.scn).getAnalyzerPanel().repaint();
            }
        };
        this.displayButton.getActuator().addValueListener(this.displayValueListener);
        return this.displayButton;
    }

    MultiStateActuatorButton createRangeHold() {
        return new MultiStateActuatorButton(this.settings.getRangeHold(), this.getContextString("rangeHold"), this.getListenerBaseName() + ".rangeHoldButton");
    }

    protected ActuatorEditor createNumChanButton(LongActuator longActuator, String string) {
        return new ActuatorEditor(longActuator, string, this.getListenerBaseName() + ".numChan");
    }

    protected MenuItem createChanStdSelectButton() {
        return FrequencyChannelButtonFactory.createChannelScannerChanStdSelectButton(this.getContextString("chan.std"), this.getListenerBaseName());
    }

    ActuatorEditor createStepSizeButton() {
        FrequencyActuator frequencyActuator = this.settings.getStepSize();
        ActuatorEditor actuatorEditor = new ActuatorEditor(frequencyActuator, this.getContextString("frequencyChannel.step"), this.getListenerBaseName() + ".stepSize");
        return actuatorEditor;
    }

    protected MultiStateActuatorButton createSensitivityButton() {
        return new MultiStateActuatorButton(this.settings.getSensitivity(), this.getContextString("sensitivity"), this.getListenerBaseName() + ".sensitivityButton");
    }

    MenuItem createStartFrequencyButton() {
        FrequencyActuator frequencyActuator = this.settings.getStartFreq();
        return new ActuatorEditor(frequencyActuator, this.getContextString("frequencyChannel.start"), this.getListenerBaseName() + ".startFreqButton");
    }

    MultiStateActuatorButton createScanModeButton(final MenuItem menuItem, final MenuItem menuItem2, final MenuItem menuItem3, final MenuItem menuItem4) {
        this.scanMode = this.settings.getScanMode();
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(this.scanMode, this.getContextString("frequencyChannel.scanMode"), this.getListenerBaseName() + ".scanModeButton");
        this.scanTypeValueListener = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = ChannelScannerMenuMgr.this.getListenerBaseName() + ".scanTypeValueListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                ChannelScannerMenuMgr.this.setRangeEnabled(valueInterface.intValue() == 0, menuItem, menuItem2, menuItem3, menuItem4);
            }
        };
        this.scanMode.addValueListener(this.scanTypeValueListener);
        this.scanTypeValueListener.valueChanged(this.scanMode.getSelectedValue());
        return multiStateActuatorButton;
    }

    private void setRangeEnabled(boolean bl, MenuItem menuItem, MenuItem menuItem2, MenuItem menuItem3, MenuItem menuItem4) {
        menuItem.setEnabled(!bl);
        menuItem2.setEnabled(bl);
        menuItem3.setEnabled(bl);
        menuItem4.setEnabled(bl);
    }

    private FreqChanListButton createFreqchanListButton() {
        FreqChanListButton freqChanListButton = new FreqChanListButton(Text.List, this.getContextString("freqchan.list"), new FrequencyListModelGetter(), new FrequencyListPersistor(), (ChannelScannerScreen)this.scn);
        return freqChanListButton;
    }

    private MenuButton createLevelButton() {
        LevelButtonFactory levelButtonFactory = new LevelButtonFactory(this.scn, this.analyzer, this.settings.getRefLevel(), this.settings.getScaleDiv(), true);
        MenuButton menuButton = levelButtonFactory.createMinimalLevelMenu();
        menuButton.addMenuItem(5, this.createdBmWattsUnitsButton());
        menuButton.addMenuItem(6, MeasurementMenuMgr.createLossButton(DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), this.settings.getRfInLoss(), DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.getContextString("rf.in.loss"), this.getListenerBaseName() + ".RfInLossButton"));
        return menuButton;
    }

    MultiStateActuatorButton createdBmWattsUnitsButton() {
        return new MultiStateActuatorButton(this.settings.getdBmWattsUnits(), this.getContextString("units"), this.getListenerBaseName() + ".dBmWattsUnitsButton");
    }

    private MenuItem createFrequencyLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Freq_Error_n_Limits, this.getContextString("frequencyLimits"), new Menu(Text.Freq_Limits, new MenuItem[]{this.onOffFreqButton, new ActuatorEditor(this.settings.getFrequencyHighLimit(), this.getContextString("frequencyLimits"), this.getListenerBaseName() + ".freqULim"), new ActuatorEditor(this.settings.getFrequencyLowLimit(), this.getContextString("frequencyLimits"), this.getListenerBaseName() + ".freqLLim")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        this.setSettingsShowFreqLimits();
        this.onOffFreqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChannelScannerMenuMgr.this.settings.allowValidationNow();
                ChannelScannerMenuMgr.this.setSettingsShowFreqLimits();
                ChannelScannerMenuMgr.this.onOffButton.setCurrentState(0);
            }
        });
        return subMenuButton;
    }

    private void setSettingsShowFreqLimits() {
        if (this.onOffFreqButton.getActuator().getSelectedValue().longValue() == 1L) {
            this.settings.getDispValue().setValue(1);
        } else if (this.onOffButton.getActuator().getSelectedValue().longValue() == 1L) {
            this.settings.getDispValue().setValue(2);
        }
    }

    private MenuItem createPowerLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Power_n_Limits, this.getContextString("powerLimits"), new Menu(Text.Power_n_Limits, new MenuItem[]{this.onOffButton, new ActuatorEditor(this.settings.getPowerHighLimit(), this.getContextString("powerLimits"), this.getListenerBaseName() + ".pwrULim"), new ActuatorEditor(this.settings.getPowerLowLimit(), this.getContextString("powerLimits"), this.getListenerBaseName() + ".pwrULim")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        this.setSettingsShowPowerLimits();
        this.onOffButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChannelScannerMenuMgr.this.settings.allowValidationNow();
                ChannelScannerMenuMgr.this.setSettingsShowPowerLimits();
                ChannelScannerMenuMgr.this.onOffFreqButton.setCurrentState(0);
            }
        });
        return subMenuButton;
    }

    private void setSettingsShowPowerLimits() {
        if (this.onOffButton.getActuator().getSelectedValue().longValue() == 1L) {
            this.settings.getDispValue().setValue(2);
        } else if (this.onOffFreqButton.getActuator().getSelectedValue().longValue() == 1L) {
            this.settings.getDispValue().setValue(1);
        }
    }

    protected MenuItem createLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Limits, this.getContextString("Limits"), new Menu(Text.Limits, new MenuItem[]{this.createPowerLimitsButton(), this.createFrequencyLimitsButton(), null, null, null, null, null}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected Menu createFormatBWMenu() {
        this.formatListButton = this.createFormatListButton();
        this.measBWButton = this.createMeasBWButton();
        this.measTimeButton = this.createMeasTimeButton();
        this.chanStdButton = this.createChanStdSelectButton();
        this.formatTypeButton = new MultiStateActuatorButton(this.settings.getFormatType(), this.getContextString("formatBW.formatType"), this.getListenerBaseName() + ".formatTypeButton");
        Menu menu = new Menu(Text.Format_slash_BW, new MenuItem[]{this.formatTypeButton, this.chanStdButton, this.formatListButton, this.measBWButton, this.measTimeButton});
        this.configureFormatButtons(this.settings.getFormatType().getSelectedValue());
        this.formatTypeValueListener = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = ChannelScannerMenuMgr.this.getListenerBaseName() + ".formatTypeValueListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                ChannelScannerMenuMgr.this.configureFormatButtons(valueInterface);
            }
        };
        this.formatTypeButton.getActuator().addValueListener(this.formatTypeValueListener);
        return menu;
    }

    private void configureFormatButtons(ValueInterface valueInterface) {
        if (valueInterface.intValue() == 2) {
            this.formatListButton.setEnabled(false);
            this.measBWButton.setEnabled(true);
            this.measTimeButton.setEnabled(true);
            this.chanStdButton.setEnabled(false);
            this.settings.getMeasBW().send(this.settings.getCustMeasBW().intValue());
            this.settings.getMeasTime().send(this.settings.getCustMeasTime().intValue());
        } else if (valueInterface.intValue() == 1) {
            this.formatListButton.setEnabled(true);
            this.measBWButton.setEnabled(false);
            this.measTimeButton.setEnabled(false);
            this.chanStdButton.setEnabled(false);
            ChannelScannerFormat channelScannerFormat = (ChannelScannerFormat)this.settings.getFormatList().getSelectedValue();
            this.setFormat(channelScannerFormat);
        } else {
            this.formatListButton.setEnabled(false);
            this.measBWButton.setEnabled(false);
            this.measTimeButton.setEnabled(false);
            this.chanStdButton.setEnabled(true);
            int n = this.settings.getChanStd().intValue();
            try {
                ChannelScannerFormat channelScannerFormat = Band.getBandByIndex(n).getChannelScannerFormat();
                this.setFormat(channelScannerFormat);
                this.settings.getFormatList().setValue(channelScannerFormat.intValue());
            }
            catch (BandNotFoundException bandNotFoundException) {
                logger.error("Could not find band for: " + n);
            }
        }
    }

    private void setFormat(ChannelScannerFormat channelScannerFormat) {
        this.settings.getMeasBW().send(channelScannerFormat.getBandwidth());
        this.settings.getMeasTime().send(channelScannerFormat.getTimeInterval());
    }

    ListActuatorButton createFormatListButton() {
        ListActuatorButton listActuatorButton = new ListActuatorButton(this.settings.getFormatList(), this.getContextString("formatBW.formatType.list"), this.getListenerBaseName() + ".formatListButton");
        listActuatorButton.addItemSelectionListener(this.createFormatButtonListener());
        return listActuatorButton;
    }

    ItemSelectionListener createFormatButtonListener() {
        return new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                ChannelScannerFormat channelScannerFormat = (ChannelScannerFormat)itemSelectionEvent.getValue();
                ChannelScannerMenuMgr.this.setFormat(channelScannerFormat);
            }
        };
    }

    MenuItem createMeasBWButton() {
        return new ActuatorEditor(this.settings.getMeasBW(), this.getContextString("formatBW.measBW"), this.getListenerBaseName() + ".measBwButton");
    }

    MenuItem createMeasTimeButton() {
        return new ActuatorEditor(this.settings.getMeasTime(), this.getContextString("formatBW.measTime"), this.getListenerBaseName() + ".measTimeButton");
    }

    protected String getMeasurementName() {
        return "spectrum";
    }

    public FrequencyListModelGetter makeFrequencyListModelGetter_test() {
        return new FrequencyListModelGetter();
    }

    public FrequencyListPersistor makeFrequencyListPersistor_test() {
        return new FrequencyListPersistor();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class FrequencyListModelGetter
    implements ListButton.ModelGetter {
        FrequencyListModelGetter() {
        }

        public EListModel getModel() {
            Vector vector = this.parseFrequencies(ChannelScannerMenuMgr.this.settings.getChannelList().toString());
            return new VectorEListModel(vector);
        }

        private Vector parseFrequencies(String string) {
            Vector<FrequencyActuator> vector = new Vector<FrequencyActuator>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    FrequencyActuator frequencyActuator = (FrequencyActuator)((ChannelScannerScreen)ChannelScannerMenuMgr.this.scn).createNewItem();
                    frequencyActuator.setValue(new Long(string2) * 100L);
                    vector.addElement(frequencyActuator);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.error("Invalid frequency list token: '" + string2 + "'", numberFormatException);
                }
            }
            return vector;
        }
    }

    static class FrequencyListPersistor
    implements ItemSelectionListener {
        FrequencyListPersistor() {
        }

        public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
            EListModel eListModel = itemSelectionEvent.getModel();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < eListModel.size(); ++i) {
                long l = ((ValueInterface)eListModel.getItem(i)).longValue();
                if (l == 0L) continue;
                if (i != 0) {
                    stringBuffer.append(' ');
                }
                long l2 = l / 100L;
                stringBuffer.append(l2);
            }
            String string = stringBuffer.toString();
            StringActuator stringActuator = ChannelScannerMeasurementSettings.instance().getChannelList();
            stringActuator.setValue(string);
            stringActuator.send();
        }
    }
}

