/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.channelScanner;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.WebplugConversions;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.ProductFactory;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.NewItemCreator;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.Value;
import elgato.measurement.channelScanner.ChannelScannerAnalyzer;
import elgato.measurement.channelScanner.ChannelScannerMeasurementSettings;
import elgato.measurement.channelScanner.ChannelScannerMenuMgr;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;

public class ChannelScannerScreen
extends MeasurementScreen
implements NewItemCreator {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$channelScanner$ChannelScannerScreen == null ? (class$elgato$measurement$channelScanner$ChannelScannerScreen = ChannelScannerScreen.class$("elgato.measurement.channelScanner.ChannelScannerScreen")) : class$elgato$measurement$channelScanner$ChannelScannerScreen);
    static final BandSelector BAND_SELECTOR = ChannelScannerMeasurementSettings.instance().getBandSelector();
    static final int LEVEL_DBM = 0;
    static final int LEVEL_WATTS = 1;
    protected ChannelScannerAnalyzer analyzer;
    protected ChannelScannerMenuMgr menuMgr;
    MenuItem startFrequencyButton;
    ActuatorEditor stepSizeButton;
    MultiStateActuatorButton scanModeButton;
    private final ChannelScannerMeasurementSettings settings = ChannelScannerMeasurementSettings.instance();
    static /* synthetic */ Class class$elgato$measurement$channelScanner$ChannelScannerScreen;
    static /* synthetic */ Class class$elgato$measurement$channelScanner$ChannelScannerMeasurement;

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
    }

    protected Menu buildLeftMenu() {
        return this.menuMgr.buildLeftMenu();
    }

    protected ChannelScannerMenuMgr createMenuMgr() {
        this.menuMgr = ProductFactory.getInstance().createChannelScannerMenuMgr(this, this.settings, this.analyzer);
        return this.menuMgr;
    }

    protected Command[] getInitialGetCommands() {
        return new Command[]{this.createInitialLocalGetCommand()};
    }

    private Command createInitialLocalGetCommand() {
        Command command = Command.makeGetCommand(this.getTopic());
        command.addProperty("chFreqList", "835000 836000 837000 880000 881000 882000");
        return command;
    }

    protected String getMeasurementName() {
        return "chScan";
    }

    public Component getAnalyzerPanel() {
        return this.analyzer;
    }

    protected Class getMeasurementClass() {
        return class$elgato$measurement$channelScanner$ChannelScannerMeasurement == null ? (class$elgato$measurement$channelScanner$ChannelScannerMeasurement = ChannelScannerScreen.class$("elgato.measurement.channelScanner.ChannelScannerMeasurement")) : class$elgato$measurement$channelScanner$ChannelScannerMeasurement;
    }

    protected void setupAnalyzer() {
        this.analyzer = new ChannelScannerAnalyzer();
        this.createMenuMgr();
    }

    protected void refreshMeasurementSettings() {
        this.settings.refresh();
    }

    public void uninstallScreen(ScreenManager screenManager) {
        this.menuMgr.cleanup();
        super.uninstallScreen(screenManager);
    }

    private boolean isChanMode() {
        return this.settings.getFreqChanUnits().intValue() == 1;
    }

    public Object createNewItem() {
        Band band = Band.getCurrentBand(BAND_SELECTOR);
        long l = band.getDefaultChannel().getCenterFrequency();
        FrequencyActuator frequencyActuator = new FrequencyActuator("", "", "");
        frequencyActuator.setWebPlugConversion(WebplugConversions.createNull());
        frequencyActuator.setValue(l);
        if (this.isChanMode()) {
            frequencyActuator.configureForChannels("", BAND_SELECTOR, Value.createValue("", 1));
        }
        return frequencyActuator;
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        return this.analyzer.filterPrintImage(image, rectangle);
    }

    public String getTestResults(ScreenManager screenManager, String string) {
        throw new RuntimeException("getTestResults() not implemented");
    }

    public ChannelScannerMenuMgr getMenuMgr() {
        return this.menuMgr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

