/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.infrastructure.valueobject.IntegerValue;

public class Cable
extends IntegerValue {
    public static final int TYPE_RG = 1;
    public static final int TYPE_HELIAX = 2;
    public static final int TYPE_CUSTOM = 0;
    private int cableKey;
    private int cableType;
    private String description;
    private int attenuation1;
    private int attenuation2;
    private long frequency1;
    private long frequency2;
    private short velocity;

    public Cable(int n, int n2, String string, int n3, int n4, int n5, int n6, short s) {
        super(string, n);
        this.cableKey = n;
        this.cableType = n2;
        this.description = string;
        this.attenuation1 = n3;
        this.frequency1 = (long)n4 * 1000000L;
        this.attenuation2 = n5;
        this.frequency2 = (long)n6 * 1000000L;
        this.velocity = s;
    }

    public int getCableKey() {
        return this.cableKey;
    }

    public int getCableType() {
        return this.cableType;
    }

    public String getDescription() {
        return this.description;
    }

    public short getVelocity() {
        return this.velocity;
    }

    public boolean isRG() {
        return this.cableType == 1;
    }

    public boolean isHeliax() {
        return this.cableType == 2;
    }

    protected float calculateSlope() {
        return (this.frequency2 - this.frequency1) / (long)(this.attenuation2 - this.attenuation1);
    }

    protected float calculateYIntercept() {
        return (float)this.frequency2 - this.calculateSlope() * (float)this.attenuation2;
    }

    public int getAttenuationInDbPer100Meters(long l) {
        float f = ((float)l - this.calculateYIntercept()) / this.calculateSlope();
        return (int)((double)f * 3.2808);
    }
}

