/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.measurement.dtf.Cable;
import elgato.measurement.dtf.DtfMeasurementSettings;
import java.util.Hashtable;

public class CableListCellRenderer
extends DefaultEListCellRenderer {
    private static final int[] columnWidths = new int[]{50, 50};
    private Hashtable lines = new Hashtable();
    private ListActuator cableList;
    private int cachedUnits;

    public CableListCellRenderer(ListActuator listActuator) {
        super(columnWidths);
        this.cableList = listActuator;
        this.cacheCableProperties();
    }

    private void cacheCableProperties() {
        Cable[] cableArray = (Cable[])this.cableList.getValueList();
        Conversion conversion = DtfMeasurementSettings.instance().getCableVelocity().getConversion();
        for (int i = 0; i < cableArray.length; ++i) {
            Cable cable = cableArray[i];
            String[] stringArray = new String[]{cable.getDescription(), Text.Vel + " " + conversion.toString(cable.getVelocity())};
            this.lines.put(cable, stringArray);
        }
        this.cachedUnits = SystemMeasurementSettings.instance().getDtfUnits().intValue();
    }

    protected String[] columnValues(Object object) {
        if (this.cacheisStale()) {
            this.cacheCableProperties();
        }
        return (String[])this.lines.get(object);
    }

    private boolean cacheisStale() {
        return SystemMeasurementSettings.instance().getDtfUnits().intValue() != this.cachedUnits;
    }
}

