/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.measurement.dtf.Cable;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class Cables {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$dtf$Cables == null ? (class$elgato$measurement$dtf$Cables = Cables.class$("elgato.measurement.dtf.Cables")) : class$elgato$measurement$dtf$Cables);
    private Vector rgCables = new Vector(53);
    private Vector heliaxCables = new Vector(23);
    static /* synthetic */ Class class$elgato$measurement$dtf$Cables;

    public Cables() {
        this.loadCables();
    }

    public Vector getRGCables() {
        return this.rgCables;
    }

    public Vector getHeliaxCables() {
        return this.heliaxCables;
    }

    public int getIndexByCableKey(int n, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Cable cable = (Cable)vector.elementAt(i);
            if (cable.getCableKey() != n) continue;
            return i;
        }
        return 0;
    }

    public int getRGIndexByCableKey(int n) {
        return this.getIndexByCableKey(n, this.rgCables);
    }

    public int getHeliaxIndexByCableKey(int n) {
        return this.getIndexByCableKey(n, this.heliaxCables);
    }

    public int getIndexByCableKey(int n) {
        int n2 = this.getIndexByCableKey(n, this.rgCables);
        int n3 = this.getIndexByCableKey(n, this.heliaxCables);
        return Math.max(n2, n3);
    }

    private void addCable(Cable cable) {
        if (cable == null) {
            return;
        }
        if (cable.isRG()) {
            this.rgCables.addElement(cable);
        }
        if (cable.isHeliax()) {
            this.heliaxCables.addElement(cable);
        }
    }

    static Cable getCableFromLine(String string) {
        try {
            string = string.trim();
            if (string.length() == 0) {
                return null;
            }
            if (string.startsWith("#")) {
                return null;
            }
            int n = string.indexOf("=");
            if (n < 0) {
                return null;
            }
            int n2 = Integer.parseInt(string.substring(0, n));
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), "|");
            if (!stringTokenizer.hasMoreTokens()) {
                return null;
            }
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            short s = Short.parseShort(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            int n5 = Integer.parseInt(stringTokenizer.nextToken());
            int n6 = Integer.parseInt(stringTokenizer.nextToken());
            int n7 = Integer.parseInt(stringTokenizer.nextToken());
            return new Cable(n2, n3, string2, n4, n5, n6, n7, s);
        }
        catch (Exception exception) {
            logger.error("getCableFromLine() exception", exception);
            return null;
        }
    }

    private void loadCables() {
        try {
            int n;
            InputStream inputStream = this.getClass().getResourceAsStream("/elgato/dtf_cables.properties");
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStream.read()) != -1) {
                if (n == 10) {
                    this.handleCableLine(stringBuffer);
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append((char)n);
            }
            this.handleCableLine(stringBuffer);
        }
        catch (IOException iOException) {
            logger.error("Error reading in cable types.", iOException);
        }
    }

    private void handleCableLine(StringBuffer stringBuffer) {
        this.addCable(Cables.getCableFromLine(stringBuffer.toString()));
    }

    public Cable getCable(int n) {
        Cable cable = Cables.getCableFrom(n, this.rgCables);
        if (cable != null) {
            return cable;
        }
        cable = Cables.getCableFrom(n, this.heliaxCables);
        return cable;
    }

    public Cable getRGCable(int n) {
        Cable cable = Cables.getCableFrom(n, this.rgCables);
        return cable;
    }

    public Cable getHeliaxCable(int n) {
        Cable cable = Cables.getCableFrom(n, this.heliaxCables);
        return cable;
    }

    private static Cable getCableFrom(int n, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Cable cable = (Cable)vector.elementAt(i);
            if (cable.getCableKey() != n) continue;
            return cable;
        }
        return null;
    }

    public String toString() {
        Cable cable;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.rgCables.size();
        stringBuffer.append("\nRG Cables ----------------------\n");
        for (n = 0; n < n2; ++n) {
            cable = (Cable)this.rgCables.elementAt(n);
            stringBuffer.append(cable.toString() + "\n");
        }
        n2 = this.heliaxCables.size();
        stringBuffer.append("\nHeliax Cables ----------------------\n");
        for (n = 0; n < n2; ++n) {
            cable = (Cable)this.heliaxCables.elementAt(n);
            stringBuffer.append(cable.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

