/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.infrastructure.actuators.ActuatorField;
import elgato.infrastructure.analyzer.AntennaTraceAnalyzer;
import elgato.infrastructure.analyzer.AntennaTraceChart;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.peakSearch.PeakFinder;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.DistanceStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Conversions;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.dtf.DistanceToFaultChart;
import elgato.measurement.dtf.DistanceToFaultMeasurement;
import elgato.measurement.dtf.DtfMeasurementSettings;
import elgato.measurement.dtf.DtfMetrics;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DistanceToFaultAnalyzer
extends AntennaTraceAnalyzer {
    private DistanceToFaultMeasurement measurement;
    private DtfMetrics metrics = new DtfMetrics();
    protected ELabel cableTypeLabel;
    protected ELabel measuredDistanceLabel;
    protected ValueListener cableTypeValueListener;
    protected ValueListener maxDistanceWindowLabelListener;
    private final NumberFieldStrategy decibelStrategyTraceSave = new DecibelStrategy(1, false);
    private final NumberFieldStrategy feetStrategyTraceSave = new FixedPointNumberFieldStrategy(1, "ft");
    private final NumberFieldStrategy meterStrategyTraceSave = new FixedPointNumberFieldStrategy(1, "m");
    private DtfMeasurementSettings settings;
    private ValueListener unitsListener = new ValueListener(){
        private String listenerName = ".unitsListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = DistanceToFaultAnalyzer.this.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            DistanceToFaultAnalyzer.this.configureChartXAxis(DistanceToFaultAnalyzer.this.getChart());
        }
    };
    private ValueListener displayDistanceListener = new ValueListener(){
        private String listenerName = ".displayDistListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = DistanceToFaultAnalyzer.this.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
            if (dtfMeasurementSettings.getDistFreqMode().intValue() == 0) {
                DistanceToFaultAnalyzer.this.panXaxis(dtfMeasurementSettings.getStartDistance().longValue(), valueInterface.longValue());
            }
        }
    };
    private ValueListener distanceListener = new ValueListener(){
        private String listenerName = ".distanceListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = DistanceToFaultAnalyzer.this.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
            if (dtfMeasurementSettings.getDistFreqMode().intValue() == 1) {
                DistanceToFaultAnalyzer.this.panXaxis(dtfMeasurementSettings.getStartDistance().longValue(), valueInterface.longValue());
            }
        }
    };
    private ValueListener startDistanceListener = new ValueListener(){
        private String listenerName = ".startDistanceListener";
        private String baseName = null;

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = DistanceToFaultAnalyzer.this.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
            long l = valueInterface.longValue();
            DistanceToFaultAnalyzer.this.panXaxis(l, dtfMeasurementSettings.getFreqModeStopDistance().longValue());
        }
    };

    DistanceToFaultAnalyzer() {
        super(DtfMeasurementSettings.instance().getRefLevel(), DtfMeasurementSettings.instance().getScaleDiv(), "DtfAnalyzer");
        this.settings = DtfMeasurementSettings.instance();
        this.cableTypeLabel = new ELabel(Text.Cable_Type, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT);
        this.measuredDistanceLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 4, 1);
        this.listenToActuator(this.settings.getFaultIndicator());
        this.maxDistanceWindowLabelListener = new ValueListener(){
            private String listenerName = ".maxDistWindowLabelListener";
            private String baseName = null;

            public String getListenerName() {
                if (this.baseName == null) {
                    this.baseName = DistanceToFaultAnalyzer.this.getListenerBaseName();
                    this.listenerName = this.baseName + this.listenerName;
                }
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                DistanceToFaultAnalyzer.this.updateMeasuredDistanceLabel();
            }
        };
        this.cableTypeValueListener = new ValueListener(){
            private String listenerName = ".cableTypeValueListener";
            private String baseName = null;

            public String getListenerName() {
                if (this.baseName == null) {
                    this.baseName = DistanceToFaultAnalyzer.this.getListenerBaseName();
                    this.listenerName = this.baseName + this.listenerName;
                }
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                DistanceToFaultAnalyzer.this.updateCableTypeLabel();
            }
        };
        this.settings.getCableType().addValueListener(this.cableTypeValueListener);
        this.settings.getCableAttenuation().addValueListener(this.cableTypeValueListener);
        this.settings.getCableVelocity().addValueListener(this.cableTypeValueListener);
        this.settings.getCalcDist().addValueListener(this.maxDistanceWindowLabelListener);
        this.settings.getDistFreqMode().addValueListener(this.maxDistanceWindowLabelListener);
        this.settings.getDistance().addValueListener(this.distanceListener);
        this.settings.getFreqModeStopDistance().addValueListener(this.displayDistanceListener);
        this.settings.getStartDistance().addValueListener(this.startDistanceListener);
        this.settings.getLimitsToggle().addValueListener(this.limitsStateListener);
        SystemMeasurementSettings.instance().getDtfUnits().addValueListener(this.unitsListener);
        this.updateMeasuredDistanceLabel();
        this.updateCableTypeLabel();
        TraceChart traceChart = this.getChart();
        traceChart.setManualXRange(false);
        this.init();
        this.settings.getLimitsToggle().fireValueChanged();
    }

    public void dispose() {
        this.settings.getCableType().removeValueListener(this.cableTypeValueListener);
        this.settings.getCableAttenuation().removeValueListener(this.cableTypeValueListener);
        this.settings.getCableVelocity().removeValueListener(this.cableTypeValueListener);
        this.settings.getCalcDist().removeValueListener(this.maxDistanceWindowLabelListener);
        this.settings.getDistFreqMode().removeValueListener(this.maxDistanceWindowLabelListener);
        this.settings.getDistance().removeValueListener(this.distanceListener);
        this.settings.getFreqModeStopDistance().removeValueListener(this.displayDistanceListener);
        this.settings.getStartDistance().removeValueListener(this.startDistanceListener);
        this.settings.getLimitsToggle().removeValueListener(this.limitsStateListener);
        SystemMeasurementSettings.instance().getDtfUnits().removeValueListener(this.unitsListener);
        super.dispose();
    }

    private void updateMeasuredDistanceLabel() {
        DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
        String string = dtfMeasurementSettings.getDistFreqMode().intValue() == 0 ? Text.Measured_Distance + ": " + dtfMeasurementSettings.getCalcDist() : "";
        this.measuredDistanceLabel.setChunk(0, string);
    }

    private void updateCableTypeLabel() {
        DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
        int n = dtfMeasurementSettings.getCableType().getSelectedValue().intValue();
        if (n == 1) {
            this.cableTypeLabel.setChunk(0, Text.Cable_Type + ": " + dtfMeasurementSettings.getRgCableList().getSelectedValue().getLabel());
        } else if (n == 2) {
            this.cableTypeLabel.setChunk(0, Text.Cable_Type + ": " + dtfMeasurementSettings.getHlxCableList().getSelectedValue().getLabel());
        } else if (n == 0) {
            this.cableTypeLabel.setChunk(0, Text.Cable_Type + ": " + Text.Atten + ": " + dtfMeasurementSettings.getCableAttenuation().toString() + " " + Text.Vel + ": " + dtfMeasurementSettings.getCableVelocity().toString());
        } else {
            this.cableTypeLabel.setChunk(0, Text.Cable_Type + ": ");
        }
    }

    public long getViewStopValue() {
        return this.measurement.getActiveDistance();
    }

    protected AntennaTraceChart getLineChart() {
        DistanceToFaultChart distanceToFaultChart = new DistanceToFaultChart(4);
        distanceToFaultChart.setDrawXAxisLabels(true);
        this.configureChartXAxis(distanceToFaultChart);
        return distanceToFaultChart;
    }

    private void configureChartXAxis(TraceChart traceChart) {
        int n = SystemMeasurementSettings.instance().getDtfUnits().intValue();
        if (n == SystemMeasurementSettings.VALUE_FEET) {
            traceChart.setxAxisStrategy(new FixedPointNumberFieldStrategy(0, "ft"));
            traceChart.setxAxisConversion(Conversions.cmToFt());
        } else {
            traceChart.setxAxisStrategy(new FixedPointNumberFieldStrategy(1, "m"));
            traceChart.setxAxisConversion(Conversions.cmToM());
        }
    }

    protected JComponent makeTopPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        jPanel.setBackground(null);
        jPanel.add(this.cableTypeLabel);
        jPanel.add(this.measuredDistanceLabel);
        jPanel.add(this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return DistanceToFaultAnalyzer.this.isValidCalibration(measurement) ? DistanceToFaultAnalyzer.this.getCalibratedText() : DistanceToFaultAnalyzer.this.getUncalibratedText();
            }
        }));
        jPanel.add(this.addLabel(new DynamicLabel("marker", 4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return DistanceToFaultAnalyzer.this.getCurrentMarkerDescription();
            }
        }));
        return jPanel;
    }

    protected Component createBottomPanel() {
        return new BorderWrapper(this.metrics, MeasurementMetrics.BORDER, true);
    }

    protected TraceAnalyzer.AverageDynamicLabel getAverageDynamicLabel() {
        return new TraceAnalyzer.AverageDynamicLabel(DistanceToFaultMeasurement.AVERAGE_TYPE, DistanceToFaultMeasurement.NUM_AVERAGES, DistanceToFaultMeasurement.AVERAGE_COUNT);
    }

    protected void addXAxisLabels(GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout) {
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected void setMeasurement(Measurement measurement) {
        TraceChart traceChart;
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        if ((traceChart = this.getChart()).isManualXRange()) {
            traceChart.setManualXRange(false);
        }
        this.measurement = (DistanceToFaultMeasurement)measurement;
        this.metrics.setMeasurement(this.measurement);
    }

    public MeasurementMetrics getMeasurementMetrics() {
        return this.metrics;
    }

    public TabDelimitable[] createReadingFields() {
        TabDelimitable[] tabDelimitableArray;
        int n;
        int n2;
        ReadingField[] readingFieldArray = new ReadingField[12];
        PeakFinder peakFinder = this.measurement.createFaultFinder();
        ActuatorField[] actuatorFieldArray = new ActuatorField[7];
        DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
        actuatorFieldArray[0] = new ActuatorField(dtfMeasurementSettings.getStartDistance());
        actuatorFieldArray[1] = dtfMeasurementSettings.getDistFreqMode().intValue() == 0 ? new ActuatorField(dtfMeasurementSettings.getFreqModeStopDistance()) : new ActuatorField(dtfMeasurementSettings.getDistance());
        actuatorFieldArray[2] = new ActuatorField(dtfMeasurementSettings.getCalStartFreq());
        actuatorFieldArray[3] = new ActuatorField(dtfMeasurementSettings.getCalStopFreq());
        switch (dtfMeasurementSettings.getCableType().intValue()) {
            case 1: {
                actuatorFieldArray[4] = new ActuatorField(dtfMeasurementSettings.getRgCableList());
                break;
            }
            case 2: {
                actuatorFieldArray[4] = new ActuatorField(dtfMeasurementSettings.getHlxCableList());
                break;
            }
            case 0: {
                actuatorFieldArray[4] = new ActuatorField(dtfMeasurementSettings.getCableType());
            }
        }
        actuatorFieldArray[5] = new ActuatorField(dtfMeasurementSettings.getCableAttenuation());
        actuatorFieldArray[6] = new ActuatorField(dtfMeasurementSettings.getCableVelocity());
        int n3 = 0;
        int n4 = 0;
        while (n3 < 4) {
            n2 = n3 < peakFinder.getNumPeaks() ? 1 : 0;
            n = n2 != 0 ? this.measurement.getIndexForXValue(peakFinder.getPeakXValue(n3)) : -1;
            long l = -333000L;
            class FaultField
            extends ReadingField {
                private final float divisor;
                private final int decimalPlace;
                private final long value;

                public FaultField(String string, String string2, float f, int n, long l) {
                    super(string, string2, -1);
                    this.divisor = f;
                    this.decimalPlace = n;
                    this.value = l;
                }

                public String getValue() {
                    if (this.value == -333000L) {
                        return "-----";
                    }
                    double d = (float)this.value / this.divisor;
                    return this.formatValue(d, this.decimalPlace);
                }
            }
            readingFieldArray[n4 + 0] = new FaultField("DTF " + (n3 + 1) + " Return Loss", "dB", 1000.0f, 1, n2 != 0 ? (long)this.measurement.getTrace()[n] : l);
            long l2 = (long)n * (this.getSettingsXstop() - this.getSettingsXstart()) / (long)this.measurement.getTraceLength();
            readingFieldArray[n4 + 1] = new FaultField("DTF " + (n3 + 1) + " Distance in meters", "meters", 100.0f, 1, n2 != 0 ? (l2 += this.getSettingsXstart()) : l);
            readingFieldArray[n4 + 2] = new FaultField("DTF " + (n3 + 1) + " Distance in feet", "feet", 30.48f, 1, n2 != 0 ? l2 : l);
            ++n3;
            n4 += 3;
        }
        n4 = this.measurement.getTrace().length;
        n2 = 2;
        n = 0;
        int n5 = readingFieldArray.length;
        int n6 = actuatorFieldArray.length;
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 1) {
            n2 = 5;
            tabDelimitableArray = new TabDelimitable[n5 + n4 + n2 + n6];
        } else {
            tabDelimitableArray = new TabDelimitable[n5 + n2 + n6];
        }
        for (int i = 0; i < n5; ++i) {
            tabDelimitableArray[n++] = readingFieldArray[i];
        }
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 1) {
            NumberFieldStrategy numberFieldStrategy;
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("");
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Trace Data");
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("X-AXIS\t\tY-AXIS");
            long l = this.getSettingsXstop() - this.getSettingsXstart();
            long l3 = this.getSettingsXstart();
            int n7 = SystemMeasurementSettings.instance().getDtfUnits().intValue();
            if (n7 == SystemMeasurementSettings.VALUE_FEET) {
                numberFieldStrategy = this.feetStrategyTraceSave;
                l = Conversions.cmToFt().convert(l);
                l3 = Conversions.cmToFt().convert(l3);
            } else {
                numberFieldStrategy = this.meterStrategyTraceSave;
                l = Conversions.cmToM().convert(l);
                l3 = Conversions.cmToM().convert(l3);
            }
            if (l <= 0L) {
                l = 1L;
            }
            double d = n4 - 1 <= 0 ? 1.0 : (double)l / (double)(n4 - 1);
            int[] nArray = this.measurement.getTrace();
            for (int i = 0; i < n4; ++i) {
                tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Trace", numberFieldStrategy, (long)(d * (double)i + (double)l3), "", this.decibelStrategyTraceSave, nArray[i]);
            }
        }
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("SETUP DATA");
        if (this.measurement.isCalibrated()) {
            for (int i = 0; i < n6; ++i) {
                tabDelimitableArray[n++] = actuatorFieldArray[i];
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                tabDelimitableArray[n++] = actuatorFieldArray[i];
            }
            String string = dtfMeasurementSettings.getCalStartFreq().getLongLabel() + "\t-----";
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string);
            string = dtfMeasurementSettings.getCalStopFreq().getLongLabel() + "\t-----";
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string);
            for (int i = 4; i < n6; ++i) {
                tabDelimitableArray[n++] = actuatorFieldArray[i];
            }
        }
        return tabDelimitableArray;
    }

    public NumberFieldStrategy getXAxisStrategy() {
        return DistanceStrategy.instance();
    }

    protected long getSettingsXstart() {
        DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
        return dtfMeasurementSettings.getStartDistance().longValue();
    }

    protected long getSettingsXstop() {
        DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
        if (dtfMeasurementSettings.getDistFreqMode().intValue() == 0) {
            return dtfMeasurementSettings.getFreqModeStopDistance().longValue();
        }
        return dtfMeasurementSettings.getDistance().longValue();
    }

    protected boolean isValidCalibration(Measurement measurement) {
        return ((DistanceToFaultMeasurement)measurement).isCalibrated();
    }

    protected String getCalibratedText() {
        DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
        if (dtfMeasurementSettings.getDistFreqMode().intValue() == 0) {
            return Text.Calibrated + "(" + DtfMeasurementSettings.instance().getCalStartFreq().toString() + " - " + DtfMeasurementSettings.instance().getCalStopFreq().toString() + ")";
        }
        return Text.Calibrated + "(" + DtfMeasurementSettings.instance().getAutoCalStartFreq().toString() + " - " + DtfMeasurementSettings.instance().getAutoCalStopFreq().toString() + ")";
    }

    protected void setLimitsState() {
        AntennaTraceChart antennaTraceChart = (AntennaTraceChart)this.getOurChart();
        antennaTraceChart.setShowLimits(this.settings.getLimitsToggle().booleanValue());
    }
}

