/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.infrastructure.analyzer.AntennaTraceChart;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.peakSearch.PeakFinder;
import elgato.measurement.dtf.DistanceToFaultMeasurement;
import elgato.measurement.dtf.DtfMeasurementSettings;
import elgato.measurement.dtf.PeakIndicator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;

public class DistanceToFaultChart
extends AntennaTraceChart {
    private int maxPeaks;

    public DistanceToFaultChart(int n) {
        this.setXGridType(new TraceChart.MajorXDivisions(this));
        this.maxPeaks = n;
    }

    public int getMaxPeaks() {
        return this.maxPeaks;
    }

    protected void drawMarkers(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (DtfMeasurementSettings.instance().getFaultIndicator().getSelectedValue().intValue() == 1) {
            this.addPeakIndicators(graphics);
        }
        super.drawMarkers(graphics, n, n2, n3, n4, n5);
    }

    protected void addPeakIndicators(Graphics graphics) {
        PeakFinder peakFinder = ((DistanceToFaultMeasurement)this.measurement).createFaultFinder();
        int n = this.getXStartTraceIndex();
        int n2 = this.getXStopTraceIndex();
        int n3 = Math.min(peakFinder.getNumPeaks(), this.maxPeaks);
        for (int i = 0; i < n3; ++i) {
            long l = peakFinder.getPeakXValue(i);
            int n4 = this.measurement.getIndexForXValue(l);
            if (n4 < n || n4 > n2) continue;
            int n5 = n4 - n;
            PeakIndicator peakIndicator = new PeakIndicator(i, ((DistanceToFaultMeasurement)this.measurement).isPassingLimitCheck(i));
            int n6 = this.traceXpts[n5];
            int n7 = this.traceYpts[n5];
            peakIndicator.paintIcon(this, graphics, n6 - peakIndicator.getIconWidth() / 2, n7 - peakIndicator.getIconHeight());
        }
    }

    protected void showLimits(Graphics graphics, int n, int n2) {
        if (this.showLimits) {
            Insets insets = this.getInsets();
            n2 -= insets.top + insets.bottom + 2;
            DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
            double d = this.getYTop();
            double d2 = (double)this.getYBottom() - d;
            double d3 = ((double)dtfMeasurementSettings.getUpperLimit().longValue() - d) * (double)(n2 -= this.getGridTopMargin() + this.getGridBottomMargin()) / d2 + 14.0;
            graphics.setColor(Color.yellow);
            graphics.drawLine(insets.left, (int)d3, n - insets.right - 1, (int)d3);
        }
    }
}

