/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.peakSearch.PeakFinder;
import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.measurement.dtf.DtfMeasurementSettings;
import java.io.DataInput;
import java.io.IOException;

public class DistanceToFaultMeasurement
extends TraceMeasurement {
    private static final long serialVersionUID = 345514086632396617L;
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$dtf$DistanceToFaultMeasurement == null ? (class$elgato$measurement$dtf$DistanceToFaultMeasurement = DistanceToFaultMeasurement.class$("elgato.measurement.dtf.DistanceToFaultMeasurement")) : class$elgato$measurement$dtf$DistanceToFaultMeasurement);
    private static final Queue pool = new Queue(3);
    static final int TRACE_LENGTH = 256;
    private IntegerArrayReading trace = new IntegerArrayReading(256);
    private BooleanReading validCalibration = new BooleanReading();
    private IntegerReading mode = new IntegerReading();
    private IntegerReading distance = new IntegerReading();
    private IntegerReading attenuation = new IntegerReading();
    private IntegerReading propVelocity = new IntegerReading();
    private IntegerReading averageType = new IntegerReading();
    private IntegerReading numAverages = new IntegerReading();
    private IntegerReading interferenceMode = new IntegerReading();
    private IntegerReading startFrequency = new IntegerReading();
    private IntegerReading stopFrequency = new IntegerReading();
    private IntegerReading distFreqMode = new IntegerReading();
    private IntegerReading calcDistance = new IntegerReading();
    private IntegerReading calcStartFreq = new IntegerReading();
    private IntegerReading calcStopFreq = new IntegerReading();
    private IntegerReading displayDistance = new IntegerReading();
    private IntegerReading averageCount = new IntegerReading();
    private IntegerReading dtfFFTSize = new IntegerReading();
    private IntegerReading startDistance = new IntegerReading();
    private IntegerReading calStart = new IntegerReading();
    private IntegerReading calStop = new IntegerReading();
    private IntegerReading autoCalStart = new IntegerReading();
    private IntegerReading autoCalStop = new IntegerReading();
    private static int readCount = 0;
    private static int mismatchCount = 0;
    private static int readingCount = 0;
    public static final int TRACE = readingCount++;
    public static final int VALID_CALIBRATION = readingCount++;
    public static final int MODE = readingCount++;
    public static final int DISTANCE = readingCount++;
    public static final int ATTENUATION = readingCount++;
    public static final int PROP_VELOCITY = readingCount++;
    public static final int AVERAGE_TYPE = readingCount++;
    public static final int NUM_AVERAGES = readingCount++;
    public static final int INTERFERENCE_MODE = readingCount++;
    public static final int START_FREQUENCY = readingCount++;
    public static final int STOP_FREQUENCY = readingCount++;
    public static final int DIST_FREQ_MOD = readingCount++;
    public static final int CALC_DISTANCE = readingCount++;
    public static final int CALC_START_FREQ = readingCount++;
    public static final int CALC_STOP_FREQ = readingCount++;
    public static final int DISPLAY_DISTANCE = readingCount++;
    public static final int AVERAGE_COUNT = readingCount++;
    public static final int DTF_FFT_SIZE = readingCount++;
    public static final int START_DISTANCE = readingCount++;
    public static final int CAL_START_FREQ = readingCount++;
    public static final int CAL_STOP_FREQ = readingCount++;
    public static final int AUTO_CAL_START_FREQ = readingCount++;
    public static final int AUTO_CAL_STOP_FREQ = readingCount++;
    private Reading[] readings = new Reading[]{this.trace, this.validCalibration, this.mode, this.distance, this.attenuation, this.propVelocity, this.averageType, this.numAverages, this.interferenceMode, this.startFrequency, this.stopFrequency, this.distFreqMode, this.calcDistance, this.calcStartFreq, this.calcStopFreq, this.displayDistance, this.averageCount, this.dtfFFTSize, this.startDistance, this.calStart, this.calStop, this.autoCalStart, this.autoCalStop};
    static /* synthetic */ Class class$elgato$measurement$dtf$DistanceToFaultMeasurement;

    public DistanceToFaultMeasurement() {
        this.setTraceInverted(true);
    }

    public static DistanceToFaultMeasurement unpack(DataInput dataInput) throws IOException {
        DistanceToFaultMeasurement distanceToFaultMeasurement = DistanceToFaultMeasurement.create();
        Reading[] readingArray = distanceToFaultMeasurement.getReadings();
        if (readCount < Integer.MAX_VALUE) {
            ++readCount;
        }
        for (int i = 0; i < readingArray.length; ++i) {
            readingArray[i].unpack(dataInput);
        }
        return distanceToFaultMeasurement;
    }

    public static DistanceToFaultMeasurement create() {
        DistanceToFaultMeasurement distanceToFaultMeasurement = (DistanceToFaultMeasurement)pool.dequeue();
        if (distanceToFaultMeasurement == null) {
            return new DistanceToFaultMeasurement();
        }
        return distanceToFaultMeasurement;
    }

    public boolean isCalibrated() {
        return this.validCalibration.booleanValue();
    }

    public int getCalibrationMeasurementMode() {
        return this.mode.intValue();
    }

    public int getDistance() {
        return this.distance.intValue();
    }

    public int getCableAttenuation() {
        return this.attenuation.intValue();
    }

    public int getCablePropogationVelocity() {
        return this.propVelocity.intValue();
    }

    public int getAverageType() {
        return this.averageType.intValue();
    }

    public int getNumAverages() {
        return this.numAverages.intValue();
    }

    public int getAverageCount() {
        return this.averageCount.intValue();
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int[] getTrace() {
        return this.trace.getTrace();
    }

    public long getTraceStartValue() {
        return this.startDistance.longValue();
    }

    public int getActiveDistance() {
        switch (this.distFreqMode.intValue()) {
            case 0: {
                return this.displayDistance.intValue();
            }
            case 1: {
                return this.distance.intValue();
            }
        }
        logger.warn("unknown dist/freq mode: " + this.distFreqMode.intValue());
        return this.distance.intValue();
    }

    public long getTraceStopValue() {
        return this.getActiveDistance();
    }

    public Reading[] getReadings() {
        return this.readings;
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public double getDoubleReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        return ((IntegerArrayReading)this.getReadings()[n]).getTrace()[n2];
    }

    public long getLongReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public String getMeasurementTitle() {
        return Text.Distance_To_Fault;
    }

    public int getInterferenceMode() {
        return this.interferenceMode.intValue();
    }

    public long getStartFrequency() {
        return this.startFrequency.intValue();
    }

    public long getStopFrequency() {
        return this.stopFrequency.intValue();
    }

    public int getDistFreqMode() {
        return this.distFreqMode.intValue();
    }

    public int getCalcDistance() {
        return this.calcDistance.intValue();
    }

    public int getCalcStartFreq() {
        return this.calcStartFreq.intValue();
    }

    public int getCalcStopFreq() {
        return this.calcStopFreq.intValue();
    }

    public int getDisplayDist() {
        return this.displayDistance.intValue();
    }

    public int getDtfFFTSize() {
        return this.dtfFFTSize.intValue();
    }

    public int getStartDistance() {
        return this.startDistance.intValue();
    }

    public int getCalStart() {
        return this.calStart.intValue();
    }

    public int getCalStop() {
        return this.calStop.intValue();
    }

    public int getAutoCalStart() {
        return this.autoCalStart.intValue();
    }

    public int getAutoCalStop() {
        return this.autoCalStop.intValue();
    }

    public PeakFinder createFaultFinder() {
        long l = this.getActiveDistance();
        int n = this.getIndexForXValue(l) - 1;
        PeakFinder peakFinder = this.createPeakFinder();
        peakFinder.processTrace(TraceMeasurement.inverted(this.getTrace()), 0, n, this);
        return peakFinder;
    }

    protected boolean actuatorsMatchCurrentSettings() {
        DtfMeasurementSettings dtfMeasurementSettings = DtfMeasurementSettings.instance();
        boolean bl = true;
        if (readCount == 0) {
            return true;
        }
        if (!this.resultEqualsSetting(logger, dtfMeasurementSettings.getCalcDist(), this.calcDistance.longValue())) {
            bl = false;
        } else if (!this.resultEqualsSetting(logger, dtfMeasurementSettings.getDistance(), this.distance.longValue())) {
            bl = false;
        } else if (!this.resultEqualsSetting(logger, dtfMeasurementSettings.getDistFreqMode(), this.distFreqMode.longValue())) {
            bl = false;
        } else if (!this.resultEqualsSetting(logger, dtfMeasurementSettings.getFreqModeStopDistance(), this.displayDistance.longValue())) {
            bl = false;
        } else if (!this.resultEqualsSetting(logger, dtfMeasurementSettings.getStartDistance(), this.startDistance.longValue())) {
            bl = false;
        }
        if (this.isCalibrated()) {
            if (!dtfMeasurementSettings.getDistFreqMode().booleanValue()) {
                if (!this.resultEqualsSetting(logger, dtfMeasurementSettings.getCalStartFreq(), this.calStart.longValue() * 1000L)) {
                    bl = false;
                } else if (!this.resultEqualsSetting(logger, dtfMeasurementSettings.getCalStopFreq(), this.calStop.longValue() * 1000L)) {
                    bl = false;
                }
            } else if (!this.resultEqualsSetting(logger, dtfMeasurementSettings.getAutoCalStartFreq(), this.autoCalStart.longValue() * 1000L)) {
                bl = false;
            } else if (!this.resultEqualsSetting(logger, dtfMeasurementSettings.getAutoCalStopFreq(), this.autoCalStop.longValue() * 1000L)) {
                bl = false;
            }
        }
        mismatchCount = bl ? 0 : ++mismatchCount;
        if (mismatchCount > 3) {
            logger.warn("Result/Setting mismatch #" + mismatchCount + ", resetting and continuing as if matched");
            mismatchCount = 0;
            bl = true;
            dtfMeasurementSettings.invalidate();
            dtfMeasurementSettings.refresh();
        }
        return bl;
    }

    public boolean isPassingLimitCheck(int n) {
        PeakFinder peakFinder = this.createFaultFinder();
        if (n < peakFinder.getNumPeaks()) {
            long l = peakFinder.getPeakXValue(n);
            int n2 = this.getIndexForXValue(l);
            int n3 = this.getTrace()[n2];
            if (DtfMeasurementSettings.instance().getUpperLimit().longValue() >= (long)n3) {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

