/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandChannelEmulator;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.measurement.dtf.DistanceToFaultMeasurement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;

public class DistanceToFaultMeasurementGenerator
extends MeasurementGenerator {
    private Random rand = new Random();
    private int calibratedState = 1;

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return DistanceToFaultMeasurement.unpack(dataInput);
    }

    protected void writePayload(DataOutput dataOutput) throws IOException {
        this.createTraceData(dataOutput);
        this.getCallibration(dataOutput);
        dataOutput.writeInt(1);
        dataOutput.writeInt(23470);
        dataOutput.writeInt(30);
        dataOutput.writeInt(8990);
        dataOutput.writeInt(0);
        dataOutput.writeInt(6);
        dataOutput.writeInt(9);
        dataOutput.writeInt(1850000);
        dataOutput.writeInt(1990000);
        dataOutput.writeInt(0);
        dataOutput.writeInt(12768);
        dataOutput.writeInt(375000);
        dataOutput.writeInt(2360000);
        dataOutput.writeInt(22);
        dataOutput.writeInt(11);
        dataOutput.writeInt(0);
        dataOutput.writeInt(0);
        dataOutput.writeInt(1850000);
        dataOutput.writeInt(1990000);
        dataOutput.writeInt(325000);
        dataOutput.writeInt(668228);
    }

    void createTraceData(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < 256; ++i) {
            int n = i > 50 && i < 60 ? 50000 - (i - 50) * 1200 + this.nextInt(2000) : (i >= 60 && i < 70 ? 50000 - (70 - i) * 1200 + this.nextInt(2000) : (i > 100 && i < 110 ? 50000 - (i - 100) * 4000 + this.nextInt(2000) : (i >= 110 && i < 120 ? 50000 - (120 - i) * 4000 + this.nextInt(2000) : (i > 150 && i < 160 ? 50000 - (i - 150) * 1200 + this.nextInt(2000) : (i >= 160 && i < 170 ? 50000 - (170 - i) * 1200 + this.nextInt(2000) : (i > 200 && i < 210 ? 50000 - (i - 200) * 1000 + this.nextInt(2000) : (i >= 210 && i < 220 ? 50000 - (220 - i) * 1000 + this.nextInt(2000) : 50000 - i * 10 + this.nextInt(1000))))))));
            dataOutput.writeInt(n);
        }
    }

    void getCallibration(DataOutput dataOutput) throws IOException {
        if (this.calibratedState == -1) {
            dataOutput.writeInt(this.rand.nextInt() & 1);
        } else {
            dataOutput.writeInt(this.calibratedState);
        }
    }

    int nextInt(int n) {
        return Math.abs(this.rand.nextInt()) % n;
    }

    public void setCalibrated() {
        this.calibratedState = 1;
    }

    public void setUncalibrated() {
        this.calibratedState = 0;
    }

    public void setCommandChannelEmulator(CommandChannelEmulator commandChannelEmulator) {
        Command command = Command.makeSetCommand("antDtf");
        command.addProperty("mode", 6L);
        commandChannelEmulator.addListener(command, (CommandChannelEmulator.EmulatorCommandListener)new UncalibratedListener());
    }

    private class UncalibratedListener
    implements CommandChannelEmulator.EmulatorCommandListener {
        private UncalibratedListener() {
        }

        public Command processCommand(Command command) {
            DistanceToFaultMeasurementGenerator.this.setUncalibrated();
            return null;
        }
    }
}

