/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.ScaleDivActuator;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.measurement.Validator;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.units.RelativeFactorConversion;
import elgato.infrastructure.units.UnitsFactory;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.PercentValueListener;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.dtf.Cable;
import elgato.measurement.dtf.Cables;
import java.util.Vector;

public class DtfMeasurementSettings
extends MeasurementSettings {
    private static DtfMeasurementSettings instance;
    public static final String TOPIC_DTF = "antDtf";
    public static final String TOPIC_DTF_DISPLAY = "display.antDtf";
    public static final String KEY_DTF_DISTANCE = "distance";
    public static final String KEY_DTF_DISTANCE_UNITS = "units";
    public static final String KEY_DTF_CABLE_ATTENUATION = "cableAtten";
    public static final String KEY_DTF_CABLE_VELOCITY = "cableVelocity";
    public static final String KEY_DTF_CABLE_KEY = "cableKey_";
    public static final String KEY_DTF_CABLE_TYPE = "cableType";
    public static final int FREQUENCY_MODE = 0;
    public static final int DISTANCE_MODE = 1;
    private ScaleDivActuator scaleDiv = new ScaleDivActuator("display.antDtf");
    private boolean passesLimitchecks;
    private LongActuator refLevel = LongActuator.createRefLevelActuator("display.antDtf", 0, "dB", -10000, 150000, this.scaleDiv);
    private LongActuator numAverages = LongActuator.createNumAverages("antDtf", 100);
    private Validator distanceValidator = new RangeValidator(100L, 30480L, 0);
    private Validator startDistanceValidator = new RangeValidator(0L, 100000000L, 0);
    private LongActuator distance = new LongActuator("antDtf", "distance", Text.Stop_n_Distance, 0L);
    private ListActuator averaging = ListActuator.createStandardAveraging("antDtf");
    private ListActuator cableType = new ListActuator("display.antDtf", "cableType", Text.Cable_Type, new Value[]{Value.createValue(Text.RG, 1), Value.createValue(Text.BTS, 2), Value.createValue(Text.Cust, 0)});
    private Cables cables = new Cables();
    private ListActuator rgCableList = new ListActuator("display.antDtf", "cableKey_1", Text.Select_Cable, this.cableVectorToArray(this.cables.getRGCables()));
    private ListActuator hlxCableList = new ListActuator("display.antDtf", "cableKey_2", Text.Select_Cable, this.cableVectorToArray(this.cables.getHeliaxCables()));
    private LongActuator cableVelocity = LongActuator.createPercentActuator("antDtf", "cableVelocity", Text.Prop_Vel, 10000, 100);
    private LongActuator cableAttenuation = new LongActuator("antDtf", "cableAtten", Text.Cable_Atten);
    private ListActuator interferenceRejection = ListActuator.createInterferenceRejection(this.getTopic());
    private FrequencyActuator startFreq = FrequencyActuator.createGlobalKilohertz("antDtf", "start", Text.Start_Freq);
    private FrequencyActuator stopFreq = FrequencyActuator.createGlobalKilohertz("antDtf", "stop", Text.Stop_Freq);
    private ListActuator distFreqMode = new ListActuator("antDtf", "distFreqMode", Text.Freq_Range, new Value[]{Value.createValue(Text.Manual, 0), Value.createValue(Text.Auto, 1)});
    private LongActuator calcDist = new LongActuator("antDtf", "calcDist", Text.Measured_Distance);
    private FrequencyActuator calcStartFreq = FrequencyActuator.createKilohertz("antDtf", "calcStart", Text.Start_Freq);
    private FrequencyActuator calcStopFreq = FrequencyActuator.createKilohertz("antDtf", "calcStop", Text.Stop_Freq);
    private LongActuator freqModeStopDistance = new LongActuator("antDtf", "displayDist", Text.Stop_n_Distance);
    private ListActuator faultIndicator = new ListActuator("display.antDtf", "faultIndicator", Text.Fault_n_Indicators, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private final ListActuator limitsToggle = new ListActuator("display.antDtf", "limitsToggle", Text.Limits, this.createOnOffValueSet());
    private LongActuator upperLimit = LongActuator.createPower("display.antDtf", "upperLimit", Text.get("Antenna_Upper_Limit"));
    private ListActuator fftSize = new ListActuator("antDtf", "dtfFFTSize", Text.Data_Points, new Value[]{Value.createValue(Text.FFTSize_256, 0), Value.createValue(Text.FFTSize_512, 1), Value.createValue(Text.FFTSize_1024, 2)});
    private LongActuator startDistance = new LongActuator("antDtf", "startDistance", Text.Start_n_Distance);
    private FrequencyActuator calStartFreq = FrequencyActuator.createGlobalKilohertz("antDtf", "calStart", Text.Calibration_n_Start_Freq);
    private FrequencyActuator calStopFreq = FrequencyActuator.createGlobalKilohertz("antDtf", "calStop", Text.Calibration_n_Stop_Freq);
    private FrequencyActuator autoCalStartFreq = FrequencyActuator.createKilohertz("antDtf", "autoCalStart", Text.Calibration_n_Start_Freq);
    private FrequencyActuator autoCalStopFreq = FrequencyActuator.createKilohertz("antDtf", "autoCalStop", Text.Calibration_n_Stop_Freq);
    private long fStoredCalStartFreq;
    private long fStoredCalStopFreq;
    static final int MINIMUM_NUMBER_OF_POINTS_IN_WINDOW = 4;
    private boolean doingLimitSetAll = true;
    private ValueListener attenuationUpdater = new DtfValueListener("attenuationUpdater"){

        public void valueChanged(ValueInterface valueInterface) {
            int n = DtfMeasurementSettings.this.getCableType().getSelectedValue().intValue();
            if (n == 1) {
                DtfMeasurementSettings.updateAttenuation((Cable)DtfMeasurementSettings.this.rgCableList.getSelectedValue());
            } else if (n == 2) {
                DtfMeasurementSettings.updateAttenuation((Cable)DtfMeasurementSettings.this.hlxCableList.getSelectedValue());
            }
        }
    };

    private DtfMeasurementSettings() {
        super(TOPIC_DTF);
        this.add(this.interferenceRejection);
        this.add(this.numAverages);
        this.add(this.averaging);
        this.add(this.distance);
        this.add(this.cableType);
        this.add(this.rgCableList);
        this.add(this.hlxCableList);
        this.add(this.cableVelocity);
        this.add(this.cableAttenuation);
        this.add(this.startFreq);
        this.add(this.stopFreq);
        this.add(this.distFreqMode);
        this.add(this.calcDist);
        this.add(this.calcStartFreq);
        this.add(this.calcStopFreq);
        this.add(this.faultIndicator);
        this.add(this.freqModeStopDistance);
        this.add(this.limitsToggle);
        this.add(this.upperLimit);
        this.add(this.fftSize);
        this.add(this.startDistance);
        this.add(this.calStartFreq);
        this.add(this.calStopFreq);
        this.add(this.autoCalStartFreq);
        this.add(this.autoCalStopFreq);
        this.startDistance.setLongLabel(Text.Start_Distance);
        this.distance.setLongLabel(Text.Stop_Distance);
        this.freqModeStopDistance.setLongLabel(Text.Stop_Distance);
        this.calStartFreq.setLongLabel(Text.Calibration_Start_Freq);
        this.calStopFreq.setLongLabel(Text.Calibration_Stop_Freq);
        this.cableType.setLongLabel(Text.Cable_Type);
        this.rgCableList.setLongLabel(Text.Cable_Type);
        this.hlxCableList.setLongLabel(Text.Cable_Type);
        this.setValidatorToFreqSrcLimits(this.startFreq, 3);
        this.setValidatorToFreqSrcLimits(this.stopFreq, 3);
        this.setValidatorToFreqSrcLimits(this.calStartFreq, 3);
        this.setValidatorToFreqSrcLimits(this.calStopFreq, 3);
        this.setValidatorToFreqSrcLimits(this.autoCalStartFreq, 3);
        this.setValidatorToFreqSrcLimits(this.autoCalStopFreq, 3);
        this.calStartFreq.setValue(1850000000L);
        this.calStopFreq.setValue(1990000000L);
        this.autoCalStartFreq.setValue(1850000000L);
        this.autoCalStopFreq.setValue(1990000000L);
        this.calcStartFreq.addValueListener(this.attenuationUpdater);
        this.calcStopFreq.addValueListener(this.attenuationUpdater);
        this.startFreq.addValueListener(this.attenuationUpdater);
        this.stopFreq.addValueListener(this.attenuationUpdater);
        this.distFreqMode.addValueListener(this.attenuationUpdater);
        PercentValueListener percentValueListener = PercentValueListener.createTenPercentValueListener(this.startFreq, this.stopFreq, "antDtf.startStop10PctListener");
        this.startFreq.addValueListener(percentValueListener);
        this.stopFreq.addValueListener(percentValueListener);
        PercentValueListener percentValueListener2 = PercentValueListener.createTenPercentValueListener(this.calStartFreq, this.calStopFreq, "antDtf.calStartStop10PctListener");
        this.calStartFreq.addValueListener(percentValueListener2);
        this.calStopFreq.addValueListener(percentValueListener2);
        this.autoCalStartFreq.addValueListener(percentValueListener2);
        this.autoCalStopFreq.addValueListener(percentValueListener2);
        this.refLevel.setPalette(Palette.createSignedDecimal());
        this.limitsToggle.setValue(0);
        this.limitsToggle.addValueListener(new DtfValueListener("limitsToggle"){

            public void valueChanged(ValueInterface valueInterface) {
                DtfMeasurementSettings.this.setAllLimits();
            }
        });
        this.upperLimit.addValueListener(new DtfValueListener("upperLimit"){

            public void valueChanged(ValueInterface valueInterface) {
                if (!DtfMeasurementSettings.this.doingLimitSetAll) {
                    DtfMeasurementSettings.this.setAllLimits();
                }
            }
        });
        this.configureDistanceActuator(this.calcDist);
        this.configureDistanceActuatorWithValidator(this.distance);
        this.configureDistanceActuatorWithValidator(this.freqModeStopDistance);
        this.startDistance.setValidator(this.startDistanceValidator);
        this.configureDistanceActuator(this.startDistance);
        this.calcDist.setValue(10000);
        this.distance.setValue(10000);
        this.freqModeStopDistance.setValue(10000);
        this.startDistance.setValue(0);
        this.cableAttenuation.setPalette(Palette.createUnsignedDecimal());
        this.cableAttenuation.setUnitsFactory(new AttenuationUnitSystem());
        SystemMeasurementSettings.instance().getDtfUnits().addValueListener(new DtfValueListener("dtfUnits"){

            public void valueChanged(ValueInterface valueInterface) {
                DtfMeasurementSettings.this.updateFeetMeter();
            }
        });
        this.calcDist.addValueListener(new DtfValueListener("calcDist"){

            public void valueChanged(ValueInterface valueInterface) {
                DtfMeasurementSettings.this.updateDistanceWindowRange();
            }
        });
        this.updateFeetMeter();
        this.refresh();
        this.createHardwareFeatureListener(this.refLevel, this.scaleDiv, TOPIC_DTF);
    }

    private void updateDistanceWindowRange() {
        int n = this.calcDist.intValue();
        int n2 = this.calcDist.intValue() / 256 * 4;
        RangeValidator rangeValidator = new RangeValidator(n2, n);
        this.freqModeStopDistance.setValidator(rangeValidator);
    }

    private void updateFeetMeter() {
        if (SystemMeasurementSettings.instance().getDtfUnits().intValue() == SystemMeasurementSettings.VALUE_FEET) {
            this.setDtfFeet();
        } else {
            this.setDtfMeters();
        }
    }

    private void configureDistanceActuatorWithValidator(LongActuator longActuator) {
        longActuator.setValidator(this.distanceValidator);
        this.configureDistanceActuator(longActuator);
    }

    private void configureDistanceActuator(LongActuator longActuator) {
        longActuator.setUnitsFactory(new DistanceUnitSystem(longActuator));
    }

    public static DtfMeasurementSettings instance() {
        if (instance == null) {
            instance = new DtfMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    private Cable[] cableVectorToArray(Vector vector) {
        Object[] objectArray = new Cable[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public LongActuator getScaleDiv() {
        return this.scaleDiv;
    }

    public LongActuator getRefLevel() {
        return this.refLevel;
    }

    public LongActuator getNumAverages() {
        return this.numAverages;
    }

    public LongActuator getDistance() {
        return this.distance;
    }

    private void setDtfFeet() {
        this.setFeetMeterUnits(((DistanceUnitSystem)this.distance.getUnitsFactory()).footConversion, AttenuationUnitSystem.dbPer100ft);
    }

    private void setDtfMeters() {
        this.setFeetMeterUnits(((DistanceUnitSystem)this.distance.getUnitsFactory()).meterConversion, AttenuationUnitSystem.dbPer100m);
    }

    private void setFeetMeterUnits(Conversion conversion, Conversion conversion2) {
        this.distance.getUnitsFactory().setDefaultUnits(conversion);
        this.calcDist.getUnitsFactory().setDefaultUnits(conversion);
        this.freqModeStopDistance.getUnitsFactory().setDefaultUnits(conversion);
        this.startDistance.getUnitsFactory().setDefaultUnits(conversion);
        this.cableAttenuation.getUnitsFactory().setDefaultUnits(conversion2);
        this.distance.fireValueChanged();
        this.calcDist.fireValueChanged();
        this.freqModeStopDistance.fireValueChanged();
        this.startDistance.fireValueChanged();
        this.cableAttenuation.fireValueChanged();
    }

    public ListActuator getAveraging() {
        return this.averaging;
    }

    public ListActuator getLimitsToggle() {
        return this.limitsToggle;
    }

    public static boolean limitsOn() {
        return DtfMeasurementSettings.instance().limitsToggle.getSelectedValue().longValue() == 1L;
    }

    public LongActuator getUpperLimit() {
        return this.upperLimit;
    }

    public ListActuator getCableType() {
        return this.cableType;
    }

    public ListActuator getRgCableList() {
        return this.rgCableList;
    }

    public ListActuator getHlxCableList() {
        return this.hlxCableList;
    }

    public LongActuator getCableVelocity() {
        return this.cableVelocity;
    }

    public LongActuator getCableAttenuation() {
        return this.cableAttenuation;
    }

    public ListActuator getInterferenceMode() {
        return this.interferenceRejection;
    }

    public FrequencyActuator getStartFreq() {
        return this.startFreq;
    }

    public FrequencyActuator getStopFreq() {
        return this.stopFreq;
    }

    public ListActuator getDistFreqMode() {
        return this.distFreqMode;
    }

    public LongActuator getCalcDist() {
        return this.calcDist;
    }

    public FrequencyActuator getCalcStartFreq() {
        return this.calcStartFreq;
    }

    public FrequencyActuator getCalcStopFreq() {
        return this.calcStopFreq;
    }

    public LongActuator getFreqModeStopDistance() {
        return this.freqModeStopDistance;
    }

    public ListActuator getFaultIndicator() {
        return this.faultIndicator;
    }

    public ListActuator getFftSize() {
        return this.fftSize;
    }

    public LongActuator getStartDistance() {
        return this.startDistance;
    }

    public FrequencyActuator getCalStartFreq() {
        return this.calStartFreq;
    }

    public FrequencyActuator getCalStopFreq() {
        return this.calStopFreq;
    }

    public FrequencyActuator getAutoCalStartFreq() {
        return this.autoCalStartFreq;
    }

    public FrequencyActuator getAutoCalStopFreq() {
        return this.autoCalStopFreq;
    }

    public void storeCalStartStopFreqValues() {
        if (this.distFreqMode.booleanValue()) {
            this.fStoredCalStartFreq = this.autoCalStartFreq.longValue();
            this.fStoredCalStopFreq = this.autoCalStopFreq.longValue();
        } else {
            this.fStoredCalStartFreq = this.calStartFreq.longValue();
            this.fStoredCalStopFreq = this.calStopFreq.longValue();
        }
    }

    public void restoreCalStartStopFreqValues() {
        if (this.distFreqMode.booleanValue()) {
            this.autoCalStopFreq.send(this.fStoredCalStopFreq);
            this.autoCalStartFreq.send(this.fStoredCalStartFreq);
        } else {
            this.calStopFreq.send(this.fStoredCalStopFreq);
            this.calStartFreq.send(this.fStoredCalStartFreq);
        }
    }

    public static void updateAttenuation(Cable cable) {
        long l = 0L;
        if (DtfMeasurementSettings.instance().getDistFreqMode().intValue() == 0) {
            l = DtfMeasurementSettings.instance().getStartFreq().longValue() + (DtfMeasurementSettings.instance().getStopFreq().longValue() - DtfMeasurementSettings.instance().getStartFreq().longValue()) / 2L;
        } else if (DtfMeasurementSettings.instance().getDistFreqMode().intValue() == 1) {
            l = DtfMeasurementSettings.instance().getCalcStartFreq().longValue() + (DtfMeasurementSettings.instance().getCalcStopFreq().longValue() - DtfMeasurementSettings.instance().getCalcStartFreq().longValue()) / 2L;
        }
        DtfMeasurementSettings.instance().getCableAttenuation().send(cable.getAttenuationInDbPer100Meters(l));
    }

    public void allowValidationNow() {
        this.doingLimitSetAll = false;
    }

    public void setAllLimits() {
        if (MeasurementSettings.suspendValidation) {
            return;
        }
        this.doingLimitSetAll = true;
        long l = 90000L;
        long l2 = this.refLevel.longValue() + 10L * this.scaleDiv.longValue();
        this.upperLimit.setValidator(new RangeValidator(this.refLevel.longValue(), Math.min(l, l2)));
        this.doingLimitSetAll = false;
    }

    public boolean passesLimitchecks() {
        return this.passesLimitchecks;
    }

    public void setPassesLimitchecks(boolean bl) {
        this.passesLimitchecks = bl;
    }

    public boolean showLimits() {
        return this.limitsToggle.getSelectedValue().longValue() == 1L;
    }

    protected abstract class DtfValueListener
    implements ValueListener {
        private final String listenerName;

        public DtfValueListener(String string) {
            this.listenerName = "DTF." + string + ".listener";
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public abstract /* synthetic */ void valueChanged(ValueInterface var1);
    }

    private static class AttenuationUnitSystem
    extends UnitsFactory {
        public static final Conversion dbPer100m = new FactorConversion("dB/100m", "1000").setMaximumFractionDigits(2);
        public static final Conversion dbPer100ft = new FactorConversion("dB/100ft", "3280").setMaximumFractionDigits(2);
        private static final Conversion[] allUnits = new Conversion[]{dbPer100m, dbPer100ft};
        private Conversion units = dbPer100m;

        private AttenuationUnitSystem() {
        }

        public Conversion[] getUnits() {
            return allUnits;
        }

        public String toString(long l) {
            return this.units.toString(l);
        }

        public Conversion getDefaultUnits() {
            return this.units;
        }

        public void setDefaultUnits(Conversion conversion) {
            this.units = conversion;
        }
    }

    private static class DistanceUnitSystem
    extends UnitsFactory {
        public final RelativeFactorConversion footConversion;
        public final RelativeFactorConversion meterConversion;
        private Conversion units;

        public DistanceUnitSystem(LongActuator longActuator) {
            this.meterConversion = new RelativeFactorConversion("m", "100", longActuator);
            this.footConversion = new FootConversion("ft", "30.48", longActuator);
            this.footConversion.setMaximumFractionDigits(0);
            this.units = this.meterConversion;
        }

        public Conversion[] getUnits() {
            return new Conversion[]{this.meterConversion, this.footConversion};
        }

        public String toString(long l) {
            return this.units.toString(l);
        }

        public Conversion getDefaultUnits() {
            return this.units;
        }

        public void setDefaultUnits(Conversion conversion) {
            this.units = conversion;
        }
    }

    private static class FootConversion
    extends RelativeFactorConversion {
        public FootConversion(String string, String string2, LongActuator longActuator) {
            super(string, string2, longActuator);
        }

        protected int getStep() {
            return (int)((long)RelativeFactorConversion.calculateTruncatedPercentIncrement((int)((double)(this.actuator.intValue() * 1000) / this.factor.doubleValue()) / 1000, 10) * this.getFactor());
        }
    }
}

