/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.calibration.AntennaCalibrateScreen;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.ClearCalButton;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.LevelButtonFactory;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.dtf.Cable;
import elgato.measurement.dtf.CableListCellRenderer;
import elgato.measurement.dtf.DistanceToFaultAnalyzer;
import elgato.measurement.dtf.DistanceToFaultScreen;
import elgato.measurement.dtf.DtfMeasurementSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class DtfMenuMgr
extends MeasurementMenuMgr {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$dtf$DistanceToFaultScreen == null ? (class$elgato$measurement$dtf$DistanceToFaultScreen = DtfMenuMgr.class$("elgato.measurement.dtf.DistanceToFaultScreen")) : class$elgato$measurement$dtf$DistanceToFaultScreen);
    protected DistanceToFaultAnalyzer analyzer;
    protected DtfMeasurementSettings settings;
    private static final int DTF_UNCALIBRATED_MODE = 0;
    protected ClearCalButton clearCalButton;
    MarkerButtonFactory markerButtonFactory;
    private MenuItem rgListButton;
    private MenuItem heliaxListButton;
    private MenuItem cableAttenuationButton;
    private MenuItem naCableListButton;
    private MenuItem cableVelocityButton;
    private MenuItem calStartFreqButton;
    private MenuItem calStopFreqButton;
    private MenuItem freqModeCalStartFreqButton;
    private MenuItem freqModeCalStopFreqButton;
    private MenuItem freqModeStopDistanceButton;
    private MenuItem distModeCalStartFreqButton;
    private MenuItem distModeCalStopFreqButton;
    private MenuItem distModeStopDistanceButton;
    public Menu cableTypeMenu;
    protected Menu freqDistMenu;
    private MultiStateActuatorButton cableTypeToggleButton;
    private CableTypeValueListener cableTypeValueListener;
    private DistFreqModeValueListener distFreqModeValueListener;
    private UnitsChangeListener unitsChangeListener;
    private CableSelectionListener rgListener;
    private CableSelectionListener heliaxListener;
    static /* synthetic */ Class class$elgato$measurement$dtf$DistanceToFaultScreen;

    public DtfMenuMgr(DistanceToFaultScreen distanceToFaultScreen, DtfMeasurementSettings dtfMeasurementSettings, DistanceToFaultAnalyzer distanceToFaultAnalyzer) {
        super(distanceToFaultScreen);
        this.settings = dtfMeasurementSettings;
        this.analyzer = distanceToFaultAnalyzer;
        this.cableTypeToggleButton = this.createCableTypeToggleButton();
        this.cableTypeValueListener = new CableTypeValueListener(this);
        this.distFreqModeValueListener = new DistFreqModeValueListener(this);
        this.unitsChangeListener = new UnitsChangeListener(this);
        this.createMiscButtons();
        this.freqDistMenu = this.createFreqDistCalMenu();
        this.cableTypeMenu = this.createCableTypeMenu();
        this.markerButtonFactory = this.createMarkerButtonFactory();
    }

    protected abstract MenuItem createFreqDistCalButton();

    protected abstract MenuItem createCableTypeButton();

    protected abstract MenuItem createSetupButton();

    protected Menu buildLeftMenu() {
        LevelButtonFactory levelButtonFactory = new LevelButtonFactory(this.scn, this.analyzer, DtfMeasurementSettings.instance().getRefLevel(), DtfMeasurementSettings.instance().getScaleDiv(), false);
        levelButtonFactory.setDtfMode(true);
        return new Menu(Text.Dist_n_Fault, new MenuItem[]{this.createFreqDistCalButton(), levelButtonFactory.createMinimalLevelMenu(), this.createCableTypeButton(), null, this.createAverageSweepButton(DtfMeasurementSettings.instance().getNumAverages(), DtfMeasurementSettings.instance().getAveraging()), this.createSetupButton(), this.markerButtonFactory.getMenuButtonWithMinPeaks()});
    }

    private void createMiscButtons() {
        this.rgListener = new CableSelectionListener(this);
        this.rgListButton = this.createRGListButton(this.rgListener);
        this.heliaxListener = new CableSelectionListener(this);
        this.heliaxListButton = this.createHeliaxListButton(this.heliaxListener);
        this.naCableListButton = this.createNACableListButton();
        this.cableAttenuationButton = this.createAttenuationButtonAndLoadCustomSettings();
        this.cableVelocityButton = this.createVelocityButtonAndLoadCustomSettings();
        this.distModeStopDistanceButton = new ActuatorEditor(this.settings.getDistance(), "calibrate.distance", this.getListenerBaseName() + ".distanceButton");
        this.distModeCalStartFreqButton = new ActuatorEditor(this.settings.getAutoCalStartFreq(), "", this.getListenerBaseName() + ".autoCalStartFreqButton");
        this.distModeCalStopFreqButton = new ActuatorEditor(this.settings.getAutoCalStopFreq(), "", this.getListenerBaseName() + ".autoCalStopFreqButton");
        this.freqModeStopDistanceButton = new ActuatorEditor(this.settings.getFreqModeStopDistance(), "calibrate.distance", this.getListenerBaseName() + ".distanceWindowButton");
        this.freqModeCalStartFreqButton = new ActuatorEditor(this.settings.getCalStartFreq(), "", this.getListenerBaseName() + ".calStartFreqButton");
        this.freqModeCalStopFreqButton = new ActuatorEditor(this.settings.getCalStopFreq(), "", this.getListenerBaseName() + ".calStopFreqButton");
        this.clearCalButton = new ClearCalButton(Text.Clear_n_Calibration, this.getContextString("clear.calibration"), "antDtf", 0);
    }

    public void prolog() {
        this.cableTypeToggleButton.getActuator().addValueListener(this.cableTypeValueListener);
        this.installDistFreqButtons();
        DtfMeasurementSettings.instance().getDistFreqMode().addValueListener(this.distFreqModeValueListener);
        SystemMeasurementSettings.instance().getDtfUnits().addValueListener(this.unitsChangeListener);
    }

    public void cleanup() {
        this.cableTypeToggleButton.getActuator().removeValueListener(this.cableTypeValueListener);
        this.settings.getDistFreqMode().removeValueListener(this.distFreqModeValueListener);
        SystemMeasurementSettings.instance().getDtfUnits().removeValueListener(this.unitsChangeListener);
        this.cableTypeValueListener = null;
        this.distFreqModeValueListener = null;
        this.unitsChangeListener = null;
        this.cableTypeToggleButton = null;
        this.clearCalButton = null;
        this.cableVelocityButton = null;
        this.cableAttenuationButton = null;
        this.naCableListButton = null;
        ((ListActuatorButton)this.heliaxListButton).dispose();
        this.heliaxListButton = null;
        ((ListActuatorButton)this.rgListButton).dispose();
        this.rgListButton = null;
        this.heliaxListener.cleanup();
        this.heliaxListener = null;
        this.rgListener.cleanup();
        this.rgListener = null;
        this.freqDistMenu = null;
        this.cableTypeMenu = null;
        this.markerButtonFactory = null;
        this.settings = null;
        this.analyzer = null;
        super.cleanup();
    }

    private MarkerButtonFactory createMarkerButtonFactory() {
        return new MarkerButtonFactory((DistanceToFaultScreen)this.scn, null, null, DtfMeasurementSettings.instance().getDistance(), true);
    }

    protected Menu createFreqDistCalMenu() {
        return new Menu(Text.Freq_slash_Dist_slash_Cal, new MenuItem[]{new MultiStateActuatorButton(DtfMeasurementSettings.instance().getDistFreqMode(), "", this.getListenerBaseName() + ".freqDistMenu"), null, null, null, null, this.createCalibrateButton(), this.createUnitToggleButton()});
    }

    protected MenuItem createFaultIndicatorButton() {
        return new MultiStateActuatorButton(DtfMeasurementSettings.instance().getFaultIndicator(), this.getContextString("faultIndicator"), this.getListenerBaseName() + ".faultIndicatorButton");
    }

    protected MenuItem createLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Limits, this.getContextString("Limits"), new Menu(Text.Limits, new MenuItem[]{this.createOnOffLimitsButton(), new ActuatorEditor(DtfMeasurementSettings.instance().getUpperLimit(), this.getContextString("UpperLimit"), this.getListenerBaseName() + ".ulim"), null, null, null, null, null}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createOnOffLimitsButton() {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(DtfMeasurementSettings.instance().getLimitsToggle(), "", this.getListenerBaseName() + ".limOnOff");
        return multiStateActuatorButton;
    }

    void installDistFreqButtons() {
        MenuItem menuItem;
        ActuatorEditor actuatorEditor;
        ActuatorEditor actuatorEditor2;
        ActuatorEditor actuatorEditor3;
        int n = this.settings.getDistFreqMode().intValue();
        switch (n) {
            case 1: {
                actuatorEditor3 = new ActuatorEditor(this.settings.getCalcStartFreq(), "", this.getListenerBaseName() + ".calcStartFreqButton");
                actuatorEditor3.setEnabled(false);
                actuatorEditor2 = new ActuatorEditor(this.settings.getCalcStopFreq(), "", this.getListenerBaseName() + ".calcStopFreqButton");
                actuatorEditor2.setEnabled(false);
                actuatorEditor = new ActuatorEditor(this.settings.getStartDistance(), "calibrate.distance", this.getListenerBaseName() + ".startDistance");
                menuItem = this.distModeStopDistanceButton;
                this.calStartFreqButton = this.distModeCalStartFreqButton;
                this.calStopFreqButton = this.distModeCalStopFreqButton;
                break;
            }
            default: {
                logger.error("Unknown distFreqMode value " + n);
            }
            case 0: {
                actuatorEditor3 = new ActuatorEditor(this.settings.getStartFreq(), "", this.getListenerBaseName() + ".startFreqButton");
                actuatorEditor2 = new ActuatorEditor(this.settings.getStopFreq(), "", this.getListenerBaseName() + ".stopFreqButton");
                actuatorEditor = new ActuatorEditor(this.settings.getStartDistance(), "calibrate.distance", this.getListenerBaseName() + ".startDistance");
                menuItem = this.freqModeStopDistanceButton;
                this.calStartFreqButton = this.freqModeCalStartFreqButton;
                this.calStopFreqButton = this.freqModeCalStopFreqButton;
            }
        }
        this.freqDistMenu.setMenuItem(actuatorEditor3, 1);
        this.freqDistMenu.setMenuItem(actuatorEditor2, 2);
        this.freqDistMenu.setMenuItem(actuatorEditor, 3);
        this.freqDistMenu.setMenuItem(menuItem, 4);
        this.scn.getScreenManager().getRightMenuPanel().repaint();
    }

    private MenuItem createNACableListButton() {
        return new NotAvailableButton();
    }

    private Menu createCableTypeMenu() {
        return new Menu(Text.Cable_Type, new MenuItem[]{this.cableTypeToggleButton, null, this.cableAttenuationButton, this.cableVelocityButton, null, null, null}, 0);
    }

    private MenuItem createCalibrateButton() {
        return new PushButton(Text.Calibrate, this.getContextString("calibrate"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DtfMenuMgr.this.settings.storeCalStartStopFreqValues();
                if (!DtfMenuMgr.this.analyzer.isValidCalibration(DtfMenuMgr.this.analyzer.getMeasurement())) {
                    if (DtfMenuMgr.this.settings.getDistFreqMode().intValue() == 0) {
                        DtfMenuMgr.this.settings.getCalStopFreq().send(DtfMenuMgr.this.settings.getStopFreq().longValue());
                        DtfMenuMgr.this.settings.getCalStartFreq().send(DtfMenuMgr.this.settings.getStartFreq().longValue());
                    } else {
                        DtfMenuMgr.this.settings.getAutoCalStopFreq().send(DtfMenuMgr.this.settings.getCalcStopFreq().longValue());
                        DtfMenuMgr.this.settings.getAutoCalStartFreq().send(DtfMenuMgr.this.settings.getCalcStartFreq().longValue());
                    }
                }
                DtfMenuMgr.this.scn.getScreenManager().pushScreen(AntennaCalibrateScreen.createDTF(DtfMenuMgr.this.analyzer, DtfMenuMgr.this.calStartFreqButton, DtfMenuMgr.this.calStopFreqButton));
            }
        });
    }

    private MenuItem createAttenuationButtonAndLoadCustomSettings() {
        return new ActuatorEditor(DtfMeasurementSettings.instance().getCableAttenuation(), this.getContextString("calibrate.attenuation"), this.getListenerBaseName() + ".cableAtten");
    }

    private MenuItem createVelocityButtonAndLoadCustomSettings() {
        return new ActuatorEditor(DtfMeasurementSettings.instance().getCableVelocity(), this.getContextString("calibrate.velocity"), this.getListenerBaseName() + ".cableVelociy");
    }

    private MenuItem createRGListButton(CableSelectionListener cableSelectionListener) {
        return this.createCableListButton(DtfMeasurementSettings.instance().getRgCableList(), cableSelectionListener);
    }

    private MenuItem createHeliaxListButton(CableSelectionListener cableSelectionListener) {
        return this.createCableListButton(DtfMeasurementSettings.instance().getHlxCableList(), cableSelectionListener);
    }

    private MenuItem createCableListButton(ListActuator listActuator, CableSelectionListener cableSelectionListener) {
        ListActuatorButton listActuatorButton = new ListActuatorButton(listActuator, this.getContextString("calibrate.cableSelect"), this.getListenerBaseName() + ".cableListButton");
        listActuatorButton.addItemSelectionListener(cableSelectionListener);
        listActuatorButton.setCellRenderer(new CableListCellRenderer(listActuator));
        return listActuatorButton;
    }

    void sendAttenuationAndVelocity(Cable cable) {
        DtfMeasurementSettings.updateAttenuation(cable);
        short s = cable.getVelocity();
        LongActuator longActuator = DtfMeasurementSettings.instance().getCableVelocity();
        longActuator.send(s);
    }

    protected void handleCableTypeChange(int n) {
        switch (n) {
            case 1: {
                this.setForNotCustom(this.rgListButton);
                this.sendAttenuationAndVelocity((Cable)DtfMeasurementSettings.instance().getRgCableList().getSelectedValue());
                break;
            }
            case 2: {
                this.setForNotCustom(this.heliaxListButton);
                this.sendAttenuationAndVelocity((Cable)DtfMeasurementSettings.instance().getHlxCableList().getSelectedValue());
                break;
            }
            case 0: {
                this.rgListButton.setEnabled(false);
                this.heliaxListButton.setEnabled(false);
                this.cableAttenuationButton.setEnabled(true);
                this.cableVelocityButton.setEnabled(true);
                this.cableTypeMenu.setMenuItem(this.naCableListButton, 1);
                MeasurementFactory.instance().getScreenManager().getRightMenuPanel().repaint();
                break;
            }
        }
    }

    private void setForNotCustom(MenuItem menuItem) {
        this.rgListButton.setEnabled(true);
        this.heliaxListButton.setEnabled(true);
        this.cableAttenuationButton.setEnabled(false);
        this.cableVelocityButton.setEnabled(false);
        this.cableTypeMenu.setMenuItem(menuItem, 1);
        menuItem.addNotify(MeasurementFactory.instance().getScreenManager().getRightMenuPanel());
        MeasurementFactory.instance().getScreenManager().getRightMenuPanel().repaint();
    }

    public MarkerButtonFactory getMarkerButtonFactory() {
        return this.markerButtonFactory;
    }

    protected String getMeasurementName() {
        return "antDtf";
    }

    MenuItem createUnitToggleButton() {
        return new MultiStateActuatorButton(SystemMeasurementSettings.instance().getDtfUnits(), "help.units", this.getListenerBaseName() + ".dtfUnitsToggle");
    }

    private MultiStateActuatorButton createCableTypeToggleButton() {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(DtfMeasurementSettings.instance().getCableType(), this.getContextString("calibrate.cableType"), this.getListenerBaseName() + ".cableTypeToggleButton"){

            public boolean isFocused() {
                return super.isFocused();
            }
        };
        return multiStateActuatorButton;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class UnitsChangeListener
    implements ValueListener {
        private String listenerName = ".unitsChangeListener";
        private String baseName = null;
        private DtfMenuMgr menuMgr;

        public UnitsChangeListener(DtfMenuMgr dtfMenuMgr) {
            this.menuMgr = dtfMenuMgr;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.menuMgr.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.menuMgr.markerButtonFactory.updateMarkerXValueUnits();
        }
    }

    private static class DistFreqModeValueListener
    implements ValueListener {
        private String listenerName = ".distFreqModeValueListener";
        private String baseName = null;
        private DtfMenuMgr menuMgr;

        public DistFreqModeValueListener(DtfMenuMgr dtfMenuMgr) {
            this.menuMgr = dtfMenuMgr;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.menuMgr.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.menuMgr.freqDistMenu.setMenuItem(null, 1);
            this.menuMgr.freqDistMenu.setMenuItem(null, 2);
            this.menuMgr.freqDistMenu.setMenuItem(null, 3);
            this.menuMgr.freqDistMenu.setMenuItem(null, 4);
            this.menuMgr.installDistFreqButtons();
        }
    }

    private static class CableTypeValueListener
    implements ValueListener {
        private String listenerName = ".cableTypeValueListener";
        private String baseName = null;
        private DtfMenuMgr menuMgr;

        public CableTypeValueListener(DtfMenuMgr dtfMenuMgr) {
            this.menuMgr = dtfMenuMgr;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.menuMgr.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.menuMgr.handleCableTypeChange(valueInterface.intValue());
        }
    }

    private static class CableSelectionListener
    implements ItemSelectionListener {
        private DtfMenuMgr menuMgr;

        public CableSelectionListener(DtfMenuMgr dtfMenuMgr) {
            this.menuMgr = dtfMenuMgr;
        }

        public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
            Cable cable = (Cable)itemSelectionEvent.getValue();
            if (cable != null) {
                this.menuMgr.sendAttenuationAndVelocity(cable);
            }
        }

        public void cleanup() {
            this.menuMgr = null;
        }
    }

    private static class NotAvailableButton
    extends MenuItem {
        public NotAvailableButton() {
            super(Text.Select_Cable, "cable.list.na");
            this.setBodyText(Text.N_slash_A);
            this.setEnabled(false);
        }

        public void press() {
        }
    }
}

