/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.metrics.MetricsTable;
import elgato.infrastructure.metrics.TechnicolorTableModel;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.peakSearch.PeakFinder;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.DistanceStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.measurement.dtf.DistanceToFaultMeasurement;
import elgato.measurement.dtf.DtfMeasurementSettings;
import elgato.measurement.dtf.PeakIndicator;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class DtfMetrics
extends MeasurementMetrics {
    public static final int NUMBER_OF_FAULTS = 4;
    public DtfMetricsModel model;

    public DtfMetrics() {
        this.setLayout(new GridLayout(1, 0));
        this.model = new DtfMetricsModel();
        MetricsTable[] metricsTableArray = new MetricsTable[]{new MetricsTable(new ColumnCuttingTableModel(this.model, 0), new MetricsTable.LabelColumn[]{new MetricsTable.LabelColumn()}), new MetricsTable(new ColumnCuttingTableModel(this.model, 1), new MetricsTable.LabelColumn[]{new MetricsTable.LabelColumn()}), new MetricsTable(new ColumnCuttingTableModel(this.model, 2), new MetricsTable.LabelColumn[]{new MetricsTable.LabelColumn()}), new MetricsTable(new ColumnCuttingTableModel(this.model, 3), new MetricsTable.LabelColumn[]{new MetricsTable.LabelColumn()}), new MetricsTable(new ColumnCuttingTableModel(this.model, 4), new MetricsTable.LabelColumn[]{new MetricsTable.LabelColumn()})};
        for (int i = 0; i < metricsTableArray.length; ++i) {
            this.add(metricsTableArray[i]);
        }
    }

    public void setMeasurement(Measurement measurement) {
        this.model.setMeasurement((DistanceToFaultMeasurement)measurement);
    }

    static class DtfMetricsModel
    extends AbstractTableModel
    implements TechnicolorTableModel {
        private final DecibelStrategy returnLossStrategy = new DecibelStrategy(1);
        private final FixedPointNumberFieldStrategy vswrStrategy = new FixedPointNumberFieldStrategy(2);
        private final String[] LABELS = new String[]{Text.Worst_Faults, Text.Return_Loss, Text.Distance, Text.VSWR};
        private DistanceToFaultMeasurement measurement;
        private PeakFinder faultFinder;

        DtfMetricsModel() {
        }

        public int getRowCount() {
            return 4;
        }

        public int getColumnCount() {
            return 5;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.LABELS[n];
            }
            int n3 = n2 - 1;
            if (n == 0) {
                return new PeakIndicator(n3, this.measurement.isPassingLimitCheck(n3));
            }
            if (n3 >= this.faultFinder.getNumPeaks()) {
                return "----";
            }
            long l = this.faultFinder.getPeakXValue(n3);
            int n4 = this.measurement.getIndexForXValue(l);
            if (n == 1) {
                int n5 = this.getPeakReturnLoss(n4);
                String string = "";
                if (DtfMeasurementSettings.limitsOn()) {
                    string = this.measurement.isPassingLimitCheck(n3) ? " (P)" : " (F)";
                }
                return this.returnLossStrategy.format(n5) + string;
            }
            if (n == 2) {
                return DistanceStrategy.instance().format(l);
            }
            long l2 = this.getPeakVswr(n4);
            if ((double)l2 < 1.0) {
                return "-----";
            }
            return this.vswrStrategy.format(l2);
        }

        private int getPeakReturnLoss(int n) {
            return this.measurement.getTrace()[n];
        }

        public long getPeakVswr(int n) {
            double d = (double)this.getPeakReturnLoss(n) / 1000.0;
            double d2 = Math.pow(10.0, d / 20.0);
            double d3 = (d2 + 1.0) / (d2 - 1.0);
            return (long)(d3 * 1000.0);
        }

        public Color getColorAt(int n, int n2) {
            Color color = Color.black;
            if (n2 == 0) {
                color = ValueSource.DARK_BLUE;
            } else if (n == 1 && DtfMeasurementSettings.limitsOn()) {
                int n3 = n2 - 1;
                color = this.measurement.isPassingLimitCheck(n3) ? MeasurementMetrics.DARK_GREEN : Color.red;
            }
            return color;
        }

        public void setMeasurement(DistanceToFaultMeasurement distanceToFaultMeasurement) {
            this.measurement = distanceToFaultMeasurement;
            this.faultFinder = distanceToFaultMeasurement.createFaultFinder();
            this.fireTableDataChanged();
        }
    }

    private static class ColumnCuttingTableModel
    implements TechnicolorTableModel {
        private TechnicolorTableModel sourceModel;
        private int sourceColumn;
        private Hashtable proxyListeners = new Hashtable(3);

        public ColumnCuttingTableModel(TechnicolorTableModel technicolorTableModel, int n) {
            this.sourceModel = technicolorTableModel;
            this.sourceColumn = n;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return this.sourceModel.getRowCount();
        }

        public Object getValueAt(int n, int n2) {
            return this.sourceModel.getValueAt(n, this.sourceColumn(n2));
        }

        public Color getColorAt(int n, int n2) {
            return this.sourceModel.getColorAt(n, this.sourceColumn(n2));
        }

        private int sourceColumn(int n) {
            if (n != 0) {
                throw new IllegalArgumentException("Only one column!");
            }
            return this.sourceColumn;
        }

        public boolean isCellEditable(int n, int n2) {
            return this.sourceModel.isCellEditable(n, this.sourceColumn(n2));
        }

        public Class getColumnClass(int n) {
            return this.sourceModel.getColumnClass(this.sourceColumn(n));
        }

        public void setValueAt(Object object, int n, int n2) {
            this.sourceModel.setValueAt(object, n, this.sourceColumn(n2));
        }

        public String getColumnName(int n) {
            return this.sourceModel.getColumnName(this.sourceColumn(n));
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            TableModelListener tableModelListener2 = new TableModelListener(this, tableModelListener){
                private final /* synthetic */ TableModelListener val$l;
                private final /* synthetic */ ColumnCuttingTableModel this$0;
                {
                    this.this$0 = columnCuttingTableModel;
                    this.val$l = tableModelListener;
                }

                public void tableChanged(TableModelEvent tableModelEvent) {
                    this.val$l.tableChanged(new TableModelEvent(this.this$0));
                }
            };
            this.proxyListeners.put(tableModelListener, tableModelListener2);
            this.sourceModel.addTableModelListener(tableModelListener2);
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            TableModelListener tableModelListener2 = (TableModelListener)this.proxyListeners.get(tableModelListener);
            this.sourceModel.removeTableModelListener(tableModelListener2);
        }
    }
}

