/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.dtf;

import elgato.measurement.dtf.DtfMeasurementSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PeakIndicator
implements Icon {
    private static final Font font = new Font("SansSerif", 0, 8);
    private int peakIndex;
    private ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("images/FaultIndicator.png"));
    private Color imageIconFontColor = Color.blue;

    public PeakIndicator(int n) {
        this(n, true);
    }

    public PeakIndicator(int n, boolean bl) {
        this.peakIndex = n;
        if (DtfMeasurementSettings.instance().showLimits()) {
            this.imageIcon = bl ? new ImageIcon(ClassLoader.getSystemResource("images/FaultIndicator.png")) : new ImageIcon(ClassLoader.getSystemResource("images/FaultIndicator_Fail.png"));
            this.imageIconFontColor = bl ? Color.blue : Color.white;
        }
    }

    public int getIconHeight() {
        return this.imageIcon.getIconHeight();
    }

    public int getIconWidth() {
        return this.imageIcon.getIconWidth();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.imageIcon.paintIcon(component, graphics, n, n2);
        graphics.setFont(font);
        String string = Integer.toString(this.peakIndex + 1);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = n + this.getIconWidth() / 2;
        int n4 = n3 - fontMetrics.stringWidth(string) / 2;
        int n5 = n2 + fontMetrics.getAscent();
        graphics.setColor(this.imageIconFontColor);
        graphics.drawString(string, n4, n5);
    }
}

