/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.analyzer.PlainLabelPainter;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.LabelOnlyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.strategies.TimeStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.InvalidFrequencyException;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.ImageIcon;
import elgato.measurement.gsm.GsmChart;
import elgato.measurement.gsm.GsmChartModel;
import elgato.measurement.gsm.GsmLineChart;
import elgato.measurement.gsm.GsmMeasurement;
import elgato.measurement.gsm.GsmMeasurementSettings;
import elgato.measurement.gsm.GsmMetrics;
import elgato.measurement.gsm.GsmScreen;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GsmAnalyzer
extends TraceAnalyzer {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$gsm$GsmMeasurement == null ? (class$elgato$measurement$gsm$GsmMeasurement = GsmAnalyzer.class$("elgato.measurement.gsm.GsmMeasurement")) : class$elgato$measurement$gsm$GsmMeasurement);
    static final int DISPVALUE_OFF = 0;
    static final int DISPVALUE_PWR = 1;
    static final int DECODECF_FROM_MEASUREMENT = 0;
    static final int DECODECF_FROM_LISTENER = 1;
    static final long SPECTRUM_SPAN = 600000L;
    static final long NO_METRIC_AVAILABLE = Integer.MIN_VALUE;
    static final Font X_AXIS_LABEL_FONT = new Font("SansSerif", 0, 9);
    private Vector components = new Vector();
    private GsmMeasurement measurement;
    private Component pane;
    JPanel chartAndTop;
    GsmChartsPanel chartPanel;
    private JPanel barChartPanelCard;
    private JPanel pvtChartPanelCard;
    private JPanel spectrumChartPanelCard;
    private BorderLayout metricsCardPanelLayout;
    private Container metricsCardPanel;
    private Component metricLimitsPanel;
    private JLabel passFailLabel;
    private JPanel slotsPanel;
    private GridBagLayout slotsPanelLayout;
    private GridBagConstraints slotsPanelConstraints;
    private Component slotsPanelWithBorder;
    protected static final Image passImage = ImageIcon.loadImage("images/LimitsMaskGreen_P.png", new Canvas());
    protected static final Image upperFailImage = ImageIcon.loadImage("images/LimitsMaskRedUpper_F.png", new Canvas());
    protected static final Image lowerFailImage = ImageIcon.loadImage("images/LimitsMaskRedLower_F.png", new Canvas());
    protected static final Image upperLowerFailImage = ImageIcon.loadImage("images/LimitsMaskRedBoth_F.png", new Canvas());
    private GsmLineChart pvtChart;
    private TraceChart[] pvtCharts;
    private TraceChart spectrumChart;
    private TraceChart[] spectrumCharts;
    private JPanel spectrumChartPanel;
    private JPanel spectrumLowerAnnotationPanel;
    private GridBagLayout spectrumLowerAnnotationLayout;
    private GridBagConstraints spectrumLowerAnnotationConstraints;
    private JPanel pvtChartPanel;
    private JPanel pvtAnnotationPanel;
    private GridBagLayout pvtAnnotationLayout;
    private GridBagConstraints pvtAnnotationConstraints;
    private ELabel startTimeLabel;
    private ELabel zoomOffsetLabel;
    private ELabel stopRiseTimeLabel;
    private ELabel zoomIntervalLabel;
    private ELabel startFallTimeLabel;
    private ELabel stopTimeLabel;
    private ELabel startFrequencyLabel;
    private ELabel centerFrequencyLabel;
    private ELabel stopFrequencyLabel;
    private ELabel spectrumResBWLabel;
    private DynamicLabel spectrumMarkerDescriptionLabel;
    private DynamicLabel pvtMarkerDescriptionLabel;
    private int currentNumChans;
    private static GsmMeasurement.XYContainer[] xyContainers;
    private int metricsIndex;
    private long decodeCfOldAutoList;
    private long decodeCfOldRange;
    private boolean decodeCfRangeDirty = false;
    private boolean keyPressInProcess = false;
    private BorderWrapper chartAndTopWithBorder;
    private BorderWrapper pvtChartWithBorder;
    private BorderWrapper spectrumChartWithBorder;
    private final NumberFieldStrategy decibelStrategy = new DecibelStrategy(1, true);
    private final NumberFieldStrategy deltaDecibelStrategy = new DecibelStrategy(1, false);
    private static final NumberFieldStrategy dBmStrategy;
    private final NumberFieldStrategy freqStrategyTraceSave = new NumberFieldStrategy("Hz");
    static final LabelOnlyStrategy numText;
    private static final TimeStrategy timeStrategy;
    private Container cardPanel;
    private CardLayout cardLayout;
    private static final String BARCHART_CARD = "barchart";
    private static final String PVT_CARD = "pvt";
    public static final String SPECTRUM_CARD = "spectrum";
    private String CURRENT_CARD;
    private boolean bViewChanged = true;
    private DecodeCfListener decodeCfListener = new DecodeCfListener();
    private GsmMeasurementSettings settings = GsmMeasurementSettings.instance();
    private GsmMetrics metrics = new GsmMetrics(this);
    private ValueListener dBmWattsUnitsListener = new ValueListener(){
        private final String listenerName = "GsmAn.dBmWattsUnitsListener";

        public String getListenerName() {
            return "GsmAn.dBmWattsUnitsListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            if (GsmAnalyzer.this.chartPanel != null) {
                GsmAnalyzer.this.chartPanel.updateYAxisStrategy();
            }
        }
    };
    private ViewTypeListener viewTypeListener;
    private LimitStateListener limitStateListener;
    static /* synthetic */ Class class$elgato$measurement$gsm$GsmMeasurement;

    protected GsmAnalyzer() {
        super("GsmAn");
        GsmMeasurementSettings gsmMeasurementSettings = GsmMeasurementSettings.instance();
        this.listenToActuator(this.getRefLevel());
        this.listenToActuator(this.getScaleDiv());
        this.listenToActuator(gsmMeasurementSettings.getBarTop());
        this.listenToActuator(gsmMeasurementSettings.getMidBar());
        this.listenToActuator(gsmMeasurementSettings.getAutoOrder());
        this.listenToActuator(gsmMeasurementSettings.getdBmWattsUnits());
        this.listenToActuator(DisplayGlobalMeasurementSettings.instance().getChanFreqUnits());
        this.startFrequencyLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 3, 0);
        this.centerFrequencyLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 2, 0);
        this.stopFrequencyLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 4, 0);
        this.spectrumResBWLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 2, 1);
        this.startTimeLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, X_AXIS_LABEL_FONT, 3, 0);
        this.zoomOffsetLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, X_AXIS_LABEL_FONT, 3, 0);
        this.stopRiseTimeLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, X_AXIS_LABEL_FONT, 2, 0);
        this.startFallTimeLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, X_AXIS_LABEL_FONT, 2, 0);
        this.zoomIntervalLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, X_AXIS_LABEL_FONT, 4, 0);
        this.stopTimeLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, X_AXIS_LABEL_FONT, 4, 0);
        this.spectrumMarkerDescriptionLabel = new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return GsmAnalyzer.this.getCurrentMarkerDescription();
            }
        };
        this.pvtMarkerDescriptionLabel = new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return GsmAnalyzer.this.getCurrentMarkerDescription();
            }
        };
        this.currentNumChans = 0;
        JPanel jPanel = new JPanel();
        ((Component)jPanel).setBackground(null);
        jPanel.setLayout(new BorderLayout());
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setBackground(null);
        jPanel.add((Component)this.cardPanel, "Center");
        this.makeBarChartPanel();
        this.makePvtChartPanel();
        this.makeSpectrumChartPanel();
        this.makeMetricsPanel();
        jPanel.add((Component)this.metricsCardPanel, "South");
        this.pane = jPanel;
        this.chartPanel.setViewAndInstallCharts();
        this.chartPanel.validate();
        this.cardPanel.add((Component)this.barChartPanelCard, BARCHART_CARD);
        this.cardPanel.add((Component)this.pvtChartPanelCard, PVT_CARD);
        this.cardPanel.add((Component)this.spectrumChartPanelCard, SPECTRUM_CARD);
        this.viewTypeListener = new ViewTypeListener(this);
        gsmMeasurementSettings.getViewType().addValueListener(this.viewTypeListener);
        this.viewTypeListener.valueChanged(gsmMeasurementSettings.getViewType());
        gsmMeasurementSettings.getViewType().fireValueChanged();
        gsmMeasurementSettings.getDecodeCf().addValueListener(this.decodeCfListener);
        gsmMeasurementSettings.getdBmWattsUnits().addValueListener(this.dBmWattsUnitsListener);
        this.limitStateListener = new LimitStateListener(this);
        for (int i = 0; i < 9; ++i) {
            gsmMeasurementSettings.limitsToggleAt(i).addValueListener(this.limitStateListener);
        }
    }

    public MeasurementMetrics getMeasurementMetrics() {
        return this.metrics;
    }

    public String getMarkerListenerBaseName() {
        return this.getListenerBaseName() + ".view" + this.settings.getViewType().intValue();
    }

    public TabDelimitable[] createReadingFields() {
        TabDelimitable[] tabDelimitableArray;
        GsmMeasurement gsmMeasurement = (GsmMeasurement)this.getMeasurement();
        int n = gsmMeasurement.getTraceLength();
        int n2 = 0;
        int n3 = 0;
        TabDelimitable[] tabDelimitableArray2 = this.metrics.getTabDelimitables();
        int n4 = tabDelimitableArray2.length;
        int n5 = 0;
        int n6 = 11;
        boolean bl = true;
        if (gsmMeasurement.getDemodStatus() == 2) {
            bl = false;
        }
        if (this.settings.getPvtMask().booleanValue() && bl) {
            n6 = 13;
        }
        switch (gsmMeasurement.getViewType()) {
            case 1: {
                if (this.settings.getZoomType().intValue() == 0) {
                    n2 = 4 + n6;
                    break;
                }
                n2 = 7 + n6;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            default: {
                n5 = gsmMeasurement.getNumDecodedChannels();
                n2 = 9;
            }
        }
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 1) {
            tabDelimitableArray = new TabDelimitable[n4 + n + n2 + n5];
            for (int i = 0; i < n4; ++i) {
                tabDelimitableArray[n3++] = tabDelimitableArray2[i];
            }
            switch (gsmMeasurement.getViewType()) {
                case 1: {
                    n3 = this.settings.getZoomType().intValue() == 0 ? this.createReadingFields_pvtSlotsView(gsmMeasurement, tabDelimitableArray, n3) : this.createReadingFields_pvtRiseFallView(gsmMeasurement, tabDelimitableArray, n3);
                    this.createReadingFields_pvtSlotPower(gsmMeasurement, tabDelimitableArray, n3, this.settings.getPvtMask().booleanValue(), bl);
                    break;
                }
                case 2: {
                    this.createReadingFields_spectrumView(gsmMeasurement, tabDelimitableArray, n3);
                    break;
                }
                default: {
                    this.createReadingFields_chanScanView(gsmMeasurement, tabDelimitableArray, n3);
                    break;
                }
            }
        } else {
            tabDelimitableArray = new TabDelimitable[n4];
            for (int i = 0; i < n4; ++i) {
                tabDelimitableArray[n3++] = tabDelimitableArray2[i];
            }
        }
        return tabDelimitableArray;
    }

    private void createReadingFields_chanScanView(GsmMeasurement gsmMeasurement, TabDelimitable[] tabDelimitableArray, int n) {
        String[] stringArray;
        int n2;
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Trace Data");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Channel Powers");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Bar Count\t" + String.valueOf(this.measurement.getTraceLength()));
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Bar #\tFrequency\t\tChannel Number\t\tChannel Power");
        float f = TraceSaveTabDelimitable.getStepSize(gsmMeasurement);
        xyContainers = gsmMeasurement.getXYContainers();
        int n3 = DisplayGlobalMeasurementSettings.instance().getChanStd().intValue();
        String string = "-----";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        for (n2 = 0; n2 < gsmMeasurement.getTraceLength(); ++n2) {
            stringArray = gsmMeasurement.getTypeOfChannelScan() == 0 ? this.getChanNumSuffixStr(gsmMeasurement, n3, n2, f, true) : this.getChanNumSuffixStr(gsmMeasurement, n3, n2, f, false);
            float f2 = this.convertPowerToFloat(GsmAnalyzer.xyContainers[n2].yValue);
            String string6 = String.valueOf(n2 + 1) + '\t' + stringArray[0] + '\t' + "Hz" + '\t' + stringArray[1] + '\t' + stringArray[2] + '\t' + String.valueOf(f2) + '\t' + "dBm";
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string6);
        }
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Decoded Channels");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Decoded Channel Count\t" + String.valueOf(this.measurement.getNumDecodedChannels()));
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Channel Frequency\t\tChannel Number\t\tChannel Frequency Error\t\tBSIC\tTSC\tMod Type\tPk Ch Pwr (dBm)\t\tPk Ch Pwr (pW)\t\tCh OBW\t\tIQ Offset\t\tRMS Phase Error\t\tPeak Phase Error\t\tRMS EVM\t\tPk EVM\t\t95%tile EVM");
        for (n2 = 0; n2 < gsmMeasurement.getNumDecodedChannels(); ++n2) {
            double d = (double)gsmMeasurement.getChannelFreqErrArr()[n2] / 1000.0;
            int n4 = gsmMeasurement.getBsicArr()[n2];
            string2 = n4 == -1 ? string : this.valueToString(n4);
            int n5 = gsmMeasurement.getTscArr()[n2];
            if (n5 >= 8 && n5 < 16) {
                string3 = Text.n_slash_a + " " + Text.LeftBanana_Sync_RighBanana;
            }
            if (n5 >= 16) {
                string3 = this.valueToString(n5 - 16);
            } else if (n5 < 0) {
                string3 = string;
            } else if (n5 < 8) {
                string3 = this.valueToString(n5);
            }
            string4 = n5 < 0 ? string : (n5 > 15 ? Text._8PSK + " " + Text.EDGE_Bracket : Text.GMSK + " " + Text.GSM_Bracket);
            double d2 = (double)gsmMeasurement.getPkTsPwrArr()[n2] / 1000.0;
            if (d2 != -2147483.648) {
                double d3 = Math.pow(10.0, d2 / 10.0) * 1.0E9;
                string5 = String.valueOf(d3);
            } else {
                string5 = string;
            }
            int n6 = gsmMeasurement.getObwArr()[n2];
            String string7 = this.valueToString(n6);
            double d4 = (double)gsmMeasurement.getIqOffsetArr()[n2] / 1000.0;
            double d5 = (double)gsmMeasurement.getRmsEvmArr()[n2] / 1000.0;
            double d6 = (double)gsmMeasurement.getPeakEvmArr()[n2] / 1000.0;
            double d7 = (double)gsmMeasurement.get95PctTileEvmArr()[n2] / 1000.0;
            double d8 = (double)gsmMeasurement.getRmsPhaseErrArr()[n2] / 1000.0;
            double d9 = (double)gsmMeasurement.getPeakPhaseErrArr()[n2] / 1000.0;
            stringArray = gsmMeasurement.getTypeOfChannelScan() == 0 ? this.getChanNumSuffixStr(gsmMeasurement, n3, this.metricsIndex, f, true) : this.getChanNumSuffixStr(gsmMeasurement, n3, n2, f, false);
            String string8 = stringArray[0] + '\t' + "Hz" + '\t' + stringArray[1] + '\t' + stringArray[2] + '\t' + this.valueToString(d) + '\t' + "Hz" + '\t' + string2 + '\t' + string3 + '\t' + string4 + '\t' + this.valueToString(d2) + '\t' + "dBm" + '\t' + string5 + '\t' + "pW" + '\t' + string7 + '\t' + "Hz" + '\t' + this.valueToString(d4) + '\t' + "dBc" + '\t' + this.valueToString(d8) + '\t' + "\u00b0" + '\t' + this.valueToString(d9) + '\t' + "\u00b0" + '\t' + this.valueToString(d5) + '\t' + "%" + '\t' + this.valueToString(d6) + '\t' + "%" + '\t' + this.valueToString(d7) + '\t' + "%";
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string8);
        }
    }

    private int createReadingFields_pvtSlotsView(GsmMeasurement gsmMeasurement, TabDelimitable[] tabDelimitableArray, int n) {
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Trace Data");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Power vs. Time (Slots)");
        int n2 = gsmMeasurement.getTraceLength();
        int[] nArray = gsmMeasurement.getPvtSlotRFTrace();
        double d = (double)gsmMeasurement.getPvtTraceStartValue() / 1000.0;
        double d2 = (double)gsmMeasurement.getPvtTraceStopValue() / 1000.0;
        double d3 = (d2 - d) / (double)n2;
        if (this.settings.getPvtMask().booleanValue() && gsmMeasurement.getDemodStatus() != 2) {
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Time (\u00b5s)\tPower (dBm)\tUpper Limit (dBm)\tLower Limit (dBm)");
            int[] nArray2 = gsmMeasurement.getPvtSlotUpperLimitTrace();
            int[] nArray3 = gsmMeasurement.getPvtSlotLowerLimitTrace();
            for (int i = 0; i < n2; ++i) {
                double d4 = d + d3 * (double)i;
                float f = this.convertPowerToFloat(nArray[i]);
                float f2 = this.convertPowerToFloat(nArray2[i]);
                float f3 = this.convertPowerToFloat(nArray3[i]);
                String string = String.valueOf(d4) + '\t' + String.valueOf(f) + '\t' + String.valueOf(f2) + '\t' + String.valueOf(f3);
                tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string);
            }
        } else {
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Time (\u00b5s)\tPower (dBm)");
            for (int i = 0; i < n2; ++i) {
                double d5 = d + d3 * (double)i;
                float f = this.convertPowerToFloat(nArray[i]);
                String string = String.valueOf(d5) + '\t' + String.valueOf(f);
                tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string);
            }
        }
        return n;
    }

    private int createReadingFields_pvtRiseFallView(GsmMeasurement gsmMeasurement, TabDelimitable[] tabDelimitableArray, int n) {
        String string;
        float f;
        float f2;
        float f3;
        double d;
        int n2;
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Trace Data");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Power vs. Time (Rise)");
        int n3 = gsmMeasurement.getTraceLength();
        int n4 = n3 / 2;
        int[] nArray = gsmMeasurement.getPvtSlotRFTrace();
        int[] nArray2 = gsmMeasurement.getPvtSlotUpperLimitTrace();
        int[] nArray3 = gsmMeasurement.getPvtSlotLowerLimitTrace();
        double d2 = (double)gsmMeasurement.getPvtTraceStartValue() / 1000.0;
        double d3 = (double)gsmMeasurement.getPvtRiseStopValue() / 1000.0;
        double d4 = (d3 - d2) / (double)n4;
        if (this.settings.getPvtMask().booleanValue() && gsmMeasurement.getDemodStatus() != 2) {
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Time (\u00b5s)\tPower (dBm)\tUpper Limit (dBm)\tLower Limit (dBm)");
            for (n2 = 0; n2 < n4; ++n2) {
                d = d2 + d4 * (double)n2;
                f3 = this.convertPowerToFloat(nArray[n2]);
                f2 = this.convertPowerToFloat(nArray2[n2]);
                f = this.convertPowerToFloat(nArray3[n2]);
                string = String.valueOf(d) + '\t' + String.valueOf(f3) + '\t' + String.valueOf(f2) + '\t' + String.valueOf(f);
                tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string);
            }
        } else {
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Time (\u00b5s)\tPower (dBm)");
            for (n2 = 0; n2 < n4; ++n2) {
                d = d2 + d4 * (double)n2;
                f3 = this.convertPowerToFloat(nArray[n2]);
                string = String.valueOf(d) + '\t' + String.valueOf(f3);
                tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string);
            }
        }
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Power vs. Time (Fall)");
        d2 = gsmMeasurement.getPvtFallStartValue();
        d3 = gsmMeasurement.getPvtTraceStopValue();
        d4 = (d3 - d2) / (double)n4;
        if (this.settings.getPvtMask().booleanValue() && gsmMeasurement.getDemodStatus() != 2) {
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Time (\u00b5s)\tPower (dBm)\tUpper Limit (dBm)\tLower Limit (dBm)");
            for (n2 = 0; n2 < n4; ++n2) {
                d = d2 + d4 * (double)n2;
                f3 = this.convertPowerToFloat(nArray[n2]);
                f2 = this.convertPowerToFloat(nArray2[n2]);
                f = this.convertPowerToFloat(nArray3[n2]);
                string = String.valueOf(d) + '\t' + String.valueOf(f3) + '\t' + String.valueOf(f2) + '\t' + String.valueOf(f);
                tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string);
            }
        } else {
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Time (\u00b5s)\tPower (dBm)");
            for (n2 = n4; n2 < n4; ++n2) {
                d = d2 + d4 * (double)n2;
                f3 = this.convertPowerToFloat(nArray[n2]);
                string = String.valueOf(d) + '\t' + String.valueOf(f3);
                tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string);
            }
        }
        return n;
    }

    private void createReadingFields_pvtSlotPower(GsmMeasurement gsmMeasurement, TabDelimitable[] tabDelimitableArray, int n, boolean bl, boolean bl2) {
        String string;
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Slot Powers");
        String string2 = "Slot #\tTS Power (dBm)";
        if (bl && bl2) {
            string2 = string2 + "\tPass/Fail";
        }
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string2);
        int n2 = 0;
        boolean bl3 = true;
        for (int i = 0; i < 8; ++i) {
            String string3;
            if (gsmMeasurement.getFrameStartSlot() == -1) {
                string3 = "n";
                if (i > 0) {
                    string3 = string3 + '+' + String.valueOf(i);
                }
            } else if (i == 0) {
                string3 = String.valueOf(gsmMeasurement.getFrameStartSlot());
            } else {
                n2 = gsmMeasurement.getFrameStartSlot() + i;
                if (n2 >= 8) {
                    n2 -= 8;
                }
                string3 = String.valueOf(n2);
            }
            float f = this.convertPowerToFloat(gsmMeasurement.getPvtTSPower(i));
            string = "";
            if (bl && bl2) {
                string = "\tPass";
                if (gsmMeasurement.getPvtSlotInfo(i) >= 4) {
                    string = "\tFail";
                    bl3 = false;
                }
            }
            String string4 = string3 + '\t' + String.valueOf(f) + string;
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string4);
        }
        if (bl && bl2) {
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("");
            string = "Pass";
            if (!bl3) {
                string = "Fail";
            }
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("MaskTest\t" + string);
        }
    }

    private void createReadingFields_spectrumView(GsmMeasurement gsmMeasurement, TabDelimitable[] tabDelimitableArray, int n) {
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Trace Data");
        tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Spectrum");
        int n2 = gsmMeasurement.getTraceLength();
        int[] nArray = gsmMeasurement.getPvtSlotRFTrace();
        int[] nArray2 = gsmMeasurement.getPvtSlotUpperLimitTrace();
        long l = gsmMeasurement.getTraceStartValue();
        long l2 = gsmMeasurement.getSpan();
        if (l2 <= 0L) {
            l2 = 1L;
        }
        float f = n2 - 1 <= 0 ? 1.0f : (float)l2 / (float)(n2 - 1);
        if (gsmMeasurement.getAverageType() == 0) {
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Frequency\t\tPower\t");
            for (int i = 0; i < n2; ++i) {
                long l3 = (long)((double)(((float)l + (float)i * f) * 1.0f) + 0.5);
                tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Trace", this.freqStrategyTraceSave, l3, "", dBmStrategy, nArray[i]);
            }
        } else {
            tabDelimitableArray[n++] = new TraceSaveTabDelimitable("Frequency\t\tPower\t\tAvg Power\t");
            for (int i = 0; i < n2; ++i) {
                long l4 = (long)((double)(((float)l + (float)i * f) * 1.0f) + 0.5);
                TraceSaveTabDelimitable traceSaveTabDelimitable = new TraceSaveTabDelimitable("Trace", this.freqStrategyTraceSave, l4, "", dBmStrategy, nArray[i]);
                float f2 = this.convertPowerToFloat(nArray2[i]);
                String string = traceSaveTabDelimitable.toTabDelimitedString() + '\t' + String.valueOf(f2) + '\t' + "dBm";
                tabDelimitableArray[n++] = new TraceSaveTabDelimitable(string);
            }
        }
    }

    private String valueToString(int n) {
        if ((long)n == Integer.MIN_VALUE) {
            return "-------";
        }
        return String.valueOf(n);
    }

    private String valueToString(double d) {
        if (d == -2147483.648) {
            return "-------";
        }
        return String.valueOf(d);
    }

    private String[] getChanNumSuffixStr(TraceMeasurement traceMeasurement, int n, int n2, float f, boolean bl) {
        String[] stringArray = new String[]{"", "", ""};
        long l = bl ? (long)((double)(((float)traceMeasurement.getTraceStartValue() + (float)n2 * f) * 1000.0f) + 0.5) : (long)((double)(traceMeasurement.getTraceStartValue() + (long)(GsmAnalyzer.xyContainers[n2].xValue * 1000)) + 0.5);
        stringArray[0] = String.valueOf(l);
        try {
            Band band = Band.getCurrentBand(n);
            stringArray[2] = band.isFrequencyFwdChannel(l) ? Text.Dn : Text.Up;
            double d = Band.getCurrentBand(n).convertFrequencyToChannelNumber(l);
            stringArray[1] = String.valueOf((long)(d += 0.050000001));
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            stringArray[1] = "?";
            stringArray[2] = "?";
        }
        return stringArray;
    }

    private LongActuator getRefLevel() {
        return GsmMeasurementSettings.instance().getRefLevel();
    }

    private LongActuator getScaleDiv() {
        return GsmMeasurementSettings.instance().getScaleDiv();
    }

    public void updateChartVerticalRange() {
        if (this.measurement == null || this.chartPanel.getAllCharts() == null) {
            return;
        }
        for (int i = 0; i < this.chartPanel.getAllCharts().length; ++i) {
            this.chartPanel.getAllCharts()[i].setVerticalRange(this.getRefLevel().intValue(), this.getRefLevel().intValue() - this.getScaleDiv().intValue() * 10);
        }
        this.pvtChart.setVerticalRange(this.getRefLevel().intValue(), this.getRefLevel().intValue() - this.getScaleDiv().intValue() * 10);
        this.spectrumChart.setVerticalRange(this.getRefLevel().intValue(), this.getRefLevel().intValue() - this.getScaleDiv().intValue() * 10);
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected void setMeasurement(Measurement measurement) {
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        this.measurement = (GsmMeasurement)measurement;
        if (this.bViewChanged && this.measurement.getViewType() == this.settings.getViewType().intValue()) {
            this.cardLayout.show(this.cardPanel, this.CURRENT_CARD);
            this.bViewChanged = false;
        }
        logger.debug("GsmAnalyzer():setMeasurement(): scanType = " + this.measurement.getTypeOfChannelScan());
        String string = TraceAnalyzer.freqStrategy.format(this.measurement.getPvtTraceStartValue());
        String string2 = TraceAnalyzer.freqStrategy.format(this.measurement.getDecodeCentFreq() * 1000);
        String string3 = TraceAnalyzer.freqStrategy.format(this.measurement.getPvtTraceStopValue());
        String string4 = TraceAnalyzer.freqStrategy.format(this.measurement.getSpectrumResBW() * 1000);
        this.startFrequencyLabel.setChunk(0, string);
        this.centerFrequencyLabel.setChunk(0, string2);
        this.stopFrequencyLabel.setChunk(0, string3);
        this.spectrumResBWLabel.setChunk(0, string4);
        float f = this.settings.getZoomOffset().intValue();
        float f2 = this.settings.getZoomOffsetRF().intValue();
        float f3 = this.settings.getZoomInterval().intValue();
        f2 /= 1000.0f;
        String string5 = timeStrategy.format(this.measurement.getPvtTraceStartValue());
        String string6 = "(" + Text.Offset + ": " + (f /= 1000.0f) + ")";
        String string7 = "(" + Text.Interval + ": " + (f3 /= 1000.0f) + ")";
        String string8 = timeStrategy.format(this.measurement.getPvtTraceStopValue());
        String string9 = timeStrategy.format(this.measurement.getPvtRiseStopValue());
        String string10 = timeStrategy.format(this.measurement.getPvtFallStartValue());
        if (this.settings.getZoomType().intValue() == 1) {
            string6 = "(" + Text.Offset + ": " + f2 + ")";
            this.stopRiseTimeLabel.setChunkColor(0, TraceAnalyzer.VALUE_COLOR);
            this.startFallTimeLabel.setChunkColor(0, TraceAnalyzer.VALUE_COLOR);
            this.zoomIntervalLabel.setChunkColor(0, Color.black);
        } else {
            this.stopRiseTimeLabel.setChunkColor(0, Color.black);
            this.startFallTimeLabel.setChunkColor(0, Color.black);
            this.zoomIntervalLabel.setChunkColor(0, TraceAnalyzer.VALUE_COLOR);
        }
        this.startTimeLabel.setChunk(0, string5);
        this.zoomOffsetLabel.setChunk(0, string6);
        this.stopRiseTimeLabel.setChunk(0, string9);
        this.startFallTimeLabel.setChunk(0, string10);
        this.zoomIntervalLabel.setChunk(0, string7);
        this.stopTimeLabel.setChunk(0, string8);
        int n = this.measurement.getTypeOfChannelScan() == 1 ? this.measurement.getIntegerReadingValue(GsmMeasurement.NUM_OF_AUTO_CHANNELS) : this.measurement.getIntegerReadingValue(GsmMeasurement.NUM_CHANNEL_POWERS);
        if (n != this.currentNumChans) {
            this.currentNumChans = n;
            this.chartPanel.setViewAndInstallCharts();
            this.chartPanel.validate();
        }
        this.calculateMetricsIndex();
    }

    protected Component getPane() {
        return this.pane;
    }

    protected TraceChart getChart() {
        return this.chartPanel.getAllCharts()[0];
    }

    protected TraceChart[] getCharts() {
        if (this.settings.getViewType().intValue() == 1) {
            return this.pvtCharts;
        }
        if (this.settings.getViewType().intValue() == 2) {
            return this.spectrumCharts;
        }
        return this.chartPanel.getAllCharts();
    }

    public NumberFieldStrategy getYAxisNormalStrategy() {
        return this.decibelStrategy;
    }

    public NumberFieldStrategy getYAxisDeltaStrategy() {
        return this.deltaDecibelStrategy;
    }

    public NumberFieldStrategy getXAxisStrategy() {
        if (GsmMeasurementSettings.instance().getViewType().intValue() == 2) {
            return TraceAnalyzer.freqStrategy;
        }
        return timeStrategy;
    }

    private void calculateMetricsIndex() {
        if (this.keyPressInProcess) {
            this.keyPressInProcess = false;
            return;
        }
        if ((long)(this.measurement.getDecodeCentFreq() * 1000) != GsmMeasurementSettings.instance().getDecodeCf().longValue()) {
            logger.debug("GsmAnalyzer:calculateMetricsIndex(): measurement decodeCf = " + this.measurement.getDecodeCentFreq() * 1000 + "  decodeCfSetting = " + GsmMeasurementSettings.instance().getDecodeCf().longValue());
            this.metrics.docodeCfChanged(1, GsmMeasurementSettings.instance().getDecodeCf().longValue());
            if (this.measurement.getDemodStatus() == 1) {
                this.setChartFocus(-1);
            }
            return;
        }
        if (this.measurement.getTypeOfChannelScan() == 0) {
            if (this.decodeCfRangeDirty) {
                this.metricsIndex = this.measurement.getStartFreqMode() == 0 ? ((int)(this.decodeCfOldRange / 1000L) - this.measurement.getStartCentFreq()) / this.measurement.getStepSize() : ((int)(this.decodeCfOldRange / 1000L) - this.measurement.getStartCentFreqChan()) / this.measurement.getStepSize();
                this.decodeCfRangeDirty = false;
            } else {
                this.decodeCfOldRange = this.measurement.getDecodeCentFreq() * 1000;
                this.metricsIndex = this.measurement.getStartFreqMode() == 0 ? (this.measurement.getDecodeCentFreq() - this.measurement.getStartCentFreq()) / this.measurement.getStepSize() : (this.measurement.getDecodeCentFreq() - this.measurement.getStartCentFreqChan()) / this.measurement.getStepSize();
            }
        } else {
            this.decodeCfOldAutoList = this.measurement.getDecodeCentFreq() * 1000;
            this.metricsIndex = this.findMetricsIndexFromXYContainers(this.measurement.getDecodeCentFreq(), false);
        }
        if (this.measurement.getTypeOfChannelScan() == 0) {
            logger.debug("GsmAnalyzer:calculateMetricsIndex(): RangeMode: metricsIndex = " + this.metricsIndex);
        } else if (this.measurement.getTypeOfChannelScan() == 1) {
            logger.debug("GsmAnalyzer:calculateMetricsIndex(): AutoMode: metricsIndex = " + this.metricsIndex);
        } else {
            logger.debug("GsmAnalyzer:calculateMetricsIndex(): ListMode: metricsIndex = " + this.metricsIndex);
        }
        this.metrics.setMetricsIndex(this.metricsIndex);
        this.setChartFocus(this.metricsIndex);
        this.metrics.docodeCfChanged(0, -1L);
        this.metrics.setMeasurement(this.measurement);
    }

    private int findMetricsIndexFromXYContainers(long l, boolean bl) {
        int n;
        if (this.measurement.getTypeOfChannelScan() == 2) {
            if (bl) {
                n = -1;
                for (int i = this.metricsIndex + 1; i < this.measurement.getTraceLength(); ++i) {
                    if (l != (long)this.measurement.getXYContainers()[i].xValue) continue;
                    n = i;
                    break;
                }
                if (n != -1) {
                    return n;
                }
            } else if (l == (long)this.measurement.getXYContainers()[this.metricsIndex].xValue) {
                return this.metricsIndex;
            }
        }
        for (n = 0; n < this.measurement.getTraceLength(); ++n) {
            if (l != (long)this.measurement.getXYContainers()[n].xValue) continue;
            return n;
        }
        logger.debug("GsmAnalyzer:findMetricsIndexFromXYContainers(): decodeCf=" + l + " invalid!");
        return 0;
    }

    private void setChartFocus(int n) {
        if (this.chartPanel.getAllCharts() != null) {
            if (this.chartPanel.getAllCharts().length == 2) {
                if (n >= this.chartPanel.getStartIndexBottomChart()) {
                    ((GsmChart)this.chartPanel.getAllCharts()[1]).setFocus(n);
                    ((GsmChart)this.chartPanel.getAllCharts()[0]).setFocus(-1);
                } else {
                    ((GsmChart)this.chartPanel.getAllCharts()[0]).setFocus(n);
                    ((GsmChart)this.chartPanel.getAllCharts()[1]).setFocus(-1);
                }
            } else {
                ((GsmChart)this.chartPanel.getAllCharts()[0]).setFocus(n);
            }
        }
    }

    public void dispose() {
        this.settings.getDecodeCf().removeValueListener(this.decodeCfListener);
        this.settings.getdBmWattsUnits().removeValueListener(this.dBmWattsUnitsListener);
        this.settings.getViewType().removeValueListener(this.viewTypeListener);
        for (int i = 0; i < 9; ++i) {
            this.settings.limitsToggleAt(i).removeValueListener(this.limitStateListener);
        }
        this.viewTypeListener = null;
        this.limitStateListener = null;
        this.dBmWattsUnitsListener = null;
        this.decodeCfListener = null;
        if (this.components != null && !this.components.isEmpty()) {
            this.components.removeAllElements();
        }
        if (this.pvtChart != null) {
            this.pvtChart.dispose();
        }
        if (this.spectrumChart != null) {
            this.spectrumChart.dispose();
        }
        if (this.slotsPanel != null) {
            this.slotsPanel.removeAll();
        }
        if (this.pvtChartPanel != null) {
            this.pvtChartPanel.removeAll();
        }
        if (this.spectrumChartPanel != null) {
            this.spectrumChartPanel.removeAll();
        }
        if (this.chartPanel != null) {
            this.chartPanel.dispose();
        }
        if (this.metrics != null) {
            this.metrics.dispose();
        }
        super.dispose();
        this.slotsPanel = null;
        this.chartPanel = null;
        this.pvtChartPanel = null;
        this.spectrumChartPanel = null;
        this.pvtChart = null;
        this.spectrumChart = null;
        xyContainers = null;
    }

    private void updownRpgActionAutoList(long l) {
        long l2;
        long l3 = GsmMeasurementSettings.instance().getStepSize().longValue();
        int n = (int)((l - this.decodeCfOldAutoList) / l3);
        this.metricsIndex = n > this.currentNumChans ? --this.metricsIndex : (this.metricsIndex += n);
        int n2 = this.measurement.getTraceLength() - 1;
        if (this.metricsIndex > n2) {
            this.metricsIndex = n2;
        } else if (this.metricsIndex < 0) {
            this.metricsIndex = 0;
        }
        this.decodeCfOldAutoList = l2 = (long)this.measurement.getXYContainers()[this.metricsIndex].xValue * 1000L;
        GsmMeasurementSettings.instance().getFocusIndex().setValue(l2);
        GsmMeasurementSettings.instance().getDecodeCf().send(l2);
        if (GsmMeasurementSettings.instance().getScanMode().intValue() == 1) {
            logger.debug("GsmAnalyzer:DecodeCfListener(): AutoMode: decodeCf = " + l2 + " metricsIndex = " + this.metricsIndex);
        } else if (GsmMeasurementSettings.instance().getScanMode().intValue() == 2) {
            logger.debug("GsmAnalyzer:DecodeCfListener(): ListMode: decodeCf = " + l2 + " metricsIndex = " + this.metricsIndex);
        }
    }

    private void updateChartFocusAndMetrics(long l) {
        this.setChartFocus(this.metricsIndex);
        this.metrics.setMetricsIndex(this.metricsIndex);
        this.metrics.docodeCfChanged(1, l);
        this.metrics.setMeasurement(this.measurement);
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle = this.chartAndTopWithBorder.getBounds();
        rectangle.x += n;
        rectangle.y += n2;
        return super.filterPrintImage(image, rectangle);
    }

    private void makeBarChartPanel() {
        this.barChartPanelCard = new JPanel(new BorderLayout());
        this.barChartPanelCard.setBackground(null);
        JPanel jPanel = new JPanel(new TableLayout(new float[][]{{0.333f, -1.0f, 0.333f}, {-2.0f, -2.0f}}));
        ((Component)jPanel).setBackground(null);
        jPanel.add((Component)this.addLabel(new DynamicLabel(2, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                int n = ((GsmMeasurement)measurement).getTypeOfChannelScan();
                String string = "";
                string = n == 0 ? Text.Range : (n == 1 ? Text.Auto : Text.List);
                return Text.Scan_Mode + "-" + string;
            }
        }), "1,0");
        jPanel.add((Component)this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                GsmMeasurement gsmMeasurement = (GsmMeasurement)measurement;
                return Text.RF_IN_Loss + " " + new DecibelStrategy(1, false).format(gsmMeasurement.getAtten()) + "  ";
            }
        }), "2,0");
        this.chartAndTop = new JPanel(new BorderLayout());
        this.chartPanel = new GsmChartsPanel(this);
        this.chartPanel.setBackground(null);
        this.chartAndTop.add((Component)jPanel, "North");
        this.chartAndTop.add((Component)this.chartPanel, "Center");
        this.chartAndTopWithBorder = new BorderWrapper(this.chartAndTop, TraceAnalyzer.getChartBorder(), true);
        this.barChartPanelCard.add((Component)this.chartAndTopWithBorder, "Center");
    }

    private void makePvtChartPanel() {
        this.pvtChartPanelCard = new JPanel(new BorderLayout());
        this.pvtChartPanelCard.setBackground(null);
        this.pvtChartPanel = new JPanel(new BorderLayout());
        this.pvtChartPanel.setBackground(null);
        this.pvtChart = new GsmLineChart(this);
        this.pvtChart.addDLabel(new TraceAnalyzer.AverageDynamicLabel(GsmMeasurement.AVERAGE_TYPE, GsmMeasurement.NUM_AVERAGES, GsmMeasurement.AVERAGE_COUNT), 450, 20);
        this.pvtChart.addDLabel(new GsmDemodStatusMessageLabel(), 40, 20);
        this.pvtChart.setyAxisStrategy(dBmStrategy);
        this.pvtChart.setDrawYAxisLabels(true);
        this.pvtChart.setWidestYAxisString("-999.9");
        this.pvtCharts = new TraceChart[]{this.pvtChart};
        this.pvtChartPanel.add((Component)this.addLabel(this.pvtMarkerDescriptionLabel), "North");
        this.pvtChartPanel.add((Component)this.pvtChart, "Center");
        this.pvtChartPanel.add((Component)this.createPvtAnnotationPanel(), "South");
        this.slotsPanelWithBorder = this.createSlotsPanel();
        this.pvtChartPanelCard.add(this.slotsPanelWithBorder, "North");
        this.pvtChartWithBorder = new BorderWrapper(this.pvtChartPanel, TraceAnalyzer.getChartBorder(), true);
        this.pvtChartPanelCard.add((Component)this.pvtChartWithBorder, "Center");
    }

    private void makeSpectrumChartPanel() {
        this.spectrumChartPanelCard = new JPanel(new BorderLayout());
        this.spectrumChartPanelCard.setBackground(null);
        this.spectrumChartPanel = new JPanel(new BorderLayout());
        this.spectrumChartPanel.setBackground(null);
        this.spectrumChart = new GsmLineChart(this);
        this.spectrumChart.addDLabel(new TraceAnalyzer.AverageDynamicLabel(GsmMeasurement.AVERAGE_TYPE, GsmMeasurement.NUM_AVERAGES, GsmMeasurement.AVERAGE_COUNT), 450, 20);
        this.spectrumChart.addDLabel(new GsmDemodStatusMessageLabel(), 40, 20);
        this.spectrumChart.setyAxisStrategy(dBmStrategy);
        this.spectrumChart.setDrawYAxisLabels(true);
        this.spectrumChart.setWidestYAxisString("-999.9");
        this.spectrumCharts = new TraceChart[]{this.spectrumChart};
        this.spectrumChartPanel.add((Component)this.spectrumChart, "Center");
        this.spectrumChartPanel.add((Component)this.createSpectrumLowerAnnotationPanel(), "South");
        this.spectrumChartPanel.add((Component)this.makeSpectrumUpperPanel(), "North");
        this.spectrumChartWithBorder = new BorderWrapper(this.spectrumChartPanel, TraceAnalyzer.getChartBorder(), true);
        this.spectrumChartPanelCard.add((Component)this.spectrumChartWithBorder, "Center");
    }

    private JComponent createSlotsPanel() {
        this.slotsPanel = new JPanel();
        this.slotsPanel.setBackground(null);
        this.slotsPanelLayout = new GridBagLayout();
        this.slotsPanelConstraints = new GridBagConstraints();
        this.slotsPanel.setLayout(this.slotsPanelLayout);
        this.slotsPanelConstraints.weightx = 0.1;
        this.slotsPanelConstraints.insets = new Insets(0, 0, 0, 0);
        this.slotsPanelConstraints.fill = 2;
        this.addGridBagComponent(this.slotsPanelLayout, this.slotsPanelConstraints, this.slotsPanel, new ELabel(Text.TS, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 3, 2), 0, 0, 1, 1, 18);
        this.addGridBagComponent(this.slotsPanelLayout, this.slotsPanelConstraints, this.slotsPanel, new ELabel(Text.Pwr, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 3, 2), 1, 0, 1, 1, 18);
        this.addGridBagComponent(this.slotsPanelLayout, this.slotsPanelConstraints, this.slotsPanel, new ELabel(Text.LeftBanana_dBm_RightBanana, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 3, 2), 2, 0, 1, 1, 18);
        for (int i = 0; i < 8; ++i) {
            this.slotsPanelConstraints.fill = 2;
            this.slotsPanelConstraints.insets = new Insets(0, 5, 0, 5);
            this.addGridBagComponent(this.slotsPanelLayout, this.slotsPanelConstraints, this.slotsPanel, this.addLabel(new SlotNumberDynamicLabel(2, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, i)), 0, i + 1, 1, 1, 10);
            this.addGridBagComponent(this.slotsPanelLayout, this.slotsPanelConstraints, this.slotsPanel, this.addLabel(new SlotPwrDynamicLabel(2, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, i)), 1, i + 1, 1, 1, 10);
            this.slotsPanelConstraints.fill = 0;
            this.addGridBagImage(this.slotsPanelLayout, this.slotsPanelConstraints, this.slotsPanel, this.addComponent(new PassFailIconCanvas(i)), 2, i + 1, 1, 1, 10);
        }
        this.slotsPanelConstraints.fill = 2;
        this.slotsPanelConstraints.insets = new Insets(0, 0, 0, 0);
        this.addGridBagComponent(this.slotsPanelLayout, this.slotsPanelConstraints, this.slotsPanel, new ELabel(Text.Mask, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 4, 2), 0, 10, 1, 1, 12);
        this.addGridBagComponent(this.slotsPanelLayout, this.slotsPanelConstraints, this.slotsPanel, new ELabel(Text.Test, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 4, 2), 1, 10, 1, 1, 12);
        this.addGridBagComponent(this.slotsPanelLayout, this.slotsPanelConstraints, this.slotsPanel, this.addLabel(new FramePassFailDynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT)), 2, 10, 1, 1, 12);
        return new BorderWrapper(this.slotsPanel, TraceAnalyzer.getChartBorder(), true);
    }

    protected Component addComponent(Component component) {
        this.components.addElement(component);
        return component;
    }

    protected void updateLabels() {
        super.updateLabels();
        Measurement measurement = this.getMeasurement();
        if (measurement != null) {
            for (int i = 0; i < this.components.size(); ++i) {
                Component component = (Component)this.components.elementAt(i);
                component.repaint();
            }
        }
    }

    private void makeMetricsPanel() {
        this.metricsCardPanelLayout = new BorderLayout();
        this.metricsCardPanel = new JPanel(this.metricsCardPanelLayout);
        this.metricLimitsPanel = this.createMetricsLimitsPanel();
        this.metricLimitsPanel.setVisible(false);
        this.metricsCardPanel.add((Component)new BorderWrapper(this.metrics, MeasurementMetrics.BORDER, true), "North");
        this.metricsCardPanel.add(this.metricLimitsPanel, "South");
    }

    private JComponent createSpectrumLowerAnnotationPanel() {
        this.spectrumLowerAnnotationPanel = new JPanel();
        this.spectrumLowerAnnotationPanel.setBackground(null);
        this.spectrumLowerAnnotationLayout = new GridBagLayout();
        this.spectrumLowerAnnotationConstraints = new GridBagConstraints();
        this.spectrumLowerAnnotationPanel.setLayout(this.spectrumLowerAnnotationLayout);
        this.spectrumLowerAnnotationConstraints.weightx = 0.1;
        this.spectrumLowerAnnotationConstraints.insets = new Insets(0, 30, 0, 10);
        this.spectrumLowerAnnotationConstraints.fill = 2;
        this.addGridBagComponent(this.spectrumLowerAnnotationLayout, this.spectrumLowerAnnotationConstraints, this.spectrumLowerAnnotationPanel, this.startFrequencyLabel, 0, 0, 1, 1, 18);
        this.spectrumLowerAnnotationConstraints.insets = new Insets(0, 0, 0, 0);
        this.addGridBagComponent(this.spectrumLowerAnnotationLayout, this.spectrumLowerAnnotationConstraints, this.spectrumLowerAnnotationPanel, this.centerFrequencyLabel, 0, 1, 1, 1, 11);
        this.spectrumLowerAnnotationConstraints.insets = new Insets(0, 10, 0, 0);
        this.addGridBagComponent(this.spectrumLowerAnnotationLayout, this.spectrumLowerAnnotationConstraints, this.spectrumLowerAnnotationPanel, this.stopFrequencyLabel, 0, 2, 1, 1, 12);
        return this.spectrumLowerAnnotationPanel;
    }

    protected JComponent makeSpectrumUpperPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        float[][] fArrayArray = new float[][]{{80.0f, -1.0f}, {-2.0f}};
        TableLayout tableLayout = new TableLayout(fArrayArray);
        JPanel jPanel2 = new JPanel(tableLayout);
        jPanel2.add((Component)this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return "Ref " + UIHelper.formatFixed(GsmAnalyzer.this.getRefLevel().intValue(), 1) + " dBm";
            }
        }), "0,0");
        jPanel2.add((Component)this.addLabel(this.spectrumMarkerDescriptionLabel), "1,0");
        float[][] fArrayArray2 = new float[][]{{-1.0f, -1.0f, -1.0f}, {-2.0f}};
        TableLayout tableLayout2 = new TableLayout(fArrayArray2);
        JPanel jPanel3 = new JPanel(tableLayout2);
        jPanel3.add((Component)this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return UIHelper.formatFixed(GsmAnalyzer.this.getScaleDiv().intValue(), 0) + " dB/";
            }
        }), "0,0");
        jPanel3.add((Component)this.addLabel(new DynamicLabel(2, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return "Res BW " + GsmAnalyzer.access$2200().format(((GsmMeasurement)measurement).getSpectrumResBW());
            }
        }), "1,0");
        jPanel2.setBackground(null);
        jPanel3.setBackground(null);
        jPanel.setBackground(null);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JComponent createPvtAnnotationPanel() {
        this.pvtAnnotationPanel = new JPanel();
        this.pvtAnnotationPanel.setBackground(null);
        this.pvtAnnotationLayout = new GridBagLayout();
        this.pvtAnnotationConstraints = new GridBagConstraints();
        this.pvtAnnotationPanel.setLayout(this.pvtAnnotationLayout);
        this.pvtAnnotationConstraints.weightx = 0.1;
        this.pvtAnnotationConstraints.fill = 2;
        this.pvtAnnotationConstraints.insets = new Insets(0, 30, 0, 10);
        this.addGridBagComponent(this.pvtAnnotationLayout, this.pvtAnnotationConstraints, this.pvtAnnotationPanel, this.startTimeLabel, 0, 0, 1, 1, 18);
        this.pvtAnnotationConstraints.insets = new Insets(0, 0, 0, 0);
        this.addGridBagComponent(this.pvtAnnotationLayout, this.pvtAnnotationConstraints, this.pvtAnnotationPanel, this.zoomOffsetLabel, 0, 1, 1, 1, 18);
        this.pvtAnnotationConstraints.insets = new Insets(0, 5, 0, 0);
        this.addGridBagComponent(this.pvtAnnotationLayout, this.pvtAnnotationConstraints, this.pvtAnnotationPanel, this.stopRiseTimeLabel, 0, 2, 1, 1, 11);
        this.pvtAnnotationConstraints.insets = new Insets(0, 0, 0, 0);
        this.addGridBagComponent(this.pvtAnnotationLayout, this.pvtAnnotationConstraints, this.pvtAnnotationPanel, this.startFallTimeLabel, 0, 3, 1, 1, 11);
        this.addGridBagComponent(this.pvtAnnotationLayout, this.pvtAnnotationConstraints, this.pvtAnnotationPanel, this.zoomIntervalLabel, 0, 4, 1, 1, 12);
        this.pvtAnnotationConstraints.insets = new Insets(0, 5, 0, 0);
        this.addGridBagComponent(this.pvtAnnotationLayout, this.pvtAnnotationConstraints, this.pvtAnnotationPanel, this.stopTimeLabel, 0, 5, 1, 1, 12);
        return this.pvtAnnotationPanel;
    }

    private void addGridBagComponent(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JPanel jPanel, JComponent jComponent, int n, int n2, int n3, int n4, int n5) {
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
    }

    private void addGridBagImage(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JPanel jPanel, Component component, int n, int n2, int n3, int n4, int n5) {
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
    }

    private Component createMetricsLimitsPanel() {
        JPanel jPanel = new JPanel();
        this.passFailLabel = new JLabel();
        jPanel.add(this.passFailLabel);
        return new BorderWrapper(jPanel, MeasurementMetrics.BORDER, true);
    }

    protected void setPassFailLabel() {
        if (this.areAllWithinLimits()) {
            this.passFailLabel.setForeground(MeasurementMetrics.DARK_GREEN);
            this.passFailLabel.setText("ALL PASS");
        } else {
            this.passFailLabel.setForeground(Color.red);
            this.passFailLabel.setText("FAILURE");
        }
    }

    public void swapLimitsSummaryPanel(boolean bl) {
        this.metricLimitsPanel.setVisible(bl);
        this.metricsCardPanel.validate();
        this.metricsCardPanel.repaint();
        this.validate();
        this.repaint();
    }

    public boolean areAllWithinLimits() {
        if (this.settings.limitsToggleAt(2).booleanValue() && !this.isTsPwrWithinLimits()) {
            return false;
        }
        if (this.settings.limitsToggleAt(1).booleanValue() && !this.isFreqErrorWithinLimits()) {
            return false;
        }
        if (this.settings.limitsToggleAt(3).booleanValue() && !this.isIqOffsetWithinLimits()) {
            return false;
        }
        if (this.settings.limitsToggleAt(4).booleanValue() && !this.isRmsPhErrWithinLimits()) {
            return false;
        }
        if (this.settings.limitsToggleAt(5).booleanValue() && !this.isPeakPhErrWithinLimits()) {
            return false;
        }
        if (this.settings.limitsToggleAt(6).booleanValue() && !this.isRmsEvmWithinLimits()) {
            return false;
        }
        if (this.settings.limitsToggleAt(7).booleanValue() && !this.isPeakEvmWithinLimits()) {
            return false;
        }
        return !this.settings.limitsToggleAt(8).booleanValue() || this.isPctTileEvmWithinLimits();
    }

    public boolean isLimitOn(int n) {
        return this.settings.limitsToggleAt(n).getSelectedValue().longValue() == 1L;
    }

    public boolean isTsPwrWithinLimits() {
        int n = this.measurement.getXYContainers()[this.metricsIndex].xIndexOrig;
        int n2 = this.measurement.getPkTsPwrArr()[n];
        int n3 = this.settings.getTsPwrUpperLimit().intValue();
        int n4 = this.settings.getTsPwrLowerLimit().intValue();
        return n3 >= n2 && n4 <= n2;
    }

    public boolean isFreqErrorWithinLimits() {
        int n = this.metricsIndex;
        if (this.measurement.getTypeOfChannelScan() == 0) {
            n = 0;
        }
        int n2 = this.measurement.getChannelFreqErrArr()[n] / 1000;
        int n3 = this.settings.getFreqErrorUpperLimitHz().intValue();
        int n4 = this.settings.getFreqErrorLowerLimitHz().intValue();
        return n3 >= n2 && n4 <= n2;
    }

    public boolean isIqOffsetWithinLimits() {
        int n;
        int n2 = this.metricsIndex;
        if (this.measurement.getTypeOfChannelScan() == 0) {
            n2 = 0;
        }
        if ((n = this.measurement.getIqOffsetArr()[n2]) == Integer.MIN_VALUE) {
            return false;
        }
        return this.settings.getIqOffsetUpperLimit().intValue() >= n;
    }

    public boolean isRmsPhErrWithinLimits() {
        int n;
        int n2 = this.metricsIndex;
        if (this.measurement.getTypeOfChannelScan() == 0) {
            n2 = 0;
        }
        if ((n = this.measurement.getRmsPhaseErrArr()[n2]) == Integer.MIN_VALUE) {
            return false;
        }
        return this.settings.getRmsPhErrUpperLimit().intValue() >= n;
    }

    public boolean isPeakPhErrWithinLimits() {
        int n;
        int n2 = this.metricsIndex;
        if (this.measurement.getTypeOfChannelScan() == 0) {
            n2 = 0;
        }
        if ((n = this.measurement.getPeakPhaseErrArr()[n2]) == Integer.MIN_VALUE) {
            return false;
        }
        return this.settings.getPeakPhErrUpperLimit().intValue() >= n;
    }

    public boolean isRmsEvmWithinLimits() {
        int n;
        int n2 = this.metricsIndex;
        if (this.measurement.getTypeOfChannelScan() == 0) {
            n2 = 0;
        }
        if ((n = this.measurement.getRmsEvmArr()[n2]) == Integer.MIN_VALUE) {
            return false;
        }
        return this.settings.getRmsEvmUpperLimit().intValue() >= n;
    }

    public boolean isPeakEvmWithinLimits() {
        int n;
        int n2 = this.metricsIndex;
        if (this.measurement.getTypeOfChannelScan() == 0) {
            n2 = 0;
        }
        if ((n = this.measurement.getPeakEvmArr()[n2]) == Integer.MIN_VALUE) {
            return false;
        }
        return this.settings.getPeakEvmUpperLimit().intValue() >= n;
    }

    public boolean isPctTileEvmWithinLimits() {
        int n;
        int n2 = this.metricsIndex;
        if (this.measurement.getTypeOfChannelScan() == 0) {
            n2 = 0;
        }
        if ((n = this.measurement.get95PctTileEvmArr()[n2]) == Integer.MIN_VALUE) {
            return false;
        }
        return this.settings.getPctTileEvmUpperLimit().intValue() >= n;
    }

    public boolean isSplitTraceView() {
        return this.measurement.getZoomType() == 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ NumberFieldStrategy access$2200() {
        return TraceAnalyzer.freqStrategy;
    }

    static {
        dBmStrategy = new FixedPointNumberFieldStrategy(1, "dBm");
        numText = new LabelOnlyStrategy();
        timeStrategy = new TimeStrategy();
    }

    protected static class GsmDemodStatusMessageLabel
    extends DynamicLabel {
        public GsmDemodStatusMessageLabel() {
            super("Demod Status", 3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT);
        }

        protected String formatValue(Measurement measurement) {
            GsmMeasurement gsmMeasurement = (GsmMeasurement)measurement;
            switch (gsmMeasurement.getDemodStatus()) {
                default: {
                    return "";
                }
                case 1: {
                    return Text.Display_Position_not_found_within_Auto_Mode_Bar_Count;
                }
                case 2: {
                    return Text.No_valid_Slot_Sync_found;
                }
                case 3: {
                    return Text.BCCH_not_found_dash_using_Auto_Slot_Sync;
                }
                case 4: 
            }
            return Text.No_Graph_Data_dot_Re_dash_aquire_using_current_Display_Position;
        }
    }

    protected static class FramePassFailDynamicLabel
    extends DynamicLabel {
        private final Font slotInfoFont;

        public FramePassFailDynamicLabel(int n, Color color, Font font) {
            super("Frame Pass/Fail", n, color, font);
            this.slotInfoFont = font;
        }

        protected String formatValue(Measurement measurement) {
            String string;
            GsmMeasurement gsmMeasurement = (GsmMeasurement)measurement;
            boolean bl = true;
            boolean bl2 = false;
            if (GsmMeasurementSettings.instance().getPvtMask().intValue() == 1) {
                for (int i = 0; i < 8; ++i) {
                    if (gsmMeasurement.getPvtSlotInfo(i) < 0) {
                        bl2 = true;
                        break;
                    }
                    if (gsmMeasurement.getPvtSlotInfo(i) < 4) continue;
                    bl = false;
                }
                if (bl2) {
                    string = "    ";
                } else if (bl) {
                    string = Text.PASS;
                    this.setAttributes(Color.green, this.slotInfoFont);
                } else {
                    string = Text.FAIL;
                    this.setAttributes(Color.red, this.slotInfoFont);
                }
            } else {
                string = "    ";
            }
            return string;
        }
    }

    protected static class SlotNumberDynamicLabel
    extends DynamicLabel {
        private final int arrayElementId;
        private String slotNumber;
        private int tempSlotNumber = 0;

        public SlotNumberDynamicLabel(int n, Color color, Font font, int n2) {
            super(Text.Slots, n, color, font);
            this.arrayElementId = n2;
        }

        protected String formatValue(Measurement measurement) {
            GsmMeasurement gsmMeasurement = (GsmMeasurement)measurement;
            if (gsmMeasurement.getFrameStartSlot() == -1) {
                this.slotNumber = "n";
                if (this.arrayElementId > 0) {
                    this.slotNumber = this.slotNumber + '+' + String.valueOf(this.arrayElementId);
                }
            } else if (this.arrayElementId == 0) {
                this.slotNumber = String.valueOf(gsmMeasurement.getFrameStartSlot());
            } else {
                this.tempSlotNumber = gsmMeasurement.getFrameStartSlot() + this.arrayElementId;
                if (this.tempSlotNumber >= 8) {
                    this.tempSlotNumber -= 8;
                }
                this.slotNumber = String.valueOf(this.tempSlotNumber);
            }
            return this.slotNumber;
        }
    }

    protected class PassFailIconCanvas
    extends Canvas {
        Image canvasImg;
        int canvasWidth = upperLowerFailImage.getWidth(this) + 1;
        int canvasHeight = upperLowerFailImage.getHeight(this) + 1;
        private final int arrayElementId;

        public PassFailIconCanvas(int n) {
            this.arrayElementId = n;
            this.setSize(this.canvasWidth, this.canvasHeight);
        }

        public void paint(Graphics graphics) {
            GsmMeasurement gsmMeasurement = (GsmMeasurement)GsmAnalyzer.this.getMeasurement();
            if (gsmMeasurement != null) {
                if (GsmMeasurementSettings.instance().getPvtMask().intValue() == 1 || gsmMeasurement.getViewType() == 1) {
                    if (gsmMeasurement.getPvtSlotInfo(this.arrayElementId) >= 4) {
                        if (gsmMeasurement.getPvtSlotInfo(this.arrayElementId) >= 12) {
                            graphics.drawImage(upperLowerFailImage, 1, 1, this);
                        } else if (gsmMeasurement.getPvtSlotInfo(this.arrayElementId) >= 8) {
                            graphics.drawImage(lowerFailImage, 1, 1, this);
                        } else {
                            graphics.drawImage(upperFailImage, 1, 1, this);
                        }
                    } else if (gsmMeasurement.getPvtSlotInfo(this.arrayElementId) < 0) {
                        graphics.setColor(Color.black);
                        graphics.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
                    } else {
                        graphics.drawImage(passImage, 1, 1, this);
                    }
                } else {
                    graphics.setColor(Color.black);
                    graphics.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
                }
            }
        }
    }

    protected static class SlotInfoDynamicLabel
    extends DynamicLabel {
        private final int arrayElementId;
        private final Font slotInfoFont;

        public SlotInfoDynamicLabel(int n, Color color, Font font, int n2) {
            super(Text.Slot_Info, n, color, font);
            this.arrayElementId = n2;
            this.slotInfoFont = font;
        }

        protected String formatValue(Measurement measurement) {
            String string;
            GsmMeasurement gsmMeasurement = (GsmMeasurement)measurement;
            if (GsmMeasurementSettings.instance().getPvtMask().intValue() == 1) {
                if (gsmMeasurement.getPvtSlotInfo(this.arrayElementId) >= 4) {
                    if (gsmMeasurement.getPvtSlotInfo(this.arrayElementId) >= 12) {
                        string = "F";
                        this.setAttributes(Color.red, this.slotInfoFont);
                    } else if (gsmMeasurement.getPvtSlotInfo(this.arrayElementId) >= 8) {
                        string = "LF";
                        this.setAttributes(Color.red, this.slotInfoFont);
                    } else {
                        string = "UF";
                        this.setAttributes(Color.red, this.slotInfoFont);
                    }
                } else if (gsmMeasurement.getPvtSlotInfo(this.arrayElementId) < 0) {
                    string = "      ";
                } else {
                    string = "P";
                    this.setAttributes(Color.green, this.slotInfoFont);
                }
            } else {
                string = "      ";
            }
            return string;
        }
    }

    protected static class SlotPwrDynamicLabel
    extends DynamicLabel {
        private final int arrayElementId;

        public SlotPwrDynamicLabel(int n, Color color, Font font, int n2) {
            super(Text.Slot_Pwr, n, color, font);
            this.arrayElementId = n2;
        }

        protected String formatValue(Measurement measurement) {
            GsmMeasurement gsmMeasurement = (GsmMeasurement)measurement;
            DecibelStrategy decibelStrategy = new DecibelStrategy(1, true);
            String string = "  -----";
            if (gsmMeasurement.getPvtTSPower(this.arrayElementId) == -1) {
                return string;
            }
            String[] stringArray = decibelStrategy.formatWithUnits(gsmMeasurement.getPvtTSPower(this.arrayElementId), new String[2]);
            return stringArray[0];
        }
    }

    private class DecodeCfListener
    implements ValueListener {
        private final String listenerName = "GsmAn.decodeCfListener";

        private DecodeCfListener() {
        }

        public String getListenerName() {
            return "GsmAn.decodeCfListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            if (GsmAnalyzer.this.measurement == null) {
                return;
            }
            long l = valueInterface.longValue();
            if (GlobalKeyManager.isKeyPressInProcess()) {
                GsmAnalyzer.this.keyPressInProcess = true;
                if (GsmMeasurementSettings.instance().getScanMode().intValue() == 0) {
                    long l2 = GsmMeasurementSettings.instance().getStartFreq().longValue();
                    if (GsmAnalyzer.this.measurement.getStartFreqMode() == 1) {
                        l2 = GsmMeasurementSettings.instance().getStartFreqChan().longValue();
                    }
                    long l3 = GsmMeasurementSettings.instance().getStepSize().longValue();
                    if (DisplayGlobalMeasurementSettings.instance().getChanFreqUnits().intValue() == 1) {
                        int n = (int)((l - GsmAnalyzer.this.decodeCfOldRange) / l3);
                        if (n > GsmAnalyzer.this.currentNumChans) {
                            GsmAnalyzer.this.metricsIndex--;
                            GsmAnalyzer.this.decodeCfOldRange = l2;
                            GsmAnalyzer.this.decodeCfRangeDirty = true;
                            GsmMeasurementSettings.instance().getFocusIndex().setValue(GsmAnalyzer.this.decodeCfOldRange);
                            GsmMeasurementSettings.instance().getDecodeCf().send(GsmAnalyzer.this.decodeCfOldRange);
                        } else {
                            GsmAnalyzer.this.metricsIndex += n;
                            GsmAnalyzer.this.decodeCfOldRange = l;
                        }
                    } else {
                        GsmAnalyzer.this.metricsIndex = (int)((l - l2) / l3);
                        GsmAnalyzer.this.decodeCfOldRange = l;
                    }
                    if (GsmAnalyzer.this.metricsIndex < 0) {
                        GsmAnalyzer.this.metricsIndex = 0;
                    } else if (GsmAnalyzer.this.metricsIndex > GsmAnalyzer.this.measurement.getTraceLength() - 1) {
                        GsmAnalyzer.this.metricsIndex = GsmAnalyzer.this.measurement.getTraceLength() - 1;
                    }
                    GsmAnalyzer.this.updateChartFocusAndMetrics(GsmAnalyzer.this.decodeCfOldRange);
                    GsmAnalyzer.this.repaint();
                    logger.debug("GsmAnalyzer:DecodeCfListener(): RangeMode: value.longValue() (ie. decodeCf) = " + valueInterface.longValue() + " metricsIndex = " + GsmAnalyzer.this.metricsIndex);
                } else if (GsmMeasurementSettings.instance().getScanMode().intValue() == 1 || GsmMeasurementSettings.instance().getScanMode().intValue() == 2) {
                    if (GsmScreen.isUpDownArrowEvent() || ScrollWheelManager.isWheelMoveInProcess()) {
                        if (l != GsmAnalyzer.this.decodeCfOldAutoList) {
                            GsmAnalyzer.this.updownRpgActionAutoList(l);
                            GsmAnalyzer.this.updateChartFocusAndMetrics(GsmAnalyzer.this.decodeCfOldAutoList);
                            GsmAnalyzer.this.repaint();
                        }
                    } else if (l != GsmAnalyzer.this.decodeCfOldAutoList) {
                        GsmAnalyzer.this.decodeCfOldAutoList = l;
                        GsmAnalyzer.this.metricsIndex = GsmAnalyzer.this.findMetricsIndexFromXYContainers(GsmAnalyzer.this.decodeCfOldAutoList / 1000L, true);
                        GsmAnalyzer.this.updateChartFocusAndMetrics(GsmAnalyzer.this.decodeCfOldAutoList);
                        logger.warn("GsmAnalyzer:DecodeCfListener(): manual entry or up/down: metricsIndex = " + GsmAnalyzer.this.metricsIndex);
                        GsmAnalyzer.this.repaint();
                    }
                }
            } else if (l != GsmAnalyzer.this.decodeCfOldAutoList) {
                if (GsmMeasurementSettings.instance().getScanMode().intValue() == 0) {
                    GsmAnalyzer.this.decodeCfOldRange = (GsmAnalyzer.this.decodeCfOldAutoList = l);
                    GsmAnalyzer.this.metricsIndex = (int)((l - GsmMeasurementSettings.instance().getStartFreq().longValue()) / GsmMeasurementSettings.instance().getStepSize().longValue());
                } else {
                    GsmAnalyzer.this.decodeCfOldRange = l;
                    if (GsmMeasurementSettings.instance().getScanMode().intValue() == 1) {
                        if (GsmScreen.isUpDownArrowEvent()) {
                            GsmAnalyzer.this.updownRpgActionAutoList(l);
                        } else {
                            GsmAnalyzer.this.decodeCfOldAutoList = l;
                            GsmAnalyzer.this.metricsIndex = GsmAnalyzer.this.findMetricsIndexFromXYContainers(GsmAnalyzer.this.decodeCfOldAutoList / 1000L, true);
                        }
                    } else if (GsmScreen.isUpDownArrowEvent()) {
                        GsmAnalyzer.this.updownRpgActionAutoList(l);
                    } else {
                        GsmAnalyzer.this.decodeCfOldAutoList = l;
                        GsmAnalyzer.this.metricsIndex = GsmAnalyzer.this.findMetricsIndexFromXYContainers(GsmAnalyzer.this.decodeCfOldAutoList / 1000L, true);
                    }
                }
                GsmAnalyzer.this.updateChartFocusAndMetrics(GsmAnalyzer.this.decodeCfOldAutoList);
                logger.debug("GsmAnalyzer:DecodeCfListener(): manual entry or up/down: metricsIndex = " + GsmAnalyzer.this.metricsIndex);
                GsmAnalyzer.this.repaint();
            }
        }
    }

    protected class GsmChartsPanel
    extends JPanel {
        private TraceChart[] charts;
        private GsmChart chart1;
        private GsmChart chart2;
        private GsmChartModel chartModel1;
        private GsmChartModel chartModel2;
        private GsmAnalyzer analyzer;
        private int numSlotsEachChart;
        private int graphStatusMessXPos;

        public GsmChartsPanel(GsmAnalyzer gsmAnalyzer2) {
            super(new TableLayout(new float[][]{{-1.0f}, {0.5f, 0.5f}}));
            this.analyzer = gsmAnalyzer2;
        }

        public void dispose() {
            this.removeAll();
            if (this.chart1 != null) {
                this.chart1.dispose();
            }
            if (this.chart2 != null) {
                this.chart2.dispose();
            }
            if (this.chartModel1 != null) {
                this.chartModel1.dispose();
            }
            if (this.chartModel2 != null) {
                this.chartModel2.dispose();
            }
            this.chartModel1 = null;
            this.chartModel2 = null;
            this.chart1 = null;
            this.chart2 = null;
            this.analyzer = null;
        }

        private void setViewAndInstallCharts() {
            this.removeAll();
            if (GsmAnalyzer.this.currentNumChans <= 20) {
                this.chartModel1 = new GsmChartModel();
                this.chart1 = new GsmChart(this.chartModel1, new PlainLabelPainter(), this.analyzer);
                this.chart1.addDLabel(new TraceAnalyzer.AverageDynamicLabel(GsmMeasurement.AVERAGE_TYPE, GsmMeasurement.NUM_AVERAGES, GsmMeasurement.AVERAGE_COUNT), 450, 20);
                this.graphStatusMessXPos = GsmAnalyzer.this.currentNumChans == 1 ? 90 : 60;
                this.chart1.addDLabel(new GsmDemodStatusMessageLabel(), this.graphStatusMessXPos, 10);
                this.chart1.setDrawYAxisLabels(true);
                this.chart1.setWidestYAxisString("-999.9");
                this.chartModel1.setSlotRange(0, GsmAnalyzer.this.currentNumChans - 1, 0);
                this.numSlotsEachChart = GsmAnalyzer.this.currentNumChans;
                this.add((Component)this.chart1, "0,0,0,1");
                this.charts = new TraceChart[]{this.chart1};
            } else {
                this.chartModel1 = new GsmChartModel();
                this.chart1 = new GsmChart(this.chartModel1, new PlainLabelPainter(), this.analyzer);
                this.chart1.addDLabel(new TraceAnalyzer.AverageDynamicLabel(GsmMeasurement.AVERAGE_TYPE, GsmMeasurement.NUM_AVERAGES, GsmMeasurement.AVERAGE_COUNT), 450, 20);
                this.chart1.addDLabel(new GsmDemodStatusMessageLabel(), 60, 10);
                this.chart1.setDrawYAxisLabels(true);
                this.chart1.setWidestYAxisString("-999.9");
                this.numSlotsEachChart = (GsmAnalyzer.this.currentNumChans + 1) / 2;
                this.chartModel1.setSlotRange(0, this.numSlotsEachChart - 1, 0);
                this.chartModel2 = new GsmChartModel();
                this.chart2 = new GsmChart(this.chartModel2, new PlainLabelPainter(), this.analyzer);
                this.chart2.setDrawYAxisLabels(true);
                this.chart2.setWidestYAxisString("-999.9");
                int n = this.numSlotsEachChart - (GsmAnalyzer.this.currentNumChans - this.numSlotsEachChart);
                int n2 = n == 0 ? 0 : n;
                this.chartModel2.setSlotRange(this.numSlotsEachChart, GsmAnalyzer.this.currentNumChans - 1, n2);
                this.add((Component)this.chart1, "0,0");
                this.add((Component)this.chart2, "0,1");
                this.charts = new TraceChart[]{this.chart1, this.chart2};
            }
            GsmAnalyzer.this.updateChartMeasurements();
            this.updateYAxisStrategy();
            GsmAnalyzer.this.updateChartVerticalRange();
        }

        public TraceChart[] getAllCharts() {
            return this.charts;
        }

        public int getStartIndexBottomChart() {
            return this.numSlotsEachChart;
        }

        public void updateYAxisStrategy() {
            NumberFieldStrategy numberFieldStrategy = dBmStrategy;
            for (int i = 0; i < this.charts.length; ++i) {
                TraceChart traceChart = this.charts[i];
                if (traceChart == null) continue;
                traceChart.setyAxisStrategy(numberFieldStrategy);
            }
        }
    }

    private static class LimitStateListener
    implements ValueListener {
        private String listenerName = ".limitsSummaryListener";
        private String baseName = null;
        private GsmAnalyzer analyzer;

        public LimitStateListener(GsmAnalyzer gsmAnalyzer) {
            this.analyzer = gsmAnalyzer;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.analyzer.swapLimitsSummaryPanel(this.analyzer.settings.getLimitsSummaryState());
        }
    }

    private class ViewTypeListener
    implements ValueListener {
        private String listenerName = "GsmAn.viewTypeListener";
        private String baseName = null;
        private GsmAnalyzer analyzer;

        public ViewTypeListener(GsmAnalyzer gsmAnalyzer2) {
            this.analyzer = gsmAnalyzer2;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            GsmAnalyzer.this.bViewChanged = true;
            if (valueInterface.intValue() == 1) {
                GsmAnalyzer.this.pvtChartPanelCard.add(GsmAnalyzer.this.slotsPanelWithBorder, "North");
                GsmAnalyzer.this.CURRENT_CARD = GsmAnalyzer.PVT_CARD;
            } else if (valueInterface.intValue() == 2) {
                GsmAnalyzer.this.pvtChartPanelCard.remove(GsmAnalyzer.this.slotsPanelWithBorder);
                GsmAnalyzer.this.CURRENT_CARD = GsmAnalyzer.SPECTRUM_CARD;
            } else {
                GsmAnalyzer.this.pvtChartPanelCard.remove(GsmAnalyzer.this.slotsPanelWithBorder);
                GsmAnalyzer.this.CURRENT_CARD = GsmAnalyzer.BARCHART_CARD;
            }
        }
    }
}

