/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.analyzer.BarChart;
import elgato.infrastructure.analyzer.BasicBarChartLimitsMask;
import elgato.infrastructure.analyzer.LabelPainter;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.FrequencyToChannelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.widgets.ImageIcon;
import elgato.measurement.gsm.GsmAnalyzer;
import elgato.measurement.gsm.GsmChartModel;
import elgato.measurement.gsm.GsmMeasurement;
import elgato.measurement.gsm.GsmMeasurementSettings;
import elgato.measurement.gsm.GsmScreen;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

class GsmChart
extends BarChart {
    private static final int SPACE_BETWEEN_LABELS_AND_CHART = 1;
    private static final Resources res = Resources.getResources((class$elgato$measurement$gsm$GsmChart == null ? (class$elgato$measurement$gsm$GsmChart = GsmChart.class$("elgato.measurement.gsm.GsmChart")) : class$elgato$measurement$gsm$GsmChart).getName());
    private static final Font YAXIS_FONT = res.getFont("yaxisFont");
    private static final Color YAXIS_COLOR = res.getColor("yaxisColor");
    private final NumberFieldStrategy frequencyFormatter = new FrequencyStrategy();
    private final NumberFieldStrategy channelFormatter = new FrequencyToChannelStrategy(Value.createValue("", 1), GsmScreen.BAND_SELECTOR);
    private final String[] result = new String[2];
    private int focusBarIndex;
    private int tallestBarIndex = 0;
    private int biggestYPoint;
    private int smallestYPoint;
    private final Font barValueFont;
    private final Font labelRotatorFont = this.barValueFont = new Font("SansSerif", 0, 9);
    private GsmChartModel model;
    private LabelPainter xAxisLabelPainter;
    private Image limitsMaskLowTab;
    private Image limitsMaskHighTab;
    private Color constantXAxisLabelColor = null;
    private Color maskColor = Color.yellow;
    private GsmAnalyzer analyzer;
    static /* synthetic */ Class class$elgato$measurement$gsm$GsmChart;

    public GsmChart(GsmChartModel gsmChartModel, LabelPainter labelPainter, GsmAnalyzer gsmAnalyzer) {
        this.model = gsmChartModel;
        this.xAxisLabelPainter = labelPainter;
        this.analyzer = gsmAnalyzer;
    }

    public void dispose() {
        this.model = null;
        this.xAxisLabelPainter = null;
        this.analyzer = null;
        super.dispose();
    }

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        super.setMeasurement(traceMeasurement);
        this.model.setMeasurement(traceMeasurement);
        this.refresh();
    }

    private void initializeLabelPainter() {
        this.xAxisLabelPainter.clearLabels();
        for (int i = 0; i < this.model.getNumBars(); ++i) {
            Color color = this.constantXAxisLabelColor != null ? this.constantXAxisLabelColor : this.model.getColor(i);
            this.xAxisLabelPainter.addLabel(this.model.getLabel(i), color, this.labelRotatorFont);
        }
    }

    public void refresh() {
        this.initializeLabelPainter();
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        GsmChartModel gsmChartModel;
        int n12 = this.getUnitBarWidth();
        int n13 = this.getSlotSpacing();
        int n14 = this.getYTop();
        int n15 = this.getYBottom();
        int n16 = n15 - n14;
        if (n4 == 0 || n16 == 0) {
            return;
        }
        graphics.translate(n, n2);
        int n17 = this.getBottomSpace();
        graphics.setFont(this.barValueFont);
        String[] stringArray = new String[2];
        if (this.model instanceof BasicBarChartLimitsMask) {
            gsmChartModel = this.model;
            this.limitsMaskLowTab = ImageIcon.loadImage("images/LimitsMaskTab-L.png", this);
            this.limitsMaskHighTab = ImageIcon.loadImage("images/LimitsMaskTab-H.png", this);
        } else {
            gsmChartModel = null;
        }
        graphics.setFont(YAXIS_FONT);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Conversion conversion = GsmMeasurementSettings.instance().getRefLevel().getConversion();
        String[] stringArray2 = this.createBarLabels((GsmMeasurement)this.getMeasurement(), n12, this.model.getNumBars() - this.model.getPaddingSlots(), fontMetrics);
        int n18 = this.model.getValue(0);
        if (n18 > n14) {
            n18 = n14;
        }
        if (n18 < n15) {
            n18 = n15;
        }
        this.biggestYPoint = this.smallestYPoint = (n18 - n14) * n4 / n16;
        int n19 = this.getPassFailIconInterval(n12);
        boolean bl = gsmChartModel != null && gsmChartModel.isMaskEnabled();
        int n20 = 0;
        for (n11 = 0; n11 < this.model.getNumBars() - this.model.getPaddingSlots(); ++n11) {
            if (this.model.isActive(n11)) {
                Image image;
                n10 = this.model.getValue(n11);
                n9 = n10;
                if (n9 > n14) {
                    n9 = n14;
                }
                if (n9 < n15) {
                    n9 = n15;
                }
                if ((n8 = (n9 - n14) * n4 / n16) > this.biggestYPoint) {
                    this.biggestYPoint = n8;
                }
                if (n8 < this.smallestYPoint) {
                    this.smallestYPoint = n8;
                    this.tallestBarIndex = n11;
                }
                graphics.setColor(this.model.getColor(n11));
                graphics.fillRect(n20, n8, n12, n4 - n8);
                if (this.model.getActualSlot(n11) == this.focusBarIndex) {
                    n7 = n20 + n12 / 2;
                    n6 = 0;
                    n5 = n4 + 22;
                    graphics.setColor(Color.yellow);
                    graphics.drawLine(n7, n6, n7, n5);
                    graphics.drawLine(n7 - 2, n6 - 5, n7, n6);
                    graphics.drawLine(n7 + 2, n6 - 5, n7, n6);
                    graphics.drawLine(n7 - 2, n5 + 5, n7, n5);
                    graphics.drawLine(n7 + 2, n5 + 5, n7, n5);
                }
                if (n11 % n19 == 0 && (image = this.model.getBottomOfBarImage(n11)) != null) {
                    graphics.drawImage(image, n20 + (n12 - image.getWidth(null)) / 2, n4 - image.getHeight(null) - 5, null);
                }
                if (GsmMeasurementSettings.instance().getScanMode().intValue() != 0 && GsmMeasurementSettings.instance().getMidBar().intValue() == 1) {
                    graphics.setColor(this.getColorForBsic(n11));
                    if (this.model.getBsic(n11) != -1) {
                        String[] stringArray3 = new String[]{String.valueOf(this.model.getBsic(n11))};
                        TraceChart.drawCenteredStringsBottomJustified(graphics, n20, n8 + (n4 - n8) / 2, n12, stringArray3, 0, n4);
                    }
                }
                n7 = n4 + 1;
                graphics.setColor(YAXIS_COLOR);
                stringArray[0] = stringArray2[2 * n11];
                stringArray[1] = stringArray2[2 * n11 + 1];
                TraceChart.drawCenteredStrings(graphics, n20, n7, n12, stringArray);
            }
            this.xAxisLabelPainter.paintLabel(n11, this, graphics, n20, n4 + 1, n12, n17);
            n20 += n12 + n13;
        }
        n11 = 0;
        if (n12 >= 20) {
            n11 = 0;
        } else {
            int n21 = n11 = this.biggestYPoint - this.smallestYPoint >= 5 ? 1 : 0;
        }
        if (GsmMeasurementSettings.instance().getBarTop().intValue() == 1) {
            n20 = this.getPowerLabelsInterval(n12);
            n9 = 0;
            for (n10 = 0; n10 < this.model.getNumBars() - this.model.getPaddingSlots(); ++n10) {
                n8 = this.model.getValue(n10);
                n7 = n8;
                if (n7 > n14) {
                    n7 = n14;
                }
                if (n7 < n15) {
                    n7 = n15;
                }
                n6 = (n7 - n14) * n4 / n16;
                if ((n10 + 1) % n20 == 0 || n10 == this.tallestBarIndex && n10 != 0) {
                    n5 = Math.abs(n10 - this.tallestBarIndex);
                    if (!(n12 <= 4 && n5 < 5 && n5 != 0 && n11 != 0 || n12 > 4 && n5 < 3 && n5 != 0 && n11 != 0)) {
                        if (n10 != this.tallestBarIndex || n10 == this.tallestBarIndex && n11 != 0) {
                            graphics.setColor(Color.white);
                            UIHelper.split(conversion.toString(n8), ' ', stringArray);
                            TraceChart.drawCenteredStringsBottomJustified(graphics, n9, n6, n12, stringArray, 0, n4);
                        } else if (n11 == 0 && n10 == this.tallestBarIndex && (n10 + 1) % n20 == 0) {
                            graphics.setColor(Color.white);
                            UIHelper.split(conversion.toString(n8), ' ', stringArray);
                            TraceChart.drawCenteredStringsBottomJustified(graphics, n9, n6, n12, stringArray, 0, n4);
                        }
                    }
                    if (n5 < 3 && n12 >= 15 && this.tallestBarIndex == 0 && n11 != 0) {
                        graphics.setColor(Color.white);
                        UIHelper.split(conversion.toString(n8), ' ', stringArray);
                        TraceChart.drawCenteredStringsBottomJustified(graphics, n9, n6, n12, stringArray, 0, n4);
                    }
                }
                n9 += n12 + n13;
            }
        }
        if (bl) {
            n20 = GsmMeasurementSettings.instance().getHighLimit().intValue();
            n10 = GsmMeasurementSettings.instance().getLowLimit().intValue();
            n9 = (n20 - n14) * n4 / n16;
            n8 = (n10 - n14) * n4 / n16;
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setClip(0, 0, n3, n4);
            graphics.setColor(this.maskColor);
            graphics.drawLine(0, n9, n3, n9);
            graphics.drawLine(0, n8, n3, n8);
            graphics.drawImage(this.limitsMaskHighTab, 0, n9 - this.limitsMaskHighTab.getHeight(null), null);
            graphics.drawImage(this.limitsMaskHighTab, n3 - this.limitsMaskHighTab.getWidth(null), n9 - this.limitsMaskHighTab.getHeight(null), null);
            graphics.drawImage(this.limitsMaskLowTab, 0, n8 + 1, null);
            graphics.drawImage(this.limitsMaskLowTab, n3 - this.limitsMaskLowTab.getWidth(null) + 1, n8 + 1, null);
            graphics.setClip(rectangle);
        }
        graphics.translate(-n, -n2);
    }

    private NumberFieldStrategy getFreqChanStrategy() {
        ListActuator listActuator = DisplayGlobalMeasurementSettings.instance().getChanFreqUnits();
        if (listActuator.intValue() == 0) {
            return this.frequencyFormatter;
        }
        return this.channelFormatter;
    }

    protected Font getXAxisFont() {
        return YAXIS_FONT;
    }

    protected int getXAxisRows() {
        return 2;
    }

    protected int getSlotCount() {
        return this.model.getNumBars();
    }

    public int getSlotSpacing() {
        int n = this.getSlotCount();
        if (n == 0) {
            return 0;
        }
        int n2 = 120 / n;
        n2 = n2 != 0 ? n2 : 1;
        return n2;
    }

    protected int getBottomSpace() {
        FontMetrics fontMetrics = BarChart.getFontMetricsForFont(this.getXAxisFont());
        return fontMetrics.getHeight() * this.getXAxisRows();
    }

    String[] createBarLabels(GsmMeasurement gsmMeasurement, int n, int n2, FontMetrics fontMetrics) {
        NumberFieldStrategy numberFieldStrategy = this.getFreqChanStrategy();
        String[] stringArray = new String[n2 * 2];
        int n3 = n;
        block0: for (int i = 0; i < n2; ++i) {
            int n4;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                stringArray[n4] = "";
            }
            for (n4 = 0; n4 < n2; n4 += i + 1) {
                long l = gsmMeasurement.getFrequencyForChannel(this.model.getActualSlot(n4));
                numberFieldStrategy.formatWithUnits(l, this.result);
                stringArray[n4 * 2] = this.result[0];
                stringArray[n4 * 2 + 1] = this.result[1];
                if (fontMetrics.stringWidth(this.result[0]) <= n3) continue;
                n3 += n;
                continue block0;
            }
        }
        return stringArray;
    }

    public void setFocus(int n) {
        this.focusBarIndex = n;
    }

    private Color getColorForBsic(int n) {
        if (this.model.getColor(n).getBlue() > 220 || this.model.getColor(n).getRed() > 220) {
            return new Color(255, 255, 0);
        }
        return new Color(255, 0, 0);
    }

    private int getPassFailIconInterval(int n) {
        if (n <= 3) {
            return 5;
        }
        if (n <= 5) {
            return 3;
        }
        return 1;
    }

    private int getPowerLabelsInterval(int n) {
        if (n <= 2) {
            return 13;
        }
        if (n <= 4) {
            return 11;
        }
        if (n <= 6) {
            return 9;
        }
        if (n <= 10) {
            return 5;
        }
        if (n <= 13) {
            return 3;
        }
        if (n <= 29) {
            return 2;
        }
        return 1;
    }

    protected void showLimits(Graphics graphics, int n, int n2) {
        this.analyzer.setPassFailLabel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

