/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.analyzer.BasicBarChartLimitsMask;
import elgato.infrastructure.analyzer.BasicBarChartModel;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.widgets.ImageIcon;
import elgato.measurement.gsm.GsmMeasurement;
import elgato.measurement.gsm.GsmMeasurementSettings;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;

public class GsmChartModel
implements BasicBarChartModel,
BasicBarChartLimitsMask {
    private final Image passIcon = ImageIcon.loadImage("images/LimitsMask_P.png", new Canvas());
    private final Image failIcon = ImageIcon.loadImage("images/LimitsMask_F.png", new Canvas());
    final Color barColorInvalid = new Color(16719920);
    final Color barColorValid = new Color(63488);
    final Color barColorNoLimits = new Color(1057016);
    private int startSlot;
    private int endSlot;
    private int paddingSlots = 0;
    private static GsmMeasurement.XYContainer[] xyContainers;
    private GsmMeasurement measurement;

    public void dispose() {
        if (xyContainers != null) {
            xyContainers = null;
        }
        if (this.measurement != null) {
            this.measurement = null;
        }
    }

    public int getNumBars() {
        if (this.measurement == null) {
            return 0;
        }
        return this.endSlot - this.startSlot + 1 + this.paddingSlots;
    }

    public int getValue(int n) {
        if (!this.isActive(n)) {
            return Integer.MIN_VALUE;
        }
        xyContainers = this.measurement.getXYContainers();
        return GsmChartModel.xyContainers[n + this.startSlot].yValue;
    }

    public boolean isActive(int n) {
        return true;
    }

    public Color getColor(int n) {
        if (this.isMaskEnabled()) {
            return this.isBarValueValid(n) ? this.barColorValid : this.barColorInvalid;
        }
        return this.barColorNoLimits;
    }

    private boolean isBarValueValid(int n) {
        int n2 = this.getValue(n);
        int n3 = this.getLowLimit(n);
        int n4 = this.getHighLimit(n);
        return (n3 == Integer.MIN_VALUE || n2 >= n3) && (n4 == Integer.MIN_VALUE || n2 <= n4);
    }

    public String getLabel(int n) {
        if (!this.isActive(n)) {
            return "";
        }
        return "";
    }

    public Image getBottomOfBarImage(int n) {
        if (!this.isActive(n)) {
            return null;
        }
        if (!this.isMaskEnabled()) {
            return null;
        }
        if (this.isBarValueValid(n)) {
            return this.passIcon;
        }
        return this.failIcon;
    }

    public String getValueUnits() {
        return "";
    }

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        this.measurement = (GsmMeasurement)traceMeasurement;
    }

    public boolean isMaskEnabled() {
        return GsmMeasurementSettings.instance().limitsToggleAt(0).booleanValue();
    }

    public int getLowLimit(int n) {
        return GsmMeasurementSettings.instance().getLowLimit().intValue();
    }

    public int getHighLimit(int n) {
        return GsmMeasurementSettings.instance().getHighLimit().intValue();
    }

    protected int getSlotCount() {
        if (this.measurement == null) {
            return 0;
        }
        return this.endSlot - this.startSlot + 1 + this.paddingSlots;
    }

    protected int getSlotSpacing() {
        int n = this.getSlotCount();
        if (n == 0) {
            return 0;
        }
        int n2 = 120 / n;
        n2 = n2 != 0 ? n2 : 1;
        return n2;
    }

    public void setSlotRange(int n, int n2, int n3) {
        this.startSlot = n;
        this.endSlot = n2;
        this.paddingSlots = n3;
    }

    public int getActualSlot(int n) {
        return this.startSlot + n;
    }

    public int getPaddingSlots() {
        return this.paddingSlots;
    }

    public int getBsic(int n) {
        int n2 = this.getActualSlot(n);
        if (GsmMeasurementSettings.instance().getScanMode().intValue() == 1 && n2 >= 40) {
            n2 = 39;
        }
        xyContainers = this.measurement.getXYContainers();
        return this.measurement.getBsicArr()[GsmChartModel.xyContainers[n2].xIndexOrig];
    }
}

